@echo off

pushd "%~dp0"

set context=%1

set CASTLEDIR=c:\Windows\castle

REM ===========================================================================
REM Check Windows Version
REM ===========================================================================

ver | findstr /i "5\.0\." > nul
IF %ERRORLEVEL% == 0 goto ver_2000
ver | findstr /i "5\.1\." > nul
IF %ERRORLEVEL% == 0 goto ver_XP
ver | findstr /i "5\.2\." > nul
IF %ERRORLEVEL% == 0 goto ver_2003
ver | findstr /i "6\.0\." > nul
IF %ERRORLEVEL% == 0 goto ver_Vista
ver | findstr /i "6\.1\." > nul
IF %ERRORLEVEL% == 0 goto ver_Win7
goto warn_and_proceed

:ver_Win7
echo OS Version: Windows 7
goto elevate

:ver_Vista
echo OS Version: Windows Vista
goto elevate

REM ===========================================================================
REM Elevate credentials
REM ===========================================================================

:warn_and_proceed
  echo Cannot determine Windows version, proceeding anyway...

:elevate
REM Check for permissions
>nul 2>&1 "%SYSTEMROOT%\system32\cacls.exe" "%SYSTEMROOT%\system32\config\system"

REM If error flag set, we do not have admin.
if '%errorlevel%' NEQ '0' (
  echo Requesting administrative privileges...
  goto UACPrompt
REM goto UACPrompt
) else ( goto gotAdmin )


:UACPrompt
  echo Set UAC = CreateObject^("Shell.Application"^) > "%temp%\getadmin.vbs"
  echo UAC.ShellExecute "%~s0", "", "", "runas", 1  >> "%temp%\getadmin.vbs"

  "%temp%\getadmin.vbs"
  REM we are done, exiting recursive call
  exit /B


REM ===========================================================================
REM Identify OS Versions
REM ===========================================================================

:ver_2000
echo OS Version: Windows 2000
goto gotAdmin

:ver_XP
echo OS Version: Windows XP
goto gotAdmin

:ver_2003
echo OS Version: Windows 2003
goto gotAdmin


:gotAdmin
  if exist "%temp%\getadmin.vbs" ( del "%temp%\getadmin.vbs" )
  echo We have admin privileges, proceeding...


:install
REM ===========================================================================
REM Run (privileged) Install Commands
REM ===========================================================================

set status=success

REM ===========================================================================
REM Version and file names need to be changed when rolling a new version
REM ===========================================================================
set package=castle_afs
set thisversion=1.2

set krb5=krb5.conf
set nimreg=NetworkIdentityManager.reg
set openafsreg=OpenAFS1-TransarcAFSDaemon.reg
set killkrb4=disable-krb4-support.reg

if "%PROCESSOR_ARCHITECTURE%" EQU "x86" goto u_32
if "%PROCESSOR_ARCHITECTURE%" EQU "AMD64" goto u_64
goto :eof

:u_32
set openafsmsi=openafs-en_US-1-7-3100.msi
set nimmsi=netidmgr-i386-rel-2_0_102_907.msi
set krbmsi=Heimdal-i386-1-6-2-0.msi
goto :continue

:u_64
set openafsmsi=openafs-en_US-64bit-1-7-3100.msi
set nimmsi=netidmgr-AMD64-rel-2_0_102_907.msi
set krbmsi=Heimdal-AMD64-full-1-6-2-0.msi
set toolsmsi=openafs-32bit-tools-en_US-1-7-3100.msi

:continue

if not exist %CASTLEDIR% mkdir %CASTLEDIR%
set LOGFILE=%CASTLEDIR%\%package%-log.txt
echo Installing %package% ... >> %LOGFILE%

set packagedir=%CASTLEDIR%\%package%
if not exist %packagedir% (
 mkdir %packagedir%
)

if not exist %packagedir%\installedversion.txt (
  echo %package% not installed
) else (
  echo Attempting to reinstall/upgrade %package%
)

echo Configuring %krb5%...
if not exist %SYSTEMDRIVE%\ProgramData\Kerberos (
  mkdir %SYSTEMDRIVE%\ProgramData\Kerberos
)
copy /y %krb5% %SYSTEMDRIVE%\ProgramData\Kerberos\%krb5% 1>NUL 2>NUL
call :errcheck %ERRORLEVEL%

echo Configuring NIM registry entries... 
reg import %nimreg% 1>NUL
call :errcheck %ERRORLEVEL%

echo Configuring AFS registry entries...
reg import %openafsreg% 1>NUL
call :errcheck %ERRORLEVEL%

echo Disabling Kerberos4...
reg import %killkrb4% 1>NUL
call :errcheck %ERRORLEVEL%

echo Installing Heimdal Kerberos
%SystemRoot%\System32\msiexec /i %krbmsi% /quiet /norestart 1>NUL
call :errcheck %ERRORLEVEL%

echo Installing Network Identity Manager
%SystemRoot%\System32\msiexec /i %nimmsi% /quiet /norestart 1>NUL
call :errcheck %ERRORLEVEL%

echo Installing OpenAFS
%SystemRoot%\System32\msiexec /i %openafsmsi% /quiet /norestart 1>NUL
call :errcheck %ERRORLEVEL%

if "%PROCESSOR_ARCHITECTURE%" EQU "AMD64" (
  echo Installing 32-bit compatibility tools
  %SystemRoot%\System32\msiexec /i %toolsmsi% /quiet /norestart 1>NUL
  call :errcheck %ERRORLEVEL%  
)

echo overall %status%
if "%status%" EQU "success" (
  echo %thisversion% > "%packagedir%\installedversion.txt"
)
goto :report

:errcheck
if "%1" EQU "0" echo OK && goto :eof
if "%1" EQU "3010" echo OK && goto :eof
if "%1" EQU "1" echo FAILED && set status=failed && goto :eof

:report
if "%context%" EQU "upgrade" (
  set action=upgrade
) else (
  set action=install
)
if exist email.vbs (
  cscript.exe email.vbs "%action%" "%thisversion%" "%status%"
) else (
  if exist %castledir%\email.vbs (
    cscript.exe %castledir%\email.vbs "%action%" "%thisversion%" "%status%"
  )
)

echo "Installing Scheduled task"
copy /y Openafs-task.bat c:\windows\castle\castle_afs\Openafs-task.bat
schtasks /create /F /RU system /sc daily /tn "Update_OpenAFS" /TR "c:\windows\castle\castle_afs\Openafs-task.bat"

