::@echo off

set package=castle_afs
set packageurl="http://archive.castle.unc.edu/windows/%package%"
set versionurl="%packageurl%/currentversion.txt"

set CASTLEDIR=c:\Windows\castle
if not exist %CASTLEDIR% mkdir %CASTLEDIR%

set LOGFILE=%CASTLEDIR%\%package%-log.txt

echo Checking ... >> %LOGFILE%

set packagedir=%CASTLEDIR%\%package%
if not exist %packagedir% (
 mkdir %packagedir%
 goto :install
)

if not exist %TEMP% mkdir %TEMP%

bitsadmin.exe /transfer "version file" %versionurl% "%packagedir%\currentversion.txt"
if not exist %packagedir%\currentversion.txt goto :error

for /f "tokens=*" %%i in (%packagedir%\currentversion.txt) do (
  set currentversion=%%i
)
set currentversion=%currentversion: =%
echo %currentversion% is newest

if not exist %packagedir%\installedversion.txt (
  echo %package% not installed
  goto :install
)

for /f "tokens=*" %%i in (%packagedir%\installedversion.txt) do (
  set installedversion=%%i
)
set installedversion=%installedversion: =%
echo %installedversion% is installed >> %LOGFILE%

if "%installedversion%" NEQ "%currentversion%" (
  echo upgrade from %installedversion% to %currentversion% needed >> %LOGFILE%
  goto :install
) else (
  echo %installedversion% = %currentversion%. Doing nothing >> %LOGFILE%
)

goto :eof

:error
echo "something bad happened"
echo "something bad happened" >> %LOGFILE%
goto :eof

:install

:: download the currentversion
bitsadmin.exe /transfer "download current version" "%packageurl%/%package%-%currentversion%.zip" "%packagedir%\%package%-%currentversion%.zip"
if %errorlevel% neq 0 goto :error

:: unzip the currentversion
if exist "%TEMP%\%package%" (
  del /f /q "%TEMP%\%package%"
)
mkdir "%TEMP%\%package%"
Call :UnZipFile "%TEMP%\%package%" "%packagedir%\%package%-%currentversion%.zip"

:: run the install script and check errorlevel
cd %TEMP%\%package%
call %TEMP%\%package%\install.bat upgrade >> %LOGFILE%
if %ERRORLEVEL% NEQ 0 goto :error

:: if successful, update installedversion.txt
echo Install successful >> %LOGFILE%
echo %currentversion% > %packagedir%\installedversion.txt
set status=success
goto :cleanup

:error
:: if not successful, do not update and cry
echo Install failed >> %LOGFILE%
set status=failed
goto :cleanup

:cleanup
if exist "%packagedir%\%package%-%currentversion%.zip" (
  del /f /q "%packagedir%\%package%-%currentversion%.zip"
) else (
  echo Cannot find file "%packagedir%\%package%-%currentversion%.zip" to remove >> %LOGFILE%
)
if exist "%TEMP%\%package%" (
  del /f /q "%TEMP%\%package%"
) else (
  echo Cannot find dir "%TEMP%\%package%" to remove >> %LOGFILE%
)
::if exist %TEMP%\%package%\email.vbs (
::  cscript.exe %TEMP%\%PACKAGE%\email.vbs "automated update to %currentversion%" %status%
::  copy /y %TEMP%\%PACKAGE%\email.vbs %castledir%\email.vbs
::) else (
::  if exist %castledir%\email.vbs (
::    cscript.exe %castledir%\email.vbs "automated update to %currentversion%" %status%
::  )
::)
goto :eof

:UnZipFile <ExtractTo> <newzipfile>
set vbs="%temp%\_.vbs"
if exist %vbs% del /f /q %vbs%
>%vbs%  echo Set fso = CreateObject("Scripting.FileSystemObject")
>>%vbs% echo If NOT fso.FolderExists(%1) Then
>>%vbs% echo fso.CreateFolder(%1)
>>%vbs% echo End If
>>%vbs% echo set objShell = CreateObject("Shell.Application")
>>%vbs% echo set FilesInZip=objShell.NameSpace(%2).items
>>%vbs% echo intOptions = 4
>>%vbs% echo objShell.NameSpace(%1).CopyHere(FilesInZip),intOptions
>>%vbs% echo Set fso = Nothing
>>%vbs% echo Set objShell = Nothing
cscript //nologo %vbs%
::if exist %vbs% del /f /q %vbs%

