if WScript.Arguments.Count < 2 then
   WScript.Echo "Missing parameters"
end if

set objArgs = WScript.Arguments
operation = objArgs(0)
version = objArgs(1)
status = objArgs(2)

Set wshShell = WScript.CreateObject( "WScript.Shell" )
strComputerName = wshShell.ExpandEnvironmentStrings( "%COMPUTERNAME%" )
rem WScript.Echo "Computer Name: " & strComputerName

Dim myBody

myBody = operation & " " & version & " script completed. Status = " & status & vbNewLine

myBody = myBody & strComputerName & " has IP addresses:" & vbNewLine

strComputer = "."
Set objWMIService = GetObject("winmgmts:" _
    & "{impersonationLevel=impersonate}!\\" & strComputer & "\root\cimv2")

Set IPConfigSet = objWMIService.ExecQuery _
    ("Select * from Win32_NetworkAdapterConfiguration Where IPEnabled=TRUE")
 
For Each IPConfig in IPConfigSet
    If Not IsNull(IPConfig.IPAddress) Then 
        For i=LBound(IPConfig.IPAddress) to UBound(IPConfig.IPAddress)
            myBody = myBody & " " & IPConfig.IPAddress(i) & vbNewLine
        Next
    End If
Next

myBody = myBody & strComputerName & " has MAC addresses:" & vbNewLine

dim WMI:  set WMI = GetObject("winmgmts:\\.\root\cimv2")
dim Nads: set Nads = WMI.ExecQuery("Select * from Win32_NetworkAdapter where physicaladapter=true")
dim nad
for each Nad in Nads
    if not isnull(Nad.MACAddress) then
        myBody = myBody & " " & Nad.MACAddress & " " & Nad.description &  vbNewLine
    end if
next

Set colSettings = objWMIService.ExecQuery _
    ("Select * from Win32_ComputerSystem")
For Each objComputer in colSettings 
    myBody = myBody & objComputer.Name & " is a" & vbNewLine
    myBody = myBody & " System Manufacturer: " & objComputer.Manufacturer & vbNewLine
    myBody = myBody & " System Model: " & objComputer.Model & vbNewLine
Next

Set colItems = objWMIService.ExecQuery( _
    "SELECT * FROM Win32_ComputerSystemProduct") 
For Each objItem in colItems 
    myBody = myBody & " Serial Number: " & objItem.IdentifyingNumber & vbNewLine
Next

strUserDomain = wshShell.ExpandEnvironmentStrings( "%USERDOMAIN%" )
myBody = myBody & " userdomain: " & strUserDomain & vbNewLine

For Each objItem in colSettings 
  myBody = myBody & vbNewLine & "Computer Name: " & objItem.Name & vbNewLine
  myBody = myBody & "Name Format: " & objItem.NameFormat & vbNewLine
  myBody = myBody & "Domain: " & objItem.Domain & vbNewLine
  myBody = myBody & "Part Of Domain: " & objItem.PartOfDomain & vbNewLine 'post-Windows 2000 only 
  myBody = myBody & "Workgroup: " & objItem.Workgroup & vbNewLine 'post-Windows 2000 only 
  myBody = myBody & "Domain Role: " & strDomainRole & vbNewLine
  strRoles = Join(objItem.Roles, ",") 
  myBody = myBody & "Roles: " & strRoles & vbNewLine
  myBody = myBody & "Network Server Mode Enabled: " & _ 
   objItem.NetworkServerModeEnabled & vbNewLine
Next

rem ========================================
Set objMessage = CreateObject("CDO.Message")
objMessage.Subject = "OpenAFS " & operation & " " & version & " " & status
objMessage.From = "openafs_task@" & strComputerName & ".unc.edu"
objMessage.To = "windows-tasks@listserv.unc.edu"
objMessage.TextBody = myBody


objMessage.Configuration.Fields.Item _
("http://schemas.microsoft.com/cdo/configuration/sendusing") = 2
'Name or IP of Remote SMTP Server
objMessage.Configuration.Fields.Item _
("http://schemas.microsoft.com/cdo/configuration/smtpserver") = "relay.unc.edu"
'Server port (typically 25)
objMessage.Configuration.Fields.Item _
("http://schemas.microsoft.com/cdo/configuration/smtpserverportport") = 25
objMessage.Configuration.Fields.Update

objMessage.Send
