/*
 *========================================================================
 * $Id: parsecl.c 69 2004-12-02 15:57:18Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include "wulflogger.h"

/*
 * This routine sets certain globals to their default values and permits
 * those defaults to be overridden on the command line.
 */

void parsecl(int argc, char **argv)
{
 int opt_c,opt_errflg=0;
 extern char *optarg;
 extern int optind, opterr, optopt;
 int localhosts_only = 0;
 struct stat statbuf;
 char *eptr;
 int helpflag = 0;

 /* 
  * Initialize global variables with defaults, then override if
  * desired on command line.  Read the getopt man page to see how
  * to set other variables.  Or insert your own parsing code in here --
  * Sometimes I use getopts, sometimes I parse myself, sometimes both.
  */
 verbose = 0;			/* Default is quiet */
 update_delay = 5;		/* 5 seconds */
 connect_delay = 10;		/* Reloop hosts every 10 seconds */
 numhosts = 0;			/* Want to lose this eventually */
 count = -1;                    /* -1 is infinity */
 /*
  * Select display type and reset associated control variables as
  * needed.  Some get computed in display_whatever().  
  */
 display_type = DISPLAY_BASIC;		/* default is BASIC */
 hostfile[0] = (char) NULL;		/* to show it untouched */

 while ((opt_c = getopt(argc,argv,"c:d:f:hlt:v:")) != EOF){
   switch (opt_c){
     case 'c':
       count = atoi(optarg);
       break;
     case 'd':
       update_delay = atoi(optarg);
       break;
     case 'f':
       strncpy(hostfile,optarg,1024);
       if( (verbose == D_ALL) || (verbose == D_PARSECL) ){
         printf("D_PARSECL: Setting hostfile via -f %s\n",hostfile);
       }
       break;
     case 'h':
       helpflag = 1;
       break;
     case 'l':
       /* If this is set, UNset any and all values for hostfile */
       localhosts_only = 1;
       break;
     case 't':		/* Set display type */
       display_type = atoi(optarg);
       /* May need to reset display.lines_for_messages here. */
       break;
     case 'v':
       verbose = atoi(optarg);
       break;
     case '?':
       opt_errflg++;
   }
 }

 /*
  * If there are no more arguments, we are done.  Otherwise print
  * Usage and exit.
  */
 if(argc-optind != 0 || helpflag){
   Usage();
   exit(0);
 }

 /*
  * The last thing we have to do is set the hostfile.
  *
  * We want to get get our hostfile from one of several places (in
  * increasing order of significance):
  *    No hostfile (-l flag) forces localhost only (debugging)
  *    /etc/wulfhosts
  *    WULFHOSTS (environment variable)
  *    ~/.wulfhosts
  *    ./wulfhosts
  *    command line -f wulfhosts
  * so that one can always specify a wulfhost file explicitly but
  * otherwise a modest search will occur.
  *
  * If it was set by the command line above, it is non-null and
  * we return.  Whether it "works" will be tested elsewhere.
  */
 
 if((verbose == D_ALL) || (verbose == D_PARSECL)){
   printf("D_PARSECL: Looking for (-f) hostfile: %s\n",hostfile);
 }

 /*
  * If -l was used we unset hostfile OVERRIDING -f or anything
  * else.
  */
 if(localhosts_only){
   if((verbose == D_ALL) || (verbose == D_PARSECL)){
     printf("D_PARSECL: localhost only flag set.  No hostfile used.\n");
   }
   sprintf(hostfile,"");
   return;
 }
 

 /* 
  * If hostfile was set via -f above AND EXISTS, it is used
  */
 if( stat(hostfile,&statbuf) == 0) return;

 /*
  * Does ./wulfhosts exist?  If so, use it.
  */
 sprintf(hostfile,"wulfhosts");
 if((verbose == D_ALL) || (verbose == D_PARSECL)){
   printf("D_PARSECL: Looking for ./hostfile: %s\n",hostfile);
 }
 if( stat(hostfile,&statbuf) == 0) return;

 /*
  * How about $HOME/.wulfhosts?
  */
 eptr = getenv("HOME");
 sprintf(hostfile,"%s/.wulfhosts",eptr);
 if((verbose == D_ALL) || (verbose == D_PARSECL)){
   printf("D_PARSECL: Looking for ~/.hostfile: %s\n",hostfile);
 }
 if( stat(hostfile,&statbuf) == 0) return;
 
 /*
  * How about $WULFHOSTS
  */
 eptr = getenv("WULFHOSTS");
 if(eptr == NULL) {
   if((verbose == D_ALL) || (verbose == D_PARSECL)){
     printf("D_PARSECL: No $WULFHOSTS hostfile defined.\n");
   }
 } else {
   sprintf(hostfile,"%s",eptr);
   if((verbose == D_ALL) || (verbose == D_PARSECL)){
     printf("D_PARSECL: Looking for $WULFHOSTS hostfile: %s\n",hostfile);
   }
   if( stat(hostfile,&statbuf) == 0) return;
 }
 
 /*
  * Goodness.  Not much there.  How about /etc/wulfhosts.
  */
 sprintf(hostfile,"/etc/wulfhosts");
 if((verbose == D_ALL) || (verbose == D_PARSECL)){
   printf("D_PARSECL: Looking for system hostfile: %s\n",hostfile);
 }
 if( stat(hostfile,&statbuf) == 0) return;

}

void Usage()
{

 fprintf(stdout, "\n");
 fprintf(stdout, "Usage: \n");
 fprintf(stdout, "  wulflogger [-h] [-v #] [-t display_type] [-d delay]\n");
 fprintf(stdout, "              [-c count] [-f /path/to/wulfhosts] [-l]\n");
 fprintf(stdout, "\n");
 fprintf(stdout, "   -v number selects \"verbose\" operation for debugging, very noisy\n");
 fprintf(stdout, "      (-h -v displays numbers options for verbosity).\n");
 fprintf(stdout, "   -h prints usage statement (this message) and exits.\n");
 fprintf(stdout, "   -t display_type selects display type from list below.\n");
 fprintf(stdout, "   -d delay (in seconds) selects update loop delay (5 seconds).\n");
 fprintf(stdout, "   -c count loops only count times (default loops forever).\n");
 fprintf(stdout, "   -f /path/to/wulfhosts to use a particular wulfhosts file.\n");
 fprintf(stdout, "   -l show localhost only (use no wulfhosts file from any location).\n");
 fprintf(stdout, "\n");
 fprintf(stdout, " Display types (enter integer or character):\n");
 fprintf(stdout, "     b(asic):    %d  (default)\n",DISPLAY_BASIC);
 fprintf(stdout, "     l(oad):     %d\n",DISPLAY_LOAD);
 fprintf(stdout, "     m(emory):   %d\n",DISPLAY_MEMORY);
 fprintf(stdout, "     n(et):      %d\n",DISPLAY_NET);
 fprintf(stdout, "     t(imes):    %d\n",DISPLAY_TIMES);
 fprintf(stdout, "     p(ids):     %d\n",DISPLAY_PIDS);
 fprintf(stdout, "     c(mdline):  %d\n",DISPLAY_PIDS_CMDLINE);
 fprintf(stdout, "\n");
 if(verbose) Usagemap();
 exit(0);

}

void Usagemap()
{
 fprintf(stdout,"For verbose debugging output, enter:\n");
 fprintf(stdout,"  -v %d (quiet/default)\n",D_QUIET);
 fprintf(stdout,"  -v %d (to see almost everything)\n",D_ALL);
 fprintf(stdout,"  -v %d main()\n",D_MAIN);
 fprintf(stdout,"  -v %d parsecl()\n",D_PARSECL);
 fprintf(stdout,"  -v %d startup()\n",D_STARTUP);
 fprintf(stdout,"  -v %d work()\n",D_WORK);
 fprintf(stdout,"  -v %d parse()\n",D_PARSE);
 fprintf(stdout,"  -v %d connect()\n",D_CONNECT);
 fprintf(stdout,"  -v %d init_host()\n",D_INIT_HOST);
 fprintf(stdout,"  -v %d connect_hosts()\n",D_CONNECT_HOSTS);
 fprintf(stdout,"  -v %d readhost()\n",D_READHOST);
 fprintf(stdout,"  -v %d sendcmd()\n",D_SENDCMD);
 fprintf(stdout,"  -v %d select_option()\n",D_SELECT_OPTION);
 fprintf(stdout,"  -v %d extract_values()\n",D_EXTRACT_VALUES);
 fprintf(stdout,"  -v %d init_values()\n",D_INIT_VALUES);
 fprintf(stdout,"  -v %d update_values()\n",D_UPDATE_VALUES);
 fprintf(stdout,"  -v %d values()\n",D_VALUES);
 fprintf(stdout,"  -v %d display_values()\n",D_DISPLAY_VALUES);
 fprintf(stdout,"  -v %d display_debug()\n",D_DISPLAY_DEBUG);
 fprintf(stdout,"  -v %d screen()\n",D_SCREEN);
 fprintf(stdout,"  -v %d quit()\n",D_QUIT);
 fprintf(stdout,"(Some of the values above are obsolete.)\n");
}
