/************************************************************************/
/*                                                                      */
/*    vspline - a set of generic tools for creation and evaluation      */
/*              of uniform b-splines                                    */
/*                                                                      */
/*            Copyright 2015 - 2017 by Kay F. Jahnke                    */
/*                                                                      */
/*    The git repository for this software is at                        */
/*                                                                      */
/*    https://bitbucket.org/kfj/vspline                                 */
/*                                                                      */
/*    Please direct questions, bug reports, and contributions to        */
/*                                                                      */
/*    kfjahnke+vspline@gmail.com                                        */
/*                                                                      */
/*    Permission is hereby granted, free of charge, to any person       */
/*    obtaining a copy of this software and associated documentation    */
/*    files (the "Software"), to deal in the Software without           */
/*    restriction, including without limitation the rights to use,      */
/*    copy, modify, merge, publish, distribute, sublicense, and/or      */
/*    sell copies of the Software, and to permit persons to whom the    */
/*    Software is furnished to do so, subject to the following          */
/*    conditions:                                                       */
/*                                                                      */
/*    The above copyright notice and this permission notice shall be    */
/*    included in all copies or substantial portions of the             */
/*    Software.                                                         */
/*                                                                      */
/*    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND    */
/*    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES   */
/*    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND          */
/*    NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT       */
/*    HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,      */
/*    WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING      */
/*    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR     */
/*    OTHER DEALINGS IN THE SOFTWARE.                                   */
/*                                                                      */
/************************************************************************/

/*! \file poles.h

    \brief precalculated prefilter poles and basis function values

    The contents of this file below the comments can be generated
    using prefilter_poles.cc

    both the precalculated basis function values and the prefilter poles
    can be generated in long double precision, so the constants below are
    given as long doubles - concrete splines will downcast them to whatever
    precision they use for prefiltering (usually the same type as the data
    type's elementary type).
    
    The values defined here are used in several places in vspline. They are
    precomputed because calculating them when needed can be (potentially very)
    expensive, and providing them by definitions evaluated at compile time
    slows compilation. Great care is taken to provide very exact values.
    The code in prefilter_poles.cc goes beyond simply calculating polynomial
    roots with gsl/blas, adding a polishing stage done in long double arithmetic.
    
    The set of values provided here is sufficient to calculate the b-spline
    basis function for all spline degrees for arbitrary arguments (including
    the spline's derivatives) - see basis.h. The poles are needed for prefiltering.
*/

#ifndef VSPLINE_POLES_H

namespace vspline_constants
{

const long double K0[] = {
 1L ,   // basis(0)
 } ; 
const long double K1[] = {
 1L ,   // basis(0)
 0.5L ,   // basis(0.5)
 } ; 
const long double K2[] = {
 0.75L ,   // basis(0)
 0.5L ,   // basis(0.5)
 0.125L ,   // basis(1)
 } ; 
const long double Poles_2[] = {
-0.171572875253809916743L ,
} ;
const long double K3[] = {
 0.666666666666666666685L ,   // basis(0)
 0.479166666666666666658L ,   // basis(0.5)
 0.166666666666666666671L ,   // basis(1)
 0.0208333333333333333339L ,   // basis(1.5)
 } ; 
const long double Poles_3[] = {
-0.267949192431122719925L ,
} ;
const long double K4[] = {
 0.598958333333333333315L ,   // basis(0)
 0.458333333333333333342L ,   // basis(0.5)
 0.197916666666666666671L ,   // basis(1)
 0.0416666666666666666678L ,   // basis(1.5)
 0.00260416666666666666674L ,   // basis(2)
 } ; 
const long double Poles_4[] = {
-0.3613412259002201794L ,
-0.0137254292973391213608L ,
} ;
const long double K5[] = {
 0.550000000000000000011L ,   // basis(0)
 0.438020833333333333299L ,   // basis(0.5)
 0.216666666666666666668L ,   // basis(1)
 0.0617187500000000000007L ,   // basis(1.5)
 0.00833333333333333333373L ,   // basis(2)
 0.000260416666666666666679L ,   // basis(2.5)
 } ; 
const long double Poles_5[] = {
-0.430575347099973781842L ,
-0.0430962882032646538245L ,
} ;
const long double K6[] = {
 0.511024305555555555529L ,   // basis(0)
 0.419444444444444444487L ,   // basis(0.5)
 0.228797743055555555543L ,   // basis(1)
 0.0791666666666666666658L ,   // basis(1.5)
 0.0156684027777777777777L ,   // basis(2)
 0.00138888888888888888895L ,   // basis(2.5)
 2.17013888888888888899e-05L ,   // basis(3)
 } ; 
const long double Poles_6[] = {
-0.488294589303044755213L ,
-0.0816792710762375126011L ,
-0.00141415180832581775119L ,
} ;
const long double K7[] = {
 0.479365079365079365124L ,   // basis(0)
 0.402596416170634920605L ,   // basis(0.5)
 0.236309523809523809522L ,   // basis(1)
 0.0940243675595238095248L ,   // basis(1.5)
 0.0238095238095238095252L ,   // basis(2)
 0.00337766617063492063474L ,   // basis(2.5)
 0.000198412698412698412712L ,   // basis(3)
 1.55009920634920634931e-06L ,   // basis(3.5)
 } ; 
const long double Poles_7[] = {
-0.535280430796438168935L ,
-0.122554615192326690523L ,
-0.00914869480960827692899L ,
} ;
const long double K8[] = {
 0.45292096819196428568L ,   // basis(0)
 0.387375992063492063515L ,   // basis(0.5)
 0.24077768477182539682L ,   // basis(1)
 0.10647321428571428571L ,   // basis(1.5)
 0.0321269686259920634935L ,   // basis(2)
 0.00612599206349206349226L ,   // basis(2.5)
 0.000634765624999999999979L ,   // basis(3)
 2.4801587301587301589e-05L ,   // basis(3.5)
 9.68812003968253968318e-08L ,   // basis(4)
 } ; 
const long double Poles_8[] = {
-0.574686909248765430565L ,
-0.163035269297280935283L ,
-0.0236322946948448500203L ,
-0.00015382131064169091176L ,
} ;
const long double K9[] = {
 0.430417768959435626143L ,   // basis(0)
 0.373602402567653218697L ,   // basis(0.5)
 0.243149250440917107593L ,   // basis(1)
 0.1168385769744819224L ,   // basis(1.5)
 0.0402557319223985890627L ,   // basis(2)
 0.0094531293058311287482L ,   // basis(2.5)
 0.00138337742504409171077L ,   // basis(3)
 0.000105885769744819223983L ,   // basis(3.5)
 2.75573192239858906539e-06L ,   // basis(4)
 5.38228891093474426835e-09L ,   // basis(4.5)
 } ; 
const long double Poles_9[] = {
-0.607997389168625778982L ,
-0.201750520193153238738L ,
-0.0432226085404817521351L ,
-0.00212130690318081842041L ,
} ;
const long double K10[] = {
 0.410962642824418540556L ,   // basis(0)
 0.361098434744268077622L ,   // basis(0.5)
 0.244066156188857197966L ,   // basis(1)
 0.12543871252204585538L ,   // basis(1.5)
 0.0479833489204420194007L ,   // basis(2)
 0.013183421516754850087L ,   // basis(2.5)
 0.00245328523074087852745L ,   // basis(3)
 0.000279155643738977072321L ,   // basis(3.5)
 1.5887978636188271604e-05L ,   // basis(4)
 2.75573192239858906539e-07L ,   // basis(4.5)
 2.69114445546737213417e-10L ,   // basis(5)
 } ; 
const long double Poles_10[] = {
-0.636550663969423858484L ,
-0.238182798377573284936L ,
-0.0657270332283085515493L ,
-0.00752819467554869064324L ,
-1.69827628232746642329e-05L ,
} ;
const long double K11[] = {
 0.393925565175565175585L ,   // basis(0)
 0.349702231887443069057L ,   // basis(0.5)
 0.243960287397787397795L ,   // basis(1)
 0.132561165432106594207L ,   // basis(1.5)
 0.0552020202020202020231L ,   // basis(2)
 0.017163149607531321399L ,   // basis(2.5)
 0.00382387866762866762846L ,   // basis(3)
 0.000571286261263271354464L ,   // basis(3.5)
 5.10060926727593394244e-05L ,   // basis(4)
 2.16679942326914983149e-06L ,   // basis(4.5)
 2.50521083854417187763e-08L ,   // basis(5)
 1.22324747975789642462e-11L ,   // basis(5.5)
 } ; 
const long double Poles_11[] = {
-0.661266068900734706973L ,
-0.272180349294785885644L ,
-0.0897595997937133099328L ,
-0.0166696273662346560986L ,
-0.000510557534446502057208L ,
} ;
const long double K12[] = {
 0.378844084544729991474L ,   // basis(0)
 0.339272950236491903185L ,   // basis(0.5)
 0.243130918010144694708L ,   // basis(1)
 0.138451466550424883762L ,   // basis(1.5)
 0.0618676680090413254889L ,   // basis(2)
 0.0212685824013949013948L ,   // basis(2.5)
 0.0054581869256967252307L ,   // basis(3)
 0.000998474744134466356579L ,   // basis(3.5)
 0.000120913920591875371615L ,   // basis(4)
 8.52397987814654481317e-06L ,   // basis(4.5)
 2.70861650696991408761e-07L ,   // basis(5)
 2.08767569878680989809e-09L ,   // basis(5.5)
 5.09686449899123510276e-13L ,   // basis(6)
 } ; 
const long double Poles_12[] = {
-0.682864884197723324803L ,
-0.30378079328825415993L ,
-0.11435052002713588501L ,
-0.0288361901986638037087L ,
-0.00251616621726133559223L ,
-1.88330564506390264383e-06L ,
} ;
const long double K13[] = {
 0.365370869485452818838L ,   // basis(0)
 0.329689879585910011891L ,   // basis(0.5)
 0.241788417986334653017L ,   // basis(1)
 0.143315017471742083661L ,   // basis(1.5)
 0.0679749672588214254906L ,   // basis(2)
 0.0254044062949849888001L ,   // basis(2.5)
 0.00731223669591725147264L ,   // basis(3)
 0.00156717310816563305462L ,   // basis(3.5)
 0.000237629847004847004809L ,   // basis(4)
 2.3492285420207986942e-05L ,   // basis(4.5)
 1.31330860497527164195e-06L ,   // basis(5)
 3.12537574712392963204e-08L ,   // basis(5.5)
 1.60590438368216146005e-10L ,   // basis(6)
 1.96033249961201350104e-14L ,   // basis(6.5)
 } ; 
const long double Poles_13[] = {
-0.701894251816807861958L ,
-0.333107232930623592306L ,
-0.138901113194319430138L ,
-0.0432138667403636696352L ,
-0.0067380314152449140003L ,
-0.000125100113214418715975L ,
} ;
const long double K14[] = {
 0.353239156699189298447L ,   // basis(0)
 0.320850245020631925431L ,   // basis(0.5)
 0.240082990415587342031L ,   // basis(1)
 0.147321800946242910537L ,   // basis(1.5)
 0.0735410325640670609783L ,   // basis(2)
 0.0294998002323771172986L ,   // basis(2.5)
 0.00934108185451225690503L ,   // basis(3)
 0.002275919650051594496L ,   // basis(3.5)
 0.000411090511493721967216L ,   // basis(4)
 5.20463745910174481555e-05L ,   // basis(4.5)
 4.2229561084936041826e-06L ,   // basis(5)
 1.87764634689237863838e-07L ,   // basis(5.5)
 3.34863577512474229312e-09L ,   // basis(6)
 1.14707455977297247148e-11L ,   // basis(6.5)
 7.00118749861433393235e-16L ,   // basis(7)
 } ; 
const long double Poles_14[] = {
-0.718783787239944450614L ,
-0.360319071916961058049L ,
-0.163033514799298691019L ,
-0.0590894821948310188073L ,
-0.0132467567348479146521L ,
-0.000864024040953337935742L ,
-2.09130967752753285063e-07L ,
} ;
const long double K15[] = {
 0.342240261355340720458L ,   // basis(0)
 0.312666606251760809706L ,   // basis(0.5)
 0.238123194910707311519L ,   // basis(1)
 0.150611949803996986836L ,   // basis(1.5)
 0.0785952538667485757425L ,   // basis(2)
 0.0335038025716498355252L ,   // basis(2.5)
 0.0115022744874968750639L ,   // basis(3)
 0.00311749394849886391303L ,   // basis(3.5)
 0.000648549006353239157451L ,   // basis(4)
 9.94402494389464625065e-05L ,   // basis(4.5)
 1.05720042682674957797e-05L ,   // basis(5)
 7.06839790279879631815e-07L ,   // basis(5.5)
 2.50459906544562629208e-08L ,   // basis(6)
 3.34864254293932428696e-10L ,   // basis(6.5)
 7.64716373181981647651e-13L ,   // basis(7)
 2.33372916620477797745e-17L ,   // basis(7.5)
 } ; 
const long double Poles_15[] = {
-0.733872571684837351016L ,
-0.385585734278435207065L ,
-0.186520108450964346307L ,
-0.0759075920476681992858L ,
-0.0217520657965404714602L ,
-0.00280115148207645487303L ,
-3.09356804514744232418e-05L ,
} ;
const long double K16[] = {
 0.33220826914249586032L ,   // basis(0)
 0.305064427814943222976L ,   // basis(0.5)
 0.235988316876636090489L ,   // basis(1)
 0.153300931440152308626L ,   // basis(1.5)
 0.0831729750455189804676L ,   // basis(2)
 0.0373810339101848175097L ,   // basis(2.5)
 0.0137576309094881893988L ,   // basis(3)
 0.00408087253210770282541L ,   // basis(3.5)
 0.000954482867889482399375L ,   // basis(4)
 0.000170727005056277129691L ,   // basis(4.5)
 2.23489506378181871124e-05L ,   // basis(5)
 2.00416604212280468886e-06L ,   // basis(5.5)
 1.10747187961685068735e-07L ,   // basis(6)
 3.13146575340689097298e-09L ,   // basis(6.5)
 3.13935464480574627987e-11L ,   // basis(7)
 4.77947733238738529782e-14L ,   // basis(7.5)
 7.29290364438993117953e-19L ,   // basis(8)
 } ; 
const long double Poles_16[] = {
-0.747432387766468507421L ,
-0.409073604757250910887L ,
-0.209228719339539694189L ,
-0.0932547189802406259143L ,
-0.0318677061204539004258L ,
-0.00625840678512598491248L ,
-0.000301565363306959580638L ,
-2.32324863642123170546e-08L ,
} ;
const long double K17[] = {
 0.323009394156998706679L ,   // basis(0)
 0.297979958708191627778L ,   // basis(0.5)
 0.233736749230651110002L ,   // basis(1)
 0.155484036150159998435L ,   // basis(1.5)
 0.0873116407701823031193L ,   // basis(2)
 0.0411080643091169147709L ,   // basis(2.5)
 0.0160739219909647846453L ,   // basis(3)
 0.00515282387357668068747L ,   // basis(3.5)
 0.00133081257213353628318L ,   // basis(4)
 0.000270404925830189195488L ,   // basis(4.5)
 4.18215496949898696688e-05L ,   // basis(5)
 4.69571537987106402301e-06L ,   // basis(5.5)
 3.56439418392324554771e-07L ,   // basis(6)
 1.63149746984798566173e-08L ,   // basis(6.5)
 3.68452719010997878094e-10L ,   // basis(7)
 2.77001951208101220232e-12L ,   // basis(7.5)
 2.81145725434552076336e-15L ,   // basis(8)
 2.14497166011468564099e-20L ,   // basis(8.5)
 } ; 
const long double Poles_17[] = {
-0.759683224071932781984L ,
-0.430939653180396579961L ,
-0.231089843599271833896L ,
-0.110828993316247253478L ,
-0.0432139114566841576597L ,
-0.0112581836894716022219L ,
-0.00118593312515217673908L ,
-7.68756258125468272936e-06L ,
} ;
const long double K18[] = {
 0.314534400858646718218L ,   // basis(0)
 0.291358446651083303363L ,   // basis(0.5)
 0.231411779366461601095L ,   // basis(1)
 0.157240113462067456344L ,   // basis(1.5)
 0.0910485005933913615569L ,   // basis(2)
 0.0446704749601585298685L ,   // basis(2.5)
 0.0184229286904982474763L ,   // basis(3)
 0.00631911641019581553075L ,   // basis(3.5)
 0.00177727765574329432895L ,   // basis(4)
 0.000402198030910974421746L ,   // basis(4.5)
 7.13838910691101004477e-05L ,   // basis(5)
 9.59071055865801927793e-06L ,   // basis(5.5)
 9.27104774298620103304e-07L ,   // basis(6)
 5.97340832600638683586e-08L ,   // basis(6.5)
 2.26850789267494323566e-09L ,   // basis(7)
 4.0941846266406646114e-11L ,   // basis(7.5)
 2.30834980193975490196e-13L ,   // basis(8)
 1.56192069685862264628e-16L ,   // basis(8.5)
 5.95825461142968233597e-22L ,   // basis(9)
 } ; 
const long double Poles_18[] = {
-0.770805051407208484079L ,
-0.451328733377817488268L ,
-0.252074574682638764562L ,
-0.128412836796714573015L ,
-0.0554629671385220109096L ,
-0.0176623776847852202014L ,
-0.00301193072899483019657L ,
-0.000106337355887136664016L ,
-2.5812403962571557538e-09L ,
} ;
const long double K19[] = {
 0.306693101737982424604L ,   // basis(0)
 0.285152657447631086029L ,   // basis(0.5)
 0.229045645681183776321L ,   // basis(1)
 0.158634625338890750896L ,   // basis(1.5)
 0.0944192951167601057425L ,   // basis(2)
 0.0480605454253507002694L ,   // basis(2.5)
 0.0207811493712450163664L ,   // basis(3)
 0.00756538341267226747638L ,   // basis(3.5)
 0.00229186688915413342573L ,   // basis(4)
 0.000568952290899485013994L ,   // basis(4.5)
 0.000113413200680775915678L ,   // basis(5)
 1.76630333585591612417e-05L ,   // basis(5.5)
 2.06939934562068942136e-06L ,   // basis(6)
 1.72752478435489838162e-07L ,   // basis(6.5)
 9.46832953509055358168e-09L ,   // basis(7)
 2.98700491781092245297e-10L ,   // basis(7.5)
 4.30981599947724409224e-12L ,   // basis(8)
 1.8223814805986014024e-14L ,   // basis(8.5)
 8.22063524662432971747e-18L ,   // basis(9)
 1.56796173984991640424e-23L ,   // basis(9.5)
 } ; 
const long double Poles_19[] = {
-0.780946444851732297302L ,
-0.470372819467643025522L ,
-0.272180376283034490098L ,
-0.145850893757564512081L ,
-0.068345906124880463918L ,
-0.0252650733448555957229L ,
-0.00593665959108296996236L ,
-0.000508410194680816563286L ,
-1.91547865621224798646e-06L ,
} ;
const long double K20[] = {
 0.299410290320012640323L ,   // basis(0)
 0.279321655993642289261L ,   // basis(0.5)
 0.226662421857486947625L ,   // basis(1)
 0.159722117626588762783L ,   // basis(1.5)
 0.0974575566598727567998L ,   // basis(2)
 0.0512754651380133029385L ,   // basis(2.5)
 0.0231293383380602931465L ,   // basis(3)
 0.00887770910234364912608L ,   // basis(3.5)
 0.00287124002002061356517L ,   // basis(4)
 0.000772619967256821964494L ,   // basis(4.5)
 0.000170150730850241728814L ,   // basis(5)
 3.00088196466905304557e-05L ,   // basis(5.5)
 4.11670330038509039567e-06L ,   // basis(6)
 4.2192794922896485481e-07L ,   // basis(6.5)
 3.04930466565191773934e-08L ,   // basis(7)
 1.42412826466311255693e-09L ,   // basis(7.5)
 3.73544185013320677245e-11L ,   // basis(8)
 4.30989409551208702348e-13L ,   // basis(8.5)
 1.36678612573657801533e-15L ,   // basis(9)
 4.11031762331216485864e-19L ,   // basis(9.5)
 3.91990434962479101051e-25L ,   // basis(10)
 } ; 
const long double Poles_20[] = {
-0.790231117480724852336L ,
-0.488191260639127939892L ,
-0.291421601474782553581L ,
-0.163033534850263082434L ,
-0.0816481156195889353096L ,
-0.0338494795539119584577L ,
-0.0099730290200587274223L ,
-0.00146832175710434043464L ,
-3.77465731975190254876e-05L ,
-2.86799448817251264668e-10L ,
} ;
const long double K21[] = {
 0.292622687231434779222L ,   // basis(0)
 0.2738298047486301248L ,   // basis(0.5)
 0.224280093878832764107L ,   // basis(1)
 0.160548212661644545846L ,   // basis(1.5)
 0.10019429073492722872L ,   // basis(2)
 0.0543159666272729709679L ,   // basis(2.5)
 0.0254519832636627386328L ,   // basis(3)
 0.0102430008488452902521L ,   // basis(3.5)
 0.00351110777263132730256L ,   // basis(4)
 0.00101430459325298737959L ,   // basis(4.5)
 0.000243612424661332394002L ,   // basis(5)
 4.77978392444135000019e-05L ,   // basis(5.5)
 7.4865177795402407054e-06L ,   // basis(6)
 9.07561579439142494542e-07L ,   // basis(6.5)
 8.15879097942759735833e-08L ,   // basis(7)
 5.11508190667103638761e-09L ,   // basis(7.5)
 2.03836837750990982686e-10L ,   // basis(8)
 4.44822374203723964682e-12L ,   // basis(8.5)
 4.10470018922697156696e-14L ,   // basis(9)
 9.76275807924129018926e-17L ,   // basis(9.5)
 1.95729410633912612316e-20L ,   // basis(10)
 9.33310559434474050122e-27L ,   // basis(10.5)
 } ; 
const long double Poles_21[] = {
-0.798762885665731613507L ,
-0.504891537448370302096L ,
-0.309823196415790324431L ,
-0.179884666798535838096L ,
-0.0952008124607312005328L ,
-0.0432139184407157353102L ,
-0.0150454999872945547364L ,
-0.00317200396388417259226L ,
-0.000219902957631632330337L ,
-4.77976468942536316244e-07L ,
} ;
const long double K22[] = {
 0.286276614055386039554L ,   // basis(0)
 0.268645940276898897319L ,   // basis(0.5)
 0.221912073096871506056L ,   // basis(1)
 0.161151214470108255204L ,   // basis(1.5)
 0.102657889534264013345L ,   // basis(2)
 0.0571852901048010636068L ,   // basis(2.5)
 0.0277367831200034982673L ,   // basis(3)
 0.0116492037590350826642L ,   // basis(3.5)
 0.00420655579826186278524L ,   // basis(4)
 0.00129434332740911861009L ,   // basis(4.5)
 0.000335529281985329123513L ,   // basis(5)
 7.2224788646371748003e-05L ,   // basis(5.5)
 1.26713837947481474385e-05L ,   // basis(6)
 1.76823505790900777494e-06L ,   // basis(6.5)
 1.89938914670434336315e-07L ,   // basis(7)
 1.50102063224714874089e-08L ,   // basis(7.5)
 8.1770577437810697864e-10L ,   // basis(8)
 2.78332478768553791978e-11L ,   // basis(8.5)
 5.05570941840879253739e-13L ,   // basis(9)
 3.73156430983189829773e-15L ,   // basis(9.5)
 6.6564259722400510509e-18L ,   // basis(10)
 8.89679139245057328719e-22L ,   // basis(10.5)
 2.12116036235107738666e-28L ,   // basis(11)
 } ; 
const long double Poles_22[] = {
-0.806629499469070434376L ,
-0.520570235969917462454L ,
-0.327416474110574466536L ,
-0.196352826127515360616L ,
-0.108872451984077597159L ,
-0.0531816045858892408468L ,
-0.0210356609306781013348L ,
-0.00570661364597512596405L ,
-0.00072254796507425291654L ,
-1.34581549833048808237e-05L ,
-3.18664326043226950698e-11L ,
} ;
const long double K23[] = {
 0.280326198549807545016L ,   // basis(0)
 0.26374269458034057742L ,   // basis(0.5)
 0.219568310050317182092L ,   // basis(1)
 0.161563403314335434516L ,   // basis(1.5)
 0.104874182876882497498L ,   // basis(2)
 0.0598884046006764718112L ,   // basis(2.5)
 0.0299741594490754701042L ,   // basis(3)
 0.0130854031040473308021L ,   // basis(3.5)
 0.00495230970916637213348L ,   // basis(4)
 0.00161240876694443049683L ,   // basis(4.5)
 0.000447314117341397825535L ,   // basis(5)
 0.000104464763013597038396L ,   // basis(5.5)
 2.0225085344373592521e-05L ,   // basis(6)
 3.18289046923990635356e-06L ,   // basis(6.5)
 3.96798661290086831989e-07L ,   // basis(7)
 3.78552338529272869352e-08L ,   // basis(7.5)
 2.63467348901839379208e-09L ,   // basis(8)
 1.24884104983961410861e-10L ,   // basis(8.5)
 3.63383071656837423748e-12L ,   // basis(9)
 5.49595855548087519785e-14L ,   // basis(9.5)
 3.24484704026298260285e-16L ,   // basis(10)
 4.34114737527508147485e-19L ,   // basis(10.5)
 3.86817017063068403804e-23L ,   // basis(11)
 4.61121817902408127552e-30L ,   // basis(11.5)
 } ; 
const long double Poles_23[] = {
-0.813905623561800423832L ,
-0.535314083668485659803L ,
-0.344236276919378086036L ,
-0.212404660540193033032L ,
-0.122561160991938728421L ,
-0.0636024801541136769679L ,
-0.0278116620379407188025L ,
-0.0090795953352951493023L ,
-0.0017112714467817036613L ,
-9.57339435007398175279e-05L ,
-1.19369188160664947563e-07L ,
} ;
const long double K24[] = {
 0.274731973521188101471L ,   // basis(0)
 0.259095933885492246126L ,   // basis(0.5)
 0.217256122184060208605L ,   // basis(1)
 0.161812082117910165327L ,   // basis(1.5)
 0.106866566729597120988L ,   // basis(2)
 0.0624314258543732094415L ,   // basis(2.5)
 0.0321568163257983379026L ,   // basis(3)
 0.014541849599514216045L ,   // basis(3.5)
 0.00574294462662439229233L ,   // basis(4)
 0.00196761740283894750425L ,   // basis(4.5)
 0.000580049962700882370756L ,   // basis(5)
 0.000145635431566187893506L ,   // basis(5.5)
 3.07460180528882923814e-05L ,   // basis(6)
 5.37040360961471687212e-06L ,   // basis(6.5)
 7.60169776706315293316e-07L ,   // basis(7)
 8.48619490096167514872e-08L ,   // basis(7.5)
 7.20452818709766667257e-09L ,   // basis(8)
 4.42291850046729626149e-10L ,   // basis(8.5)
 1.82614999388872219242e-11L ,   // basis(9)
 4.54526283883070886422e-13L ,   // basis(9.5)
 5.72536381119234370332e-15L ,   // basis(10)
 2.70404290721556569e-17L ,   // basis(10.5)
 2.71321710999844103522e-20L ,   // basis(11)
 1.61173757109611834921e-24L ,   // basis(11.5)
 9.6067045396335026575e-32L ,   // basis(12)
 } ; 
const long double Poles_24[] = {
-0.820655181072953240136L ,
-0.549200963957329733618L ,
-0.360319071376742828281L ,
-0.228020147227906865145L ,
-0.136188500068012711185L ,
-0.074351497277369400168L ,
-0.0352441266658319660804L ,
-0.0132463753253008104888L ,
-0.00329768262348645466398L ,
-0.000358071544108679951611L ,
-4.8126755633104826723e-06L ,
-3.54070880733606722549e-12L ,
} ;
const long double* const precomputed_poles[] = {
  0, 
  0, 
  Poles_2, 
  Poles_3, 
  Poles_4, 
  Poles_5, 
  Poles_6, 
  Poles_7, 
  Poles_8, 
  Poles_9, 
  Poles_10, 
  Poles_11, 
  Poles_12, 
  Poles_13, 
  Poles_14, 
  Poles_15, 
  Poles_16, 
  Poles_17, 
  Poles_18, 
  Poles_19, 
  Poles_20, 
  Poles_21, 
  Poles_22, 
  Poles_23, 
  Poles_24, 
} ;
const long double* const precomputed_basis_function_values[] = {
  K0, 
  K1, 
  K2, 
  K3, 
  K4, 
  K5, 
  K6, 
  K7, 
  K8, 
  K9, 
  K10, 
  K11, 
  K12, 
  K13, 
  K14, 
  K15, 
  K16, 
  K17, 
  K18, 
  K19, 
  K20, 
  K21, 
  K22, 
  K23, 
  K24, 
} ;


} ; // end of namespace vspline_constants

#define VSPLINE_POLES_H
#endif
