/*---------------------------------------------------------------------------*\

    FILE....: VLOG.CPP
    TYPE....: C++ Console program
    AUTHOR..: Peter Wintulich
    DATE....: 20-APR-2005

    

\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#include "../kbhit.h"

#include "vpbapi.h"
#include "verbose.h"

#include <cstdio>
#include <cstdlib>
#include <cstring>

static int arg_exists(int argc, char *argv[], const char *arg)
{ //{{{
	for(int i = 0; i < argc; ++i)
		if(strcmp(argv[i],arg) == 0) return i;

	return 0;
} //}}}

int main(int argc, char * argv[])
{
	int		VERB=0;
	int	        ret,arg,i,x;
	char		date[VPB_MAX_STR];
	char		time[VPB_MAX_STR];
	char		number[VPB_MAX_STR];
	char		show[VPB_MAX_STR];
	char		temp[VPB_MAX_STR];
	WFILE		*fp;
	VPB_VLOG	detail;

	//verbose(1);
	if (argc == 1) {
		printf("\nusage (continuous tone, e.g. dial tone): \n");
		printf("%s [options] filename\n",argv[0]);
		printf("-d [year][month]dd[-[year][month]dd]\n");
		printf("-t hh:mm[-hh:mm]\n");
		printf("-n number\n");
		printf("-s vdcsentrfp/\n");
		printf("  v  Verbose\n");
		printf("  d  Date\n");
		printf("  c  Channel\n");
		printf("  s  Start time\n");
		printf("  e  End time\n");
		printf("  n  CID number\n");
		printf("  t  CID text\n");
		printf("  r  Reason for call end\n");
		printf("  f  Call flow (IN/OUT)\n");
		printf("  p  Period of call\n");
		printf("  /  new line\n");
		printf(" ' ' white space\n");
		printf("\n");
		exit(0);
	}
	date[0] = 0;
	time[0] = 0;
	number[0] = 0;
	strcpy(show, "vf/c/s/p/n/t/r/");		// default display format
	if ((arg = arg_exists(argc, argv, "-d")) != 0)
	{
		strcpy(date,argv[arg+1]);
	}
	if ((arg = arg_exists(argc, argv, "-t")) != 0)
	{
		strcpy(time,argv[arg+1]);
	}
	if ((arg = arg_exists(argc, argv, "-n")) != 0)
	{
		strcpy(number,argv[arg+1]);
	}
	if ((arg = arg_exists(argc, argv, "-s")) != 0)
	{
		strcpy(show,argv[arg+1]);
	}

	// open wave file // start with one file at a time only
//	printf("file= %s\n", argv[argc-1]);
	vpb_wave_open_read(&fp, argv[argc-1]);
	ret = vpb_wave_get_vlog(fp, &detail);
	vpb_wave_close_read(fp);

	// display format
	i=0;
	while( (show[i] != 0) && (ret==0) )
	{
		switch(show[i])
		{
			case 'v':		// Verbose display fields
				VERB=1;
				i++;
				break;
			case 'd':		// Call start date
				if(VERB == 1)
					printf("Date:");
				printf("%c%c%c%c-%c%c-%c%c ",detail.statime[0],detail.statime[1],detail.statime[2],detail.statime[3],detail.statime[4],detail.statime[5],detail.statime[6],detail.statime[7]);
				i++;
				break;
			case 'c':		// Call Channel number
				if(VERB == 1)
					printf("Line:");
				printf("%2d ",detail.channel);
				i++;
				break;
			case 's':		// Call Start time
				strcpy(temp,detail.statime+8);
				if(VERB == 1)
					printf("Start:");
				printf("%c%c:%c%c:%c%c ",temp[0],temp[1],temp[2],temp[3],temp[4],temp[5]);
				i++;
				break;
			case 'e':		// Call end time
				strcpy(temp,detail.endtime+8);
				if(VERB == 1)
					printf("Finish:");
				printf("%c%c:%c%c:%c%c ",temp[0],temp[1],temp[2],temp[3],temp[4],temp[5]);
				i++;
				break;
			case 'n':		// Caller ID number
				if(VERB == 1)
					printf("Caller ID num:");
				for(x=0;(detail.cidn[x]!=0)&&(detail.cidn[x]!=0x0a);x++)
					printf("%c",detail.cidn[x]);
				i++;
				break;
			case 't':		// Caller ID text
				if(VERB == 1)
					printf("Caller ID txt:");
				for(x=0;(detail.cidt[x]!=0)&&(detail.cidt[x]!=0x0a);x++)
					printf("%c",detail.cidt[x]);
				i++;
				break;
			case 'r':		// Call Termination Reason
				if(VERB == 1)
					printf("Completion:");
				for(x=0;(detail.term[x]!=0)&&(detail.term[x]!=0x0a);x++)
					printf("%c",detail.term[x]);
				i++;
				break;
			case 'f':		// Direction of call
				if(VERB == 1)
					printf("Call:");
				for(x=0;(detail.inout[x]!=0)&&(detail.inout[x]!=0x0a);x++)
					printf("%c",detail.inout[x]);
				i++;
				break;
			case 'p':		// Duration of call 
				{
					int hour,min,sec;
					hour= (detail.endtime[9]-' ')+(10*(detail.endtime[8]-' '))-(detail.statime[9]-' ')-(10*(detail.statime[8]-' '));
					if(hour<0)
						hour= 24 + hour;
					min = (detail.endtime[11]-' ')+(10*(detail.endtime[10]-' '))-(detail.statime[11]-' ')-(10*(detail.statime[10]-' '));
					if(min <0)
					{
						min = 60 + min;
						hour--;
					}
					sec = (detail.endtime[13]-' ')+(10*(detail.endtime[12]-' '))-(detail.statime[13]-' ')-(10*(detail.statime[12]-' '));
					if(sec <0)
					{
						sec = 60 + sec;
						min--;
					}
					if(min <0)
					{
						min = 60 + min;
						hour--;
					}
					sprintf(temp,"%02d:%02d:%02d",hour,min,sec);
				}
				if(VERB == 1)
					printf("Duration:%s",temp);
				else
					printf("%s",temp);
				i++;
				break;
			case '/':		// treat as new line
				printf("\n");
				i++;
				break;
			case '"':		// Ignore Double Quotes
				i++;
				break;
			default:		// any other %c as is
				printf("%c",show[i]);
				i++;
				break;
		}
	}
	if(ret != 0)
		printf("No VLOG data in file\n");

	return 0;
}

