c###timvar.for
      SUBROUTINE TIMVAR
C--------------------------------
C
C     THIS ROUTINE EVALUATES THE ZENITH ANGLE, RATIO OF F2 LAYER HEIGHT
C     OF MAXIMUM TO SEMITHICKNESS AND ABSORPTION INDEX.
C     SUBROUTINE EF1VAR IS CALLED TO EVALUATE THE E AND F1 PARAMETERS
C
      COMMON / TIME / IT, GMT, UTIME(24), GMTR, XLMT(24), ITIM, JTX
      COMMON / CON / D2R, DCL, GAMA, PI, PI2, PIO2, R2D, RZ, VOFL
      COMMON /RON /CLAT(5), CLONG(5), GLAT(5), RD(5), FI(3,5), YI(3,5),
     1HI(3,5), HPRIM(30,5), HTRUE(30,5), FVERT(30,5),KM,KFX, AFAC(30,5),
     2HTR(50,3), FNSQ(50,3)
      COMMON/GEOG/GYZ(5),RAT(5),GMDIP(5),CLCK(5),ABIY(5),ARTIC(5),SIGPAT
     A(5), EPSPAT(5)
      COMMON / SSP / SUN(2,12), MONTH
C.....LONGITUDE OF NOON
      SSL = (180. - 15. * GMT) * D2R
      IF (KM .LT. 1) GO TO 160
      DO 155 II = 1, KM
C.....SAMPLE AREA LONGITUDE AND LATITUDE
      CENLG = CLONG (II)
      CENLAT = CLAT (II)
      CENDOG = ABS(CENLAT - D2R * SUN(1,MONTH))
C.....SSP IS THE LATITUDE OF THE SUBSOLAR POINT
      SSP = SUN(2,MONTH) * D2R
      CENCAT = ABS (CENLAT - SSP)
      IF (CENDOG - CENCAT)105, 105, 100
C.....SSP IS THE LATITUDE OF THE SUBSOLAR POINT
  100 SSP = SUN(1,MONTH) * D2R
  105 CLOCK = GMT + CENLG / .261799387
      IF (24. - CLOCK)110, 115, 115
  110 CLOCK = CLOCK - 24.
      GO TO 125
  115 IF (CLOCK)120, 120, 125
  120 CLOCK = CLOCK + 24.
C.....CLCK(II) IS LOCAL MEAN TIME
  125 CLCK (II) = CLOCK
      Z = CENLG - SSL
      CYCEN = SIN (CENLAT) * SIN (SSP) + COS (CENLAT) * COS (SSP) * COS
     1(Z)
C.....CYCEN IS THE ZENITH ANGLE
      CYCEN = ACOS (CYCEN)
C.....EVALUATE THE E AND F1 LAYER PARAMETERS
      CALL EF1VAR (CYCEN, II)
C.....GLAT(II) IS THE GEOMAGNETIC LATITUDE
      GM = ABS (GLAT (II)) * R2D - 45.
      Z = CYCEN * R2D
      IF (CLOCK - 12.0)135, 140, 140
  135 Z = - Z
  140 Z = Z + 180.0
C.....EVALUATE RATIO MAP
      CALL NOISY (8, GM, Z, YM)
      IF (YM - 2.0)145, 150, 150
  145 YM = 2.0
C.....RAT(II) IS RATIO OF F2 HEIGHT OF MAXIMUM IONIZATION TO SEMITHICK
C.....ABIY(II) IS ABSORPTION INDEX AS RELATED TO E LAYER CRITICAL FREQ
  150 RAT (II) = YM
      ABI = - .04 + EXP ( - 2.937 + .8445 * FI (1, II))
      ABIY (II) = ABI
  155 CONTINUE
  160 CONTINUE
      RETURN
      END
C--------------------------------
