from unittest import mock

from vmms.tests import base
from vmms.policy import enforcer


class TestPolicyEnforcer(base.VMMSPolicyTestCase):
    """Test policy rule enforcement."""

    def test_vmms_viewer_can_list(self):
        """Test that vmms_viewer can list VMs."""
        creds = self._create_creds(roles=['vmms_viewer'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:list', creds, target, should_pass=True)

    def test_vmms_viewer_cannot_set(self):
        """Test that vmms_viewer cannot set VMs."""
        creds = self._create_creds(roles=['vmms_viewer'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:update', creds, target, should_pass=False)

    def test_vmms_operator_can_list(self):
        """Test that vmms_operator can list VMs."""
        creds = self._create_creds(roles=['vmms_operator'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:list', creds, target, should_pass=True)

    def test_vmms_operator_can_set(self):
        """Test that vmms_operator can set VMs."""
        creds = self._create_creds(roles=['vmms_operator'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:update', creds, target, should_pass=True)

    def test_admin_can_list(self):
        """Test that admin can list VMs."""
        creds = self._create_creds(roles=['admin'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:list', creds, target, should_pass=True)

    def test_admin_can_set(self):
        """Test that admin can set VMs."""
        creds = self._create_creds(roles=['admin'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:update', creds, target, should_pass=True)

    def test_regular_user_cannot_list(self):
        """Test that regular user cannot list VMs."""
        creds = self._create_creds(roles=['member'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:list', creds, target, should_pass=False)

    def test_regular_user_cannot_set(self):
        """Test that regular user cannot set VMs."""
        creds = self._create_creds(roles=['member'])
        target = self._create_target()
        
        self.assertRuleIsEnforced('vmms:update', creds, target, should_pass=False)


class TestPolicyDecorator(base.VMMSPolicyTestCase):
    """Test policy decorator functionality."""

    def test_require_policy_factory_creates_decorator(self):
        """Test that require_policy_factory creates a decorator."""
        def mock_get_config():
            # Return a simple mock config for testing
            mock_conf = mock.Mock()
            return mock_conf
            
        decorator_factory = enforcer.require_policy_factory(mock_get_config)
        decorator = decorator_factory('vmms:list')
        
        self.assertIsNotNone(decorator)
