// Copyright 2015, VIXL authors
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//   * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//   * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//   * Neither the name of ARM Limited nor the names of its contributors may be
//     used to endorse or promote products derived from this software without
//     specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


// ---------------------------------------------------------------------
// This file is auto generated using tools/generate_simulator_traces.py.
//
// PLEASE DO NOT EDIT.
// ---------------------------------------------------------------------

#ifndef VIXL_SIM_SMULL2_4S_TRACE_AARCH64_H_
#define VIXL_SIM_SMULL2_4S_TRACE_AARCH64_H_

const uint32_t kExpected_NEON_smull2_4S[] = {
  0x3ffd0009, 0x3ffe0004, 0x3fff0001, 0x00000000,
  0x3ffd8006, 0x3ffe8002, 0x00000000, 0x00000000,
  0x3ffe0003, 0x00000000, 0x00007fff, 0x00000000,
  0x00000000, 0x00007ffe, 0x0000fffe, 0x00000000,
  0x00007ffd, 0x0000fffc, 0x0007fff0, 0x00000000,
  0x0000fffa, 0x0007ffe0, 0x003e7f83, 0x00000000,
  0x0007ffd0, 0x003e7f06, 0x003eff82, 0x00000000,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0x00000000,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0x00000000,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0x00000000,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0x00000000,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0x00000000,
  0x3ffd0009, 0x3ffe0004, 0x3fff0001, 0x00000000,
  0x3ffd8006, 0x3ffe8002, 0xc0008000, 0x00000000,
  0x3ffe0003, 0xc0010000, 0xc000ffff, 0x00000000,
  0xc0018000, 0xc0017ffe, 0xd5555556, 0x00000000,
  0xc001fffd, 0xd555aaac, 0xe6663334, 0x00000000,
  0xd5560002, 0xe6666668, 0xffc00080, 0x00000000,
  0xe666999c, 0xffc00100, 0xffc0807f, 0x00000000,
  0xffc00180, 0xffc080fe, 0xffc1007e, 0x00000000,
  0xffc0817d, 0xffc100fc, 0xffc1807d, 0x00000000,
  0xffc1017a, 0xffc180fa, 0xfff80010, 0x00000000,
  0xffc18177, 0xfff80020, 0xfffe8003, 0x00000000,
  0xfff80030, 0xfffe8006, 0xffff0002, 0x00000000,
  0xfffe8006, 0xffff0002, 0x00000000, 0x00000000,
  0xffff0004, 0xffff8001, 0x00000000, 0x00000001,
  0xffff8002, 0x00000000, 0x00000000, 0x00000002,
  0x00000000, 0x00007fff, 0x00000000, 0x00000010,
  0x00007ffe, 0x0000fffe, 0x00000000, 0x0000007d,
  0x0000fffc, 0x0007fff0, 0x00000000, 0x0000007e,
  0x0007ffe0, 0x003e7f83, 0x00000000, 0x0000007f,
  0x003e7f06, 0x003eff82, 0x00000000, 0x00003333,
  0x003eff04, 0x003f7f81, 0x00000000, 0x00005555,
  0x003f7f02, 0x19994ccd, 0x00000000, 0x00007ffd,
  0x1999199a, 0x2aaa2aab, 0x00000000, 0x00007ffe,
  0x2aa9d556, 0x3ffe0003, 0x00000000, 0x00007fff,
  0x3ffd8006, 0x3ffe8002, 0x00000000, 0xffff8000,
  0x3ffe0004, 0x3fff0001, 0x00000000, 0xffff8001,
  0x3ffe8002, 0xc0008000, 0x00000000, 0xffffaaaa,
  0xc0010000, 0xc000ffff, 0x00000000, 0xffffcccc,
  0xc0017ffe, 0xd5555556, 0x00000000, 0xffffff80,
  0xd555aaac, 0xe6663334, 0x00000000, 0xffffff81,
  0xe6666668, 0xffc00080, 0x00000000, 0xffffff82,
  0xffc00100, 0xffc0807f, 0x00000000, 0xffffff83,
  0xffc080fe, 0xffc1007e, 0x00000000, 0xfffffff0,
  0xffc100fc, 0xffc1807d, 0x00000000, 0xfffffffd,
  0xffc180fa, 0xfff80010, 0x00000000, 0xfffffffe,
  0xfff80020, 0xfffe8003, 0x00000000, 0xffffffff,
  0xfffe8003, 0x00000000, 0xffffffff, 0x00000000,
  0xffff0002, 0x00000000, 0x00000000, 0x00000002,
  0xffff8001, 0x00000000, 0x00000001, 0x00000004,
  0x00000000, 0x00000000, 0x00000002, 0x00000020,
  0x00007fff, 0x00000000, 0x00000010, 0x000000fa,
  0x0000fffe, 0x00000000, 0x0000007d, 0x000000fc,
  0x0007fff0, 0x00000000, 0x0000007e, 0x000000fe,
  0x003e7f83, 0x00000000, 0x0000007f, 0x00006666,
  0x003eff82, 0x00000000, 0x00003333, 0x0000aaaa,
  0x003f7f81, 0x00000000, 0x00005555, 0x0000fffa,
  0x19994ccd, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x2aaa2aab, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x3ffe0003, 0x00000000, 0x00007fff, 0xffff0000,
  0x3ffe8002, 0x00000000, 0xffff8000, 0xffff0002,
  0x3fff0001, 0x00000000, 0xffff8001, 0xffff5554,
  0xc0008000, 0x00000000, 0xffffaaaa, 0xffff9998,
  0xc000ffff, 0x00000000, 0xffffcccc, 0xffffff00,
  0xd5555556, 0x00000000, 0xffffff80, 0xffffff02,
  0xe6663334, 0x00000000, 0xffffff81, 0xffffff04,
  0xffc00080, 0x00000000, 0xffffff82, 0xffffff06,
  0xffc0807f, 0x00000000, 0xffffff83, 0xffffffe0,
  0xffc1007e, 0x00000000, 0xfffffff0, 0xfffffffa,
  0xffc1807d, 0x00000000, 0xfffffffd, 0xfffffffc,
  0xfff80010, 0x00000000, 0xfffffffe, 0xfffffffe,
  0x00000000, 0xfffffffe, 0xfffffffe, 0x00000000,
  0x00000000, 0xffffffff, 0x00000000, 0x00000010,
  0x00000000, 0x00000000, 0x00000002, 0x00000020,
  0x00000000, 0x00000001, 0x00000004, 0x00000100,
  0x00000000, 0x00000002, 0x00000020, 0x000007d0,
  0x00000000, 0x00000010, 0x000000fa, 0x000007e0,
  0x00000000, 0x0000007d, 0x000000fc, 0x000007f0,
  0x00000000, 0x0000007e, 0x000000fe, 0x00033330,
  0x00000000, 0x0000007f, 0x00006666, 0x00055550,
  0x00000000, 0x00003333, 0x0000aaaa, 0x0007ffd0,
  0x00000000, 0x00005555, 0x0000fffa, 0x0007ffe0,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x0007fff0,
  0x00000000, 0x00007ffe, 0x0000fffe, 0xfff80000,
  0x00000000, 0x00007fff, 0xffff0000, 0xfff80010,
  0x00000000, 0xffff8000, 0xffff0002, 0xfffaaaa0,
  0x00000000, 0xffff8001, 0xffff5554, 0xfffcccc0,
  0x00000000, 0xffffaaaa, 0xffff9998, 0xfffff800,
  0x00000000, 0xffffcccc, 0xffffff00, 0xfffff810,
  0x00000000, 0xffffff80, 0xffffff02, 0xfffff820,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff830,
  0x00000000, 0xffffff82, 0xffffff06, 0xffffff00,
  0x00000000, 0xffffff83, 0xffffffe0, 0xffffffd0,
  0x00000000, 0xfffffff0, 0xfffffffa, 0xffffffe0,
  0x00000000, 0xfffffffd, 0xfffffffc, 0xfffffff0,
  0xfffffffd, 0xfffffffc, 0xfffffff0, 0x00000000,
  0xfffffffe, 0xfffffffe, 0x00000000, 0x0000007d,
  0xffffffff, 0x00000000, 0x00000010, 0x000000fa,
  0x00000000, 0x00000002, 0x00000020, 0x000007d0,
  0x00000001, 0x00000004, 0x00000100, 0x00003d09,
  0x00000002, 0x00000020, 0x000007d0, 0x00003d86,
  0x00000010, 0x000000fa, 0x000007e0, 0x00003e03,
  0x0000007d, 0x000000fc, 0x000007f0, 0x0018ffe7,
  0x0000007e, 0x000000fe, 0x00033330, 0x0029aa81,
  0x0000007f, 0x00006666, 0x00055550, 0x003e7e89,
  0x00003333, 0x0000aaaa, 0x0007ffd0, 0x003e7f06,
  0x00005555, 0x0000fffa, 0x0007ffe0, 0x003e7f83,
  0x00007ffd, 0x0000fffc, 0x0007fff0, 0xffc18000,
  0x00007ffe, 0x0000fffe, 0xfff80000, 0xffc1807d,
  0x00007fff, 0xffff0000, 0xfff80010, 0xffd65502,
  0xffff8000, 0xffff0002, 0xfffaaaa0, 0xffe6ff9c,
  0xffff8001, 0xffff5554, 0xfffcccc0, 0xffffc180,
  0xffffaaaa, 0xffff9998, 0xfffff800, 0xffffc1fd,
  0xffffcccc, 0xffffff00, 0xfffff810, 0xffffc27a,
  0xffffff80, 0xffffff02, 0xfffff820, 0xffffc2f7,
  0xffffff81, 0xffffff04, 0xfffff830, 0xfffff830,
  0xffffff82, 0xffffff06, 0xffffff00, 0xfffffe89,
  0xffffff83, 0xffffffe0, 0xffffffd0, 0xffffff06,
  0xfffffff0, 0xfffffffa, 0xffffffe0, 0xffffff83,
  0xfffffffa, 0xffffffe0, 0xffffff83, 0x00000000,
  0xfffffffc, 0xfffffff0, 0x00000000, 0x0000007e,
  0xfffffffe, 0x00000000, 0x0000007d, 0x000000fc,
  0x00000000, 0x00000010, 0x000000fa, 0x000007e0,
  0x00000002, 0x00000020, 0x000007d0, 0x00003d86,
  0x00000004, 0x00000100, 0x00003d09, 0x00003e04,
  0x00000020, 0x000007d0, 0x00003d86, 0x00003e82,
  0x000000fa, 0x000007e0, 0x00003e03, 0x0019331a,
  0x000000fc, 0x000007f0, 0x0018ffe7, 0x0029ffd6,
  0x000000fe, 0x00033330, 0x0029aa81, 0x003efe86,
  0x00006666, 0x00055550, 0x003e7e89, 0x003eff04,
  0x0000aaaa, 0x0007ffd0, 0x003e7f06, 0x003eff82,
  0x0000fffa, 0x0007ffe0, 0x003e7f83, 0xffc10000,
  0x0000fffc, 0x0007fff0, 0xffc18000, 0xffc1007e,
  0x0000fffe, 0xfff80000, 0xffc1807d, 0xffd5ffac,
  0xffff0000, 0xfff80010, 0xffd65502, 0xffe6cc68,
  0xffff0002, 0xfffaaaa0, 0xffe6ff9c, 0xffffc100,
  0xffff5554, 0xfffcccc0, 0xffffc180, 0xffffc17e,
  0xffff9998, 0xfffff800, 0xffffc1fd, 0xffffc1fc,
  0xffffff00, 0xfffff810, 0xffffc27a, 0xffffc27a,
  0xffffff02, 0xfffff820, 0xffffc2f7, 0xfffff820,
  0xffffff04, 0xfffff830, 0xfffff830, 0xfffffe86,
  0xffffff06, 0xffffff00, 0xfffffe89, 0xffffff04,
  0xffffffe0, 0xffffffd0, 0xffffff06, 0xffffff82,
  0xffffffd0, 0xffffff06, 0xffffff82, 0x00000000,
  0xffffffe0, 0xffffff83, 0x00000000, 0x0000007f,
  0xfffffff0, 0x00000000, 0x0000007e, 0x000000fe,
  0x00000000, 0x0000007d, 0x000000fc, 0x000007f0,
  0x00000010, 0x000000fa, 0x000007e0, 0x00003e03,
  0x00000020, 0x000007d0, 0x00003d86, 0x00003e82,
  0x00000100, 0x00003d09, 0x00003e04, 0x00003f01,
  0x000007d0, 0x00003d86, 0x00003e82, 0x0019664d,
  0x000007e0, 0x00003e03, 0x0019331a, 0x002a552b,
  0x000007f0, 0x0018ffe7, 0x0029ffd6, 0x003f7e83,
  0x00033330, 0x0029aa81, 0x003efe86, 0x003f7f02,
  0x00055550, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x0007ffd0, 0x003e7f06, 0x003eff82, 0xffc08000,
  0x0007ffe0, 0x003e7f83, 0xffc10000, 0xffc0807f,
  0x0007fff0, 0xffc18000, 0xffc1007e, 0xffd5aa56,
  0xfff80000, 0xffc1807d, 0xffd5ffac, 0xffe69934,
  0xfff80010, 0xffd65502, 0xffe6cc68, 0xffffc080,
  0xfffaaaa0, 0xffe6ff9c, 0xffffc100, 0xffffc0ff,
  0xfffcccc0, 0xffffc180, 0xffffc17e, 0xffffc17e,
  0xfffff800, 0xffffc1fd, 0xffffc1fc, 0xffffc1fd,
  0xfffff810, 0xffffc27a, 0xffffc27a, 0xfffff810,
  0xfffff820, 0xffffc2f7, 0xfffff820, 0xfffffe83,
  0xfffff830, 0xfffff830, 0xfffffe86, 0xffffff02,
  0xffffff00, 0xfffffe89, 0xffffff04, 0xffffff81,
  0xfffffe89, 0xffffff04, 0xffffff81, 0x00000000,
  0xffffff06, 0xffffff82, 0x00000000, 0x00003333,
  0xffffff83, 0x00000000, 0x0000007f, 0x00006666,
  0x00000000, 0x0000007e, 0x000000fe, 0x00033330,
  0x0000007d, 0x000000fc, 0x000007f0, 0x0018ffe7,
  0x000000fa, 0x000007e0, 0x00003e03, 0x0019331a,
  0x000007d0, 0x00003d86, 0x00003e82, 0x0019664d,
  0x00003d09, 0x00003e04, 0x00003f01, 0x0a3d5c29,
  0x00003d86, 0x00003e82, 0x0019664d, 0x1110eeef,
  0x00003e03, 0x0019331a, 0x002a552b, 0x1998e667,
  0x0018ffe7, 0x0029ffd6, 0x003f7e83, 0x1999199a,
  0x0029aa81, 0x003efe86, 0x003f7f02, 0x19994ccd,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0xe6668000,
  0x003e7f06, 0x003eff82, 0xffc08000, 0xe666b333,
  0x003e7f83, 0xffc10000, 0xffc0807f, 0xeeeeddde,
  0xffc18000, 0xffc1007e, 0xffd5aa56, 0xf5c270a4,
  0xffc1807d, 0xffd5ffac, 0xffe69934, 0xffe66680,
  0xffd65502, 0xffe6cc68, 0xffffc080, 0xffe699b3,
  0xffe6ff9c, 0xffffc100, 0xffffc0ff, 0xffe6cce6,
  0xffffc180, 0xffffc17e, 0xffffc17e, 0xffe70019,
  0xffffc1fd, 0xffffc1fc, 0xffffc1fd, 0xfffcccd0,
  0xffffc27a, 0xffffc27a, 0xfffff810, 0xffff6667,
  0xffffc2f7, 0xfffff820, 0xfffffe83, 0xffff999a,
  0xfffff830, 0xfffffe86, 0xffffff02, 0xffffcccd,
  0xfffffe86, 0xffffff02, 0xffffcccd, 0x00000000,
  0xffffff04, 0xffffff81, 0x00000000, 0x00005555,
  0xffffff82, 0x00000000, 0x00003333, 0x0000aaaa,
  0x00000000, 0x0000007f, 0x00006666, 0x00055550,
  0x0000007e, 0x000000fe, 0x00033330, 0x0029aa81,
  0x000000fc, 0x000007f0, 0x0018ffe7, 0x0029ffd6,
  0x000007e0, 0x00003e03, 0x0019331a, 0x002a552b,
  0x00003d86, 0x00003e82, 0x0019664d, 0x1110eeef,
  0x00003e04, 0x00003f01, 0x0a3d5c29, 0x1c718e39,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0xd5558000,
  0x003eff04, 0x003f7f81, 0xe6668000, 0xd555d555,
  0x003eff82, 0xffc08000, 0xe666b333, 0xe38e1c72,
  0xffc10000, 0xffc0807f, 0xeeeeddde, 0xeeeebbbc,
  0xffc1007e, 0xffd5aa56, 0xf5c270a4, 0xffd55580,
  0xffd5ffac, 0xffe69934, 0xffe66680, 0xffd5aad5,
  0xffe6cc68, 0xffffc080, 0xffe699b3, 0xffd6002a,
  0xffffc100, 0xffffc0ff, 0xffe6cce6, 0xffd6557f,
  0xffffc17e, 0xffffc17e, 0xffe70019, 0xfffaaab0,
  0xffffc1fc, 0xffffc1fd, 0xfffcccd0, 0xffff0001,
  0xffffc27a, 0xfffff810, 0xffff6667, 0xffff5556,
  0xfffff820, 0xfffffe83, 0xffff999a, 0xffffaaab,
  0xfffffe83, 0xffff999a, 0xffffaaab, 0x00000000,
  0xffffff02, 0xffffcccd, 0x00000000, 0x00007ffd,
  0xffffff81, 0x00000000, 0x00005555, 0x0000fffa,
  0x00000000, 0x00003333, 0x0000aaaa, 0x0007ffd0,
  0x0000007f, 0x00006666, 0x00055550, 0x003e7e89,
  0x000000fe, 0x00033330, 0x0029aa81, 0x003efe86,
  0x000007f0, 0x0018ffe7, 0x0029ffd6, 0x003f7e83,
  0x00003e03, 0x0019331a, 0x002a552b, 0x1998e667,
  0x00003e82, 0x0019664d, 0x1110eeef, 0x2aa98001,
  0x00003f01, 0x0a3d5c29, 0x1c718e39, 0x3ffd0009,
  0x0019664d, 0x1110eeef, 0x2aa98001, 0x3ffd8006,
  0x002a552b, 0x1998e667, 0x2aa9d556, 0x3ffe0003,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0xc0018000,
  0x003f7f02, 0x19994ccd, 0xd5558000, 0xc001fffd,
  0x003f7f81, 0xe6668000, 0xd555d555, 0xd5560002,
  0xffc08000, 0xe666b333, 0xe38e1c72, 0xe666999c,
  0xffc0807f, 0xeeeeddde, 0xeeeebbbc, 0xffc00180,
  0xffd5aa56, 0xf5c270a4, 0xffd55580, 0xffc0817d,
  0xffe69934, 0xffe66680, 0xffd5aad5, 0xffc1017a,
  0xffffc080, 0xffe699b3, 0xffd6002a, 0xffc18177,
  0xffffc0ff, 0xffe6cce6, 0xffd6557f, 0xfff80030,
  0xffffc17e, 0xffe70019, 0xfffaaab0, 0xfffe8009,
  0xffffc1fd, 0xfffcccd0, 0xffff0001, 0xffff0006,
  0xfffff810, 0xffff6667, 0xffff5556, 0xffff8003,
  0xffff6667, 0xffff5556, 0xffff8003, 0x00000000,
  0xffff999a, 0xffffaaab, 0x00000000, 0x00007ffe,
  0xffffcccd, 0x00000000, 0x00007ffd, 0x0000fffc,
  0x00000000, 0x00005555, 0x0000fffa, 0x0007ffe0,
  0x00003333, 0x0000aaaa, 0x0007ffd0, 0x003e7f06,
  0x00006666, 0x00055550, 0x003e7e89, 0x003eff04,
  0x00033330, 0x0029aa81, 0x003efe86, 0x003f7f02,
  0x0018ffe7, 0x0029ffd6, 0x003f7e83, 0x1999199a,
  0x0019331a, 0x002a552b, 0x1998e667, 0x2aa9d556,
  0x0019664d, 0x1110eeef, 0x2aa98001, 0x3ffd8006,
  0x0a3d5c29, 0x1c718e39, 0x3ffd0009, 0x3ffe0004,
  0x1110eeef, 0x2aa98001, 0x3ffd8006, 0x3ffe8002,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0xc0010000,
  0x1999199a, 0x2aaa2aab, 0xc0018000, 0xc0017ffe,
  0x19994ccd, 0xd5558000, 0xc001fffd, 0xd555aaac,
  0xe6668000, 0xd555d555, 0xd5560002, 0xe6666668,
  0xe666b333, 0xe38e1c72, 0xe666999c, 0xffc00100,
  0xeeeeddde, 0xeeeebbbc, 0xffc00180, 0xffc080fe,
  0xf5c270a4, 0xffd55580, 0xffc0817d, 0xffc100fc,
  0xffe66680, 0xffd5aad5, 0xffc1017a, 0xffc180fa,
  0xffe699b3, 0xffd6002a, 0xffc18177, 0xfff80020,
  0xffe6cce6, 0xffd6557f, 0xfff80030, 0xfffe8006,
  0xffe70019, 0xfffaaab0, 0xfffe8009, 0xffff0004,
  0xfffcccd0, 0xffff0001, 0xffff0006, 0xffff8002,
  0xffff0001, 0xffff0006, 0xffff8002, 0x00000000,
  0xffff5556, 0xffff8003, 0x00000000, 0x00007fff,
  0xffffaaab, 0x00000000, 0x00007ffe, 0x0000fffe,
  0x00000000, 0x00007ffd, 0x0000fffc, 0x0007fff0,
  0x00005555, 0x0000fffa, 0x0007ffe0, 0x003e7f83,
  0x0000aaaa, 0x0007ffd0, 0x003e7f06, 0x003eff82,
  0x00055550, 0x003e7e89, 0x003eff04, 0x003f7f81,
  0x0029aa81, 0x003efe86, 0x003f7f02, 0x19994ccd,
  0x0029ffd6, 0x003f7e83, 0x1999199a, 0x2aaa2aab,
  0x002a552b, 0x1998e667, 0x2aa9d556, 0x3ffe0003,
  0x1110eeef, 0x2aa98001, 0x3ffd8006, 0x3ffe8002,
  0x1c718e39, 0x3ffd0009, 0x3ffe0004, 0x3fff0001,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0xc0008000,
  0x2aa9d556, 0x3ffe0003, 0xc0010000, 0xc000ffff,
  0x2aaa2aab, 0xc0018000, 0xc0017ffe, 0xd5555556,
  0xd5558000, 0xc001fffd, 0xd555aaac, 0xe6663334,
  0xd555d555, 0xd5560002, 0xe6666668, 0xffc00080,
  0xe38e1c72, 0xe666999c, 0xffc00100, 0xffc0807f,
  0xeeeebbbc, 0xffc00180, 0xffc080fe, 0xffc1007e,
  0xffd55580, 0xffc0817d, 0xffc100fc, 0xffc1807d,
  0xffd5aad5, 0xffc1017a, 0xffc180fa, 0xfff80010,
  0xffd6002a, 0xffc18177, 0xfff80020, 0xfffe8003,
  0xffd6557f, 0xfff80030, 0xfffe8006, 0xffff0002,
  0xfffaaab0, 0xfffe8009, 0xffff0004, 0xffff8001,
  0xfffe8009, 0xffff0004, 0xffff8001, 0x00000000,
  0xffff0006, 0xffff8002, 0x00000000, 0xffff8000,
  0xffff8003, 0x00000000, 0x00007fff, 0xffff0000,
  0x00000000, 0x00007ffe, 0x0000fffe, 0xfff80000,
  0x00007ffd, 0x0000fffc, 0x0007fff0, 0xffc18000,
  0x0000fffa, 0x0007ffe0, 0x003e7f83, 0xffc10000,
  0x0007ffd0, 0x003e7f06, 0x003eff82, 0xffc08000,
  0x003e7e89, 0x003eff04, 0x003f7f81, 0xe6668000,
  0x003efe86, 0x003f7f02, 0x19994ccd, 0xd5558000,
  0x003f7e83, 0x1999199a, 0x2aaa2aab, 0xc0018000,
  0x1998e667, 0x2aa9d556, 0x3ffe0003, 0xc0010000,
  0x2aa98001, 0x3ffd8006, 0x3ffe8002, 0xc0008000,
  0x3ffd0009, 0x3ffe0004, 0x3fff0001, 0x40000000,
  0x3ffd8006, 0x3ffe8002, 0xc0008000, 0x3fff8000,
  0x3ffe0003, 0xc0010000, 0xc000ffff, 0x2aab0000,
  0xc0018000, 0xc0017ffe, 0xd5555556, 0x199a0000,
  0xc001fffd, 0xd555aaac, 0xe6663334, 0x00400000,
  0xd5560002, 0xe6666668, 0xffc00080, 0x003f8000,
  0xe666999c, 0xffc00100, 0xffc0807f, 0x003f0000,
  0xffc00180, 0xffc080fe, 0xffc1007e, 0x003e8000,
  0xffc0817d, 0xffc100fc, 0xffc1807d, 0x00080000,
  0xffc1017a, 0xffc180fa, 0xfff80010, 0x00018000,
  0xffc18177, 0xfff80020, 0xfffe8003, 0x00010000,
  0xfff80030, 0xfffe8006, 0xffff0002, 0x00008000,
  0xfffe8006, 0xffff0002, 0x00008000, 0x00000000,
  0xffff0004, 0xffff8001, 0x00000000, 0xffff8001,
  0xffff8002, 0x00000000, 0xffff8000, 0xffff0002,
  0x00000000, 0x00007fff, 0xffff0000, 0xfff80010,
  0x00007ffe, 0x0000fffe, 0xfff80000, 0xffc1807d,
  0x0000fffc, 0x0007fff0, 0xffc18000, 0xffc1007e,
  0x0007ffe0, 0x003e7f83, 0xffc10000, 0xffc0807f,
  0x003e7f06, 0x003eff82, 0xffc08000, 0xe666b333,
  0x003eff04, 0x003f7f81, 0xe6668000, 0xd555d555,
  0x003f7f02, 0x19994ccd, 0xd5558000, 0xc001fffd,
  0x1999199a, 0x2aaa2aab, 0xc0018000, 0xc0017ffe,
  0x2aa9d556, 0x3ffe0003, 0xc0010000, 0xc000ffff,
  0x3ffd8006, 0x3ffe8002, 0xc0008000, 0x3fff8000,
  0x3ffe0004, 0x3fff0001, 0x40000000, 0x3fff0001,
  0x3ffe8002, 0xc0008000, 0x3fff8000, 0x2aaaaaaa,
  0xc0010000, 0xc000ffff, 0x2aab0000, 0x1999cccc,
  0xc0017ffe, 0xd5555556, 0x199a0000, 0x003fff80,
  0xd555aaac, 0xe6663334, 0x00400000, 0x003f7f81,
  0xe6666668, 0xffc00080, 0x003f8000, 0x003eff82,
  0xffc00100, 0xffc0807f, 0x003f0000, 0x003e7f83,
  0xffc080fe, 0xffc1007e, 0x003e8000, 0x0007fff0,
  0xffc100fc, 0xffc1807d, 0x00080000, 0x00017ffd,
  0xffc180fa, 0xfff80010, 0x00018000, 0x0000fffe,
  0xfff80020, 0xfffe8003, 0x00010000, 0x00007fff,
  0xfffe8003, 0x00010000, 0x00007fff, 0x00000000,
  0xffff0002, 0x00008000, 0x00000000, 0xffffaaaa,
  0xffff8001, 0x00000000, 0xffff8001, 0xffff5554,
  0x00000000, 0xffff8000, 0xffff0002, 0xfffaaaa0,
  0x00007fff, 0xffff0000, 0xfff80010, 0xffd65502,
  0x0000fffe, 0xfff80000, 0xffc1807d, 0xffd5ffac,
  0x0007fff0, 0xffc18000, 0xffc1007e, 0xffd5aa56,
  0x003e7f83, 0xffc10000, 0xffc0807f, 0xeeeeddde,
  0x003eff82, 0xffc08000, 0xe666b333, 0xe38e1c72,
  0x003f7f81, 0xe6668000, 0xd555d555, 0xd5560002,
  0x19994ccd, 0xd5558000, 0xc001fffd, 0xd555aaac,
  0x2aaa2aab, 0xc0018000, 0xc0017ffe, 0xd5555556,
  0x3ffe0003, 0xc0010000, 0xc000ffff, 0x2aab0000,
  0x3ffe8002, 0xc0008000, 0x3fff8000, 0x2aaaaaaa,
  0x3fff0001, 0x40000000, 0x3fff0001, 0x1c7238e4,
  0xc0008000, 0x3fff8000, 0x2aaaaaaa, 0x11117778,
  0xc000ffff, 0x2aab0000, 0x1999cccc, 0x002aab00,
  0xd5555556, 0x199a0000, 0x003fff80, 0x002a55aa,
  0xe6663334, 0x00400000, 0x003f7f81, 0x002a0054,
  0xffc00080, 0x003f8000, 0x003eff82, 0x0029aafe,
  0xffc0807f, 0x003f0000, 0x003e7f83, 0x00055560,
  0xffc1007e, 0x003e8000, 0x0007fff0, 0x00010002,
  0xffc1807d, 0x00080000, 0x00017ffd, 0x0000aaac,
  0xfff80010, 0x00018000, 0x0000fffe, 0x00005556,
  0x00018000, 0x0000fffe, 0x00005556, 0x00000000,
  0x00010000, 0x00007fff, 0x00000000, 0xffffcccc,
  0x00008000, 0x00000000, 0xffffaaaa, 0xffff9998,
  0x00000000, 0xffff8001, 0xffff5554, 0xfffcccc0,
  0xffff8000, 0xffff0002, 0xfffaaaa0, 0xffe6ff9c,
  0xffff0000, 0xfff80010, 0xffd65502, 0xffe6cc68,
  0xfff80000, 0xffc1807d, 0xffd5ffac, 0xffe69934,
  0xffc18000, 0xffc1007e, 0xffd5aa56, 0xf5c270a4,
  0xffc10000, 0xffc0807f, 0xeeeeddde, 0xeeeebbbc,
  0xffc08000, 0xe666b333, 0xe38e1c72, 0xe666999c,
  0xe6668000, 0xd555d555, 0xd5560002, 0xe6666668,
  0xd5558000, 0xc001fffd, 0xd555aaac, 0xe6663334,
  0xc0018000, 0xc0017ffe, 0xd5555556, 0x199a0000,
  0xc0010000, 0xc000ffff, 0x2aab0000, 0x1999cccc,
  0xc0008000, 0x3fff8000, 0x2aaaaaaa, 0x11117778,
  0x40000000, 0x3fff0001, 0x1c7238e4, 0x0a3dc290,
  0x3fff8000, 0x2aaaaaaa, 0x11117778, 0x00199a00,
  0x2aab0000, 0x1999cccc, 0x002aab00, 0x001966cc,
  0x199a0000, 0x003fff80, 0x002a55aa, 0x00193398,
  0x00400000, 0x003f7f81, 0x002a0054, 0x00190064,
  0x003f8000, 0x003eff82, 0x0029aafe, 0x00033340,
  0x003f0000, 0x003e7f83, 0x00055560, 0x0000999c,
  0x003e8000, 0x0007fff0, 0x00010002, 0x00006668,
  0x00080000, 0x00017ffd, 0x0000aaac, 0x00003334,
  0x00017ffd, 0x0000aaac, 0x00003334, 0x00000000,
  0x0000fffe, 0x00005556, 0x00000000, 0xffffff80,
  0x00007fff, 0x00000000, 0xffffcccc, 0xffffff00,
  0x00000000, 0xffffaaaa, 0xffff9998, 0xfffff800,
  0xffff8001, 0xffff5554, 0xfffcccc0, 0xffffc180,
  0xffff0002, 0xfffaaaa0, 0xffe6ff9c, 0xffffc100,
  0xfff80010, 0xffd65502, 0xffe6cc68, 0xffffc080,
  0xffc1807d, 0xffd5ffac, 0xffe69934, 0xffe66680,
  0xffc1007e, 0xffd5aa56, 0xf5c270a4, 0xffd55580,
  0xffc0807f, 0xeeeeddde, 0xeeeebbbc, 0xffc00180,
  0xe666b333, 0xe38e1c72, 0xe666999c, 0xffc00100,
  0xd555d555, 0xd5560002, 0xe6666668, 0xffc00080,
  0xc001fffd, 0xd555aaac, 0xe6663334, 0x00400000,
  0xc0017ffe, 0xd5555556, 0x199a0000, 0x003fff80,
  0xc000ffff, 0x2aab0000, 0x1999cccc, 0x002aab00,
  0x3fff8000, 0x2aaaaaaa, 0x11117778, 0x00199a00,
  0x3fff0001, 0x1c7238e4, 0x0a3dc290, 0x00004000,
  0x2aaaaaaa, 0x11117778, 0x00199a00, 0x00003f80,
  0x1999cccc, 0x002aab00, 0x001966cc, 0x00003f00,
  0x003fff80, 0x002a55aa, 0x00193398, 0x00003e80,
  0x003f7f81, 0x002a0054, 0x00190064, 0x00000800,
  0x003eff82, 0x0029aafe, 0x00033340, 0x00000180,
  0x003e7f83, 0x00055560, 0x0000999c, 0x00000100,
  0x0007fff0, 0x00010002, 0x00006668, 0x00000080,
  0x00010002, 0x00006668, 0x00000080, 0x00000000,
  0x0000aaac, 0x00003334, 0x00000000, 0xffffff81,
  0x00005556, 0x00000000, 0xffffff80, 0xffffff02,
  0x00000000, 0xffffcccc, 0xffffff00, 0xfffff810,
  0xffffaaaa, 0xffff9998, 0xfffff800, 0xffffc1fd,
  0xffff5554, 0xfffcccc0, 0xffffc180, 0xffffc17e,
  0xfffaaaa0, 0xffe6ff9c, 0xffffc100, 0xffffc0ff,
  0xffd65502, 0xffe6cc68, 0xffffc080, 0xffe699b3,
  0xffd5ffac, 0xffe69934, 0xffe66680, 0xffd5aad5,
  0xffd5aa56, 0xf5c270a4, 0xffd55580, 0xffc0817d,
  0xeeeeddde, 0xeeeebbbc, 0xffc00180, 0xffc080fe,
  0xe38e1c72, 0xe666999c, 0xffc00100, 0xffc0807f,
  0xd5560002, 0xe6666668, 0xffc00080, 0x003f8000,
  0xd555aaac, 0xe6663334, 0x00400000, 0x003f7f81,
  0xd5555556, 0x199a0000, 0x003fff80, 0x002a55aa,
  0x2aab0000, 0x1999cccc, 0x002aab00, 0x001966cc,
  0x2aaaaaaa, 0x11117778, 0x00199a00, 0x00003f80,
  0x1c7238e4, 0x0a3dc290, 0x00004000, 0x00003f01,
  0x11117778, 0x00199a00, 0x00003f80, 0x00003e82,
  0x002aab00, 0x001966cc, 0x00003f00, 0x00003e03,
  0x002a55aa, 0x00193398, 0x00003e80, 0x000007f0,
  0x002a0054, 0x00190064, 0x00000800, 0x0000017d,
  0x0029aafe, 0x00033340, 0x00000180, 0x000000fe,
  0x00055560, 0x0000999c, 0x00000100, 0x0000007f,
  0x0000999c, 0x00000100, 0x0000007f, 0x00000000,
  0x00006668, 0x00000080, 0x00000000, 0xffffff82,
  0x00003334, 0x00000000, 0xffffff81, 0xffffff04,
  0x00000000, 0xffffff80, 0xffffff02, 0xfffff820,
  0xffffcccc, 0xffffff00, 0xfffff810, 0xffffc27a,
  0xffff9998, 0xfffff800, 0xffffc1fd, 0xffffc1fc,
  0xfffcccc0, 0xffffc180, 0xffffc17e, 0xffffc17e,
  0xffe6ff9c, 0xffffc100, 0xffffc0ff, 0xffe6cce6,
  0xffe6cc68, 0xffffc080, 0xffe699b3, 0xffd6002a,
  0xffe69934, 0xffe66680, 0xffd5aad5, 0xffc1017a,
  0xf5c270a4, 0xffd55580, 0xffc0817d, 0xffc100fc,
  0xeeeebbbc, 0xffc00180, 0xffc080fe, 0xffc1007e,
  0xe666999c, 0xffc00100, 0xffc0807f, 0x003f0000,
  0xe6666668, 0xffc00080, 0x003f8000, 0x003eff82,
  0xe6663334, 0x00400000, 0x003f7f81, 0x002a0054,
  0x199a0000, 0x003fff80, 0x002a55aa, 0x00193398,
  0x1999cccc, 0x002aab00, 0x001966cc, 0x00003f00,
  0x11117778, 0x00199a00, 0x00003f80, 0x00003e82,
  0x0a3dc290, 0x00004000, 0x00003f01, 0x00003e04,
  0x00199a00, 0x00003f80, 0x00003e82, 0x00003d86,
  0x001966cc, 0x00003f00, 0x00003e03, 0x000007e0,
  0x00193398, 0x00003e80, 0x000007f0, 0x0000017a,
  0x00190064, 0x00000800, 0x0000017d, 0x000000fc,
  0x00033340, 0x00000180, 0x000000fe, 0x0000007e,
  0x00000180, 0x000000fe, 0x0000007e, 0x00000000,
  0x00000100, 0x0000007f, 0x00000000, 0xffffff83,
  0x00000080, 0x00000000, 0xffffff82, 0xffffff06,
  0x00000000, 0xffffff81, 0xffffff04, 0xfffff830,
  0xffffff80, 0xffffff02, 0xfffff820, 0xffffc2f7,
  0xffffff00, 0xfffff810, 0xffffc27a, 0xffffc27a,
  0xfffff800, 0xffffc1fd, 0xffffc1fc, 0xffffc1fd,
  0xffffc180, 0xffffc17e, 0xffffc17e, 0xffe70019,
  0xffffc100, 0xffffc0ff, 0xffe6cce6, 0xffd6557f,
  0xffffc080, 0xffe699b3, 0xffd6002a, 0xffc18177,
  0xffe66680, 0xffd5aad5, 0xffc1017a, 0xffc180fa,
  0xffd55580, 0xffc0817d, 0xffc100fc, 0xffc1807d,
  0xffc00180, 0xffc080fe, 0xffc1007e, 0x003e8000,
  0xffc00100, 0xffc0807f, 0x003f0000, 0x003e7f83,
  0xffc00080, 0x003f8000, 0x003eff82, 0x0029aafe,
  0x00400000, 0x003f7f81, 0x002a0054, 0x00190064,
  0x003fff80, 0x002a55aa, 0x00193398, 0x00003e80,
  0x002aab00, 0x001966cc, 0x00003f00, 0x00003e03,
  0x00199a00, 0x00003f80, 0x00003e82, 0x00003d86,
  0x00004000, 0x00003f01, 0x00003e04, 0x00003d09,
  0x00003f80, 0x00003e82, 0x00003d86, 0x000007d0,
  0x00003f00, 0x00003e03, 0x000007e0, 0x00000177,
  0x00003e80, 0x000007f0, 0x0000017a, 0x000000fa,
  0x00000800, 0x0000017d, 0x000000fc, 0x0000007d,
  0x0000017d, 0x000000fc, 0x0000007d, 0x00000000,
  0x000000fe, 0x0000007e, 0x00000000, 0xfffffff0,
  0x0000007f, 0x00000000, 0xffffff83, 0xffffffe0,
  0x00000000, 0xffffff82, 0xffffff06, 0xffffff00,
  0xffffff81, 0xffffff04, 0xfffff830, 0xfffff830,
  0xffffff02, 0xfffff820, 0xffffc2f7, 0xfffff820,
  0xfffff810, 0xffffc27a, 0xffffc27a, 0xfffff810,
  0xffffc1fd, 0xffffc1fc, 0xffffc1fd, 0xfffcccd0,
  0xffffc17e, 0xffffc17e, 0xffe70019, 0xfffaaab0,
  0xffffc0ff, 0xffe6cce6, 0xffd6557f, 0xfff80030,
  0xffe699b3, 0xffd6002a, 0xffc18177, 0xfff80020,
  0xffd5aad5, 0xffc1017a, 0xffc180fa, 0xfff80010,
  0xffc0817d, 0xffc100fc, 0xffc1807d, 0x00080000,
  0xffc080fe, 0xffc1007e, 0x003e8000, 0x0007fff0,
  0xffc0807f, 0x003f0000, 0x003e7f83, 0x00055560,
  0x003f8000, 0x003eff82, 0x0029aafe, 0x00033340,
  0x003f7f81, 0x002a0054, 0x00190064, 0x00000800,
  0x002a55aa, 0x00193398, 0x00003e80, 0x000007f0,
  0x001966cc, 0x00003f00, 0x00003e03, 0x000007e0,
  0x00003f80, 0x00003e82, 0x00003d86, 0x000007d0,
  0x00003f01, 0x00003e04, 0x00003d09, 0x00000100,
  0x00003e82, 0x00003d86, 0x000007d0, 0x00000030,
  0x00003e03, 0x000007e0, 0x00000177, 0x00000020,
  0x000007f0, 0x0000017a, 0x000000fa, 0x00000010,
  0x0000017a, 0x000000fa, 0x00000010, 0x00000000,
  0x000000fc, 0x0000007d, 0x00000000, 0xfffffffd,
  0x0000007e, 0x00000000, 0xfffffff0, 0xfffffffa,
  0x00000000, 0xffffff83, 0xffffffe0, 0xffffffd0,
  0xffffff82, 0xffffff06, 0xffffff00, 0xfffffe89,
  0xffffff04, 0xfffff830, 0xfffff830, 0xfffffe86,
  0xfffff820, 0xffffc2f7, 0xfffff820, 0xfffffe83,
  0xffffc27a, 0xffffc27a, 0xfffff810, 0xffff6667,
  0xffffc1fc, 0xffffc1fd, 0xfffcccd0, 0xffff0001,
  0xffffc17e, 0xffe70019, 0xfffaaab0, 0xfffe8009,
  0xffe6cce6, 0xffd6557f, 0xfff80030, 0xfffe8006,
  0xffd6002a, 0xffc18177, 0xfff80020, 0xfffe8003,
  0xffc1017a, 0xffc180fa, 0xfff80010, 0x00018000,
  0xffc100fc, 0xffc1807d, 0x00080000, 0x00017ffd,
  0xffc1007e, 0x003e8000, 0x0007fff0, 0x00010002,
  0x003f0000, 0x003e7f83, 0x00055560, 0x0000999c,
  0x003eff82, 0x0029aafe, 0x00033340, 0x00000180,
  0x002a0054, 0x00190064, 0x00000800, 0x0000017d,
  0x00193398, 0x00003e80, 0x000007f0, 0x0000017a,
  0x00003f00, 0x00003e03, 0x000007e0, 0x00000177,
  0x00003e82, 0x00003d86, 0x000007d0, 0x00000030,
  0x00003e04, 0x00003d09, 0x00000100, 0x00000009,
  0x00003d86, 0x000007d0, 0x00000030, 0x00000006,
  0x000007e0, 0x00000177, 0x00000020, 0x00000003,
  0x00000177, 0x00000020, 0x00000003, 0x00000000,
  0x000000fa, 0x00000010, 0x00000000, 0xfffffffe,
  0x0000007d, 0x00000000, 0xfffffffd, 0xfffffffc,
  0x00000000, 0xfffffff0, 0xfffffffa, 0xffffffe0,
  0xffffff83, 0xffffffe0, 0xffffffd0, 0xffffff06,
  0xffffff06, 0xffffff00, 0xfffffe89, 0xffffff04,
  0xfffff830, 0xfffff830, 0xfffffe86, 0xffffff02,
  0xffffc2f7, 0xfffff820, 0xfffffe83, 0xffff999a,
  0xffffc27a, 0xfffff810, 0xffff6667, 0xffff5556,
  0xffffc1fd, 0xfffcccd0, 0xffff0001, 0xffff0006,
  0xffe70019, 0xfffaaab0, 0xfffe8009, 0xffff0004,
  0xffd6557f, 0xfff80030, 0xfffe8006, 0xffff0002,
  0xffc18177, 0xfff80020, 0xfffe8003, 0x00010000,
  0xffc180fa, 0xfff80010, 0x00018000, 0x0000fffe,
  0xffc1807d, 0x00080000, 0x00017ffd, 0x0000aaac,
  0x003e8000, 0x0007fff0, 0x00010002, 0x00006668,
  0x003e7f83, 0x00055560, 0x0000999c, 0x00000100,
  0x0029aafe, 0x00033340, 0x00000180, 0x000000fe,
  0x00190064, 0x00000800, 0x0000017d, 0x000000fc,
  0x00003e80, 0x000007f0, 0x0000017a, 0x000000fa,
  0x00003e03, 0x000007e0, 0x00000177, 0x00000020,
  0x00003d86, 0x000007d0, 0x00000030, 0x00000006,
  0x00003d09, 0x00000100, 0x00000009, 0x00000004,
  0x000007d0, 0x00000030, 0x00000006, 0x00000002,
  0x00000030, 0x00000006, 0x00000002, 0x00000000,
  0x00000020, 0x00000003, 0x00000000, 0xffffffff,
  0x00000010, 0x00000000, 0xfffffffe, 0xfffffffe,
  0x00000000, 0xfffffffd, 0xfffffffc, 0xfffffff0,
  0xfffffff0, 0xfffffffa, 0xffffffe0, 0xffffff83,
  0xffffffe0, 0xffffffd0, 0xffffff06, 0xffffff82,
  0xffffff00, 0xfffffe89, 0xffffff04, 0xffffff81,
  0xfffff830, 0xfffffe86, 0xffffff02, 0xffffcccd,
  0xfffff820, 0xfffffe83, 0xffff999a, 0xffffaaab,
  0xfffff810, 0xffff6667, 0xffff5556, 0xffff8003,
  0xfffcccd0, 0xffff0001, 0xffff0006, 0xffff8002,
  0xfffaaab0, 0xfffe8009, 0xffff0004, 0xffff8001,
  0xfff80030, 0xfffe8006, 0xffff0002, 0x00008000,
  0xfff80020, 0xfffe8003, 0x00010000, 0x00007fff,
  0xfff80010, 0x00018000, 0x0000fffe, 0x00005556,
  0x00080000, 0x00017ffd, 0x0000aaac, 0x00003334,
  0x0007fff0, 0x00010002, 0x00006668, 0x00000080,
  0x00055560, 0x0000999c, 0x00000100, 0x0000007f,
  0x00033340, 0x00000180, 0x000000fe, 0x0000007e,
  0x00000800, 0x0000017d, 0x000000fc, 0x0000007d,
  0x000007f0, 0x0000017a, 0x000000fa, 0x00000010,
  0x000007e0, 0x00000177, 0x00000020, 0x00000003,
  0x000007d0, 0x00000030, 0x00000006, 0x00000002,
  0x00000100, 0x00000009, 0x00000004, 0x00000001,
};
const unsigned kExpectedCount_NEON_smull2_4S = 576;

#endif  // VIXL_SIM_SMULL2_4S_TRACE_AARCH64_H_
