/**
 * This file is a part of VideoCut package.
 * ---------------------------------------------------------------------- 
 * Copyright (C) 2007-2008 troorl
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * ---------------------------------------------------------------------- 
 *
 * @author troorl <troorl@gmail.com>
 */

#include "TViewItem.h"

TViewItem::TViewItem()
{	
	w_s = 0;
	h_s = 0;
}

void TViewItem::scale(qreal scale)
{
	this->h_s = (int)(this->p->height() * scale);
	this->w_s = this->p->width() * h_s / this->p->height();
	boundRect = QRectF(0 , 0, w_s, h_s); // result rect
	
	realPixRect = QRectF(0, 0, p->width(), p->height());
	
	this->prepareGeometryChange();
}

QRectF TViewItem::boundingRect() const
{
	return boundRect;
}

void TViewItem::paint(QPainter *painter, const QStyleOptionGraphicsItem *,
               QWidget *)
{
	painter->setRenderHint(QPainter::Antialiasing, true); 
	painter->drawImage(boundRect, *p, realPixRect);
}

void TViewItem::setImage(QImage &image)
{
	this->p = &image;
	realPixRect = QRectF(0, 0, p->width(), p->height());
	this->prepareGeometryChange();
}

void TViewItem::setScale(qreal scale)
{
	this->h_s = (int)(this->p->height() * scale);
	this->w_s = this->p->width() * h_s / this->p->height();
	boundRect = QRectF(0 , 0, w_s, h_s);
	this->prepareGeometryChange();
}
