#include <eventtestbox.h>
#include <iostream>
EventTestBox::EventTestBox(VDKForm* pw)
     : VDKBox(pw, v_box),
       _bp_color(clBlue),
       _br_color(clYellow),
       _kp_color(clYellow),
       _kr_color(clGreen),
       _mk_color(clGreen),
       _mp_color(clRed),
       _rp_color(clBlack),
       _cl_color(clBlue),
       _any_flag(false),
       _bp_flag(false),
       _br_flag(false),
       _kp_flag(false),
       _kr_flag(false),
       _mk_flag(false),
       _mp_flag(false),
       _rp_flag(false),
       _cl_flag(false)
{}

void
EventTestBox::Setup()
{
     _event_area=new VDKCanvas(Owner(),200,200);
     _event_area->NormalBackground=clWhite;
     _event_area->Foreground=clBlack;
     _event_area->Enable(true);
     _event_area->Font=new VDKFont("*-courier-*-14-*");

     VDKLabel* label=new VDKLabel(Owner(), "RawEvent :");
     _any_entry=new VDKEntry(Owner());
     _any_entry->SetEditable(false);

     _any_btn=new VDKCheckButton(Owner(), "Raw Events");
     _mk_btn=new VDKCheckButton(Owner(), "Button Motion");
     _mp_btn=new VDKCheckButton(Owner(), "Pointer Motion");
     _kp_btn=new VDKCheckButton(Owner(), "Key Press");
     _kr_btn=new VDKCheckButton(Owner(), "Key Release");
     _bp_btn=new VDKCheckButton(Owner(), "Button Press");
     _br_btn=new VDKCheckButton(Owner(), "Button Release");
     _rp_btn=new VDKCheckButton(Owner(), "Paint Event");
     _cl_btn=new VDKCheckButton(Owner(), "2x(3x)-Clicks");
     _clear_btn=new VDKCustomButton(Owner(), "Clear");
     _setup_btn=new VDKCustomButton(Owner(), "Setup");

     VDKBox* hbox1=new VDKBox(Owner(), h_box);
     VDKEventBox* hbox2=new VDKEventBox(Owner(), h_box);
     VDKBox* hbox3=new VDKBox(Owner(), h_box);
     VDKBox* hbox4=new VDKBox(Owner(), h_box);

     hbox1->Add(label);
     hbox1->Add(_any_entry);
     hbox1->Add(_clear_btn);
     hbox1->Add(_setup_btn);

     hbox2->Add(_event_area);

     hbox3->Add(_any_btn);
     hbox3->Add(_kp_btn);
     hbox3->Add(_kr_btn);
     hbox3->Add(_rp_btn);

     hbox4->Add(_mk_btn);
     hbox4->Add(_mp_btn);
     hbox4->Add(_bp_btn);
     hbox4->Add(_br_btn);
     hbox4->Add(_cl_btn);
     
     Add(hbox1);
     Add(hbox2);
     Add(hbox3);
     Add(hbox4);
     _cw=_event_area;
     // Vernetzung
     _clear_btn->OnButtonPressed.connect(slot(*_event_area,
					      &VDKCanvas::Clear));
     _any_btn->OnButtonToggled.connect(slot(*this,
					    &EventTestBox::any_connect));
     _kp_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::kp_connect));

     _kr_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::kr_connect));
     _mk_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::mk_connect));
     _mp_btn->OnButtonToggled.connect(slot(*this,
 					   &EventTestBox::mp_connect));
     _bp_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::bp_connect));
     _br_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::br_connect));
     _rp_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::rp_connect));
     _cl_btn->OnButtonToggled.connect(slot(*this,
					   &EventTestBox::cl_connect));
     // Let's it take effect
     _any_btn->SetChecked(true);
     _kp_btn->SetChecked(true);
     _kr_btn->SetChecked(true);
     _mk_btn->SetChecked(true);
     _mp_btn->SetChecked(true);
     _br_btn->SetChecked(true);
     _bp_btn->SetChecked(true);
     _rp_btn->SetChecked(true);
     _cl_btn->SetChecked(true);
     
     _setup_btn->SetTip("Not implemented yet");
     _clear_btn->SetTip("Clear event indicating drawing-area");
     _any_btn->SetTip("Turn receiving of Raw-Events on/off");
     _mk_btn->SetTip("Motion events with any modifier was pressed");
     _mp_btn->SetTip("Any Motion-Event");
     _kp_btn->SetTip("Key-Press Events");
     _kr_btn->SetTip("Key-Release Events");
     _rp_btn->SetTip("Paint-Events To test cover a region of paintarea" 
		     "and then uncover it");
     _cl_btn->SetTip("Make Double- and Tertinary-Clicks visible");
}

void
EventTestBox::any_handler(VDKObject* obj, const GdkEvent* eve)
{
     char* signame;
     switch(eve->type){
     case GDK_NOTHING:
	  signame="GDK_NOTHING";
	  break;
     case GDK_DELETE:
	  signame="GDK_DELETE";
	  break;
     case GDK_DESTROY:
	  signame="GDK_DESTROY";
	  break;
     case GDK_EXPOSE:
	  signame="GDK_EXPOSE";
	  break;
     case GDK_MOTION_NOTIFY:
	  signame="GDK_MOTION_NOTIFY";
	  break;
     case GDK_BUTTON_PRESS:
	  signame="GDK_BUTTON_PRESS";
	  break;
     case GDK_2BUTTON_PRESS:
	  signame="GDK_2BUTTON_PRESS";
	  break;
     case GDK_3BUTTON_PRESS:
	  signame="GDK_3BUTTON_PRESS";
	  break;
     case GDK_BUTTON_RELEASE:
	  signame="GDK_BUTTON_RELEASE";
	  break;
     case GDK_KEY_PRESS:
	  signame="GDK_KEY_PRESS";
	  break;
     case GDK_KEY_RELEASE:
	  signame="GDK_KEY_RELEASE";
	  break;
     case GDK_ENTER_NOTIFY:
	  signame="GDK_ENTER_NOTIFY";
	  break;
     case GDK_LEAVE_NOTIFY:
	  signame="GDK_LEAVE_NOTIFY";
	  break;
     case GDK_FOCUS_CHANGE:
	  signame="GDK_FOCUS_CHANGE";
	  break;
     case GDK_CONFIGURE:
	  signame="GDK_CONFIGURE";
	  break;
     case GDK_MAP:
	  signame="GDK_MAP";
	  break;
     case GDK_UNMAP:
	  signame="GDK_UNMAP";
	  break;
     case GDK_PROPERTY_NOTIFY:
	  signame="GDK_PROPERTY_NOTIFY";
	  break;
     case GDK_SELECTION_CLEAR:
	  signame="GDK_SELECTION_CLEAR";
	  break;
     case GDK_SELECTION_REQUEST:
	  signame="GDK_SELECTION_REQUEST";
	  break;
     case GDK_SELECTION_NOTIFY:
	  signame="GDK_SELECTION_NOTIFY";
	  break;
     case GDK_PROXIMITY_IN:
	  signame="GDK_PROXIMITY_IN";
	  break;
     case GDK_PROXIMITY_OUT:
	  signame="GDK_PROXIMITY_OUT";
	  break;
     case GDK_DRAG_ENTER:
	  signame="GDK_DRAG_ENTER";
	  break;
     case GDK_DRAG_LEAVE:
	  signame="GDK_DRAG_LEAVE";
	  break;
     case GDK_DRAG_MOTION:
	  signame="GDK_DRAG_MOTION";
	  break;
     case GDK_DRAG_STATUS:
	  signame="GDK_DRAG_STATUS";
	  break;
     case GDK_DROP_START:
	  signame="GDK_DROP_START";
	  break;
     case GDK_DROP_FINISHED:
	  signame="GDK_DROP_FINISHED";
	  break;
     case GDK_CLIENT_EVENT:
	  signame="GDK_CLIENT_EVENT";
	  break;
     case GDK_VISIBILITY_NOTIFY:
	  signame="GDK_VISIBILITY_NOTIFY";
	  break;
     case GDK_NO_EXPOSE:
	  signame="GDK_NO_EXPOSE";
	  break;
     default:
	  signame="Error: Unknown Eventtype";
     }
     _any_entry->SetText(signame);
}

void
EventTestBox::any_connect(bool mode)
{
     if(mode && !_any_flag){
	  _any_con=_cw->OnRawEvent.connect(slot(*this,
						&EventTestBox::any_handler));
	  _any_flag=true;
     }
     else if( !mode && _any_flag){
	  _cw->OnRawEvent.disconnect(_any_con);
	  _any_flag=false;
     }
}

void
EventTestBox::kp_connect(bool mode)
{
     if(mode && !_kp_flag){
	  _kp_con=Owner()->OnKeyEvent.connect(slot(*this,
						   &EventTestBox::kp_handler),
					      KE_PRESS);
	  _kp_flag=true;
     }
     else if(!mode && _kp_flag){
	  Owner()->OnKeyEvent.disconnect(_kp_con);
	  _kp_flag=false;
     }
}

void
EventTestBox::kr_connect(bool mode)
{
     if(mode && !_kr_flag){
	  _kr_con=Owner()->OnKeyEvent.connect(slot(*this,
						 &EventTestBox::kr_handler),
					    KE_RELEASE);
	  _kr_flag=true;
     }
     else if(!mode && _kr_flag){
	  Owner()->OnKeyEvent.disconnect(_kr_con);
	  _kr_flag=false;
     }
}

void
EventTestBox::mp_connect(bool mode)
{
      if(mode && !_mp_flag){
	   _mp_con=_cw->OnPointerEvent.connect(slot(*this,
						    &EventTestBox::mp_handler),
					       PE_ALL);
	   _mp_flag=true;
      }
     else if(!mode && _mp_flag){
	  _cw->OnPointerEvent.disconnect(_mp_con);
	  _mp_flag=false;
     }
}

void
EventTestBox::mk_connect(bool mode)
{
     if(mode && !_mk_flag){
	  _mk_con=_cw->OnPointerEvent.connect(slot(*this,
						   &EventTestBox::mk_handler),
					      PE_PRESSED);
	  _mk_flag=true;
     }
     else if( !mode && _mk_flag) {
	  _cw->OnPointerEvent.disconnect(_mk_con);
	  _mk_flag=false;
     }
}

void
EventTestBox::bp_connect(bool mode)
{
     if(mode && !_bp_flag){
	  _bp_con=_cw->OnButtonEvent.connect(slot(*this,
						  &EventTestBox::bp_handler),
					     BE_PRESS);
	  _bp_flag=true;
     }
     else if( !mode && _bp_flag) {
	  _cw->OnButtonEvent.disconnect(_bp_con);
	  _bp_flag=false;
     }
}

void
EventTestBox::br_connect(bool mode)
{
     if(mode && !_br_flag){
	  _br_con=_cw->OnButtonEvent.connect(slot(*this,
						  &EventTestBox::br_handler),
					     BE_RELEASE);
	  _br_flag=true;
     }
     else if( !mode && _br_flag) {
	  _cw->OnButtonEvent.disconnect(_br_con);
	  _br_flag=false;
     }
}

void
EventTestBox::rp_connect(bool mode)
{
     if(mode && !_rp_flag){
	  _rp_con=_cw->OnPaintEvent.connect(slot(*this,
						 &EventTestBox::rp_handler));
	  _br_flag=true;
     }
     else if( !mode && _rp_flag) {
	  _cw->OnPaintEvent.disconnect(_br_con);
	  _br_flag=false;
     }
}

void
EventTestBox::cl_connect(bool mode)
{
     if(mode && !_cl_flag){
	  cout << "Establish CL_Connections" << endl;
	  _cl2_con=_cw->OnButtonEvent.connect(slot(*this,
						  &EventTestBox::cl2_handler),
					      BE_CLICK2);
	  _cl3_con=_cw->OnButtonEvent.connect(slot(*this,
						  &EventTestBox::cl3_handler),
					      BE_CLICK3);
	  _cl_flag=true;
     }
     else if( !mode && _cl_flag) {
	  _cw->OnPaintEvent.disconnect(_cl2_con);
	  _cw->OnPaintEvent.disconnect(_cl3_con);
	  _cl_flag=false;
     }
}
void
EventTestBox::kp_handler(VDKObject* obj, const VDKKeyEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_kp_color;
     _event_area->DrawText(30,30, eve.String(),1);
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::kr_handler(VDKObject* obj, const VDKKeyEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_kr_color;
     _event_area->DrawText(30,30, eve.String(),1);
     _event_area->Redraw();
     _event_area->Foreground=col;
}


void EventTestBox::mp_handler(VDKObject* obj, const VDKMouseEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_mp_color;
     _event_area->DrawPoint(eve.Position().X(),
			    eve.Position().Y());
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::mk_handler(VDKObject* obj, const VDKMouseEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_mk_color;
     _event_area->DrawPoint(eve.Position().X()-1,
			    eve.Position().Y()-1);
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::bp_handler(VDKObject* obj, const VDKMouseEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_bp_color;
     _event_area->DrawRect(1,
			   eve.Position().X()-2,
			   eve.Position().Y()-2,
			   5,5);
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::br_handler(VDKObject* obj, const VDKMouseEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_br_color;
     _event_area->DrawRect(1,
			   eve.Position().X()-2,
			   eve.Position().Y()-2,
			   5,5);
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::rp_handler(VDKObject* obj, const VDKPaintEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_rp_color;
     _event_area->DrawRect(0,
			   eve.Area().Origin().X(), 
			   eve.Area().Origin().Y(),
			   eve.Area().W(), eve.Area().H());
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::cl2_handler(VDKObject* obj, const VDKMouseEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_cl_color;
     cout << "CL2_Handler called" << endl;
     _event_area->DrawRect(0,
			  eve.Position().X()-5,
			  eve.Position().Y()-5,
			  10,10);
     _event_area->Redraw();
     _event_area->Foreground=col;
}

void EventTestBox::cl3_handler(VDKObject* obj, const VDKMouseEvent& eve)
{
     VDKRgb col=_event_area->Foreground;
     _event_area->Foreground=_cl_color;
     cout << "CL3_Handler called " << endl;
     _event_area->DrawRect(0,
			   eve.Position().X()-10,
			   eve.Position().Y()-10,
			   20,20);
     _event_area->Redraw();
     _event_area->Foreground=col;
}
