/* valalambdaexpression.c generated by valac, the Vala compiler
 * generated from valalambdaexpression.vala, do not modify */

/* valalambdaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaLambdaExpressionPrivate {
	ValaExpression* _expression_body;
	ValaBlock* _statement_body;
	ValaMethod* _method;
	ValaList* parameters;
};

static gint ValaLambdaExpression_private_offset;
static gpointer vala_lambda_expression_parent_class = NULL;
static gint vala_lambda_expression_next_lambda_id;
static gint vala_lambda_expression_next_lambda_id = 0;

static void vala_lambda_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_lambda_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_lambda_expression_real_is_pure (ValaExpression* base);
static gboolean vala_lambda_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_lambda_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_lambda_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_lambda_expression_finalize (ValaCodeNode * obj);
static GType vala_lambda_expression_get_type_once (void);

static inline gpointer
vala_lambda_expression_get_instance_private (ValaLambdaExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaLambdaExpression_private_offset);
}

ValaExpression*
vala_lambda_expression_get_expression_body (ValaLambdaExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression_body;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_lambda_expression_set_expression_body (ValaLambdaExpression* self,
                                            ValaExpression* value)
{
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_expression_body);
	self->priv->_expression_body = _tmp0_;
}

ValaBlock*
vala_lambda_expression_get_statement_body (ValaLambdaExpression* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_statement_body;
	result = _tmp0_;
	return result;
}

void
vala_lambda_expression_set_statement_body (ValaLambdaExpression* self,
                                           ValaBlock* value)
{
	ValaBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_statement_body);
	self->priv->_statement_body = _tmp0_;
}

ValaMethod*
vala_lambda_expression_get_method (ValaLambdaExpression* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}

void
vala_lambda_expression_set_method (ValaLambdaExpression* self,
                                   ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_method);
	self->priv->_method = _tmp0_;
}

/**
 * Creates a new lambda expression.
 *
 * @param expression_body  expression body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct (GType object_type,
                                  ValaExpression* expression_body,
                                  ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (expression_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_lambda_expression_set_expression_body (self, expression_body);
	return self;
}

ValaLambdaExpression*
vala_lambda_expression_new (ValaExpression* expression_body,
                            ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct (VALA_TYPE_LAMBDA_EXPRESSION, expression_body, source_reference);
}

/**
 * Creates a new lambda expression with statement body.
 *
 * @param statement_body   statement body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct_with_statement_body (GType object_type,
                                                      ValaBlock* statement_body,
                                                      ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (statement_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_lambda_expression_set_statement_body (self, statement_body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}

ValaLambdaExpression*
vala_lambda_expression_new_with_statement_body (ValaBlock* statement_body,
                                                ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct_with_statement_body (VALA_TYPE_LAMBDA_EXPRESSION, statement_body, source_reference);
}

/**
 * Appends implicitly typed parameter.
 *
 * @param param parameter name
 */
void
vala_lambda_expression_add_parameter (ValaLambdaExpression* self,
                                      ValaParameter* param)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
}

/**
 * Returns the parameter list.
 *
 * @return parameter list
 */
ValaList*
vala_lambda_expression_get_parameters (ValaLambdaExpression* self)
{
	ValaList* _tmp0_;
	ValaList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	result = _tmp0_;
	return result;
}

static void
vala_lambda_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_lambda_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_lambda_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_method;
	if (_tmp0_ == NULL) {
		ValaExpression* _tmp1_;
		_tmp1_ = self->priv->_expression_body;
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = self->priv->_expression_body;
			vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
			_tmp3_ = self->priv->_expression_body;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp3_);
		} else {
			ValaBlock* _tmp4_;
			_tmp4_ = self->priv->_statement_body;
			if (_tmp4_ != NULL) {
				ValaBlock* _tmp5_;
				_tmp5_ = self->priv->_statement_body;
				vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
			}
		}
	} else {
		ValaMethod* _tmp6_;
		_tmp6_ = self->priv->_method;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
	}
}

static gboolean
vala_lambda_expression_real_is_pure (ValaExpression* base)
{
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	result = FALSE;
	return result;
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static gboolean
vala_lambda_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaLambdaExpression * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDelegate* cb = NULL;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDelegate* _tmp20_;
	ValaDelegate* _tmp21_;
	ValaDelegate* _tmp22_;
	ValaDataType* return_type = NULL;
	ValaDelegate* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gint _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaDataType* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaMethod* _tmp35_;
	ValaMethod* _tmp36_;
	ValaMethod* _tmp37_;
	ValaMethod* _tmp38_;
	ValaVersionAttribute* _tmp39_;
	ValaVersionAttribute* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaDataType* _tmp43_;
	gboolean _tmp53_ = FALSE;
	ValaDelegate* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	ValaMethod* _tmp100_;
	ValaSemanticAnalyzer* _tmp101_;
	ValaSemanticAnalyzer* _tmp102_;
	ValaSymbol* _tmp103_;
	ValaSymbol* _tmp104_;
	ValaScope* _tmp105_;
	ValaScope* _tmp106_;
	ValaList* lambda_params = NULL;
	ValaList* _tmp107_;
	ValaList* _tmp108_;
	ValaIterator* lambda_param_it = NULL;
	ValaList* _tmp109_;
	ValaIterator* _tmp110_;
	gboolean _tmp111_ = FALSE;
	ValaDelegate* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaIterator* _tmp168_;
	ValaArrayList* error_types = NULL;
	GEqualFunc _tmp171_;
	ValaArrayList* _tmp172_;
	ValaDelegate* _tmp173_;
	ValaArrayList* _tmp174_;
	ValaExpression* _tmp186_;
	ValaMethod* _tmp217_;
	ValaBlock* _tmp218_;
	ValaBlock* _tmp219_;
	ValaMethod* _tmp220_;
	ValaScope* _tmp221_;
	ValaScope* _tmp222_;
	ValaMethod* m = NULL;
	ValaSemanticAnalyzer* _tmp223_;
	ValaSemanticAnalyzer* _tmp224_;
	ValaSymbol* _tmp225_;
	ValaSymbol* _tmp226_;
	ValaMethod* _tmp227_;
	ValaMethod* _tmp228_;
	ValaMethod* _tmp250_;
	ValaMethod* _tmp251_;
	ValaMethod* _tmp252_;
	ValaMethodType* _tmp253_;
	ValaMethodType* _tmp254_;
	ValaDataType* _tmp255_;
	ValaDataType* _tmp256_;
	ValaDataType* _tmp257_;
	ValaDataType* _tmp258_;
	gboolean _tmp259_;
	gboolean _tmp260_;
	gboolean _tmp261_;
	gboolean _tmp262_;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (!VALA_IS_DELEGATE_TYPE (_tmp5_)) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Cannot convert lambda expression to `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp9_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "lambda expression not allowed in this context");
		}
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_DELEGATE, ValaDelegate));
	cb = _tmp22_;
	_tmp23_ = cb;
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_data_type_get_actual_type (_tmp25_, _tmp27_, NULL, (ValaCodeNode*) self);
	return_type = _tmp28_;
	_tmp29_ = vala_lambda_expression_next_lambda_id;
	vala_lambda_expression_next_lambda_id = _tmp29_ + 1;
	_tmp30_ = g_strdup_printf ("_lambda%d_", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = return_type;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_method_new (_tmp31_, _tmp32_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	vala_lambda_expression_set_method (self, _tmp36_);
	_vala_code_node_unref0 (_tmp36_);
	_g_free0 (_tmp31_);
	_tmp37_ = self->priv->_method;
	vala_symbol_set_used ((ValaSymbol*) _tmp37_, TRUE);
	_tmp38_ = self->priv->_method;
	_tmp39_ = vala_symbol_get_version ((ValaSymbol*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	vala_version_attribute_check (_tmp40_, _tmp42_);
	_tmp43_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp43_)) {
		ValaMethod* _tmp44_;
		ValaDelegate* _tmp45_;
		ValaMethod* _tmp46_;
		ValaDelegate* _tmp47_;
		ValaMethod* _tmp48_;
		ValaDelegate* _tmp49_;
		_tmp44_ = self->priv->_method;
		_tmp45_ = cb;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp44_, (ValaCodeNode*) _tmp45_, "CCode", "array_length");
		_tmp46_ = self->priv->_method;
		_tmp47_ = cb;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp46_, (ValaCodeNode*) _tmp47_, "CCode", "array_null_terminated");
		_tmp48_ = self->priv->_method;
		_tmp49_ = cb;
		vala_code_node_copy_attribute_string ((ValaCodeNode*) _tmp48_, (ValaCodeNode*) _tmp49_, "CCode", "array_length_type");
	} else {
		ValaDataType* _tmp50_;
		_tmp50_ = return_type;
		if (VALA_IS_DELEGATE_TYPE (_tmp50_)) {
			ValaMethod* _tmp51_;
			ValaDelegate* _tmp52_;
			_tmp51_ = self->priv->_method;
			_tmp52_ = cb;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp51_, (ValaCodeNode*) _tmp52_, "CCode", "delegate_target");
		}
	}
	_tmp54_ = cb;
	_tmp55_ = vala_delegate_get_has_target (_tmp54_);
	_tmp56_ = _tmp55_;
	if (!_tmp56_) {
		_tmp53_ = TRUE;
	} else {
		ValaSemanticAnalyzer* _tmp57_;
		ValaSemanticAnalyzer* _tmp58_;
		_tmp57_ = vala_code_context_get_analyzer (context);
		_tmp58_ = _tmp57_;
		_tmp53_ = !vala_semantic_analyzer_is_in_instance_method (_tmp58_);
	}
	if (_tmp53_) {
		ValaMethod* _tmp59_;
		_tmp59_ = self->priv->_method;
		vala_method_set_binding (_tmp59_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaSymbol* sym = NULL;
		ValaSemanticAnalyzer* _tmp60_;
		ValaSemanticAnalyzer* _tmp61_;
		ValaSymbol* _tmp62_;
		ValaSymbol* _tmp63_;
		ValaSymbol* _tmp64_;
		_tmp60_ = vala_code_context_get_analyzer (context);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_semantic_analyzer_get_current_symbol (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = _vala_code_node_ref0 (_tmp63_);
		sym = _tmp64_;
		while (TRUE) {
			ValaMethod* _tmp65_;
			ValaParameter* _tmp66_;
			ValaParameter* _tmp67_;
			ValaSymbol* _tmp68_;
			ValaSymbol* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			ValaSymbol* _tmp99_;
			_tmp65_ = self->priv->_method;
			_tmp66_ = vala_method_get_this_parameter (_tmp65_);
			_tmp67_ = _tmp66_;
			if (!(_tmp67_ == NULL)) {
				break;
			}
			_tmp68_ = sym;
			if (VALA_IS_PROPERTY (_tmp68_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp69_;
				ValaProperty* _tmp70_;
				ValaMethod* _tmp71_;
				ValaProperty* _tmp72_;
				ValaParameter* _tmp73_;
				ValaParameter* _tmp74_;
				_tmp69_ = sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp70_;
				_tmp71_ = self->priv->_method;
				_tmp72_ = prop;
				_tmp73_ = vala_property_get_this_parameter (_tmp72_);
				_tmp74_ = _tmp73_;
				vala_method_set_this_parameter (_tmp71_, _tmp74_);
				_vala_code_node_unref0 (prop);
			} else {
				ValaSymbol* _tmp75_;
				_tmp75_ = sym;
				if (VALA_IS_CONSTRUCTOR (_tmp75_)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp76_;
					ValaConstructor* _tmp77_;
					ValaMethod* _tmp78_;
					ValaConstructor* _tmp79_;
					ValaParameter* _tmp80_;
					ValaParameter* _tmp81_;
					_tmp76_ = sym;
					_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
					c = _tmp77_;
					_tmp78_ = self->priv->_method;
					_tmp79_ = c;
					_tmp80_ = vala_constructor_get_this_parameter (_tmp79_);
					_tmp81_ = _tmp80_;
					vala_method_set_this_parameter (_tmp78_, _tmp81_);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp82_;
					_tmp82_ = sym;
					if (VALA_IS_DESTRUCTOR (_tmp82_)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp83_;
						ValaDestructor* _tmp84_;
						ValaMethod* _tmp85_;
						ValaDestructor* _tmp86_;
						ValaParameter* _tmp87_;
						ValaParameter* _tmp88_;
						_tmp83_ = sym;
						_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
						d = _tmp84_;
						_tmp85_ = self->priv->_method;
						_tmp86_ = d;
						_tmp87_ = vala_destructor_get_this_parameter (_tmp86_);
						_tmp88_ = _tmp87_;
						vala_method_set_this_parameter (_tmp85_, _tmp88_);
						_vala_code_node_unref0 (d);
					} else {
						ValaSymbol* _tmp89_;
						_tmp89_ = sym;
						if (VALA_IS_METHOD (_tmp89_)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp90_;
							ValaMethod* _tmp91_;
							ValaMethod* _tmp92_;
							ValaMethod* _tmp93_;
							ValaParameter* _tmp94_;
							ValaParameter* _tmp95_;
							_tmp90_ = sym;
							_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp91_;
							_tmp92_ = self->priv->_method;
							_tmp93_ = m;
							_tmp94_ = vala_method_get_this_parameter (_tmp93_);
							_tmp95_ = _tmp94_;
							vala_method_set_this_parameter (_tmp92_, _tmp95_);
							_vala_code_node_unref0 (m);
						}
					}
				}
			}
			_tmp96_ = sym;
			_tmp97_ = vala_symbol_get_parent_symbol (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = _vala_code_node_ref0 (_tmp98_);
			_vala_code_node_unref0 (sym);
			sym = _tmp99_;
		}
		_vala_code_node_unref0 (sym);
	}
	_tmp100_ = self->priv->_method;
	_tmp101_ = vala_code_context_get_analyzer (context);
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_semantic_analyzer_get_current_symbol (_tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = vala_symbol_get_scope (_tmp104_);
	_tmp106_ = _tmp105_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp100_, _tmp106_);
	_tmp107_ = vala_lambda_expression_get_parameters (self);
	_tmp108_ = _vala_iterable_ref0 (_tmp107_);
	lambda_params = _tmp108_;
	_tmp109_ = lambda_params;
	_tmp110_ = vala_iterable_iterator ((ValaIterable*) _tmp109_);
	lambda_param_it = _tmp110_;
	_tmp112_ = cb;
	_tmp113_ = vala_delegate_get_sender_type (_tmp112_);
	_tmp114_ = _tmp113_;
	if (_tmp114_ != NULL) {
		ValaList* _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		ValaDelegate* _tmp118_;
		ValaList* _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
		_tmp115_ = lambda_params;
		_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
		_tmp117_ = _tmp116_;
		_tmp118_ = cb;
		_tmp119_ = vala_callable_get_parameters ((ValaCallable*) _tmp118_);
		_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
		_tmp121_ = _tmp120_;
		_tmp111_ = _tmp117_ == (_tmp121_ + 1);
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		ValaIterator* _tmp122_;
		ValaParameter* lambda_param = NULL;
		ValaIterator* _tmp123_;
		gpointer _tmp124_;
		ValaParameter* _tmp125_;
		ValaDelegate* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaMethod* _tmp129_;
		ValaParameter* _tmp130_;
		_tmp122_ = lambda_param_it;
		vala_iterator_next (_tmp122_);
		_tmp123_ = lambda_param_it;
		_tmp124_ = vala_iterator_get (_tmp123_);
		lambda_param = (ValaParameter*) _tmp124_;
		_tmp125_ = lambda_param;
		_tmp126_ = cb;
		_tmp127_ = vala_delegate_get_sender_type (_tmp126_);
		_tmp128_ = _tmp127_;
		vala_variable_set_variable_type ((ValaVariable*) _tmp125_, _tmp128_);
		_tmp129_ = self->priv->_method;
		_tmp130_ = lambda_param;
		vala_callable_add_parameter ((ValaCallable*) _tmp129_, _tmp130_);
		_vala_code_node_unref0 (lambda_param);
	}
	{
		ValaList* _cb_param_list = NULL;
		ValaDelegate* _tmp131_;
		ValaList* _tmp132_;
		ValaList* _tmp133_;
		gint _cb_param_size = 0;
		ValaList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _cb_param_index = 0;
		_tmp131_ = cb;
		_tmp132_ = vala_callable_get_parameters ((ValaCallable*) _tmp131_);
		_tmp133_ = _vala_iterable_ref0 (_tmp132_);
		_cb_param_list = _tmp133_;
		_tmp134_ = _cb_param_list;
		_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_cb_param_size = _tmp136_;
		_cb_param_index = -1;
		while (TRUE) {
			ValaParameter* cb_param = NULL;
			ValaList* _tmp137_;
			gpointer _tmp138_;
			ValaIterator* _tmp139_;
			ValaParameter* lambda_param = NULL;
			ValaIterator* _tmp140_;
			gpointer _tmp141_;
			ValaParameter* _tmp142_;
			ValaParameterDirection _tmp143_;
			ValaParameterDirection _tmp144_;
			ValaParameter* _tmp145_;
			ValaParameterDirection _tmp146_;
			ValaParameterDirection _tmp147_;
			ValaParameter* _tmp156_;
			ValaParameter* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			ValaDataType* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaParameter* _tmp164_;
			ValaParameter* _tmp165_;
			ValaMethod* _tmp166_;
			ValaParameter* _tmp167_;
			_cb_param_index = _cb_param_index + 1;
			if (!(_cb_param_index < _cb_param_size)) {
				break;
			}
			_tmp137_ = _cb_param_list;
			_tmp138_ = vala_list_get (_tmp137_, _cb_param_index);
			cb_param = (ValaParameter*) _tmp138_;
			_tmp139_ = lambda_param_it;
			if (!vala_iterator_next (_tmp139_)) {
				_vala_code_node_unref0 (cb_param);
				break;
			}
			_tmp140_ = lambda_param_it;
			_tmp141_ = vala_iterator_get (_tmp140_);
			lambda_param = (ValaParameter*) _tmp141_;
			_tmp142_ = lambda_param;
			_tmp143_ = vala_parameter_get_direction (_tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = cb_param;
			_tmp146_ = vala_parameter_get_direction (_tmp145_);
			_tmp147_ = _tmp146_;
			if (_tmp144_ != _tmp147_) {
				ValaParameter* _tmp148_;
				ValaSourceReference* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaParameter* _tmp151_;
				const gchar* _tmp152_;
				const gchar* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp148_ = lambda_param;
				_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = lambda_param;
				_tmp152_ = vala_symbol_get_name ((ValaSymbol*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = g_strdup_printf ("direction of parameter `%s' is incompatible with the target delegate", _tmp153_);
				_tmp155_ = _tmp154_;
				vala_report_error (_tmp150_, _tmp155_);
				_g_free0 (_tmp155_);
			}
			_tmp156_ = lambda_param;
			_tmp157_ = cb_param;
			_tmp158_ = vala_variable_get_variable_type ((ValaVariable*) _tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_data_type_get_actual_type (_tmp159_, _tmp161_, NULL, (ValaCodeNode*) self);
			_tmp163_ = _tmp162_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp156_, _tmp163_);
			_vala_code_node_unref0 (_tmp163_);
			_tmp164_ = lambda_param;
			_tmp165_ = cb_param;
			vala_parameter_set_base_parameter (_tmp164_, _tmp165_);
			_tmp166_ = self->priv->_method;
			_tmp167_ = lambda_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp166_, _tmp167_);
			_vala_code_node_unref0 (lambda_param);
			_vala_code_node_unref0 (cb_param);
		}
		_vala_iterable_unref0 (_cb_param_list);
	}
	_tmp168_ = lambda_param_it;
	if (vala_iterator_next (_tmp168_)) {
		ValaSourceReference* _tmp169_;
		ValaSourceReference* _tmp170_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp170_ = _tmp169_;
		vala_report_error (_tmp170_, "lambda expression: too many parameters");
		result = FALSE;
		_vala_iterator_unref0 (lambda_param_it);
		_vala_iterable_unref0 (lambda_params);
		_vala_code_node_unref0 (return_type);
		_vala_code_node_unref0 (cb);
		return result;
	}
	_tmp171_ = g_direct_equal;
	_tmp172_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp171_);
	error_types = _tmp172_;
	_tmp173_ = cb;
	_tmp174_ = error_types;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp173_, (ValaCollection*) _tmp174_, NULL);
	{
		ValaArrayList* _error_type_list = NULL;
		ValaArrayList* _tmp175_;
		ValaArrayList* _tmp176_;
		gint _error_type_size = 0;
		ValaArrayList* _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gint _error_type_index = 0;
		_tmp175_ = error_types;
		_tmp176_ = _vala_iterable_ref0 (_tmp175_);
		_error_type_list = _tmp176_;
		_tmp177_ = _error_type_list;
		_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
		_tmp179_ = _tmp178_;
		_error_type_size = _tmp179_;
		_error_type_index = -1;
		while (TRUE) {
			ValaDataType* error_type = NULL;
			ValaArrayList* _tmp180_;
			gpointer _tmp181_;
			ValaMethod* _tmp182_;
			ValaDataType* _tmp183_;
			ValaDataType* _tmp184_;
			ValaDataType* _tmp185_;
			_error_type_index = _error_type_index + 1;
			if (!(_error_type_index < _error_type_size)) {
				break;
			}
			_tmp180_ = _error_type_list;
			_tmp181_ = vala_list_get ((ValaList*) _tmp180_, _error_type_index);
			error_type = (ValaDataType*) _tmp181_;
			_tmp182_ = self->priv->_method;
			_tmp183_ = error_type;
			_tmp184_ = vala_data_type_copy (_tmp183_);
			_tmp185_ = _tmp184_;
			vala_method_add_error_type (_tmp182_, _tmp185_);
			_vala_code_node_unref0 (_tmp185_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp186_ = self->priv->_expression_body;
	if (_tmp186_ != NULL) {
		ValaBlock* block = NULL;
		ValaSourceReference* _tmp187_;
		ValaSourceReference* _tmp188_;
		ValaBlock* _tmp189_;
		ValaBlock* _tmp190_;
		ValaScope* _tmp191_;
		ValaScope* _tmp192_;
		ValaMethod* _tmp193_;
		ValaScope* _tmp194_;
		ValaScope* _tmp195_;
		ValaMethod* _tmp196_;
		ValaDataType* _tmp197_;
		ValaDataType* _tmp198_;
		ValaTypeSymbol* _tmp199_;
		ValaTypeSymbol* _tmp200_;
		ValaMethod* _tmp213_;
		ValaBlock* _tmp214_;
		_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp188_ = _tmp187_;
		_tmp189_ = vala_block_new (_tmp188_);
		block = _tmp189_;
		_tmp190_ = block;
		_tmp191_ = vala_symbol_get_scope ((ValaSymbol*) _tmp190_);
		_tmp192_ = _tmp191_;
		_tmp193_ = self->priv->_method;
		_tmp194_ = vala_symbol_get_scope ((ValaSymbol*) _tmp193_);
		_tmp195_ = _tmp194_;
		vala_scope_set_parent_scope (_tmp192_, _tmp195_);
		_tmp196_ = self->priv->_method;
		_tmp197_ = vala_callable_get_return_type ((ValaCallable*) _tmp196_);
		_tmp198_ = _tmp197_;
		_tmp199_ = vala_data_type_get_type_symbol (_tmp198_);
		_tmp200_ = _tmp199_;
		if (_tmp200_ != NULL) {
			ValaBlock* _tmp201_;
			ValaExpression* _tmp202_;
			ValaSourceReference* _tmp203_;
			ValaSourceReference* _tmp204_;
			ValaReturnStatement* _tmp205_;
			ValaReturnStatement* _tmp206_;
			_tmp201_ = block;
			_tmp202_ = self->priv->_expression_body;
			_tmp203_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_return_statement_new (_tmp202_, _tmp204_);
			_tmp206_ = _tmp205_;
			vala_block_add_statement (_tmp201_, (ValaStatement*) _tmp206_);
			_vala_code_node_unref0 (_tmp206_);
		} else {
			ValaBlock* _tmp207_;
			ValaExpression* _tmp208_;
			ValaSourceReference* _tmp209_;
			ValaSourceReference* _tmp210_;
			ValaExpressionStatement* _tmp211_;
			ValaExpressionStatement* _tmp212_;
			_tmp207_ = block;
			_tmp208_ = self->priv->_expression_body;
			_tmp209_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp210_ = _tmp209_;
			_tmp211_ = vala_expression_statement_new (_tmp208_, _tmp210_);
			_tmp212_ = _tmp211_;
			vala_block_add_statement (_tmp207_, (ValaStatement*) _tmp212_);
			_vala_code_node_unref0 (_tmp212_);
		}
		_tmp213_ = self->priv->_method;
		_tmp214_ = block;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp213_, _tmp214_);
		_vala_code_node_unref0 (block);
	} else {
		ValaMethod* _tmp215_;
		ValaBlock* _tmp216_;
		_tmp215_ = self->priv->_method;
		_tmp216_ = self->priv->_statement_body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp215_, _tmp216_);
	}
	_tmp217_ = self->priv->_method;
	_tmp218_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp217_);
	_tmp219_ = _tmp218_;
	_tmp220_ = self->priv->_method;
	_tmp221_ = vala_symbol_get_scope ((ValaSymbol*) _tmp220_);
	_tmp222_ = _tmp221_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp219_, _tmp222_);
	_tmp223_ = vala_code_context_get_analyzer (context);
	_tmp224_ = _tmp223_;
	_tmp225_ = vala_semantic_analyzer_get_current_symbol (_tmp224_);
	_tmp226_ = _tmp225_;
	_tmp227_ = vala_semantic_analyzer_find_parent_method (_tmp226_);
	m = _tmp227_;
	_tmp228_ = m;
	if (_tmp228_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaMethod* _tmp229_;
			ValaList* _tmp230_;
			ValaList* _tmp231_;
			gint _type_param_size = 0;
			ValaList* _tmp232_;
			gint _tmp233_;
			gint _tmp234_;
			gint _type_param_index = 0;
			_tmp229_ = m;
			_tmp230_ = vala_method_get_type_parameters (_tmp229_);
			_tmp231_ = _vala_iterable_ref0 (_tmp230_);
			_type_param_list = _tmp231_;
			_tmp232_ = _type_param_list;
			_tmp233_ = vala_collection_get_size ((ValaCollection*) _tmp232_);
			_tmp234_ = _tmp233_;
			_type_param_size = _tmp234_;
			_type_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp235_;
				gpointer _tmp236_;
				ValaMethod* _tmp237_;
				ValaTypeParameter* _tmp238_;
				const gchar* _tmp239_;
				const gchar* _tmp240_;
				ValaTypeParameter* _tmp241_;
				ValaSourceReference* _tmp242_;
				ValaSourceReference* _tmp243_;
				ValaTypeParameter* _tmp244_;
				ValaTypeParameter* _tmp245_;
				ValaMethod* _tmp246_;
				ValaMethod* _tmp247_;
				ValaBlock* _tmp248_;
				ValaBlock* _tmp249_;
				_type_param_index = _type_param_index + 1;
				if (!(_type_param_index < _type_param_size)) {
					break;
				}
				_tmp235_ = _type_param_list;
				_tmp236_ = vala_list_get (_tmp235_, _type_param_index);
				type_param = (ValaTypeParameter*) _tmp236_;
				_tmp237_ = self->priv->_method;
				_tmp238_ = type_param;
				_tmp239_ = vala_symbol_get_name ((ValaSymbol*) _tmp238_);
				_tmp240_ = _tmp239_;
				_tmp241_ = type_param;
				_tmp242_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp241_);
				_tmp243_ = _tmp242_;
				_tmp244_ = vala_typeparameter_new (_tmp240_, _tmp243_);
				_tmp245_ = _tmp244_;
				vala_method_add_type_parameter (_tmp237_, _tmp245_);
				_vala_code_node_unref0 (_tmp245_);
				_tmp246_ = self->priv->_method;
				vala_method_set_closure (_tmp246_, TRUE);
				_tmp247_ = m;
				_tmp248_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp247_);
				_tmp249_ = _tmp248_;
				vala_block_set_captured (_tmp249_, TRUE);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
	}
	_tmp250_ = self->priv->_method;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp250_);
	_tmp251_ = self->priv->_method;
	vala_code_node_check ((ValaCodeNode*) _tmp251_, context);
	_tmp252_ = self->priv->_method;
	_tmp253_ = vala_method_type_new (_tmp252_);
	_tmp254_ = _tmp253_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp254_);
	_vala_code_node_unref0 (_tmp254_);
	_tmp255_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp256_ = _tmp255_;
	_tmp257_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp258_ = _tmp257_;
	_tmp259_ = vala_data_type_get_value_owned (_tmp258_);
	_tmp260_ = _tmp259_;
	vala_data_type_set_value_owned (_tmp256_, _tmp260_);
	_tmp261_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp262_ = _tmp261_;
	result = !_tmp262_;
	_vala_iterable_unref0 (error_types);
	_vala_iterator_unref0 (lambda_param_it);
	_vala_iterable_unref0 (lambda_params);
	_vala_code_node_unref0 (return_type);
	_vala_code_node_unref0 (cb);
	return result;
}

static void
vala_lambda_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_lambda_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_lambda_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaLambdaExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp1_ = self->priv->_method;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_method;
		_tmp3_ = vala_method_get_closure (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaMethod* _tmp5_;
		_tmp5_ = self->priv->_method;
		vala_method_get_captured_variables (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

static void
vala_lambda_expression_class_init (ValaLambdaExpressionClass * klass,
                                   gpointer klass_data)
{
	vala_lambda_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_lambda_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaLambdaExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_lambda_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_lambda_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_lambda_expression_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_lambda_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_lambda_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_lambda_expression_real_get_used_variables;
}

static void
vala_lambda_expression_instance_init (ValaLambdaExpression * self,
                                      gpointer klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_lambda_expression_get_instance_private (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_lambda_expression_finalize (ValaCodeNode * obj)
{
	ValaLambdaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression);
	_vala_code_node_unref0 (self->priv->_expression_body);
	_vala_code_node_unref0 (self->priv->_statement_body);
	_vala_code_node_unref0 (self->priv->_method);
	_vala_iterable_unref0 (self->priv->parameters);
	VALA_CODE_NODE_CLASS (vala_lambda_expression_parent_class)->finalize (obj);
}

/**
 * Represents a lambda expression in the source code. Lambda expressions are
 * anonymous methods with implicitly typed parameters.
 */
static GType
vala_lambda_expression_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaLambdaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lambda_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLambdaExpression), 0, (GInstanceInitFunc) vala_lambda_expression_instance_init, NULL };
	GType vala_lambda_expression_type_id;
	vala_lambda_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLambdaExpression", &g_define_type_info, 0);
	ValaLambdaExpression_private_offset = g_type_add_instance_private (vala_lambda_expression_type_id, sizeof (ValaLambdaExpressionPrivate));
	return vala_lambda_expression_type_id;
}

GType
vala_lambda_expression_get_type (void)
{
	static volatile gsize vala_lambda_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_lambda_expression_type_id__volatile)) {
		GType vala_lambda_expression_type_id;
		vala_lambda_expression_type_id = vala_lambda_expression_get_type_once ();
		g_once_init_leave (&vala_lambda_expression_type_id__volatile, vala_lambda_expression_type_id);
	}
	return vala_lambda_expression_type_id__volatile;
}

