/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef WORKEROBJECT_H
#define WORKEROBJECT_H

#include <QObject>
#include <QPixmap>

#include "xmlhandle.h"
#include <QStandardPaths>
#include <QtXml>

#define LOCAL_USR_PATH QStandardPaths::writableLocation(QStandardPaths::GenericDataLocation)
#define LOCAL_APP_PATH QStandardPaths::writableLocation(QStandardPaths::GenericDataLocation)\
                       %QStringLiteral("/ukui-control-center/")
#define LOCAL_WALLPAPER_PATH QStandardPaths::writableLocation(QStandardPaths::GenericDataLocation)\
                                %QStringLiteral("/ukui-control-center/wallpaperData/")
#define LOCAL_WALLPAPER_HASH_PATH QStandardPaths::writableLocation(QStandardPaths::GenericDataLocation)\
                                  %QStringLiteral("/ukui-control-center/wallpaperData/HASH")



class WorkerObject : public QObject
{
    Q_OBJECT

public:
    explicit WorkerObject();
    ~WorkerObject();

public:
    void run();
    void setExit(bool flag);

private:
    XmlHandle * xmlHandleObj;

    QMap<QString, QMap<QString, QString> > wallpaperinfosMap;
    QStringList filenameList;
    bool exitFlag;

Q_SIGNALS:
    void pixmapGenerate(QPixmap pixmap, QString filename);
    void workComplete(QMap<QString, QMap<QString, QString>> wpInfoMaps);
    void readWallPaper_data(QStringList filenameList);
};

#endif // WORKEROBJECT_H
