/**
 * UGENE - Integrated Bioinformatics Tools.
 * Copyright (C) 2008-2011 UniPro <ugene@unipro.ru>
 * http://ugene.unipro.ru
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#ifndef _U2_EXTERNAL_TOOL_SUPPORT_ACTION_H
#define _U2_EXTERNAL_TOOL_SUPPORT_ACTION_H

#include <U2Core/ExternalToolRegistry.h>
#include <U2Gui/ObjectViewModel.h>

namespace U2 {

class ExternalToolSupprotAction : public GObjectViewAction {
    Q_OBJECT
public:
    ExternalToolSupprotAction(QObject* p, GObjectView* v, const QString& _text, int order, const QStringList& _toolNames);

    ExternalToolSupprotAction(const QString& text, QObject* p, const QStringList& _toolNames);

    const QStringList getToolNames(){return toolNames;}
private slots:
    void sl_pathChanged();
private:
    QStringList toolNames;
};

}//namespace
#endif // _U2_EXTERNAL_TOOL_SUPPORT_ACTION_H
