/*
 * Copyright 2013-2014 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of version 3 of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "purchase_service.h"

namespace UbuntuPurchases {

PurchaseService::PurchaseService(QObject *parent) :
    QObject(parent)
{
}

void PurchaseService::purchase(const QVariantMap &packageInfo)
{
    if(!this->m_packageName.isEmpty() || !packageInfo.contains("package_name")) {
        Q_EMIT this->failure(this->m_packageName);
        return;
    }
    this->m_packageName = packageInfo["package_name"].toString();

    Q_EMIT this->purchaseItem(this->m_packageName);
}

const QString& PurchaseService::getPackageName() const
{
    return this->m_packageName;
}

}
