/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.mviz;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import net.tinyos.mviz.DShapeModelListener;

class DShapeModel
implements Serializable {
    protected char type;
    protected int x1;
    protected int y1;
    protected int x;
    protected int x2;
    protected int y2;
    protected int y;
    protected Color fill;
    protected float value;
    protected int HALF_WIDTH = 20;
    protected int HALF_HEIGHT = 20;
    private transient ArrayList listeners;

    public DShapeModel(char c, int n, int n2, float f) {
        this.type = c;
        this.x = n;
        this.y = n2;
        this.value = f;
        int n3 = (int)f % 230;
        this.fill = new Color(n3 + 15, n3, n3 + 25);
        this.listeners = null;
        this.x1 = n - this.HALF_WIDTH;
        this.x2 = n + this.HALF_WIDTH;
        this.y1 = n2 - this.HALF_HEIGHT;
        this.y2 = n2 + this.HALF_HEIGHT;
    }

    public DShapeModel(char c, Color color) {
        this(c, 50, 50, 89, 89, color);
    }

    public DShapeModel() {
        this('m', new Color(12, 24, 48));
    }

    public DShapeModel(char c, int n, int n2, int n3, int n4, Color color) {
        this.type = c;
        this.x1 = n;
        this.y1 = n2;
        this.x2 = n3;
        this.y2 = n4;
        this.fill = color;
        this.listeners = null;
    }

    public DShapeModel(DShapeModel dShapeModel) {
        this.type = dShapeModel.type;
        this.x1 = dShapeModel.x1;
        this.y1 = dShapeModel.y1;
        this.x2 = dShapeModel.x2;
        this.y2 = dShapeModel.y2;
        this.fill = dShapeModel.fill;
        this.listeners = null;
    }

    public char getType() {
        return this.type;
    }

    public int getX1() {
        return this.x1;
    }

    public int getY1() {
        return this.y1;
    }

    public int getX2() {
        return this.x2;
    }

    public int getY2() {
        return this.y2;
    }

    public void applyDeltas(int n, int n2, int n3, int n4) {
        this.x1 += n;
        this.x2 += n3;
        this.y1 += n2;
        this.y2 += n4;
        this.x += n;
        this.y += n2;
        this.fireChanges();
    }

    public int getWidth() {
        return Math.abs(this.x2 - this.x1) + 1;
    }

    public int getHeight() {
        return Math.abs(this.y2 - this.y1) + 1;
    }

    public int getLocX() {
        return Math.min(this.x1, this.x2);
    }

    public int getLocY() {
        return Math.min(this.y1, this.y2);
    }

    public Color getColor() {
        return this.fill;
    }

    public void setColor(Color color) {
        if (this.fill.equals(color)) {
            return;
        }
        this.fill = color;
        this.fireChanges();
    }

    public void addListener(DShapeModelListener dShapeModelListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dShapeModelListener) continue;
            return;
        }
        this.listeners.add(dShapeModelListener);
    }

    public void removeListener(DShapeModelListener dShapeModelListener) {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            if (iterator.next() != dShapeModelListener) continue;
            iterator.remove();
            return;
        }
    }

    protected void fireChanges() {
        if (this.listeners == null) {
            return;
        }
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((DShapeModelListener)iterator.next()).shapeChanged(this);
        }
    }

    public void rotate() {
        int n = this.getLocX();
        int n2 = this.getLocY();
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = n4 / 2 - n3 / 2;
        this.x1 = n -= n5;
        this.x2 = n + n4 - 1;
        this.y1 = n2 += n5;
        this.y2 = n2 + n3 - 1;
        this.fireChanges();
    }

    public void scale(int n) {
        if (this.x1 < this.x2) {
            this.x1 -= n;
            this.x2 += n;
        } else {
            this.x1 += n;
            this.x2 -= n;
        }
        if (this.y1 < this.y2) {
            this.y1 -= n;
            this.y2 += n;
        } else {
            this.y1 += n;
            this.y2 -= n;
        }
        this.fireChanges();
    }

    public void move(int n, int n2) {
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        this.x1 = n;
        this.x2 = n + n4 - 1;
        this.y1 = n2;
        this.y2 = n2 + n3 - 1;
        this.fireChanges();
    }
}

