from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1


FLOAT32_MINPOS = _Mock()

_applyZoomToBackend = _Mock()

_scale1DRange = _Mock()

math = _Mock()

np = _Mock()

prepareCurveSignal = _Mock()

prepareDrawingSignal = _Mock()

prepareHoverSignal = _Mock()

prepareImageSignal = _Mock()

prepareMarkerSignal = _Mock()

prepareMouseSignal = _Mock()

rgba = _Mock()

time = _Mock()

weakref = _Mock()

FLOAT32_SAFE_MAX = 1e+37

FLOAT32_SAFE_MIN = -1e+37

LEFT_BTN = 'left'

RIGHT_BTN = 'right'

class ClickOrDrag(_Mock):
  pass
  DRAG_THRESHOLD_SQUARE_DIST = 25

class FocusManager(_Mock):
  pass


class ItemsInteraction(_Mock):
  pass
  DRAG_THRESHOLD_SQUARE_DIST = 25

class Pan(_Mock):
  pass
  DRAG_THRESHOLD_SQUARE_DIST = 25

class PlotBackend(_Mock):
  pass


class PlotInteraction(_Mock):
  pass


class Select(_Mock):
  pass


class Select1Point(_Mock):
  pass


class Select2Points(_Mock):
  pass


class SelectHLine(_Mock):
  pass


class SelectLine(_Mock):
  pass


class SelectPolygon(_Mock):
  pass


class SelectRectangle(_Mock):
  pass


class SelectVLine(_Mock):
  pass


class State(_Mock):
  pass


class StateMachine(_Mock):
  pass


class Zoom(_Mock):
  pass
  DRAG_THRESHOLD_SQUARE_DIST = 25
  _DOUBLE_CLICK_TIMEOUT = 0.4

class ZoomAndSelect(_Mock):
  pass


class _ZoomOnWheel(_Mock):
  pass
  DRAG_THRESHOLD_SQUARE_DIST = 25

