/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc 
#include "ErrorImpl.h"


namespace sc
{

ErrorImpl::ErrorImpl( const ErrorImpl& src )
: _code(src._code), _msg(src._msg), _nested(src._nested)
{
}

ErrorImpl::ErrorImpl( long code, const String& msg )
: _code(code), _msg(msg), _nested(sc::Success)
{
}

ErrorImpl::ErrorImpl( long code, const String& msg, const Error* nested )
: _code(code), _msg(msg), _nested(nested)
{
}

long ErrorImpl::getCode() const
{
  return _code;
}

String ErrorImpl::getMessage() const
{
  return _msg;
}

String ErrorImpl::getMessages() const
{
  if( ! _nested )
  {
    return getMessage();
  }

  sc::String msg(_msg);
  msg += _nested->getMessages();
  return msg;
}

const Error* ErrorImpl::getNested() const
{
  return _nested;
}


} // namespace
