/* ====================================================================
 * Copyright (c) 2003-2006, The Subcommander Crew
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_CONDITION_H
#define _SC_CONDITION_H

// sc
#include "Mutex.h"
#include "apr.h"

// apr
struct apr_thread_cond_t;


namespace sc
{

/**
 * Wrapper for the apr condition variable.
 */
class Condition
{
public:
  Condition();
  ~Condition();

  void wakeOne();
  void wakeAll();
  void wait();
  bool wait( unsigned long );

  void reset();

private:
  apr::Pool          _pool;

  Mutex              _mutex;
  apr_thread_cond_t* _condition;
  bool               _c;
};

} // namespace

#endif // _SC_CONDITION_H
