/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SWITCHCMD_H
#define _SC_SWITCHCMD_H

// sc
#include "ScCmd.h"
#include "svn/svn.h"
class SwitchParam;
class CmdResultCallback;

/**
 * Command for switching a working copy.
 */
class SwitchCmd : public ScCmd
{
public:
  /**
   * Construct a SwitchCmd.
   *
   * \param param the parameters for the command.
   * \param cb the callback that gets called when the command has finished.
   * The command takes ownership the callback.
   */
  SwitchCmd( SwitchParam* param, CmdResultCallback* cb );
  ~SwitchCmd();

  void run();

private:
  // in
  SwitchParam*       _param;

  // out
  CmdResultCallback* _cb;
};

#endif // _SC_SWITCHCMD_H
