-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

-------------------------------------------------------------------------------
--                                                                           --
-- SPARK.Ada.Command_Line.Unbounded_String                                   --
--                                                                           --
-- Description                                                               --
--   This is a binding to package Ada.Command_Line                           --
--                                                                           --
-- Language                                                                  --
--   Specification : SPARK                                                   --
--   Private Part  : None                                                    --
--   Body          : Ada                                                     --
--                                                                           --
-- Runtime Requirements and Dependencies                                     --
--   Full Ada Runtime                                                        --
--                                                                           --
-- Verification                                                              --
--   N/A                                                                     --
--                                                                           --
-- Exceptions                                                                --
--   None                                                                    --
-------------------------------------------------------------------------------

with SPARK.Ada.Strings.Unbounded;

--# inherit SPARK.Ada.Command_Line,
--#         SPARK.Ada.Strings.Unbounded;

package SPARK.Ada.Command_Line.Unbounded_String is

   -- function Argument (Number : Positive) return String;
   function Argument (Number : Positive)
                     return Strings.Unbounded.Unbounded_String;
   --# global Command_Line.State;
   --# pre Number <= Command_Line.Argument_Count (Command_Line.State);

   -- function Command_Name return String;
   function Command_Name return Strings.Unbounded.Unbounded_String;
   --# global Command_Line.State;

end SPARK.Ada.Command_Line.Unbounded_String;
