-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================
--------------------------------------------------------------------------------
-- Heap_Storage
--
-- Implementation
--
-- Uses Ada.Containers.Vectors to offer an automatically-extending
-- Vector. Implemented in Ada, not SPARK, so hidden.
--------------------------------------------------------------------------------

package body Heap_Storage is
   --# hide Heap_Storage;

   -----------------
   -- Initialize  --
   -----------------

   procedure Initialize (Initial_Length : in     SPARK.Ada.Containers.Count_Type;
                         V              :    out Vector) is
   begin
      V := Vector'(Vec => Vectors.To_Vector (Ada.Containers.Count_Type (Initial_Length)));
   end Initialize;

   -------------------
   --  Last_Index   --
   -------------------

   function Last_Index (V : Vector) return Atom is
   begin
      return Atom (Vectors.Last_Index (V.Vec));
   end Last_Index;

   -----------------
   -- Get_Element --
   -----------------

   function Get_Element (V     : in Vector;
                         Index : in Atom) return Atom_Descriptor is
   begin
      return Vectors.Element (Container => V.Vec,
                              Index     => Index);
   end Get_Element;

   -----------------
   -- Set_Element --
   -----------------

   procedure Set_Element (V     : in out Vector;
                          Index : in     Atom;
                          Value : in     Atom_Descriptor) is
   begin
      Vectors.Replace_Element (Container => V.Vec,
                               Index     => Index,
                               New_Item  => Value);
   end Set_Element;

   -----------------
   --   Append    --
   -----------------

   procedure Append (V     : in out Vector;
                     Value : in     Atom_Descriptor) is
   begin
      Vectors.Append (Container => V.Vec,
                      New_Item  => Value);
   end Append;

end Heap_Storage;
