8.4 リング

# リング

標準のリストで面白いスピンオンにリングがあります。いくつかのプログラミングを理解していれば、リングバッファやリングアレイなどをみたことがあるかもしれません。ここでは、まさに`ring`(環状リスト)についてみていきます。 - それは短く、簡単です。

リストの前章では、インデックスの機構を使用してリストから要素を取り出す方法を説明しました。

```
puts [52, 55, 59][1]
```

もしインデックス100を取り出そうとしら、何が起こるでしょう？まあ、3つの要素しか持たないリストの中でインデックス100の要素は、明らかにありません。だからSonic Piは空を意味する `nil` を返すでしょう。

ここでは、現在のビート（拍子）が継続的に増加する`counter`を考えてみましょう。まずはカウンターとリストを作成します。

```
counter = 0
notes = [52, 55, 59]
```

これで、リストの音符にアクセスするためのカウンタを使用することができます。

```
puts notes[counter]
```

素晴らしい、`52`を取得しました。カウンターを増やして別の音符を取得してみましょう。

```
counter = (inc counter)
puts notes[counter]
```

すごいでしょう、 `55`を取得し、それを再び繰り返すならば`59を得ます。さらに繰り返す場合は、リスト内の数が不足し`nil`になるでしょう。では、ちょうどループのはじめに戻り、再びリストの先頭から開始したい場合はどうしたらようでしょうか？そのためにリングを使います。

## リングの作成

2つの方法の内、どちらか1つの方法でリングを作成することができます。どちらもパラメータとしての環(円環構造を持つリスト)要素である`ring`関数を利用します。

```
(ring 52, 55, 59)
```

また、正常のリストを取得し、`.ring`メッセージをそれを送りリングに変換することができます。

```
[52, 55, 59].ring
```

リングのインデックス化

いったんリングを取得したら、インデックスがマイナスもしくはリングの数値より大きい場合を除いて、通常のリストを使用する場合とまったく同じ方法で使用することができます。、そしてリングの１つの要素として括弧でくくられて表示されます。

```
(ring 52, 55, 59)[0] #=> 52
(ring 52, 55, 59)[1] #=> 55
(ring 52, 55, 59)[2] #=> 59
(ring 52, 55, 59)[3] #=> 52
(ring 52, 55, 59)[-1] #=> 59
```

## リングを使用する

現在のビート（拍子）の値を表すために変数を使用しているとしましょう​​。
その変数は、現在表しているビート値に関わらず、インデックスとして音符を演奏するためや、
リリースタイム（放出時間）、リングに格納されている有用な値として使うことができます。

## スケールとコードはリング

知っておくと役立つこととして、`scale`（音階）と`chord` (和音)によって返されたリストもリングであり、任意のインデックスでそれらにアクセスすることを可能にします。

## リングのコンストラクタ(構成子)

加えて、リングを構成する多くの機能があります。

* `range`は始点、終点とステップサイズを指定します。
* `bools`は簡単に1と0を使用するためのブール値を扱うことができます。
* `knit`は一連の繰り返される値のために構成することを可能にします。
* `spread`はユークリッド分布に従ったブール値のリングを作成します。

詳細については、それら個々のドキュメンテーションを見てください。
