9.4 Ticking

# Ticking

Something you'll likely find yourself doing a lot when live coding is
looping through rings. You'll be putting notes into rings for melodies,
sleeps for rhythms, chord progressions, timbral variations, etc. etc.

## Ticking Rings

Sonic Pi provides a *very* handy tool for working with rings within
`live_loop`s. It's called the tick system. In the section about the rings we were talking about the counter that is constantly increasing, like a current beat number. Tick just implements this idea. It provides you with the ability to *tick through rings*. Let's look at an example:

```
counter = 0
live_loop :arp do
  play (scale :e3, :minor_pentatonic)[counter], release: 0.1
  counter += 1
  sleep 0.125
end
```

This is equivalent to:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end
```

Here, we're just grabbing the scale E3 minor pentatonic and ticking through each element. This is done by adding `.tick` to the end of the scale declaration. This tick is local to the live loop, so each live loop can have its own independent tick:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick, release: 0.1
  sleep 0.125
end

live_loop :arp2 do
  use_synth :dsaw
  play (scale :e2, :minor_pentatonic, num_octaves: 3).tick, release: 0.25
  sleep 0.25
end
```

## Tick

You can also call `tick` as a standard fn and use the value as an index:

```
live_loop :arp do
  idx = tick
  play (scale :e3, :minor_pentatonic)[idx], release: 0.1
  sleep 0.125
end
```

However, it is much nicer to call `.tick` at the end. The `tick` fn is
for when you want to do fancy things with the tick value and for when
you want to use ticks for other things than indexing into rings.


## Look

The magical thing about tick is that not only does it return a new index
(or the value of the ring at that index) it also makes sure that next
time you call tick, it's the next value. Take a look at the examples in
the docs for `tick` for many ways of working with this. However, for
now, it's important to point out that sometimes you'll want to just look
at the current tick value and *not increase* it. This is available via
the `look` fn. You can call `look` as a standard fn or by adding `.look`
to the end of a ring.

## Naming Ticks

Finally, sometimes you'll need more than one tick per live loop. This is achieved by giving your tick a name:

```
live_loop :arp do
  play (scale :e3, :minor_pentatonic).tick(:foo), release: 0.1
  sleep (ring 0.125, 0.25).tick(:bar)
end
```

Here we're using two ticks one for the note to play and another for the
sleep time. As they're both in the same live loop, to keep them separate
we need to give them unique names. This is exactly the same kind of
thing as naming `live_loop`s - we just pass a symbol prefixed with a
`:`. In the example above we called one tick `:foo` and the other
`:bar`. If we want to `look` at these we also need to pass the name of
the tick to `look`.

## Don't make it too complicated

Most of the power in the tick system isn't useful when you get
started. Don't try and learn everything in this section. Just focus on
ticking through a single ring. That'll give you most of the joy and
simplicity of ticking through rings in your `live_loop`s.

Take a look at the documentation for `tick` where there are many useful
examples and happy ticking!

