
/*
 * slmon
 *
 * Copyright (C) 2000, 2001, 2002 Krzysztof Luks <m00se@iq.pl>
 *
 * This program is distributed under the GPL license. For details see
 * COPYING text.
 *
 * Author: Krzysztof Luks <m00se@iq.pl>
 *
 * $Date: 2004/06/20 15:56:47 $
 * $Revision: 1.2 $
 *
 */

#ifndef UTF8
#define UTF8
#endif

#ifndef SLMON_DEFINES_H
#define SLMON_DEFINES_H

#include <stdlib.h>
#include <time.h>
#include <string.h>
#include <utmp.h>
#include <getopt.h>

#ifdef HAVE_SLANG_H
#include <slang.h>
#endif				/* !HAVE_SLANG_H */

#ifdef HAVE_SLANG_SLANG_H
#include<slang/slang.h>
#endif				/* !HAVE_SLANG_SLANG_H */

#include <signal.h>
#include <sys/utsname.h>
#include <sys/file.h>

#include <glib.h>
#include <glibtop/cpu.h>
#include <glibtop/uptime.h>
#include <glibtop/mem.h>
#include <glibtop/swap.h>
#include <glibtop/loadavg.h>
#include <glibtop/procmap.h>
#include <glibtop/mountlist.h>
#include <glibtop/fsusage.h>

#ifndef PROFILE_COUNT
#define PROFILE_COUNT   1000
#endif				/* !PROFILE_COUNT */

/* slmon specific defines */

#define MAXCPU 9

#define MODE_H 0		/* Histogram              */
#define MODE_M 1		/* Main                   */
#define MODE_N 2		/* Network                */
#define MODE_P 3		/* Proceses               */
#define MODE_X 4		/* Help                   */

#define COL_NORM 241		/* Default text color     */
#define COL_VALU 242		/* Values color           */
#define COL_STAT 243		/* Status line text       */
#define COL_STBA 244		/* Status line background */
#define COL_BACK 245		/* Background color       */
#define COL_GRA1 246		/* Gradient 1st color     */
#define COL_GRA2 247		/* Gradient 2nd color     */
#define COL_GRA3 248		/* Gradient 3rd color     */

#define GAUGE_LEFT 0		/* Gauge is drawn left of the caption */
#define GAUGE_RIGHT 1		/* Gauge is drawn right of the caption */

/* used to compute percentage of cpu usage */
struct last {
    double idlelast;
    double totallast;
};

struct last l[GLIBTOP_NCPU];	/* we have to remember data for all cpus */

static const int unit_div[3] = { 1, 1024, 1048576 };	/* unit dividers */
static const char unit_name[4] = { 'b', 'k', 'M', 'G' };	/* unit letters  */
unsigned long update_time;

/* main configuration is kept here */
struct config {
    int cpus;			/* number of processors */
    int mem;			/* memory usage unit */
    int fs;			/* fs usage unit */
    int net;			/* network traffic unit */
    int gauge_len;		/* gauge length */
    int fs_first;		/* which fs is displayed first */
    int fs_max;			/* how many fs should be displayed */
    int proc_first;		/* which process is displayed first */
    int proc_curr;
    int freq;			/* tick frequency */
    int iface_count;            /* number of interfaces */
    int iface_first;            /* which iface is displayed first */
    SLKeyMap_List_Type *map_h;
    SLKeyMap_List_Type *map_g;
    SLKeyMap_List_Type *map_n;
    SLKeyMap_List_Type *map_p;
    SLKeyMap_List_Type *map_x;
    SLKeyMap_List_Type *map;
    struct slmon_net *iface;
    int (*sort_func)(const void *, const void *);
} conf;

struct slmon_conf {
    const char *name;
    int type;			/* type of the value - unused? */
    int val;
};

typedef struct {
    char *user;
    unsigned int pid;
    unsigned long pcpu;
    unsigned long pmem;
    unsigned int vsz;
    unsigned int rss;
    char state;
    char *args;
} slmon_proc;

struct slmon_net {
    char *name;
    int now;
    unsigned long last_in;
    unsigned long last_out;
    struct slmon_net *next;
    struct slmon_net *prev;
};

slmon_proc *plist;

int rspace, cspace, do_bold, height;
int mode, last_mode, cur_cpu, pos, redraw;
int fnord;			/* We don't need to update all stats in every cycle */

char *col_norm;			/* descriptions       */
char *col_valu;			/* values             */
char *col_stat;			/* status line fg     */
char *col_stba;			/* status line bg     */
char *col_back;			/* background         */
char *col_gra1;			/* 1st gradient color */
char *col_gra2;			/* 2nd gradient color */
char *col_gra3;			/* 3rd gradient color */

/* vaild slang color names *
static char *slangColors[] = { "black", "red", "green", "brown",
    "blue", "magenta", "cyan", "lightgray", "gray", "brightred",
    "brightgreen", "yellow", "brightblue", "brightmagenta",
    "brightcyan", "white", "default"
};
*/

static const struct option slmon_options[] = {
    {"version", no_argument, 0, 'v'},
    {"help", no_argument, 0, 'h'},
    {"mem-unit", required_argument, 0, 'm'},
    {"fs-unit", required_argument, 0, 'f'},
    {"net-unit", required_argument, 0, 'n'},
    {"mode", required_argument, 0, 'd'},
    {"update", required_argument, 0, 'u'},
    {NULL, 0, 0, 0}
};

/* TODO: add colors */

static const struct slmon_conf rc_conf[] = {
    {"mode", 0, 'd'},
    {"mem_unit", 0, 'm'},
    {"fs_unit", 0, 'f'},
    {"net_unit", 0, 'n'},
    {"net_dev", 0, 'v'},
    {"update_time", 0, 't'},
    {NULL, 0, 0}
};

#endif				/* !SLMON_DEFINES_H */
