/* Public domain. */

#include <errno.h>
#include "sysdeps.h"
#include "tai.h"
#ifndef HASPOLL
# include "select.h"
#endif
#include "iopause.h"

int iopause (iopause_fd *x, unsigned int len, struct taia const *deadline, struct taia const *stamp)
{
  int millisecs ;
  int r ;

  if (!deadline) millisecs = -1 ;
  else if (taia_less(stamp, deadline))
  {
    double d ;
    struct taia t ;
    taia_sub(&t, deadline, stamp) ;
    d = taia_approx(&t) ;
    millisecs = d * 1000.0 + 20.0 ;
  }
  else millisecs = 0 ;

  {
    register unsigned int i = 0 ;
    for (; i < len ; i++) x[i].revents = 0 ;
  }

#ifdef HASPOLL

  do
    r = poll(x, len, millisecs) ;
  while ((r == -1) && (errno == EINTR)) ;

#else

  {
    fd_set rfds, wfds, xfds ;
    int nfds = 1 ;
    struct timeval tv ;

    if (millisecs >= 0)
    {
      tv.tv_sec = millisecs / 1000 ;
      tv.tv_usec = 1000 * (millisecs % 1000) ;
    }

    FD_ZERO(&rfds) ;
    FD_ZERO(&wfds) ;
    FD_ZERO(&xfds) ;

    {
      register unsigned int i = 0 ;
      for (; i < len ; i++)
        if (x[i].fd >= 0)
        {
          /* if (x[i].fd >= (sizeof(fd_set) << 3)) continue ; */
          if (x[i].fd >= nfds) nfds = x[i].fd + 1 ;
          if (x[i].events & IOPAUSE_READ) FD_SET(x[i].fd, &rfds) ;
          if (x[i].events & IOPAUSE_WRITE) FD_SET(x[i].fd, &wfds) ;
          if (x[i].events & IOPAUSE_EXCEPT) FD_SET(x[i].fd, &xfds) ;
        }
    }

    do
      r = select(nfds, &rfds, &wfds, &xfds, (millisecs >= 0) ? &tv : 0) ;
    while ((r == -1) && (errno == EINTR)) ;

    if (r > 0)
    {
      register unsigned int i = 0 ;
      for (; i < len ; i++)
        if (x[i].fd >= 0)
        {
          /* if (x[i].fd >= (sizeof(fd_set) << 3)) continue ; */
          if ((x[i].events & IOPAUSE_READ) && FD_ISSET(x[i].fd, &rfds))
            x[i].revents |= IOPAUSE_READ ;
          if ((x[i].events & IOPAUSE_WRITE) && FD_ISSET(x[i].fd, &wfds))
            x[i].revents |= IOPAUSE_WRITE ;
          if ((x[i].events & IOPAUSE_EXCEPT) && FD_ISSET(x[i].fd, &xfds))
            x[i].revents |= IOPAUSE_EXCEPT ;
        }
    }
  }

#endif

  return r ;
}
