/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.output.xsd.basic.Annotated;
import com.thaiopensource.relaxng.output.xsd.basic.Annotation;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeGroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.AttributeUse;
import com.thaiopensource.relaxng.output.xsd.basic.Comment;
import com.thaiopensource.relaxng.output.xsd.basic.GroupDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.Include;
import com.thaiopensource.relaxng.output.xsd.basic.Particle;
import com.thaiopensource.relaxng.output.xsd.basic.RootDeclaration;
import com.thaiopensource.relaxng.output.xsd.basic.SchemaVisitor;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleType;
import com.thaiopensource.relaxng.output.xsd.basic.SimpleTypeDefinition;
import com.thaiopensource.relaxng.output.xsd.basic.TopLevel;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Schema
extends Annotated {
    private final String uri;
    private final String encoding;
    private Schema parent;
    private final List<TopLevel> topLevel = new Vector<TopLevel>();
    private final Map<String, GroupDefinition> groupMap;
    private final Map<String, AttributeGroupDefinition> attributeGroupMap;
    private final Map<String, SimpleTypeDefinition> simpleTypeMap;
    private final List<Schema> subSchemas;
    private final List<Comment> leadingComments = new Vector<Comment>();
    private final List<Comment> trailingComments = new Vector<Comment>();

    public Schema(SourceLocation sourceLocation, Annotation annotation, String string, String string2) {
        super(sourceLocation, annotation);
        this.uri = string;
        this.encoding = string2;
        this.groupMap = new HashMap<String, GroupDefinition>();
        this.attributeGroupMap = new HashMap<String, AttributeGroupDefinition>();
        this.simpleTypeMap = new HashMap<String, SimpleTypeDefinition>();
        this.subSchemas = new Vector<Schema>();
        this.subSchemas.add(this);
    }

    private Schema(SourceLocation sourceLocation, Annotation annotation, String string, String string2, Schema schema) {
        super(sourceLocation, annotation);
        this.parent = schema;
        this.uri = string;
        this.encoding = string2;
        this.groupMap = schema.groupMap;
        this.attributeGroupMap = schema.attributeGroupMap;
        this.simpleTypeMap = schema.simpleTypeMap;
        this.subSchemas = schema.subSchemas;
        this.subSchemas.add(this);
    }

    public String getUri() {
        return this.uri;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Schema getParent() {
        return this.parent;
    }

    public void defineGroup(String string, Particle particle, SourceLocation sourceLocation, Annotation annotation) {
        GroupDefinition groupDefinition = new GroupDefinition(sourceLocation, annotation, this, string, particle);
        this.topLevel.add(groupDefinition);
        this.groupMap.put(string, groupDefinition);
    }

    public void defineAttributeGroup(String string, AttributeUse attributeUse, SourceLocation sourceLocation, Annotation annotation) {
        AttributeGroupDefinition attributeGroupDefinition = new AttributeGroupDefinition(sourceLocation, annotation, this, string, attributeUse);
        this.topLevel.add(attributeGroupDefinition);
        this.attributeGroupMap.put(string, attributeGroupDefinition);
    }

    public void defineSimpleType(String string, SimpleType simpleType, SourceLocation sourceLocation, Annotation annotation) {
        SimpleTypeDefinition simpleTypeDefinition = new SimpleTypeDefinition(sourceLocation, annotation, this, string, simpleType);
        this.topLevel.add(simpleTypeDefinition);
        this.simpleTypeMap.put(string, simpleTypeDefinition);
    }

    public void addRoot(Particle particle, SourceLocation sourceLocation, Annotation annotation) {
        this.topLevel.add(new RootDeclaration(sourceLocation, annotation, particle));
    }

    public Schema addInclude(String string, String string2, SourceLocation sourceLocation, Annotation annotation) {
        Schema schema = new Schema(sourceLocation, annotation, string, string2, this);
        this.topLevel.add(new Include(sourceLocation, annotation, schema));
        return schema;
    }

    public void addComment(String string, SourceLocation sourceLocation) {
        this.topLevel.add(new Comment(sourceLocation, string));
    }

    public GroupDefinition getGroup(String string) {
        return this.groupMap.get(string);
    }

    public SimpleTypeDefinition getSimpleType(String string) {
        return this.simpleTypeMap.get(string);
    }

    public AttributeGroupDefinition getAttributeGroup(String string) {
        return this.attributeGroupMap.get(string);
    }

    public void accept(SchemaVisitor schemaVisitor) {
        for (TopLevel topLevel : this.topLevel) {
            topLevel.accept(schemaVisitor);
        }
    }

    public List<Schema> getSubSchemas() {
        return this.subSchemas;
    }

    public List<Comment> getLeadingComments() {
        return this.leadingComments;
    }

    public List<Comment> getTrailingComments() {
        return this.trailingComments;
    }

    @Override
    public boolean equals(Object object) {
        return object == this;
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }
}

