/***************************************************************************
 *   Copyright (C) 2004 by Johan Maes - ON4QZ                              *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef FFTDISPLAY_H
#define FFTDISPLAY_H
#include <QtGui>
#include "global.h"
#include "fftw3.h"



/**Fast Fourier Transform
  *@author Johan Maes - ON1MH
  */


class fftDisplay : public QFrame
 {
 	Q_OBJECT
public: 
	fftDisplay(QWidget *p=NULL);
	~fftDisplay();
  /** must be called before performing any FFT */
  void init(unsigned int fftLength, int samplingrate);
  void realFFT(short int *iBuffer);
  void realFFT(float *iBuffer);
  /** do the actual FFT calculation */
  void paintEvent(QPaintEvent *);
//	void resizeEvent(QResizeEvent *e);
public slots:
	void mousePressEvent( QMouseEvent *e );

private:
	unsigned int points;
  unsigned char bufIndex;
  unsigned int w,h;
//	DSPFLOAT *A,*B;
  DSPFLOAT*sptr;
	DSPFLOAT *endptr1,*endptr2;
//	short *br1,*br2;
//	DSPFLOAT HRplus,HRminus,HIplus,HIminus;
  double *arMag;
//	DSPFLOAT *oBuffer;
	uint dataLength;
	short int *buffer;
	QImage *im;

  int bucketHigIndex;
  int bucketLowIndex;
  int bucketSpanIndex;
	bool showWaterfall;
  double maxMagnitude;
  double  minMagnitude;
  double avgMagnitude;
	QPolygon *FFTArray;
	float *fftTempArray;
private: // Private methods
  /** delete allocated buffers */
  void deleteBuffers();
	void doFFT();
  /** No descriptions */
  void draw(bool update);
	
//  int h,w;
	bool enabled;
	uint eraseColor;
  double *in;
  double *out;
  fftw_plan plan;
  //double *magnitude;
};

#endif
