Minutes from 89th OpenVDB TSC meeting, May 4th, 2021, (EDT)

Attendees: *Ken* m., *Jeff* L., *Dan* B., *Andre* P.

Additional Attendees: Jeff Budsberg (DWA), JT Nelson (Blender),
Johannes Meng (Intel)

Regrets: *Nick* A.

Agenda:

1) Confirm Quorum
2) Secretary
3) Siggraph Course
4) ABI=9
4a) Root Node Offset
4b) Blind Data
5) NanoVDB
6) Example Hip File
7) Quick review of PRs
8) Next Meeting


1) Confirm Quorum

Quorum is present.

2) Secretary

Secretary is Dan Bailey.

3) Siggraph Course

Siggraph course has been accepted with a very high review score. It will be a
three hour session. Presenters will be Ken Museth, Jeff Lait, Jeff Budsberg,
Richard Jones and Dan Bailey. There may be an additional presenter which would
mean 30 minutes for each presentation. Jeff Budsberg will present the VDB
Extrapolate SOP instead of Andre. Richard Jones will present VDB AX instead of
Nick.

Presentations must be pre-recorded and delivered on 4th June, or 11th June if
delivered with closed captioning. All in agreement that it would be preferred
for Siggraph to handle the closed captioning for us, so 4th June is the deadline
for recordings. The videos will need editing and splicing together, JT mentions
that he is a video editor so could help us with this. Course notes and
supplemental material need to be delivered by 11th June.

4) ABI=9

What changes should be considered for ABI=9? New features can be added now and
gated by the ABI=9 macro in preparation for the v9.0 release around Siggraph
time.

4a) Root Node Offset

A root node offset in space would be highly desirable as the common use case of
objects centered on the origin could feasibly use just one root node child. This
is expected to greatly accelerate random access, particularly when using the
ValueAccessor as it would avoid needing to go through the root node hash table
which is known to be slow. However, this is a theory and should be tested to
confirm.

Backwards compatibility is important, a breaking change to the file format is a
big deal.

One option is to apply the offset in-memory only during VDB deserialization.
This would have the benefit of not requiring any changes to the file format
itself, however the IO code will need to become more complicated as a result.
Potential to test performance by manipulating a VDB to apply the offset and
accessing the impact on the root node access times. Open question about whether
an index-space offset would still need to be applied for every voxel access and
what exactly the cost of that might be. More investigation and thought needed
here.

4b) Blind Data

PR1050 attempts to implement this feature. After a brief discussion, the name
transientData() is settled upon for the blind data method. This makes it clear
that the blind data is not serialized. All in agreement that a 64-bit unsigned
integer allows room for expansion at a later date without needing an API change.
The proposed technique of stealing bits from the origin coordinate to extend the
range is not part of this PR.

5) NanoVDB

NanoVDB will be shared with the group for review soon. Likely just the core
library at first. One missing component is updating PNanoVDB (the C API). SideFX
needs an updated CNanoVDB API to match the new data layout, this may end up
being something that is maintained on their end.

6) Example Hip File

Jeff Budsberg has been updating the example hip file that has been shared on the
website removing some old nodes and adding some new examples. Currently missing
any examples for VDB AX as this is not yet released at DWA. Plan is to release
the current version and then to extend nearer to Siggraph with some VDB AX
examples.

7) Quick review of PRs

PR1045 - VDB Activate SOP world space parameter and question about expand/dilate
behavior. Jeff mentions that there is precedence in Houdini to want two
constraints to be enforced. Suggestion is to add a warning instead.
PR1038 - Dan to implement VDB Resample SOP feedback from Jeff.
PR1031 - Dan has now implemented VDB Merge feedback from Jeff.

8) Next Meeting

Next meeting is May 11th, 2021. 12pm-1pm EST (GMT-5).
