###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for vm-builder vulnerability USN-670-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840256);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "670-1");
  script_name( "Ubuntu Update for vm-builder vulnerability USN-670-1");
  desc = "

  Vulnerability Insight:

  Mathias Gug discovered that vm-builder improperly set the root
  password when creating virtual machines. An attacker could exploit
  this to gain root privileges to the virtual machine by using a
  predictable password.
  
  This vulnerability only affects virtual machines created with
  vm-builder under Ubuntu 8.10, and does not affect native Ubuntu
  installations. An update was made to the shadow package to detect
  vulnerable systems and disable password authentication for the
  root account. Vulnerable virtual machines which an attacker has
  access to should be considered compromised, and appropriate actions
  taken to secure the machine.

  Affected Software/OS:
  vm-builder vulnerability on Ubuntu 6.06 LTS ,
  Ubuntu 7.10 ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-November/000777.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of vm-builder vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"login", ver:"4.0.13-7ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"passwd", ver:"4.0.13-7ubuntu3.3", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"login", ver:"4.1.1-1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"passwd", ver:"4.1.1-1ubuntu1.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-vm-builder-ec2", ver:"0.9-0ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"python-vm-builder", ver:"0.9-0ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"ubuntu-vm-builder", ver:"0.9-0ubuntu3.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"login", ver:"4.0.18.2-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"passwd", ver:"4.0.18.2-1ubuntu2.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"login", ver:"4.0.18.1-9ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"passwd", ver:"4.0.18.1-9ubuntu0.1", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}