# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8507 (viewvc)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64629);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 11 FEDORA-2009-8507 (viewvc)");

 desc = "The remote host is missing an update to viewvc
announced via advisory FEDORA-2009-8507.

Update Information:

CHANGES in 1.1.2:
- security fix: validate the 'view' parameter to avoid XSS attack
- security fix: avoid printing illegal parameter names and values
- add optional support for character encoding detection (issue #400)
- fix username case handling in svnauthz module (issue #419)
- fix cvsdbadmin/svnadmin rebuild error on missing repos (issue #420)
- don't drop leading blank lines from colorized file contents (issue #422)
- add file.ezt template logic for optionally hiding binary file contents

Also includes:    Install and populate mimetypes.conf. This should
hopefully help when colouring syntax using pygments.
Install and populate mimetypes.conf.

ChangeLog:

* Wed Aug 12 2009 Bojan Smojver  - 1.1.2-2
- fix replacement of varius config variables
* Wed Aug 12 2009 Bojan Smojver  - 1.1.2-1
- bump up to 1.1.2
- security fix: validate the 'view' parameter to avoid XSS attack
- security fix: avoid printing illegal parameter names and values
* Tue Aug 11 2009 Bojan Smojver  - 1.1.1-2
- install mimetypes.conf
- populate mimetypes.conf with what pygments understands

References:

[ 1 ] Bug #516958 - default viewvc.conf changed, paths need fixing
https://bugzilla.redhat.com/show_bug.cgi?id=516958
[ 2 ] Bug #514909 - RFE: mimetypes.conf should be in /etc/viewvc/
https://bugzilla.redhat.com/show_bug.cgi?id=514909
[ 3 ] Bug #514773 - syntax highlighting not working
https://bugzilla.redhat.com/show_bug.cgi?id=514773

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update viewvc' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8507

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8507 (viewvc)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"viewvc", rpm:"viewvc~1.1.2~2.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"viewvc-httpd", rpm:"viewvc-httpd~1.1.2~2.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
