# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1925-1 (proftpd-dfsg)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66205);
 script_cve_id("CVE-2009-3639");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1925-1 (proftpd-dfsg)");

 desc = "The remote host is missing an update to proftpd-dfsg
announced via advisory DSA 1925-1.

It has been discovered that proftpd-dfsg, a virtual-hosting FTP daemon,
does not properly handle a '\0' character in a domain name in the
Subject Alternative Name field of an X.509 client certificate, when the
dNSNameRequired TLS option is enabled.


For the stable distribution (lenny), this problem has been fixed in
version 1.3.1-17lenny4.

For the oldstable distribution (etch), this problem has been fixed in
version 1.3.0-19etch3.

Binaries for the amd64 architecture will be released once they are
available.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1.3.2a-2.


We recommend that you upgrade your proftpd-dfsg packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201925-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1925-1 (proftpd-dfsg)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"proftpd-mysql", ver:"1.3.0-19etch3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-ldap", ver:"1.3.0-19etch3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-pgsql", ver:"1.3.0-19etch3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-doc", ver:"1.3.1-17lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd", ver:"1.3.1-17lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-ldap", ver:"1.3.1-17lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-basic", ver:"1.3.1-17lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-mysql", ver:"1.3.1-17lenny4", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"proftpd-mod-pgsql", ver:"1.3.1-17lenny4", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
