# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1508-1 (diatheke)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60442);
 script_cve_id("CVE-2008-0932");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1508-1 (diatheke)";
 script_name(name);

 desc = "The remote host is missing an update to diatheke
announced via advisory DSA 1508-1.

Dan Dennison discovered that Diatheke, a CGI program to make a bible
website, performs insufficient sanitising of a parameter, allowing a
remote attacker to execute arbitrary shell commands as the web server
user.

For the stable distribution (etch), this problem has been fixed in version
1.5.9-2etch1.

For the old stable distribution (sarge), this problem has been fixed in
version 1.5.7-7sarge1.

For the unstable distribution (sid), this problem has been fixed in version
1.5.9-8.

We recommend that you upgrade your diatheke package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201508-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1508-1 (diatheke)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libsword-dev", ver:"1.5.7-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsword4", ver:"1.5.7-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"diatheke", ver:"1.5.7-7sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"diatheke", ver:"1.5.9-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsword-dev", ver:"1.5.9-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsword6", ver:"1.5.9-2etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
