//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir WeightedExperiments
 *
 *  Copyright 2005-2023 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTWEIGHTEDEXPERIMENTS_HXX
#define OPENTURNS_OTWEIGHTEDEXPERIMENTS_HXX

#include "openturns/BootstrapExperiment.hxx"
#include "openturns/FixedExperiment.hxx"
#include "openturns/GaussProductExperiment.hxx"
#include "openturns/ImportanceSamplingExperiment.hxx"
#include "openturns/TemperatureProfile.hxx"
#include "openturns/GeometricProfile.hxx"
#include "openturns/LinearProfile.hxx"
#include "openturns/SpaceFillingC2.hxx"
#include "openturns/SpaceFillingMinDist.hxx"
#include "openturns/SpaceFillingPhiP.hxx"
#include "openturns/OptimalLHSExperiment.hxx"
#include "openturns/SimulatedAnnealingLHS.hxx"
#include "openturns/MonteCarloLHS.hxx"
#include "openturns/LHSResult.hxx"
#include "openturns/LHSExperiment.hxx"
#include "openturns/LowDiscrepancyExperiment.hxx"
#include "openturns/MonteCarloExperiment.hxx"
#include "openturns/WeightedExperiment.hxx"
#include "openturns/WeightedExperimentImplementation.hxx"
#include "openturns/SplitterImplementation.hxx"
#include "openturns/KFoldSplitter.hxx"
#include "openturns/LeaveOneOutSplitter.hxx"
#include "openturns/TensorProductExperiment.hxx"
#include "openturns/SmolyakExperiment.hxx"

#endif /* OPENTURNS_OTWEIGHTEDEXPERIMENTS_HXX */
