/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | www.openfoam.com
     \\/     M anipulation  |
-------------------------------------------------------------------------------
    Copyright (C) 2011-2013 OpenFOAM Foundation
    Copyright (C) 2018 OpenCFD Ltd.
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

\*---------------------------------------------------------------------------*/

#include "volumeType.H"
#include "dictionary.H"

// * * * * * * * * * * * * * * Static Data Members * * * * * * * * * * * * * //

const Foam::Enum
<
    Foam::volumeType::type
>
Foam::volumeType::names
({
    { volumeType::type::UNKNOWN, "unknown" },
    { volumeType::type::INSIDE, "inside" },
    { volumeType::type::OUTSIDE, "outside" },
    { volumeType::type::MIXED, "mixed" },
});


// * * * * * * * * * * * * * * * * Constructors  * * * * * * * * * * * * * * //

Foam::volumeType::volumeType
(
    const word& key,
    const dictionary& dict,
    const type deflt
)
:
    t_(names.lookupOrDefault(key, dict, deflt))
{}


// * * * * * * * * * * * * * * * Member Functions * * * * * * * * * * * * * * //

const Foam::word& Foam::volumeType::str() const
{
    return names[t_];
}


// * * * * * * * * * * * * * * * IOstream Operators  * * * * * * * * * * * * //

Foam::Istream& Foam::operator>>(Istream& is, volumeType& vt)
{
    int val;
    is  >> val;

    vt.t_ = static_cast<volumeType::type>(val);

    return is;
}


Foam::Ostream& Foam::operator<<(Ostream& os, const volumeType& vt)
{
    os  << static_cast<int>(vt.t_);

    return os;
}


// ************************************************************************* //
