; $Id: dickson.tac 2156 2008-01-25 13:25:12Z schimans $

(set! COMMENT-FLAG #f)
(libload "nat.scm")
(set! COMMENT-FLAG #t)

(add-var-name "f" "g" (py "nat=>nat"))
(add-var-name "i" "j" "l" (py "nat"))

; "DicksonTwo"
(set-goal (pf "all f,g excl i,j.i<j ! (f j<f i -> bot) ! (g j<g i -> bot)"))
(assume "f" "g")

(by-assume-minimal-wrt (pf "excl n T") "n" (pt "f") "MinH1" "H1")

; Generates two new goals: excl n T (trivial), and the existence of the
; minimal element (a hypothesis) implies our goal
(strip)
(use-with 1 (pt "0") "Truth-Axiom")
(drop "H1") 

; By the minimum principle, applied with
; excl n all m.n<m+1 -> f m<f n -> bot and measure function g,
; we obtain an element i that is a left-minimum of f and also minimal
; w.r.t. g

(by-assume-minimal-wrt
 (pf "excl n. all m.n<m+1 -> f m<f n -> bot") "i" (pt "g") "MinH2" "H2")
(exc-intro (pt "n"))
(assume "i")
(strip)
(use-with "MinH1" (pt "i") 4 "Truth-Axiom")

; By a third application of the minimum principle we choose the next
; left-minimum w.r.t. f

(by-assume-minimal-wrt (pf "excl l. i < l") "j" (pt "f") "MinH3" "H3")

(exc-intro (pt "i+1"))
(use "Truth-Axiom")

; Now we have i and j as desired
(exc-intro (pt "i") (pt "j"))
(use "H3")

(use-with "H2" (pt "j") "?")
(add-global-assumption "nat2" (pf "all n,m.n<m -> n<m+1"))
(use-with "nat2" (pt "i") (pt "j") "H3")

(strip)
(use-with "MinH2" (pt "j") 7 "?")

(strip)
(use-with "MinH3" (pt "m") 9 "?")
(add-global-assumption "nat1" (pf "all n,m,k.n<m -> m<k+1 -> n<k"))
(use-with "nat1" (pt "i") (pt "j") (pt "m") "H3" 8)
(save "DicksonTwo")

(set! UNFOLDING-FLAG #f)
(define dickson
  (np (expand-theorems
       (theorem-name-to-proof "DicksonTwo"))))

(define reduced-dickson (np (reduce-efq-and-stab dickson)))

(mload "../modules/atr.scm")

(define term
  (atr-min-excl-proof-to-structured-extracted-term reduced-dickson))

(define nterm (nt term))
(pp nterm)

; [f0,f1]
;  (Rec nat=>nat=>nat@@nat)([n2]0@0)
;  ([n2,(nat=>nat@@nat)_3,n4]
;    (Rec nat=>nat=>(nat=>nat@@nat)=>nat@@nat)([n5,(nat=>nat@@nat)_6]0@0)
;    ([n5,(nat=>(nat=>nat@@nat)=>nat@@nat)_6,n7,(nat=>nat@@nat)_8]
;      (Rec nat=>nat=>nat@@nat)([n9]0@0)
;      ([n9,(nat=>nat@@nat)_10,n11]
;        [if (f0 n11<f0 n7)
;          ((nat=>nat@@nat)_8 n11)
;          [if (f1 n11<f1 n7)
;           ((nat=>(nat=>nat@@nat)=>nat@@nat)_6 n11(nat=>nat@@nat)_10)
;           (n7@n11)]])
;      (Succ(f0(Succ n7)))
;      (Succ n7))
;    (Succ(f1 n4))
;    n4
;    (nat=>nat@@nat)_3)
;  (Succ(f0 0))
;  0

(define constr-proof
  (atr-min-excl-proof-to-intuit-ex-proof reduced-dickson))
; (cdp constr-proof)

; Test of the extracted term

(set! UNFOLDING-FLAG #t)
(define f (pt "[n][if (n=0) 4 [if (n=1) 3 n]]"))
(define g (pt "[n][if (n<3) 1 0]"))
(term-to-string (nt (make-term-in-app-form
		     (make-term-in-app-form nterm f) g)))

;  "3@4"

;Local Variables:
;mode: scheme
;End:
