# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20211206222446;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"8198296", "Hyuga\,\ Miyazaki",
"812675", "Saku\,\ Nagano",
"81839", "Yamaguchi\,\ Yamaguchi",
"811856", "Noshiro\,\ Akita",
"817457", "Yamatotakada\,\ Nara",
"811756", "Noheji\,\ Aomori",
"81938", "Kitakyushu\,\ Fukuoka",
"817686", "Noto\,\ Ishikawa",
"818660", "Seto\,\ Okayama",
"817675", "Nanao\,\ Ishikawa",
"812673", "Komoro\,\ Nagano",
"812388", "Nagai\,\ Yamagata",
"819743", "Mie\,\ Oita",
"81478", "Sawara\,\ Chiba",
"817673", "Hakui\,\ Ishikawa",
"81488", "Urawa\,\ Saitama",
"81534", "Hamamatsu\,\ Shizuoka",
"81423", "Kokubunji\,\ Tokyo",
"812587", "Nagaoka\,\ Niigata",
"812853", "Oyama\,\ Tochigi",
"811378", "Imakane\,\ Hokkaido",
"811987", "Tono\,\ Iwate",
"818685", "Tsuyama\,\ Okayama",
"811354", "Yoichi\,\ Hokkaido",
"818676", "Kuse\,\ Okayama",
"81426", "Hachioji\,\ Tokyo",
"817904", "Fukusaki\,\ Hyogo",
"812892", "Utsunomiya\,\ Tochigi",
"812564", "Sanjo\,\ Niigata",
"818378", "Shimonoseki\,\ Yamaguchi",
"812855", "Oyama\,\ Tochigi",
"81940", "Munakata\,\ Fukuoka",
"811934", "Kamaishi\,\ Iwate",
"812792", "Shibukawa\,\ Gunma",
"8126172", "Omachi\,\ Nagano",
"814289", "Ome\,\ Tokyo",
"817949", "Kakogawa\,\ Hyogo",
"811549", "Kushiro\,\ Hokkaido",
"818683", "Tsuyama\,\ Okayama",
"818596", "Yonago\,\ Tottori",
"817482", "Yokaichi\,\ Shiga",
"811525", "Abashiri\,\ Hokkaido",
"815582", "Shimoda\,\ Shizuoka",
"812789", "Maebashi\,\ Gunma",
"819575", "Isahaya\,\ Nagasaki",
"812482", "Shirakawa\,\ Fukushima",
"81827", "Iwakuni\,\ Yamaguchi",
"819738", "Kusu\,\ Oita",
"811523", "Shari\,\ Hokkaido",
"81922", "Fukuoka\,\ Fukuoka",
"81276", "Ota\,\ Gunma",
"8112391", "Yubari\,\ Hokkaido",
"81286", "Utsunomiya\,\ Tochigi",
"819542", "Takeo\,\ Saga",
"817996", "Tsuna\,\ Hyogo",
"81273", "Takasaki\,\ Gunma",
"812996", "Itako\,\ Ibaraki",
"819573", "Isahaya\,\ Nagasaki",
"8198299", "Hyuga\,\ Miyazaki",
"81776", "Fukui\,\ Fukui",
"812414", "Yanaizu\,\ Fukushima",
"818362", "Ube\,\ Yamaguchi",
"811952", "Ninohe\,\ Iwate",
"818697", "Bizen\,\ Okayama",
"8198297", "Hyuga\,\ Miyazaki",
"8112394", "Yubari\,\ Hokkaido",
"818879", "Muroto\,\ Kochi",
"81494", "Chichibu\,\ Saitama",
"81728", "Neyagawa\,\ Osaka",
"812552", "Joetsu\,\ Niigata",
"819687", "Tamana\,\ Kumamoto",
"818244", "Miyoshi\,\ Hiroshima",
"815972", "Owase\,\ Mie",
"811362", "Kutchan\,\ Hokkaido",
"818952", "Uwajima\,\ Ehime",
"817239", "Neyagawa\,\ Osaka",
"818298", "Hatsukaichi\,\ Hiroshima",
"819664", "Hitoyoshi\,\ Kumamoto",
"819976", "Naze\,\ Kagoshima",
"812239", "Sendai\,\ Miyagi",
"811332", "Tobetsu\,\ Hokkaido",
"819668", "Minamata\,\ Kumamoto",
"818294", "Hatsukaichi\,\ Hiroshima",
"8198298", "Hyuga\,\ Miyazaki",
"818972", "Niihama\,\ Ehime",
"815995", "Ago\,\ Mie",
"818493", "Onomichi\,\ Hiroshima",
"811452", "Hayakita\,\ Hokkaido",
"812545", "Murakami\,\ Niigata",
"811945", "Kuji\,\ Iwate",
"818943", "Yawatahama\,\ Ehime",
"819956", "Kajiki\,\ Kagoshima",
"81763", "Fukuno\,\ Toyama",
"81266", "Suwa\,\ Nagano",
"812543", "Shibata\,\ Niigata",
"815993", "Toba\,\ Mie",
"815362", "Shinshiro\,\ Aichi",
"811972", "Mizusawa\,\ Iwate",
"818248", "Shobara\,\ Hiroshima",
"812572", "Kashiwazaki\,\ Niigata",
"81766", "Takaoka\,\ Toyama",
"811943", "Iwaizumi\,\ Iwate",
"81263", "Matsumoto\,\ Nagano",
"811647", "Haboro\,\ Hokkaido",
"818945", "Yawatahama\,\ Ehime",
"818797", "Tonosho\,\ Kagawa",
"818514", "Ama\,\ Shimane",
"814703", "Tateyama\,\ Chiba",
"811582", "Monbetsu\,\ Hokkaido",
"814770", "Ichikawa\,\ Chiba",
"819787", "Kunisaki\,\ Oita",
"818679", "Niimi\,\ Okayama",
"81125", "Takikawa\,\ Hokkaido",
"818546", "Kakeya\,\ Shimane",
"819553", "Imari\,\ Saga",
"814705", "Tateyama\,\ Chiba",
"818582", "Kurayoshi\,\ Tottori",
"817496", "Nagahama\,\ Shiga",
"817914", "Aioi\,\ Hyogo",
"819734", "Hita\,\ Oita",
"814286", "Sagamihara\,\ Kanagawa",
"81825", "Hiroshima\,\ Hiroshima",
"817946", "Miki\,\ Hyogo",
"819592", "Oseto\,\ Nagasaki",
"811546", "Kushiro\,\ Hokkaido",
"812914", "Hokota\,\ Ibaraki",
"819555", "Karatsu\,\ Saga",
"812875", "Otawara\,\ Tochigi",
"812786", "Numata\,\ Gunma",
"811235", "Yubari\,\ Hokkaido",
"818263", "Kake\,\ Hiroshima",
"811656", "Bifuka\,\ Hokkaido",
"818374", "Nagato\,\ Yamaguchi",
"818464", "Takehara\,\ Hiroshima",
"814281", "Sagamihara\,\ Kanagawa",
"811938", "Miyako\,\ Iwate",
"811541", "Teshikaga\,\ Hokkaido",
"8188095", "Tosashimizu\,\ Kochi",
"812873", "Otawara\,\ Tochigi",
"811233", "Chitose\,\ Hokkaido",
"811464", "Shizunai\,\ Hokkaido",
"819947", "Shibushi\,\ Kagoshima",
"812742", "Fujioka\,\ Gunma",
"812999", "Itako\,\ Ibaraki",
"818656", "Kasaoka\,\ Okayama",
"811374", "Mori\,\ Hokkaido",
"81468", "Yokosuka\,\ Kanagawa",
"81956", "Sasebo\,\ Nagasaki",
"812384", "Yonezawa\,\ Yamagata",
"812957", "Daigo\,\ Ibaraki",
"8152", "Nagoya\,\ Aichi",
"812653", "Iida\,\ Nagano",
"8125482", "Murakami\,\ Niigata",
"818206", "Yanai\,\ Yamaguchi",
"81834", "Tokuyama\,\ Yamaguchi",
"81561", "Seto\,\ Aichi",
"812692", "Nakano\,\ Nagano",
"819726", "Usuki\,\ Oita",
"812477", "Miharu\,\ Fukushima",
"819826", "Hyuga\,\ Miyazaki",
"812655", "Iida\,\ Nagano",
"818557", "Kawamoto\,\ Shimane",
"817367", "Iwade\,\ Wakayama",
"819979", "Tokunoshima\,\ Kagoshima",
"812236", "Sendai\,\ Miyagi",
"811876", "Omagari\,\ Akita",
"81134", "Otaru\,\ Hokkaido",
"8153965", "Hamamatsu\,\ Shizuoka",
"811238", "Kuriyama\,\ Hokkaido",
"818667", "Ibara\,\ Okayama",
"812878", "Nasukarasuyama\,\ Tochigi",
"811353", "Yoichi\,\ Hokkaido",
"812854", "Oyama\,\ Tochigi",
"811935", "Kamaishi\,\ Iwate",
"812565", "Sanjo\,\ Niigata",
"817905", "Fukusaki\,\ Hyogo",
"811392", "Kikonai\,\ Hokkaido",
"81764", "Toyama\,\ Toyama",
"81987", "Nichinan\,\ Miyazaki",
"818684", "Tsuyama\,\ Okayama",
"81977", "Beppu\,\ Oita",
"811933", "Kamaishi\,\ Iwate",
"81182", "Yokote\,\ Akita",
"817903", "Fukusaki\,\ Hyogo",
"81172", "Hirosaki\,\ Aomori",
"812563", "Sanjo\,\ Niigata",
"81965", "Yatsushiro\,\ Kumamoto",
"817356", "Kushimoto\,\ Wakayama",
"8182942", "Hiroshima\,\ Hiroshima",
"812580", "Tokamachi\,\ Niigata",
"812658", "Ina\,\ Nagano",
"817674", "Hakui\,\ Ishikawa",
"815767", "Gero\,\ Gifu",
"819744", "Mie\,\ Oita",
"8125486", "Tsugawa\,\ Niigata",
"812936", "Mito\,\ Ibaraki",
"819809", "Yaeyama\ District\,\ Okinawa",
"811536", "Akkeshi\,\ Hokkaido",
"815737", "Nakatsugawa\,\ Gifu",
"81779", "Ono\,\ Gifu",
"812674", "Komoro\,\ Nagano",
"818243", "Higashi\-ku\,\ Hiroshima",
"815998", "Ago\,\ Mie",
"819665", "Hitoyoshi\,\ Kumamoto",
"81429", "Tokorozawa\,\ Saitama",
"818245", "Miyoshi\,\ Hiroshima",
"8125487", "Tsugawa\,\ Niigata",
"814757", "Togane\,\ Chiba",
"819967", "Izumi\,\ Kagoshima",
"817732", "Fukuchiyama\,\ Kyoto",
"819663", "Hitoyoshi\,\ Kumamoto",
"818948", "Uwajima\,\ Ehime",
"819937", "Kaseda\,\ Kagoshima",
"817717", "Sonobe\,\ Kyoto",
"812832", "Sano\,\ Tochigi",
"8153971", "Hamamatsu\,\ Shizuoka",
"812415", "Yanaizu\,\ Fukushima",
"8126178", "Omachi\,\ Nagano",
"81545", "Fuji\,\ Shizuoka",
"8165", "Osaka\,\ Osaka",
"81833", "Kudamatsu\,\ Yamaguchi",
"818690", "Okayama\,\ Okayama",
"8125489", "Tsugawa\,\ Niigata",
"812413", "Kitakata\,\ Fukushima",
"819574", "Isahaya\,\ Nagasaki",
"812246", "Ogawara\,\ Miyagi",
"81942", "Kurume\,\ Fukuoka",
"819558", "Karatsu\,\ Saga",
"811524", "Abashiri\,\ Hokkaido",
"819554", "Imari\,\ Saga",
"811528", "Bihoro\,\ Hokkaido",
"817915", "Aioi\,\ Hyogo",
"819735", "Hita\,\ Oita",
"819578", "Shimabara\,\ Nagasaki",
"814704", "Tateyama\,\ Chiba",
"81845", "Innoshima\,\ Hiroshima",
"81547", "Shimada\,\ Shizuoka",
"812913", "Hokota\,\ Ibaraki",
"819733", "Hita\,\ Oita",
"817617", "Kaga\,\ Ishikawa",
"81533", "Toyohashi\,\ Aichi",
"81992", "Kagoshima\,\ Kagoshima",
"818944", "Yawatahama\,\ Ehime",
"814777", "Funabashi\,\ Chiba",
"81798", "Nishinomiya\,\ Hyogo",
"81298", "Tsuchiura\,\ Ibaraki",
"818293", "Hatsukaichi\,\ Hiroshima",
"817969", "Hamasaka\,\ Hyogo",
"8125488", "Tsugawa\,\ Niigata",
"812939", "Mito\,\ Ibaraki",
"811944", "Iwaizumi\,\ Iwate",
"812544", "Shibata\,\ Niigata",
"815994", "Ago\,\ Mie",
"8126179", "Omachi\,\ Nagano",
"819437", "Tanushimaru\,\ Fukuoka",
"818295", "Hatsukaichi\,\ Hiroshima",
"812678", "Saku\,\ Nagano",
"817678", "Nanao\,\ Ishikawa",
"812654", "Iida\,\ Nagano",
"812383", "Yonezawa\,\ Yamagata",
"81862", "Okayama\,\ Okayama",
"8175", "Kyoto\,\ Kyoto",
"8198292", "Nobeoka\,\ Miyazaki",
"815566", "Minobu\,\ Yamanashi",
"819940", "Shibushi\,\ Kagoshima",
"81774", "Uji\,\ Kyoto",
"811867", "Takanosu\,\ Akita",
"817466", "Totsukawa\,\ Nara",
"8199345", "Kagoshima\,\ Kagoshima",
"81162", "Wakkanai\,\ Hokkaido",
"81284", "Ashikaga\,\ Tochigi",
"817707", "Obama\,\ Fukui",
"812376", "Sagae\,\ Yamagata",
"812385", "Yonezawa\,\ Yamagata",
"818463", "Takehara\,\ Hiroshima",
"811375", "Yakumo\,\ Hokkaido",
"81975", "Oita\,\ Oita",
"817950", "Sanda\,\ Hyogo",
"818373", "Nagato\,\ Yamaguchi",
"811465", "Shizunai\,\ Hokkaido",
"8126176", "Omachi\,\ Nagano",
"81985", "Miyazaki\,\ Miyazaki",
"81493", "Higashimatsuyama\,\ Saitama",
"814796", "Yokaichiba\,\ Chiba",
"814220", "Kokubunji\,\ Tokyo",
"818688", "Mimasaka\,\ Okayama",
"8186993", "Bizen\,\ Okayama",
"812858", "Mooka\,\ Tochigi",
"815392", "Hamamatsu\,\ Shizuoka",
"818375", "Mine\,\ Yamaguchi",
"811463", "Urakawa\,\ Hokkaido",
"811234", "Chitose\,\ Hokkaido",
"81582", "Gifu\,\ Gifu",
"81572", "Tajimi\,\ Gifu",
"812874", "Otawara\,\ Tochigi",
"819435", "Yame\,\ Fukuoka",
"81268", "Ueda\,\ Nagano",
"818297", "Hatsukaichi\,\ Hiroshima",
"814700", "Kamogawa\,\ Chiba",
"8153968", "Hamamatsu\,\ Shizuoka",
"81875", "Kan\'onji\,\ Kagawa",
"814775", "Funabashi\,\ Chiba",
"81577", "Takayama\,\ Gifu",
"81885", "Komatsushima\,\ Tokushima",
"811644", "Rumoi\,\ Hokkaido",
"818698", "Bizen\,\ Okayama",
"81587", "Ichinomiya\,\ Aichi",
"811396", "Esashi\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"819433", "Yame\,\ Fukuoka",
"819688", "Tamana\,\ Kumamoto",
"81565", "Toyota\,\ Aichi",
"819784", "Bungotakada\,\ Oita",
"8186691", "Kurashiki\,\ Okayama",
"812615", "Omachi\,\ Nagano",
"817615", "Komatsu\,\ Ishikawa",
"818894", "Susaki\,\ Kochi",
"818490", "Onomichi\,\ Hiroshima",
"817352", "Shingu\,\ Fukuoka",
"818562", "Masuda\,\ Shimane",
"815744", "Minokamo\,\ Gifu",
"812917", "Mito\,\ Ibaraki",
"811532", "Nemuro\,\ Hokkaido",
"812962", "Shimodate\,\ Ibaraki",
"812613", "Omachi\,\ Nagano",
"81167", "Furano\,\ Hokkaido",
"817613", "Komatsu\,\ Ishikawa",
"817962", "Toyooka\,\ Hyogo",
"811562", "Honbetsu\,\ Hokkaido",
"81962", "Kumamoto\,\ Kumamoto",
"812932", "Takahagi\,\ Ibaraki",
"8188098", "Tosashimizu\,\ Kochi",
"819737", "Kusu\,\ Oita",
"815984", "Matsusaka\,\ Mie",
"81958", "Nagasaki\,\ Nagasaki",
"818377", "Shimonoseki\,\ Yamaguchi",
"81466", "Fujisawa\,\ Kanagawa",
"818467", "Mima\,\ Tokushima",
"818806", "Sukumo\,\ Kochi",
"81463", "Hiratsuka\,\ Kanagawa",
"8161", "Osaka\,\ Osaka",
"819944", "Kanoya\,\ Kagoshima",
"81554", "Otsuki\,\ Yamanashi",
"81744", "Yamatotakada\,\ Nara",
"812836", "Sano\,\ Tochigi",
"812588", "Nagaoka\,\ Niigata",
"811377", "Yakumo\,\ Hokkaido",
"81244", "Hobara\,\ Fukushima",
"817736", "Maizuru\,\ Kyoto",
"811865", "Odate\,\ Akita",
"811554", "Obihiro\,\ Hokkaido",
"817954", "Nishiwaki\,\ Hyogo",
"812387", "Nagai\,\ Yamagata",
"817705", "Obama\,\ Fukui",
"81892", "Kumakogen\,\ Ehime",
"818833", "Kamojima\,\ Tokushima",
"811735", "Goshogawara\,\ Aomori",
"818554", "Hamada\,\ Shimane",
"811863", "Kazuno\,\ Akita",
"8198295", "Hyuga\,\ Miyazaki",
"812242", "Shiroishi\,\ Miyagi",
"81252", "Niigata\,\ Niigata",
"81192", "Ofunato\,\ Iwate",
"817703", "Tsuruga\,\ Fukui",
"812474", "Ishikawa\,\ Fukushima",
"818391", "Ogori\,\ Yamaguchi",
"811733", "Goshogawara\,\ Aomori",
"8186553", "Kurashiki\,\ Okayama",
"818835", "Mima\,\ Tokushima",
"81542", "Shizuoka\,\ Shizuoka",
"81486", "Urawa\,\ Saitama",
"817454", "Yamatotakada\,\ Nara",
"812478", "Miharu\,\ Fukushima",
"815765", "Gero\,\ Gifu",
"81476", "Narita\,\ Chiba",
"818558", "Kawamoto\,\ Shimane",
"817368", "Iwade\,\ Wakayama",
"815735", "Ena\,\ Gifu",
"81473", "Ichikawa\,\ Chiba",
"8153966", "Hamamatsu\,\ Shizuoka",
"81936", "Kitakyushu\,\ Fukuoka",
"818680", "Okayama\,\ Okayama",
"81947", "Tagawa\,\ Fukuoka",
"815763", "Gero\,\ Gifu",
"81933", "Kitakyushu\,\ Fukuoka",
"81592", "Tsu\,\ Mie",
"81142", "Date\,\ Hokkaido",
"811558", "Hiroo\,\ Hokkaido",
"815733", "Ena\,\ Gifu",
"811984", "Hanamaki\,\ Iwate",
"811357", "Iwanai\,\ Hokkaido",
"818663", "Soja\,\ Okayama",
"811635", "Hamatonbetsu\,\ Hokkaido",
"819948", "Shibushi\,\ Kagoshima",
"812584", "Nagaoka\,\ Niigata",
"819802", "Minamidaito\,\ Okinawa",
"818665", "Takahashi\,\ Okayama",
"81249", "Koriyama\,\ Fukushima",
"8188096", "Tosashimizu\,\ Kochi",
"811937", "Miyako\,\ Iwate",
"81294", "Hitachiota\,\ Ibaraki",
"81559", "Numazu\,\ Shizuoka",
"818844", "Anan\,\ Tokushima",
"81778", "Takefu\,\ Fukui",
"81288", "Imabari\,\ Ehime",
"818798", "Tonosho\,\ Kagawa",
"8153969", "Hamamatsu\,\ Shizuoka",
"81567", "Tsushima\,\ Aichi",
"812839", "Sano\,\ Tochigi",
"812372", "Murayama\,\ Yamagata",
"819788", "Kunisaki\,\ Oita",
"8188097", "Tosashimizu\,\ Kochi",
"8188099", "Tosashimizu\,\ Kochi",
"81585", "Ibigawa\,\ Gifu",
"814792", "Choshi\,\ Chiba",
"8112393", "Yubari\,\ Hokkaido",
"819684", "Yamaga\,\ Kumamoto",
"81877", "Marugame\,\ Kagawa",
"819965", "Satsumasendai\,\ Kagoshima",
"814755", "Togane\,\ Chiba",
"818247", "Shobara\,\ Hiroshima",
"8153967", "Hamamatsu\,\ Shizuoka",
"8198290", "Nobeoka\,\ Miyazaki",
"817715", "Kameoka\,\ Kyoto",
"819935", "Kaseda\,\ Kagoshima",
"81432", "Chiba\,\ Chiba",
"818694", "Okayama\,\ Okayama",
"819667", "Minamata\,\ Kumamoto",
"81177", "Aomori\,\ Aomori",
"814753", "Mobara\,\ Chiba",
"81726", "Ibaraki\,\ Osaka",
"819963", "Satsumasendai\,\ Kagoshima",
"81226", "Kesennuma\,\ Miyagi",
"818382", "Hagi\,\ Yamaguchi",
"81723", "Sakai\,\ Osaka",
"817713", "Kameoka\,\ Kyoto",
"819933", "Ibusuki\,\ Kagoshima",
"818893", "Sakawa\,\ Kochi",
"811852", "Oga\,\ Akita",
"818290", "Hiroshima\,\ Hiroshima",
"811752", "Mutsu\,\ Aomori",
"817682", "Wajima\,\ Ishikawa",
"81538", "Iwata\,\ Shizuoka",
"815959", "Kameyama\,\ Mie",
"819557", "Karatsu\,\ Saga",
"81484", "Kawaguchi\,\ Saitama",
"815745", "Minokamo\,\ Gifu",
"819783", "Bungotakada\,\ Oita",
"81474", "Funabashi\,\ Chiba",
"8126170", "Omachi\,\ Nagano",
"812551", "Joetsu\,\ Niigata",
"818895", "Susaki\,\ Kochi",
"8145", "Yokohama\,\ Kanagawa",
"817614", "Komatsu\,\ Ishikawa",
"812646", "Nagano\,\ Nagano",
"812614", "Omachi\,\ Nagano",
"81934", "Kitakyushu\,\ Fukuoka",
"815743", "Minokamo\,\ Gifu",
"819785", "Bungotakada\,\ Oita",
"81235", "Tsuruoka\,\ Yamagata",
"814758", "Togane\,\ Chiba",
"819968", "Izumi\,\ Kagoshima",
"81853", "Izumo\,\ Shimane",
"8163", "Osaka\,\ Osaka",
"817725", "Miyazu\,\ Kyoto",
"819938", "Kaseda\,\ Kagoshima",
"818947", "Uwajima\,\ Ehime",
"817718", "Sonobe\,\ Kyoto",
"811645", "Rumoi\,\ Hokkaido",
"811589", "Okoppe\,\ Hokkaido",
"812547", "Murakami\,\ Niigata",
"819233", "Maebaru\,\ Fukuoka",
"819599", "Oseto\,\ Nagasaki",
"815997", "Ago\,\ Mie",
"81793", "Himeji\,\ Hyogo",
"814291", "Hanno\,\ Saitama",
"819434", "Yame\,\ Fukuoka",
"817723", "Miyazu\,\ Kyoto",
"81250", "Niitsu\,\ Niigata",
"812896", "Kanuma\,\ Tochigi",
"812796", "Shibukawa\,\ Gunma",
"811947", "Kuji\,\ Iwate",
"812657", "Ina\,\ Nagano",
"818834", "Kamojima\,\ Tokushima",
"815768", "Gero\,\ Gifu",
"812475", "Ishikawa\,\ Fukushima",
"8125485", "Tsugawa\,\ Niigata",
"812486", "Sukagawa\,\ Fukushima",
"811553", "Obihiro\,\ Hokkaido",
"817475", "Shimonoseki\,\ Yamaguchi",
"817953", "Nishiwaki\,\ Hyogo",
"818592", "Yonago\,\ Tottori",
"815738", "Nakatsugawa\,\ Gifu",
"817486", "Minakuchi\,\ Shiga",
"81925", "Fukuoka\,\ Fukuoka",
"818555", "Gotsu\,\ Shimane",
"815586", "Shimoda\,\ Shizuoka",
"812992", "Ishioka\,\ Ibaraki",
"811734", "Goshogawara\,\ Aomori",
"81591", "Tsu\,\ Mie",
"817704", "Tsuruga\,\ Fukui",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"812473", "Ishikawa\,\ Fukushima",
"817955", "Sanda\,\ Hyogo",
"819679", "Takamori\,\ Kumamoto",
"811555", "Obihiro\,\ Hokkaido",
"811864", "Odate\,\ Akita",
"819546", "Kashima\,\ Saga",
"818553", "Hamada\,\ Shimane",
"817992", "Sumoto\,\ Hyogo",
"812556", "Itoigawa\,\ Niigata",
"811956", "Iwate\,\ Iwate",
"818366", "Ube\,\ Yamaguchi",
"818476", "Fuchu\,\ Hiroshima",
"819945", "Kanoya\,\ Kagoshima",
"815983", "Matsusaka\,\ Mie",
"811237", "Kuriyama\,\ Hokkaido",
"818668", "Ibara\,\ Okayama",
"812877", "Kuroiso\,\ Tochigi",
"811336", "Ishikari\,\ Hokkaido",
"815985", "Matsusaka\,\ Mie",
"819943", "Kanoya\,\ Kagoshima",
"818956", "Uwajima\,\ Ehime",
"8186994", "Seto\,\ Okayama",
"811366", "Suttsu\,\ Hokkaido",
"812583", "Nagaoka\,\ Niigata",
"812857", "Mooka\,\ Tochigi",
"819952", "Okuchi\,\ Kagoshima",
"818976", "Niihama\,\ Ehime",
"818664", "Takahashi\,\ Okayama",
"811983", "Hanamaki\,\ Iwate",
"812585", "Nagaoka\,\ Niigata",
"812576", "Tokamachi\,\ Niigata",
"81729", "Yao\,\ Osaka",
"8126175", "Omachi\,\ Nagano",
"812649", "Nagano\,\ Nagano",
"811634", "Hamatonbetsu\,\ Hokkaido",
"815366", "Shitara\,\ Aichi",
"811976", "Kitakami\,\ Iwate",
"818687", "Mimasaka\,\ Okayama",
"81822", "Hiroshima\,\ Hiroshima",
"811868", "Takanosu\,\ Akita",
"818542", "Yasugi\,\ Shimane",
"811586", "Nakayubetsu\,\ Hokkaido",
"817453", "Yamatotakada\,\ Nara",
"811542", "Kushiro\,\ Hokkaido",
"81191", "Ichinoseki\,\ Iwate",
"814282", "Ome\,\ Tokyo",
"815734", "Ena\,\ Gifu",
"819596", "Fukue\,\ Nagasaki",
"817942", "Kakogawa\,\ Hyogo",
"812677", "Saku\,\ Nagano",
"812560", "Itoigawa\,\ Niigata",
"818586", "Kurayoshi\,\ Tottori",
"817677", "Nanao\,\ Ishikawa",
"817492", "Hikone\,\ Shiga",
"812899", "Kanuma\,\ Tochigi",
"815764", "Gero\,\ Gifu",
"817455", "Yamatotakada\,\ Nara",
"819747", "Taketa\,\ Oita",
"81927", "Fukuoka\,\ Fukuoka",
"812799", "Naganohara\,\ Gunma",
"811652", "Shibetsu\,\ Hokkaido",
"8199347", "Kagoshima\,\ Kagoshima",
"818693", "Oku\,\ Okayama",
"812489", "Sukagawa\,\ Fukushima",
"81464", "Atsugi\,\ Kanagawa",
"819683", "Yamaga\,\ Kumamoto",
"812782", "Numata\,\ Gunma",
"819438", "Tanushimaru\,\ Fukuoka",
"812746", "Tomioka\,\ Gunma",
"818695", "Seto\,\ Okayama",
"817714", "Kameoka\,\ Kyoto",
"81246", "Iwaki\,\ Fukushima",
"81553", "Yamanashi\,\ Yamanashi",
"819934", "Ibusuki\,\ Kagoshima",
"818652", "Kurashiki\,\ Okayama",
"81743", "Nara\,\ Nara",
"819676", "Takamori\,\ Kumamoto",
"814754", "Mobara\,\ Chiba",
"81737", "Yuasa\,\ Wakayama",
"819685", "Tamana\,\ Kumamoto",
"81243", "Nihonmatsu\,\ Fukushima",
"819964", "Satsumasendai\,\ Kagoshima",
"8125480", "Murakami\,\ Niigata",
"812618", "Omachi\,\ Nagano",
"818872", "Muroto\,\ Kochi",
"81489", "Soka\,\ Saitama",
"815752", "Sekigahara\,\ Gifu",
"812559", "Yasuzuka\,\ Niigata",
"812571", "Muika\,\ Niigata",
"818240", "Higashi\-ku\,\ Hiroshima",
"818369", "Ube\,\ Yamaguchi",
"81138", "Hakodate\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"8153973", "Hamamatsu\,\ Shizuoka",
"818202", "Yanai\,\ Yamaguchi",
"817618", "Kaga\,\ Ishikawa",
"818843", "Anan\,\ Tokushima",
"812232", "Iwanuma\,\ Miyagi",
"81939", "Kitakyushu\,\ Fukuoka",
"811527", "Bihoro\,\ Hokkaido",
"819722", "Saiki\,\ Oita",
"812696", "Iiyama\,\ Nagano",
"819822", "Nobeoka\,\ Miyazaki",
"819577", "Shimabara\,\ Nagasaki",
"815979", "Kumano\,\ Mie",
"811588", "Okoppe\,\ Hokkaido",
"812412", "Kitakata\,\ Fukushima",
"812377", "Sagae\,\ Yamagata",
"817706", "Obama\,\ Fukui",
"81549", "Shizuoka\,\ Shizuoka",
"81199", "Morioka\,\ Iwate",
"811736", "Goshogawara\,\ Aomori",
"81594", "Kuwana\,\ Mie",
"819544", "Takeo\,\ Saga",
"811866", "Takanosu\,\ Akita",
"81259", "Sado\,\ Niigata",
"814771", "Ichikawa\,\ Chiba",
"81144", "Tomakomai\,\ Hokkaido",
"81899", "Matsuyama\,\ Ehime",
"812484", "Shirakawa\,\ Fukushima",
"818836", "Mima\,\ Tokushima",
"818588", "Koge\,\ Tottori",
"81460", "Odawara\,\ Kanagawa",
"812780", "Maebashi\,\ Gunma",
"81998", "Kagoshima\,\ Kagoshima",
"815584", "Shimoda\,\ Shizuoka",
"817484", "Yokaichi\,\ Shiga",
"819598", "Fukue\,\ Nagasaki",
"81792", "Himeji\,\ Hyogo",
"818978", "Hakata\,\ Ehime",
"817230", "Neyagawa\,\ Osaka",
"819662", "Hitoyoshi\,\ Kumamoto",
"817733", "Fukuchiyama\,\ Kyoto",
"815958", "Kameyama\,\ Mie",
"81721", "Tondabayashi\,\ Osaka",
"8112395", "Kuriyama\,\ Hokkaido",
"818954", "Uwajima\,\ Ehime",
"811364", "Kutchan\,\ Hokkaido",
"818387", "Tamagawa\,\ Yamaguchi",
"815974", "Owase\,\ Mie",
"812230", "Sendai\,\ Miyagi",
"81425", "Tachikawa\,\ Tokyo",
"81292", "Mito\,\ Ibaraki",
"812833", "Utsunomiya\,\ Tochigi",
"815368", "Shitara\,\ Aichi",
"811978", "Kitakami\,\ Iwate",
"818242", "Higashi\-ku\,\ Hiroshima",
"812554", "Joetsu\,\ Niigata",
"81852", "Matsue\,\ Shimane",
"817735", "Fukuchiyama\,\ Kyoto",
"814797", "Yokaichiba\,\ Chiba",
"818474", "Fuchu\,\ Hiroshima",
"812835", "Sano\,\ Tochigi",
"811954", "Ninohe\,\ Iwate",
"818364", "Ube\,\ Yamaguchi",
"812578", "Muika\,\ Niigata",
"81969", "Amakusa\,\ Kumamoto",
"817616", "Komatsu\,\ Ishikawa",
"8182943", "Hiroshima\,\ Hiroshima",
"812616", "Omachi\,\ Nagano",
"8186697", "Kurashiki\,\ Okayama",
"8168", "Osaka\,\ Osaka",
"81471", "Kashiwa\,\ Chiba",
"812698", "Iiyama\,\ Nagano",
"8167", "Osaka\,\ Osaka",
"81775", "Otsu\,\ Shiga",
"818669", "Soja\,\ Okayama",
"811393", "Matsumae\,\ Hokkaido",
"817940", "Kakogawa\,\ Hyogo",
"814280", "Tachikawa\,\ Tokyo",
"811932", "Kamaishi\,\ Iwate",
"812794", "Shibukawa\,\ Gunma",
"81984", "Kobayashi\,\ Miyazaki",
"812562", "Sanjo\,\ Niigata",
"815769", "Shokawa\,\ Gifu",
"812894", "Utsunomiya\,\ Tochigi",
"817902", "Fukusaki\,\ Hyogo",
"811395", "Esashi\,\ Hokkaido",
"811352", "Yoichi\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"81578", "Kamioka\,\ Akita",
"812748", "Tomioka\,\ Gunma",
"81434", "Chiba\,\ Chiba",
"815393", "Hamamatsu\,\ Shizuoka",
"811372", "Shikabe\,\ Hokkaido",
"81989", "Naha\,\ Okinawa",
"8199331", "Kagoshima\,\ Kagoshima",
"812744", "Fujioka\,\ Gunma",
"819936", "Kaseda\,\ Kagoshima",
"81979", "Nakatsu\,\ Oita",
"811462", "Urakawa\,\ Hokkaido",
"817716", "Sonobe\,\ Kyoto",
"811869", "Odate\,\ Akita",
"81888", "Kochi\,\ Kochi",
"814756", "Togane\,\ Chiba",
"81878", "Takamatsu\,\ Kagawa",
"819966", "Izumi\,\ Kagoshima",
"8166", "Osaka\,\ Osaka",
"815395", "Hamamatsu\,\ Shizuoka",
"81439", "Kisarazu\,\ Chiba",
"812798", "Naganohara\,\ Gunma",
"818462", "Takehara\,\ Hiroshima",
"818372", "Nagato\,\ Yamaguchi",
"812898", "Kanuma\,\ Tochigi",
"81765", "Uozu\,\ Toyama",
"81178", "Hachinohe\,\ Aomori",
"81188", "Akita\,\ Akita",
"8186992", "Bizen\,\ Okayama",
"812247", "Ogawara\,\ Miyagi",
"81277", "Kiryu\,\ Gunma",
"8186698", "Kurashiki\,\ Okayama",
"812694", "Nakano\,\ Nagano",
"81126", "Iwamizawa\,\ Hokkaido",
"8111", "Sapporo\,\ Hokkaido",
"81823", "Kure\,\ Hiroshima",
"8112390", "Yubari\,\ Hokkaido",
"812648", "Nagano\,\ Nagano",
"81568", "Kasugai\,\ Aichi",
"8153964", "Hamamatsu\,\ Shizuoka",
"812382", "Yonezawa\,\ Yamagata",
"8198293", "Nobeoka\,\ Miyazaki",
"818478", "Tojo\,\ Hiroshima",
"81552", "Kofu\,\ Yamanashi",
"811958", "Iwate\,\ Iwate",
"812574", "Kashiwazaki\,\ Niigata",
"81930", "Yukuhashi\,\ Fukuoka",
"818368", "Ube\,\ Yamaguchi",
"81742", "Nara\,\ Nara",
"811974", "Mizusawa\,\ Iwate",
"81242", "Aizuwakamatsu\,\ Fukushima",
"812619", "Omachi\,\ Nagano",
"818958", "Misho\,\ Ehime",
"815978", "Kumano\,\ Mie",
"81480", "Kuki\,\ Saitama",
"81427", "Sagamihara\,\ Kanagawa",
"811454", "Mukawa\,\ Hokkaido",
"818974", "Niihama\,\ Ehime",
"818292", "Hiroshima\,\ Hiroshima",
"818666", "Ibara\,\ Okayama",
"812967", "Kasama\,\ Ibaraki",
"811537", "Nakashibetsu\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"817488", "Minakuchi\,\ Shiga",
"819732", "Hita\,\ Oita",
"817912", "Aioi\,\ Hyogo",
"812488", "Sukagawa\,\ Fukushima",
"812937", "Mito\,\ Ibaraki",
"814298", "Hanno\,\ Saitama",
"81544", "Fujinomiya\,\ Shizuoka",
"818584", "Kurayoshi\,\ Tottori",
"815766", "Gero\,\ Gifu",
"81849", "Fukuyama\,\ Hiroshima",
"8178", "Kobe\,\ Hyogo",
"811584", "Engaru\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"817357", "Kushimoto\,\ Wakayama",
"818512", "Nishigo\,\ Fukushima",
"81948", "Iizuka\,\ Fukuoka",
"818365", "Ube\,\ Yamaguchi",
"818657", "Kasaoka\,\ Okayama",
"811955", "Ninohe\,\ Iwate",
"812834", "Utsunomiya\,\ Tochigi",
"818953", "Uwajima\,\ Ehime",
"819946", "Kanoya\,\ Kagoshima",
"818475", "Fuchu\,\ Hiroshima",
"811363", "Kutchan\,\ Hokkaido",
"815973", "Owase\,\ Mie",
"81551", "Nirasaki\,\ Yamanashi",
"817734", "Fukuchiyama\,\ Kyoto",
"812555", "Itoigawa\,\ Niigata",
"811333", "Tobetsu\,\ Hokkaido",
"811953", "Ninohe\,\ Iwate",
"8186999", "Seto\,\ Okayama",
"818363", "Ube\,\ Yamaguchi",
"811365", "Kutchan\,\ Hokkaido",
"815986", "Matsusaka\,\ Mie",
"818955", "Uwajima\,\ Ehime",
"812787", "Numata\,\ Gunma",
"8147950", "Yokaichiba\,\ Chiba",
"812553", "Joetsu\,\ Niigata",
"817485", "Yokaichi\,\ Shiga",
"811877", "Omagari\,\ Akita",
"8153975", "Hamamatsu\,\ Shizuoka",
"814998", "Ogasawara\,\ Tokyo",
"817476", "Shimonoseki\,\ Yamaguchi",
"811522", "Shari\,\ Hokkaido",
"819543", "Takeo\,\ Saga",
"818556", "Gotsu\,\ Shimane",
"815585", "Shimoda\,\ Shizuoka",
"817366", "Iwade\,\ Wakayama",
"81124", "Ashibetsu\,\ Hokkaido",
"812237", "Sendai\,\ Miyagi",
"819572", "Isahaya\,\ Nagasaki",
"8186997", "Seto\,\ Okayama",
"819827", "Takachiho\,\ Miyazaki",
"812485", "Shirakawa\,\ Fukushima",
"81963", "Kumamoto\,\ Kumamoto",
"819727", "Usuki\,\ Oita",
"812476", "Miharu\,\ Fukushima",
"811556", "Obihiro\,\ Hokkaido",
"817483", "Yokaichi\,\ Shiga",
"817956", "Sanda\,\ Hyogo",
"815583", "Shimoda\,\ Shizuoka",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"812483", "Shirakawa\,\ Fukushima",
"811646", "Haboro\,\ Hokkaido",
"812893", "Utsunomiya\,\ Tochigi",
"812793", "Shibukawa\,\ Gunma",
"818682", "Tsuyama\,\ Okayama",
"8186996", "Seto\,\ Okayama",
"811394", "Matsumae\,\ Hokkaido",
"812895", "Utsunomiya\,\ Tochigi",
"819957", "Kajiki\,\ Kagoshima",
"812795", "Shibukawa\,\ Gunma",
"815398", "Hamamatsu\,\ Shizuoka",
"812852", "Oyama\,\ Tochigi",
"8126173", "Omachi\,\ Nagano",
"81462", "Atsugi\,\ Kanagawa",
"81196", "Morioka\,\ Iwate",
"81537", "Kakegawa\,\ Shizuoka",
"81835", "Hofu\,\ Yamaguchi",
"812672", "Komoro\,\ Nagano",
"814287", "Ome\,\ Tokyo",
"817947", "Miki\,\ Hyogo",
"815746", "Minokamo\,\ Gifu",
"81253", "Niigata\,\ Niigata",
"811547", "Shiranuka\,\ Hokkaido",
"81546", "Shizuoka\,\ Shizuoka",
"819742", "Mie\,\ Oita",
"817672", "Hakui\,\ Ishikawa",
"81543", "Shizuoka\,\ Shizuoka",
"817497", "Nagahama\,\ Shiga",
"818547", "Kakeya\,\ Shimane",
"81896", "Iyomishima\,\ Ehime",
"819786", "Kitsuki\,\ Oita",
"818896", "Susaki\,\ Kochi",
"812589", "Nagaoka\,\ Niigata",
"81893", "Ozu\,\ Ehime",
"818796", "Tonosho\,\ Kagawa",
"812693", "Nakano\,\ Nagano",
"81596", "Ise\,\ Mie",
"8147955", "Yokaichiba\,\ Chiba",
"812997", "Itako\,\ Ibaraki",
"8125483", "Murakami\,\ Niigata",
"81740", "Imazu\,\ Shiga",
"81932", "Kitakyushu\,\ Fukuoka",
"817997", "Tsuna\,\ Hyogo",
"81593", "Yokkaichi\,\ Mie",
"81143", "Muroran\,\ Hokkaido",
"81550", "Gotenba\,\ Shizuoka",
"812695", "Nakano\,\ Nagano",
"81535", "Hamamatsu\,\ Shizuoka",
"812652", "Iida\,\ Nagano",
"81482", "Kawaguchi\,\ Saitama",
"812872", "Otawara\,\ Tochigi",
"818398", "Ogori\,\ Yamaguchi",
"818559", "Kawamoto\,\ Shimane",
"819977", "Setouchi\,\ Kagoshima",
"811232", "Chitose\,\ Hokkaido",
"8144", "Kawasaki\,\ Kanagawa",
"812743", "Fujioka\,\ Gunma",
"815394", "Hamamatsu\,\ Shizuoka",
"811559", "Obihiro\,\ Hokkaido",
"81738", "Gobo\,\ Wakayama",
"819686", "Tamana\,\ Kumamoto",
"817959", "Sanda\,\ Hyogo",
"811398", "Kumaishi\,\ Hokkaido",
"818696", "Bizen\,\ Okayama",
"818262", "Kake\,\ Hiroshima",
"8153970", "Hamamatsu\,\ Shizuoka",
"812745", "Fujioka\,\ Gunma",
"818583", "Kurayoshi\,\ Tottori",
"811585", "Engaru\,\ Hokkaido",
"819593", "Oseto\,\ Nagasaki",
"8186998", "Seto\,\ Okayama",
"811757", "Noheji\,\ Aomori",
"817687", "Noto\,\ Ishikawa",
"814702", "Tateyama\,\ Chiba",
"818585", "Kurayoshi\,\ Tottori",
"811583", "Monbetsu\,\ Hokkaido",
"811857", "Noshiro\,\ Akita",
"817456", "Yamatotakada\,\ Nara",
"81928", "Fukuoka\,\ Fukuoka",
"819552", "Imari\,\ Saga",
"81495", "Honjo\,\ Saitama",
"818975", "Niihama\,\ Ehime",
"81222", "Sendai\,\ Miyagi",
"811973", "Mizusawa\,\ Iwate",
"815363", "Shinshiro\,\ Aichi",
"815992", "Toba\,\ Mie",
"812930", "Mito\,\ Ibaraki",
"81986", "Miyakonojo\,\ Miyazaki",
"812542", "Shibata\,\ Niigata",
"818808", "Tosashimizu\,\ Kochi",
"811455", "Mukawa\,\ Hokkaido",
"811942", "Iwaizumi\,\ Iwate",
"812573", "Kashiwazaki\,\ Niigata",
"81983", "Takanabe\,\ Miyazaki",
"81722", "Sakai\,\ Osaka",
"818973", "Niihama\,\ Ehime",
"817738", "Maizuru\,\ Kyoto",
"811986", "Tono\,\ Iwate",
"811453", "Hayakita\,\ Hokkaido",
"811975", "Mizusawa\,\ Iwate",
"818677", "Niimi\,\ Okayama",
"819789", "Kitsuki\,\ Oita",
"81436", "Ichihara\,\ Chiba",
"812575", "Tokamachi\,\ Niigata",
"812838", "Sano\,\ Tochigi",
"812586", "Nagaoka\,\ Niigata",
"818942", "Yawatahama\,\ Ehime",
"81433", "Chiba\,\ Chiba",
"81280", "Koga\,\ Ibaraki",
"81727", "Ikeda\,\ Osaka",
"81176", "Towada\,\ Aomori",
"81270", "Isesaki\,\ Gunma",
"8112399", "Kuriyama\,\ Hokkaido",
"81183", "Yuzawa\,\ Akita",
"812747", "Tomioka\,\ Gunma",
"8198291", "Nobeoka\,\ Miyazaki",
"81227", "Sendai\,\ Miyagi",
"819975", "Naze\,\ Kagoshima",
"819808", "Yaeyama\ District\,\ Okinawa",
"81886", "Tokushima\,\ Tokushima",
"812659", "Ina\,\ Nagano",
"815982", "Matsusaka\,\ Mie",
"81566", "Kariya\,\ Aichi",
"819576", "Shimabara\,\ Nagasaki",
"812993", "Ishioka\,\ Ibaraki",
"81828", "Hiroshima\,\ Hiroshima",
"812697", "Iiyama\,\ Nagano",
"812472", "Ishikawa\,\ Fukushima",
"81563", "Nishio\,\ Aichi",
"811526", "Abashiri\,\ Hokkaido",
"812879", "Nasukarasuyama\,\ Tochigi",
"818595", "Yonago\,\ Tottori",
"812244", "Shiroishi\,\ Miyagi",
"818552", "Hamada\,\ Shimane",
"817993", "Sumoto\,\ Hyogo",
"81929", "Fukuoka\,\ Fukuoka",
"812995", "Ishioka\,\ Ibaraki",
"8198294", "Nobeoka\,\ Miyazaki",
"817952", "Nishiwaki\,\ Hyogo",
"818593", "Yonago\,\ Tottori",
"811552", "Obihiro\,\ Hokkaido",
"8112397", "Kuriyama\,\ Hokkaido",
"817995", "Sumoto\,\ Hyogo",
"815367", "Shitara\,\ Aichi",
"818675", "Kuse\,\ Okayama",
"819232", "Maebaru\,\ Fukuoka",
"8182920", "Hatsukaichi\,\ Hiroshima",
"811977", "Kitakami\,\ Iwate",
"818686", "Tsuyama\,\ Okayama",
"81465", "Odawara\,\ Kanagawa",
"817722", "Miyazu\,\ Kyoto",
"814798", "Yokaichiba\,\ Chiba",
"81739", "Tanabe\,\ Wakayama",
"812577", "Muika\,\ Niigata",
"818977", "Hakata\,\ Ehime",
"818388", "Tamagawa\,\ Yamaguchi",
"814709", "Kamogawa\,\ Chiba",
"8112396", "Kuriyama\,\ Hokkaido",
"812856", "Mooka\,\ Tochigi",
"819746", "Taketa\,\ Oita",
"812934", "Takahagi\,\ Ibaraki",
"811855", "Noshiro\,\ Akita",
"81946", "Amagi\,\ Fukuoka",
"817676", "Nanao\,\ Ishikawa",
"818587", "Koge\,\ Tottori",
"811564", "Kamishihoro\,\ Hokkaido",
"81937", "Kitakyushu\,\ Fukuoka",
"817685", "Wajima\,\ Ishikawa",
"817964", "Toyooka\,\ Hyogo",
"812676", "Saku\,\ Nagano",
"812964", "Shimodate\,\ Ibaraki",
"812549", "Tsugawa\,\ Niigata",
"811534", "Nakashibetsu\,\ Hokkaido",
"819597", "Fukue\,\ Nagasaki",
"815742", "Minokamo\,\ Gifu",
"815999", "Tsu\,\ Mie",
"818564", "Masuda\,\ Shimane",
"817354", "Shingu\,\ Fukuoka",
"811853", "Oga\,\ Akita",
"811587", "Nakayubetsu\,\ Hokkaido",
"812378", "Sagae\,\ Yamagata",
"818892", "Sakawa\,\ Kochi",
"817683", "Wajima\,\ Ishikawa",
"81487", "Urawa\,\ Saitama",
"811753", "Mutsu\,\ Aomori",
"818949", "Uwajima\,\ Ehime",
"81832", "Shimonoseki\,\ Yamaguchi",
"817468", "Kamikitayama\,\ Nara",
"81420", "Tokorozawa\,\ Saitama",
"819782", "Bungotakada\,\ Oita",
"81485", "Kumagaya\,\ Saitama",
"819547", "Kashima\,\ Saga",
"8153972", "Hamamatsu\,\ Shizuoka",
"812233", "Iwanuma\,\ Miyagi",
"817464", "Yoshino\,\ Nara",
"815755", "Sekigahara\,\ Gifu",
"811873", "Kakunodate\,\ Akita",
"81281", "Utsunomiya\,\ Tochigi",
"812830", "Utsunomiya\,\ Tochigi",
"812374", "Murayama\,\ Yamagata",
"81950", "Hirado\,\ Nagasaki",
"818568", "Tsuwano\,\ Shimane",
"819723", "Saiki\,\ Oita",
"818205", "Yanai\,\ Yamaguchi",
"81532", "Toyohashi\,\ Aichi",
"819823", "Nobeoka\,\ Miyazaki",
"81935", "Kitakyushu\,\ Fukuoka",
"818873", "Aki\,\ Kochi",
"812235", "Sendai\,\ Miyagi",
"812968", "Kasama\,\ Ibaraki",
"815753", "Sekigahara\,\ Gifu",
"817487", "Minakuchi\,\ Shiga",
"811875", "Kakunodate\,\ Akita",
"819725", "Saiki\,\ Oita",
"812487", "Sukagawa\,\ Fukushima",
"812938", "Mito\,\ Ibaraki",
"819825", "Hyuga\,\ Miyazaki",
"812656", "Ina\,\ Nagano",
"814297", "Hanno\,\ Saitama",
"818842", "Anan\,\ Tokushima",
"818203", "Yanai\,\ Yamaguchi",
"817968", "Hamasaka\,\ Hyogo",
"818957", "Misho\,\ Ehime",
"811655", "Nayoro\,\ Hokkaido",
"815977", "Kumano\,\ Mie",
"811367", "Suttsu\,\ Hokkaido",
"818384", "Hagi\,\ Yamaguchi",
"81734", "Wakayama\,\ Wakayama",
"812876", "Kuroiso\,\ Tochigi",
"81234", "Sakata\,\ Yamagata",
"811337", "Ishikari\,\ Hokkaido",
"811236", "Chitose\,\ Hokkaido",
"812785", "Numata\,\ Gunma",
"813", "Tokyo",
"814701", "Kamogawa\,\ Chiba",
"818692", "Oku\,\ Okayama",
"818477", "Tojo\,\ Hiroshima",
"811653", "Shibetsu\,\ Hokkaido",
"811957", "Iwate\,\ Iwate",
"818655", "Kamogata\,\ Okayama",
"81467", "Fujisawa\,\ Kanagawa",
"818367", "Ube\,\ Yamaguchi",
"819682", "Yamaga\,\ Kumamoto",
"814794", "Choshi\,\ Chiba",
"812783", "Numata\,\ Gunma",
"817943", "Kakogawa\,\ Hyogo",
"814283", "Ome\,\ Tokyo",
"81924", "Fukuoka\,\ Fukuoka",
"818689", "Okayama\,\ Okayama",
"81166", "Asahikawa\,\ Hokkaido",
"81260", "Anan\,\ Nagano",
"811543", "Kushiro\,\ Hokkaido",
"818545", "Kisuki\,\ Shimane",
"817493", "Hikone\,\ Shiga",
"812647", "Nagano\,\ Nagano",
"811545", "Kushiro\,\ Hokkaido",
"817945", "Kakogawa\,\ Hyogo",
"814285", "Sagamihara\,\ Kanagawa",
"812248", "Ogawara\,\ Miyagi",
"819556", "Karatsu\,\ Saga",
"818543", "Yasugi\,\ Shimane",
"817495", "Nagahama\,\ Shiga",
"8112398", "Kuriyama\,\ Hokkaido",
"8128798", "Otawara\,\ Tochigi",
"817452", "Yamatotakada\,\ Nara",
"81863", "Tamano\,\ Okayama",
"812859", "Oyama\,\ Tochigi",
"81586", "Ichinomiya\,\ Aichi",
"811946", "Kuji\,\ Iwate",
"812797", "Shibukawa\,\ Gunma",
"819955", "Kajiki\,\ Kagoshima",
"812897", "Kanuma\,\ Tochigi",
"812679", "Saku\,\ Nagano",
"81583", "Gifu\,\ Gifu",
"812546", "Murakami\,\ Niigata",
"819804", "Nago\,\ Okinawa",
"815996", "Ago\,\ Mie",
"812582", "Nagaoka\,\ Niigata",
"819953", "Okuchi\,\ Kagoshima",
"818946", "Uwajima\,\ Ehime",
"81725", "Izumi\,\ Osaka",
"81492", "Kawagoe\,\ Saitama",
"81225", "Ishinomaki\,\ Miyagi",
"8182941", "Hiroshima\,\ Hiroshima",
"811982", "Hanamaki\,\ Iwate",
"8162", "Osaka\,\ Osaka",
"812243", "Shiroishi\,\ Miyagi",
"811862", "Kazuno\,\ Akita",
"817994", "Sumoto\,\ Hyogo",
"8125484", "Murakami\,\ Niigata",
"81949", "Nogata\,\ Fukuoka",
"812416", "Tajima\,\ Fukushima",
"817702", "Tsuruga\,\ Fukui",
"81848", "Onomichi\,\ Hiroshima",
"8153979", "Hamamatsu\,\ Shizuoka",
"811732", "Goshogawara\,\ Aomori",
"812994", "Ishioka\,\ Ibaraki",
"8186552", "Kurashiki\,\ Okayama",
"812245", "Ogawara\,\ Miyagi",
"814288", "Ome\,\ Tokyo",
"818594", "Yonago\,\ Tottori",
"817948", "Miki\,\ Hyogo",
"811548", "Teshikaga\,\ Hokkaido",
"8199343", "Kagoshima\,\ Kagoshima",
"818832", "Kamojima\,\ Tokushima",
"817498", "Nagahama\,\ Shiga",
"81236", "Yamagata\,\ Yamagata",
"81233", "Shinjo\,\ Yamagata",
"819666", "Minamata\,\ Kumamoto",
"81557", "Ito\,\ Shizuoka",
"819974", "Yakushima\,\ Kagoshima",
"8169", "Osaka\,\ Osaka",
"812389", "Yonezawa\,\ Yamagata",
"8125481", "Murakami\,\ Niigata",
"818246", "Miyoshi\,\ Hiroshima",
"8186995", "Seto\,\ Okayama",
"811533", "Nemuro\,\ Hokkaido",
"81923", "Fukuoka\,\ Fukuoka",
"81531", "Tahara\,\ Aichi",
"81569", "Handa\,\ Aichi",
"812963", "Shimodate\,\ Ibaraki",
"812612", "Omachi\,\ Nagano",
"811563", "Honbetsu\,\ Hokkaido",
"81926", "Fukuoka\,\ Fukuoka",
"81272", "Maebashi\,\ Gunma",
"817612", "Komatsu\,\ Ishikawa",
"817963", "Toyooka\,\ Hyogo",
"818565", "Masuda\,\ Shimane",
"812933", "Takahagi\,\ Ibaraki",
"817355", "Shingu\,\ Fukuoka",
"81282", "Tochigi\,\ Tochigi",
"811878", "Omagari\,\ Akita",
"811535", "Akkeshi\,\ Hokkaido",
"8153976", "Hamamatsu\,\ Shizuoka",
"812965", "Shimodate\,\ Ibaraki",
"818299", "Hiroshima\,\ Hiroshima",
"812238", "Sendai\,\ Miyagi",
"817684", "Wajima\,\ Ishikawa",
"811754", "Mutsu\,\ Aomori",
"817965", "Toyooka\,\ Hyogo",
"817238", "Neyagawa\,\ Osaka",
"819828", "Takachiho\,\ Miyazaki",
"812935", "Mito\,\ Ibaraki",
"818563", "Masuda\,\ Shimane",
"817353", "Shingu\,\ Fukuoka",
"811854", "Oga\,\ Akita",
"81864", "Kurashiki\,\ Okayama",
"819728", "Usuki\,\ Oita",
"811936", "Miyako\,\ Iwate",
"81179", "Sannohe\,\ Aomori",
"811658", "Kamikawa\,\ Hokkaido",
"812566", "Sanjo\,\ Niigata",
"819432", "Yame\,\ Fukuoka",
"8183768", "Shimonoseki\,\ Yamaguchi",
"81584", "Ogaki\,\ Gifu",
"812788", "Maebashi\,\ Gunma",
"81438", "Kisarazu\,\ Chiba",
"814772", "Ichikawa\,\ Chiba",
"81988", "Naha\,\ Okinawa",
"818674", "Kuse\,\ Okayama",
"811356", "Iwanai\,\ Hokkaido",
"814240", "Kokubunji\,\ Tokyo",
"81762", "Kanazawa\,\ Ishikawa",
"817737", "Maizuru\,\ Kyoto",
"814795", "Choshi\,\ Chiba",
"819962", "Satsumasendai\,\ Kagoshima",
"814752", "Mobara\,\ Chiba",
"818678", "Niimi\,\ Okayama",
"812419", "Tajima\,\ Fukushima",
"81184", "Yurihonjo\,\ Akita",
"812837", "Sano\,\ Tochigi",
"811376", "Yakumo\,\ Hokkaido",
"818654", "Kamogata\,\ Okayama",
"8112392", "Yubari\,\ Hokkaido",
"819932", "Ibusuki\,\ Kagoshima",
"81262", "Nagano\,\ Nagano",
"811466", "Erimo\,\ Hokkaido",
"817712", "Kameoka\,\ Kyoto",
"818383", "Hagi\,\ Yamaguchi",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81174", "Kanita\,\ Aomori",
"814793", "Choshi\,\ Chiba",
"8147957", "Yokaichiba\,\ Chiba",
"812784", "Numata\,\ Gunma",
"818807", "Sukumo\,\ Kochi",
"818466", "Mima\,\ Tokushima",
"812911", "Hokota\,\ Ibaraki",
"8124197", "Yanaizu\,\ Fukushima",
"818385", "Hagi\,\ Yamaguchi",
"811654", "Nayoro\,\ Hokkaido",
"818376", "Mine\,\ Yamaguchi",
"817688", "Noto\,\ Ishikawa",
"819824", "Nobeoka\,\ Miyazaki",
"812373", "Murayama\,\ Yamagata",
"811858", "Noshiro\,\ Akita",
"819724", "Saiki\,\ Oita",
"811874", "Kakunodate\,\ Akita",
"81564", "Okazaki\,\ Aichi",
"817463", "Yoshino\,\ Nara",
"812234", "Sendai\,\ Miyagi",
"818204", "Yanai\,\ Yamaguchi",
"812386", "Nagai\,\ Yamagata",
"812375", "Murayama\,\ Yamagata",
"812550", "Yasuzuka\,\ Niigata",
"815754", "Sekigahara\,\ Gifu",
"818360", "Ogori\,\ Yamaguchi",
"818249", "Higashi\-ku\,\ Hiroshima",
"817465", "Yoshino\,\ Nara",
"818874", "Aki\,\ Kochi",
"819803", "Nago\,\ Okinawa",
"811397", "Okushiri\,\ Hokkaido",
"812640", "Nagano\,\ Nagano",
"81952", "Saga\,\ Saga",
"811632", "Teshio\,\ Hokkaido",
"81157", "Kitami\,\ Hokkaido",
"81797", "Nishinomiya\,\ Hyogo",
"818397", "Ogori\,\ Yamaguchi",
"819805", "Nago\,\ Okinawa",
"81245", "Fukushima\,\ Fukushima",
"8153978", "Hamamatsu\,\ Shizuoka",
"8126174", "Omachi\,\ Nagano",
"818296", "Hiroshima\,\ Hiroshima",
"818662", "Takahashi\,\ Okayama",
"8164", "Osaka\,\ Osaka",
"819978", "Tokunoshima\,\ Kagoshima",
"81857", "Tottori\,\ Tottori",
"819954", "Kajiki\,\ Kagoshima",
"81555", "Fujiyoshida\,\ Yamanashi",
"811939", "Miyako\,\ Iwate",
"815762", "Gero\,\ Gifu",
"817494", "Hikone\,\ Shiga",
"81944", "Setaka\,\ Fukuoka",
"8183766", "Shimonoseki\,\ Yamaguchi",
"81898", "Imabari\,\ Ehime",
"8126171", "Omachi\,\ Nagano",
"812890", "Utsunomiya\,\ Tochigi",
"815732", "Ena\,\ Gifu",
"817944", "Kakogawa\,\ Hyogo",
"814284", "Tachikawa\,\ Tokyo",
"811544", "Kushiro\,\ Hokkaido",
"812998", "Itako\,\ Ibaraki",
"81548", "Haibara\,\ Shizuoka",
"818544", "Kisuki\,\ Shimane",
"817998", "Tsuna\,\ Hyogo",
"8124196", "Yanaizu\,\ Fukushima",};
$areanames{ja} = {"811528", "美幌",
"814992", "伊豆大島",
"814704", "館山",
"819735", "日田",
"812913", "鉾田",
"818944", "八幡浜",
"818293", "廿日市",
"811944", "岩泉",
"817969", "浜坂",
"819437", "田主丸",
"812544", "新発田",
"815994", "阿児",
"812678", "佐久",
"81862", "岡山",
"8175", "京都",
"812654", "飯田",
"817678", "七尾",
"811867", "鷹巣",
"8199345", "鹿児島",
"817466", "十津川",
"817707", "小浜",
"812385", "米沢",
"81162", "稚内",
"818264", "安芸吉田",
"81985", "宮崎",
"818373", "長門",
"811465", "静内",
"81975", "大分",
"817950", "三田",
"81493", "東松山",
"812878", "烏山",
"811238", "栗山",
"818667", "井原",
"812565", "三条",
"817905", "福崎",
"812854", "小山",
"818684", "津山",
"811392", "木古内",
"81172", "弘前",
"81182", "横手",
"811933", "釜石",
"817356", "串本",
"81965", "八代",
"8182942", "広島",
"812580", "十日町",
"8125486", "津川",
"811566", "十勝清水",
"817966", "八鹿",
"815737", "中津川",
"81779", "大野",
"81429", "所沢",
"819663", "人吉",
"817732", "福知山",
"814757", "東金",
"818245", "三次",
"812832", "佐野",
"819937", "加世田",
"81545", "富士",
"81833", "下松",
"8165", "大阪",
"819574", "諫早",
"812413", "喜多方",
"812246", "大河原",
"819558", "唐津",
"811452", "早来",
"818294", "廿日市",
"818943", "八幡浜",
"819956", "加治木",
"812543", "新発田",
"81266", "諏訪",
"818248", "庄原",
"815993", "鳥羽",
"817727", "峰山",
"81766", "高岡",
"811943", "岩泉",
"811582", "紋別",
"818514", "海士",
"818797", "土庄",
"814703", "館山",
"81125", "滝川",
"814770", "市川",
"818679", "新見",
"819787", "国東",
"817914", "相生",
"817496", "長浜",
"818582", "倉吉",
"819555", "唐津",
"819592", "大瀬戸",
"815747", "美濃白川",
"81825", "広島",
"812914", "鉾田",
"811235", "夕張",
"812875", "大田原",
"814281", "相模原",
"811541", "弟子屈",
"817908", "播磨山崎",
"818263", "加計",
"815987", "三瀬谷",
"812568", "巻",
"818374", "長門",
"819672", "熊本一の宮",
"811374", "森",
"81468", "横須賀",
"819947", "志布志",
"812742", "藤岡",
"812999", "潮来",
"812653", "飯田",
"814227", "武蔵野三鷹",
"8152", "名古屋",
"815756", "郡上八幡",
"81834", "徳山",
"818876", "土佐山田",
"81561", "瀬戸",
"812477", "三春",
"81134", "小樽",
"811876", "大曲",
"812236", "仙台",
"8198296", "日向",
"812675", "佐久",
"817675", "七尾",
"812977", "竜ケ崎",
"81488", "浦和",
"812642", "木曾福島",
"81478", "佐原",
"812388", "長井",
"812853", "小山",
"81426", "八王子",
"818676", "久世",
"811934", "釜石",
"81581", "高富",
"818683", "津山",
"817482", "八日市",
"818596", "米子",
"811525", "網走",
"812482", "白河",
"819738", "玖珠",
"8188090", "窪川",
"81286", "宇都宮",
"817996", "津名",
"81922", "福岡",
"81276", "太田",
"81776", "福井",
"812414", "柳津",
"819573", "諫早",
"812996", "潮来",
"8153960", "天竜",
"818697", "備前",
"81228", "築館",
"818362", "宇部",
"811952", "二戸",
"819687", "玉名",
"812552", "上越",
"818879", "室戸",
"81728", "寝屋川",
"81494", "秩父",
"811362", "倶知安",
"815972", "尾鷲",
"817239", "寝屋川",
"818952", "宇和島",
"819664", "人吉",
"812239", "仙台",
"812583", "長岡",
"811983", "花巻",
"818976", "新居浜",
"815956", "上野",
"811634", "浜頓別",
"812576", "十日町",
"811976", "北上",
"815366", "設楽",
"818542", "安来",
"811868", "鷹巣",
"812975", "水海道",
"817453", "大和高田",
"812677", "佐久",
"811542", "釧路",
"817942", "加古川",
"814282", "青梅",
"819747", "竹田",
"812799", "長野原",
"81927", "福岡",
"817677", "七尾",
"812899", "鹿沼",
"815764", "下呂",
"811652", "士別",
"812782", "沼田",
"815589", "修善寺大仁",
"819438", "田主丸",
"81464", "厚木",
"818652", "倉敷",
"818695", "岡山瀬戸",
"81553", "山梨",
"81246", "いわき",
"817714", "亀岡",
"819964", "川内",
"819685", "玉名",
"818479", "東城",
"818202", "柳井",
"818843", "阿南",
"81138", "函館",
"811527", "美幌",
"81939", "北九州",
"819822", "延岡",
"819722", "佐伯",
"812696", "飯山",
"818290", "広島",
"817682", "輪島",
"811752", "むつ",
"811852", "男鹿",
"81474", "船橋",
"815745", "美濃加茂",
"81484", "川口",
"819557", "唐津",
"815959", "亀山",
"817614", "小松",
"818795", "三本松",
"812579", "小出",
"818895", "須崎",
"812551", "上越",
"819785", "豊後高田",
"812614", "大町",
"817725", "宮津",
"814758", "東金",
"81235", "鶴岡",
"819938", "加世田",
"819233", "前原",
"812796", "渋川",
"81250", "新津",
"811643", "石狩深川",
"812896", "鹿沼",
"8125485", "津川",
"812475", "石川",
"818834", "鴨島",
"815586", "下田",
"811553", "帯広",
"817475", "下市",
"815738", "中津川",
"817953", "西脇",
"814225", "武蔵野三鷹",
"811734", "五所川原",
"81591", "津",
"819546", "鹿島",
"817363", "和歌山橋本",
"818553", "浜田",
"8153962", "天竜",
"818476", "府中",
"8188092", "窪川",
"819945", "鹿屋",
"811336", "石狩",
"812877", "黒磯",
"819972", "種子島",
"811237", "栗山",
"818668", "井原",
"81724", "岸和田貝塚",
"815985", "松阪",
"812478", "三春",
"817454", "大和高田",
"81473", "市川",
"815735", "恵那",
"815763", "下呂",
"814228", "武蔵野三鷹",
"81936", "北九州",
"818680", "岡山",
"81142", "伊達",
"811984", "花巻",
"811357", "岩内",
"812584", "長岡",
"819948", "志布志",
"818665", "高梁",
"81249", "郡山",
"819802", "南大東",
"817907", "播磨山崎",
"812567", "巻",
"815988", "三瀬谷",
"818844", "阿南",
"815748", "美濃白川",
"812372", "村山",
"818798", "土庄",
"815562", "鰍沢青柳",
"819788", "国東",
"8188097", "土佐清水",
"81877", "丸亀",
"818247", "庄原",
"814755", "東金",
"8188099", "土佐清水",
"814792", "銚子",
"81585", "揖斐川",
"817728", "峰山",
"819935", "加世田",
"81432", "千葉",
"819963", "川内",
"81177", "青森",
"81723", "堺",
"817713", "亀岡",
"815396", "浜松",
"819435", "八女",
"814700", "鴨川",
"811644", "留萌",
"818698", "備前",
"819688", "玉名",
"81565", "豊田",
"812613", "大町",
"81167", "富良野",
"811532", "根室",
"812932", "高萩",
"8188098", "土佐清水",
"819737", "玖珠",
"817613", "小松",
"818467", "木江",
"81958", "長崎",
"81463", "平塚",
"818806", "宿毛",
"81554", "大月",
"811554", "帯広",
"812978", "竜ケ崎",
"817954", "西脇",
"811865", "大館",
"818833", "鴨島",
"81892", "久万",
"812387", "長井",
"817705", "小浜",
"81252", "新潟",
"818554", "浜田",
"817364", "和歌山橋本",
"8198295", "日向",
"8186553", "倉敷",
"811733", "五所川原",
"815399", "天竜",
"81192", "大船渡",
"818391", "小郡",
"812693", "中野",
"81596", "伊勢",
"81550", "御殿場",
"81143", "室蘭",
"81535", "浜松",
"818846", "丹生谷",
"81482", "川口",
"818559", "川本",
"811232", "千歳",
"819977", "瀬戸内",
"812872", "大田原",
"818398", "小郡",
"815394", "浜松",
"8144", "川崎",
"811398", "熊石",
"811559", "帯広",
"817959", "三田",
"819675", "熊本一の宮",
"812745", "藤岡",
"811585", "遠軽",
"811857", "能代",
"81928", "福岡",
"817456", "大和高田",
"817687", "能都",
"811757", "野辺地",
"818585", "倉吉",
"819552", "伊万里",
"819595", "有川",
"815363", "新城",
"811973", "水沢",
"811455", "鵡川",
"81986", "都城",
"81222", "仙台",
"817960", "八鹿",
"81722", "堺",
"812573", "柏崎",
"811986", "遠野",
"818973", "新居浜",
"815953", "上野",
"817738", "舞鶴",
"81433", "千葉",
"812586", "長岡",
"812838", "佐野",
"818365", "宇部",
"811955", "二戸",
"818657", "笠岡",
"812555", "糸魚川",
"811333", "当別",
"811365", "倶知安",
"818473", "甲山",
"818955", "宇和島",
"8147950", "八日市場",
"818804", "土佐中村",
"812787", "沼田",
"819543", "武雄",
"818556", "江津",
"817366", "岩出",
"814998", "小笠原",
"817485", "八日市",
"811522", "斜里",
"812485", "白河",
"819727", "臼杵",
"819827", "高千穂",
"815583", "下田",
"811556", "帯広",
"817956", "三田",
"812956", "常陸大宮",
"818207", "久賀",
"812793", "渋川",
"811646", "羽幌",
"812893", "宇都宮",
"8186996", "岡山瀬戸",
"817459", "大和榛原",
"81462", "厚木",
"817947", "三木",
"814287", "青梅",
"81546", "静岡",
"81253", "新潟",
"811547", "白糠",
"812672", "小諸",
"817672", "羽咋",
"819742", "三重",
"818547", "掛合",
"812645", "木曾福島",
"81893", "大洲",
"812589", "長岡",
"811462", "浦河",
"817716", "園部",
"81979", "中津",
"815393", "浜松",
"8153961", "天竜",
"81989", "那覇",
"81878", "高松",
"8188094", "窪川",
"819966", "出水",
"81888", "高知",
"818462", "竹原",
"81188", "秋田",
"81178", "八戸",
"81765", "魚津",
"81126", "岩見沢",
"812694", "中野",
"81220", "迫",
"8188091", "窪川",
"8111", "札幌",
"812382", "米沢",
"812648", "長野",
"811958", "岩手",
"818368", "宇部",
"812574", "柏崎",
"811636", "北見枝幸",
"81552", "甲府",
"812619", "大町",
"811974", "水沢",
"812558", "新井",
"81480", "久喜",
"818958", "御荘",
"815978", "熊野",
"818974", "新居浜",
"815954", "上野",
"811537", "中標津",
"817488", "水口",
"815766", "下呂",
"819732", "日田",
"812937", "水戸",
"812488", "須賀川",
"811736", "五所川原",
"812377", "寒河江",
"811588", "興部",
"81549", "静岡",
"81144", "苫小牧",
"819969", "中甑",
"819544", "武雄",
"81460", "小田原",
"818836", "脇町",
"818588", "郡家",
"819598", "福江",
"815584", "下田",
"817230", "寝屋川",
"819913", "硫黄島",
"81425", "立川",
"8112395", "栗山",
"812230", "仙台",
"817735", "福知山",
"814797", "八日市場",
"818242", "東広島",
"818803", "土佐中村",
"812835", "佐野",
"818474", "府中",
"819204", "郷ノ浦",
"817616", "小松",
"81969", "天草",
"811639", "利尻礼文",
"812616", "大町",
"8182943", "広島",
"81775", "大津",
"819807", "沖縄宮古",
"812562", "三条",
"817902", "福崎",
"812894", "宇都宮",
"815769", "荘川",
"812794", "渋川",
"811352", "余市",
"819678", "矢部",
"811395", "江差",
"812748", "富岡",
"81434", "千葉",
"814776", "船橋",
"814752", "茂原",
"814795", "銚子",
"817737", "舞鶴",
"819932", "指宿",
"8183767", "下関",
"818383", "萩",
"81174", "蟹田",
"811376", "八雲",
"812419", "田島",
"812837", "佐野",
"81184", "本荘",
"8147957", "八日市場",
"818376", "美祢",
"8124197", "柳津",
"811858", "能代",
"817688", "能都",
"817463", "吉野",
"812234", "仙台",
"811874", "角館",
"812375", "村山",
"818874", "安芸",
"815565", "鰍沢青柳",
"815754", "関",
"81952", "佐賀",
"811397", "奥尻",
"818662", "高梁",
"818296", "広島",
"819978", "徳之島",
"819805", "名護",
"81245", "福島",
"818397", "小郡",
"819954", "加治木",
"817494", "彦根",
"811939", "宮古",
"817916", "竜野",
"815732", "恵那",
"81898", "今治",
"812890", "宇都宮",
"81949", "直方",
"812243", "白石",
"818548", "石見大田",
"817994", "洲本",
"811862", "鹿角",
"81848", "尾道",
"812994", "石岡",
"817702", "敦賀",
"812416", "田島",
"817948", "三木",
"818594", "米子",
"814288", "青梅",
"811548", "弟子屈",
"8186552", "倉敷",
"81236", "山形",
"819666", "水俣",
"81557", "伊東",
"8186995", "岡山瀬戸",
"81569", "半田",
"81531", "田原",
"812963", "下館",
"812570", "小出",
"81923", "福岡",
"811563", "本別",
"818208", "久賀",
"817963", "豊岡",
"818299", "広島",
"811535", "厚岸",
"81864", "倉敷",
"818563", "益田",
"817353", "新宮",
"812935", "水戸",
"819728", "臼杵",
"819828", "高千穂",
"811658", "上川",
"811936", "宮古",
"8183768", "下関",
"819432", "八女",
"81438", "木更津",
"812788", "前橋",
"818674", "久世",
"811873", "角館",
"81281", "宇都宮",
"812233", "岩沼",
"817464", "吉野",
"818205", "柳井",
"81950", "平戸",
"811538", "根室標津",
"817487", "水口",
"815753", "関",
"818873", "安芸",
"81935", "北九州",
"819825", "日向",
"812656", "伊那",
"819725", "佐伯",
"812938", "水戸",
"812487", "須賀川",
"811655", "名寄",
"818957", "御荘",
"811367", "寿都",
"818384", "萩",
"815977", "熊野",
"812785", "沼田",
"818655", "鴨方",
"811957", "岩手",
"81467", "藤沢",
"818367", "宇部",
"818692", "邑久",
"818266", "千代田",
"819682", "山鹿",
"812557", "新井",
"818545", "木次",
"81924", "福岡",
"812972", "水海道",
"818689", "岡山",
"812647", "長野",
"817493", "彦根",
"811545", "釧路",
"814285", "相模原",
"817945", "加古川",
"812859", "小山",
"81863", "玉野",
"814706", "大原",
"81586", "一宮",
"811946", "久慈",
"812546", "村上",
"815996", "阿児",
"819953", "大口",
"818946", "宇和",
"8162", "大阪",
"81492", "川越",
"8182941", "広島",
"819677", "矢部",
"8188093", "窪川",
"81727", "池田",
"812747", "富岡",
"81227", "仙台",
"819942", "大根占",
"81183", "湯沢",
"819808", "八重山",
"819975", "名瀬",
"815982", "松阪",
"812659", "伊那",
"812472", "石川",
"81566", "刈谷",
"812993", "石岡",
"819576", "島原",
"812244", "白石",
"817993", "洲本",
"817472", "五条",
"814222", "武蔵野三鷹",
"8153963", "天竜",
"818593", "米子",
"814798", "八日市場",
"817722", "宮津",
"818686", "津山",
"81739", "田辺",
"811457", "門別富川",
"818673", "福渡",
"812856", "真岡",
"8112396", "栗山",
"814709", "鴨川",
"818587", "郡家",
"811564", "上士幌",
"817964", "豊岡",
"817685", "輪島",
"81946", "甘木",
"811855", "能代",
"812549", "津川",
"815999", "津",
"819597", "福江",
"815742", "美濃加茂",
"812964", "下館",
"81487", "浦和",
"818949", "宇和",
"818792", "三本松",
"812378", "寒河江",
"818564", "益田",
"817354", "新宮",
"811587", "中湧別",
"818892", "佐川",
"819782", "豊後高田",
"81832", "下関",
"8126177", "長野",
"819554", "伊万里",
"819578", "島原",
"817915", "相生",
"81845", "因島",
"812617", "大町",
"81547", "島田",
"81533", "豊橋",
"817617", "加賀",
"81992", "鹿児島",
"819733", "日田",
"814777", "船橋",
"81424", "武蔵野三鷹",
"81798", "西宮",
"81298", "土浦",
"812939", "水戸",
"8125488", "津川",
"818295", "廿日市",
"811539", "根室標津",
"819806", "沖縄宮古",
"812383", "米沢",
"818837", "阿波池田",
"819940", "志布志",
"81774", "宇治",
"8198292", "延岡",
"815566", "身延",
"812376", "寒河江",
"81284", "足利",
"811737", "鰺ケ沢",
"811375", "八雲",
"818463", "竹原",
"814220", "国分寺",
"818688", "美作",
"814796", "八日市場",
"811463", "浦河",
"818375", "美祢",
"815392", "浜松",
"812858", "真岡",
"8186993", "備前",
"812874", "大田原",
"81572", "多治見",
"811234", "千歳",
"81582", "岐阜",
"811353", "余市",
"811935", "釜石",
"81977", "別府",
"81764", "富山",
"81987", "日南",
"818268", "千代田",
"817903", "福崎",
"811637", "北見枝幸",
"812563", "三条",
"819744", "三重",
"812936", "水戸",
"817674", "羽咋",
"812658", "伊那",
"815767", "下呂",
"812674", "小諸",
"81562", "尾張横須賀",
"811536", "厚岸",
"819809", "八重山",
"819665", "人吉",
"818802", "窪川",
"815998", "阿児",
"818243", "東広島",
"819912", "中之島",
"8125487", "津川",
"819967", "出水",
"817717", "園部",
"818948", "宇和",
"8153974", "天竜",
"812415", "柳津",
"818690", "岡山",
"8125489", "津川",
"814708", "大原",
"811524", "網走",
"81942", "久留米",
"818493", "尾道",
"815995", "阿児",
"812545", "村上",
"8198298", "日向",
"815952", "上野",
"819668", "水俣",
"818972", "新居浜",
"811945", "久慈",
"811972", "水沢",
"815362", "新城",
"81763", "福野",
"818945", "八幡浜",
"811647", "羽幌",
"81263", "松本",
"812572", "柏崎",
"812418", "会津山口",
"819553", "伊万里",
"818546", "掛合",
"819734", "日田",
"814705", "館山",
"817946", "三木",
"814286", "相模原",
"811546", "釧路",
"812786", "沼田",
"811938", "宮古",
"818464", "竹原",
"8188095", "土佐清水",
"811656", "美深",
"811233", "千歳",
"812873", "大田原",
"81956", "佐世保",
"818656", "笠岡",
"811464", "静内",
"818265", "安芸吉田",
"8125482", "村上",
"818206", "柳井",
"812384", "米沢",
"812957", "大子",
"811557", "十勝池田",
"817957", "丹波柏原",
"819826", "日向",
"812655", "飯田",
"819726", "臼杵",
"812692", "中野",
"817367", "岩出",
"818557", "川本",
"819979", "徳之島",
"81839", "山口",
"817686", "能都",
"811756", "野辺地",
"81938", "北九州",
"818660", "岡山瀬戸",
"811856", "能代",
"817457", "大和高田",
"812673", "小諸",
"817673", "羽咋",
"81534", "浜松",
"819743", "三重",
"81423", "国分寺",
"811378", "今金",
"812587", "長岡",
"818549", "石見大田",
"818685", "津山",
"811987", "遠野",
"811354", "余市",
"812855", "小山",
"81940", "宗像",
"812792", "渋川",
"812892", "宇都宮",
"817904", "福崎",
"818378", "下関",
"812564", "三条",
"817949", "加古川",
"814289", "青梅",
"811549", "釧路",
"815582", "下田",
"812789", "前橋",
"81827", "岩国",
"819575", "諫早",
"818847", "牟岐",
"819542", "武雄",
"8112391", "夕張",
"811523", "斜里",
"8198299", "日向",
"81273", "高崎",
"8198297", "日向",
"818472", "甲山",
"818244", "三次",
"8112394", "夕張",
"811332", "当別",
"818298", "廿日市",
"819976", "名瀬",
"819952", "大口",
"812857", "真岡",
"811456", "門別富川",
"818664", "高梁",
"812649", "長野",
"812585", "長岡",
"81729", "八尾",
"818687", "美作",
"81229", "古川",
"81822", "広島",
"811586", "中湧別",
"811738", "鰺ケ沢",
"812560", "糸魚川",
"81191", "一関",
"819596", "福江",
"815734", "恵那",
"812973", "水海道",
"817455", "大和高田",
"817492", "彦根",
"818838", "阿波池田",
"818586", "倉吉",
"812489", "須賀川",
"818693", "邑久",
"8199347", "鹿児島",
"819683", "山鹿",
"81743", "奈良",
"812746", "富岡",
"819934", "指宿",
"8125480", "村上",
"81737", "湯浅",
"819676", "高森",
"814754", "茂原",
"81243", "二本松",
"81489", "草加",
"815752", "関",
"812571", "六日町",
"812559", "安塚",
"812618", "大町",
"818872", "室戸",
"817618", "加賀",
"818369", "宇部",
"818240", "東広島",
"812232", "岩沼",
"818845", "丹生谷",
"815979", "熊野",
"819577", "島原",
"818793", "三本松",
"814707", "大原",
"818893", "佐川",
"819783", "豊後高田",
"81538", "磐田",
"8145", "横浜",
"812646", "長野",
"815743", "美濃加茂",
"81934", "北九州",
"8163", "大阪",
"81853", "出雲",
"818672", "福渡",
"819968", "出水",
"811589", "興部",
"817718", "園部",
"811645", "留萌",
"818947", "宇和",
"814291", "飯能",
"819434", "八女",
"817723", "宮津",
"812547", "村上",
"815997", "阿児",
"819599", "大瀬戸",
"81793", "姫路",
"811947", "久慈",
"814223", "武蔵野三鷹",
"812486", "須賀川",
"812657", "伊那",
"815768", "下呂",
"817365", "和歌山橋本",
"818555", "江津",
"81925", "福岡",
"817486", "水口",
"818592", "米子",
"812955", "常陸大宮",
"817704", "敦賀",
"812473", "石川",
"812992", "石岡",
"811864", "大館",
"817992", "洲本",
"817955", "三田",
"819679", "高森",
"811555", "帯広",
"817473", "五条",
"812556", "糸魚川",
"818267", "千代田",
"811638", "利尻礼文",
"815983", "松阪",
"811956", "岩手",
"818366", "宇部",
"818956", "宇和島",
"819943", "鹿屋",
"811366", "寿都",
"8186994", "岡山瀬戸",
"81476", "成田",
"815765", "下呂",
"81486", "浦和",
"814996", "八丈島",
"818558", "川本",
"817368", "岩出",
"81947", "田川",
"811558", "広尾",
"815733", "恵那",
"817958", "丹波柏原",
"812974", "水海道",
"81933", "北九州",
"81592", "津",
"818663", "総社",
"811635", "浜頓別",
"811937", "宮古",
"81294", "常陸太田",
"8188096", "土佐清水",
"81559", "沼津",
"81778", "武生",
"81288", "今市",
"81567", "津島",
"812417", "会津山口",
"812839", "佐野",
"819965", "川内",
"8112393", "夕張",
"819684", "山鹿",
"811648", "焼尻",
"817715", "亀岡",
"818694", "岡山",
"8198290", "延岡",
"814753", "茂原",
"81726", "茨木",
"819667", "水俣",
"818382", "萩",
"819933", "指宿",
"81226", "気仙沼",
"81268", "上田",
"818297", "廿日市",
"81885", "小松島",
"81587", "一宮",
"81875", "観音寺",
"814775", "船橋",
"81577", "高山",
"817724", "宮津",
"819433", "八女",
"811396", "江差",
"8186691", "倉敷",
"812615", "大町",
"819784", "豊後高田",
"818490", "尾道",
"818894", "須崎",
"817352", "新宮",
"818562", "益田",
"818794", "三本松",
"817615", "小松",
"812962", "下館",
"815744", "美濃加茂",
"812917", "水戸",
"81962", "熊本",
"817917", "竜野",
"817962", "豊岡",
"811562", "本別",
"818848", "牟岐",
"818377", "下関",
"81466", "藤沢",
"815984", "松阪",
"8161", "大阪",
"81744", "大和高田",
"811377", "八雲",
"812588", "長岡",
"812836", "佐野",
"819944", "鹿屋",
"817736", "舞鶴",
"81244", "原町",
"811735", "五所川原",
"814224", "武蔵野三鷹",
"817474", "五条",
"811863", "鹿角",
"812242", "白石",
"818835", "脇町",
"81542", "静岡",
"817703", "敦賀",
"817458", "大和榛原",
"812474", "石川",
"81240", "磐城富岡",
"819949", "大根占",
"8147955", "八日市場",
"812997", "潮来",
"81932", "北九州",
"8125483", "村上",
"81740", "今津",
"81593", "四日市",
"817997", "津名",
"812652", "飯田",
"812695", "中野",
"818597", "根雨",
"819673", "熊本一の宮",
"812743", "藤岡",
"819686", "玉名",
"81738", "御坊",
"814229", "武蔵野三鷹",
"818696", "備前",
"818262", "加計",
"818583", "倉吉",
"8186998", "岡山瀬戸",
"812976", "竜ケ崎",
"819593", "大瀬戸",
"811583", "紋別",
"814702", "館山",
"814994", "三宅",
"815992", "鳥羽",
"818808", "土佐清水",
"812542", "新発田",
"812930", "水戸",
"815955", "上野",
"81495", "本庄",
"818975", "新居浜",
"81983", "高鍋",
"811942", "岩泉",
"811453", "早来",
"819789", "杵築",
"81436", "市原",
"818677", "新見",
"811975", "水沢",
"818942", "八幡浜",
"812575", "十日町",
"819946", "鹿屋",
"818953", "宇和島",
"815973", "尾鷲",
"818475", "府中",
"811363", "倶知安",
"812834", "宇都宮",
"817734", "福知山",
"81551", "韮崎",
"815986", "松阪",
"811953", "二戸",
"8186999", "岡山瀬戸",
"818363", "宇部",
"812553", "上越",
"815585", "下田",
"812237", "仙台",
"81124", "芦別",
"811877", "大曲",
"817476", "下市",
"81963", "熊本",
"812476", "三春",
"819572", "諫早",
"8186997", "岡山瀬戸",
"818877", "嶺北",
"815757", "郡上八幡",
"817483", "八日市",
"814226", "武蔵野三鷹",
"812483", "白河",
"811551", "十勝池田",
"811394", "松前",
"817726", "峰山",
"818682", "津山",
"812979", "竜ケ崎",
"815398", "浜松",
"812795", "渋川",
"812852", "小山",
"812895", "宇都宮",
"819957", "加治木",
"815746", "美濃加茂",
"81537", "掛川",
"81196", "盛岡",
"81835", "防府",
"812643", "木曾福島",
"81543", "静岡",
"817497", "長浜",
"81896", "伊予三島",
"819786", "杵築",
"818796", "土庄",
"819205", "厳原",
"818896", "須崎",
"812744", "藤岡",
"8199331", "鹿児島",
"819936", "加世田",
"811372", "鹿部",
"814756", "東金",
"819674", "熊本一の宮",
"811869", "大館",
"818372", "長門",
"812898", "鹿沼",
"8166", "大阪",
"81439", "木更津",
"812798", "長野原",
"815395", "浜松",
"8186992", "備前",
"812247", "大河原",
"81277", "桐生",
"81964", "松橋",
"8186698", "倉敷",
"81823", "呉",
"8112390", "夕張",
"81568", "春日井",
"8198293", "延岡",
"819208", "対馬佐賀",
"81742", "奈良",
"81930", "行橋",
"818478", "東城",
"81242", "会津若松",
"818666", "井原",
"818292", "広島",
"811454", "鵡川",
"81427", "相模原",
"815736", "中津川",
"819594", "有川",
"815588", "修善寺大仁",
"812967", "笠間",
"818584", "倉吉",
"811567", "十勝清水",
"81544", "富士宮",
"814298", "飯能",
"817967", "八鹿",
"817912", "相生",
"81849", "福山",
"8178", "神戸",
"818512", "西郷",
"81948", "飯塚",
"811584", "遠軽",
"818567", "津和野",
"817357", "串本",
"81199", "盛岡",
"817706", "小浜",
"812412", "喜多方",
"814771", "市川",
"81594", "桑名",
"811866", "鷹巣",
"81259", "佐渡",
"812780", "前橋",
"81899", "松山",
"812484", "白河",
"817484", "八日市",
"81998", "鹿児島",
"818978", "伯方",
"815958", "亀山",
"817733", "福知山",
"81721", "富田林",
"819662", "人吉",
"818805", "土佐中村",
"81792", "姫路",
"812833", "宇都宮",
"81292", "水戸",
"818954", "宇和島",
"815974", "尾鷲",
"811364", "倶知安",
"818387", "田万川",
"81852", "松江",
"811978", "北上",
"815368", "設楽",
"812554", "上越",
"811954", "二戸",
"812578", "六日町",
"818364", "宇部",
"812644", "木曾福島",
"8186697", "倉敷",
"81471", "柏",
"812698", "飯山",
"8167", "大阪",
"8168", "大阪",
"818669", "総社",
"811393", "松前",
"81984", "小林",
"814280", "立川",
"817940", "加古川",
"811932", "釜石",
"81578", "神岡",
"819962", "川内",
"818678", "新見",
"81762", "金沢",
"811466", "えりも",
"817712", "亀岡",
"81262", "長野",
"818654", "鴨方",
"8112392", "夕張",
"818807", "宿毛",
"814793", "銚子",
"812784", "沼田",
"818385", "萩",
"811654", "名寄",
"818466", "木江",
"812911", "鉾田",
"812373", "村山",
"819724", "佐伯",
"819824", "延岡",
"815563", "鰍沢青柳",
"81564", "岡崎",
"812386", "長井",
"812550", "安塚",
"818204", "柳井",
"817465", "吉野",
"818249", "東広島",
"818360", "小郡",
"812640", "長野",
"819803", "名護",
"81157", "北見",
"81797", "西宮",
"811632", "天塩",
"8164", "大阪",
"81857", "鳥取",
"81555", "吉田",
"815762", "下呂",
"812569", "巻",
"814284", "立川",
"818598", "根雨",
"817944", "加古川",
"811544", "釧路",
"8183766", "下関",
"81944", "瀬高",
"812998", "潮来",
"8124196", "柳津",
"817998", "津名",
"818544", "木次",
"81548", "榛原",
"8125484", "村上",
"811732", "五所川原",
"812245", "大河原",
"817498", "長浜",
"818832", "鴨島",
"8199343", "鹿児島",
"815397", "浜松",
"819974", "屋久島",
"81233", "新庄",
"8153977", "天竜",
"812389", "米沢",
"8169", "大阪",
"818246", "三次",
"8125481", "村上",
"818878", "嶺北",
"812612", "大町",
"811533", "根室",
"815758", "郡上八幡",
"81282", "栃木",
"818565", "益田",
"812933", "高萩",
"817355", "新宮",
"817612", "小松",
"81926", "福岡",
"81272", "前橋",
"812965", "下館",
"812238", "仙台",
"811878", "大曲",
"811854", "男鹿",
"811754", "むつ",
"817965", "豊岡",
"817684", "輪島",
"817238", "寝屋川",
"817906", "播磨山崎",
"812566", "三条",
"81179", "三戸",
"81584", "大垣",
"814772", "市川",
"814240", "国分寺",
"811356", "岩内",
"81988", "那覇",
"815755", "関",
"812830", "宇都宮",
"815564", "鰍沢青柳",
"81485", "熊谷",
"819547", "鹿島",
"818875", "土佐山田",
"81532", "豊橋",
"819823", "延岡",
"818568", "津和野",
"812374", "村山",
"819723", "佐伯",
"811875", "角館",
"812235", "仙台",
"815587", "修善寺大仁",
"812968", "笠間",
"818842", "阿南",
"814297", "飯能",
"818203", "柳井",
"817968", "浜坂",
"81734", "和歌山",
"813", "東京",
"811236", "千歳",
"814701", "鴨川",
"81234", "酒田",
"811337", "石狩",
"812876", "黒磯",
"818477", "東城",
"811653", "士別",
"814794", "銚子",
"812783", "沼田",
"814283", "青梅",
"817943", "加古川",
"811543", "釧路",
"81260", "阿南町",
"81166", "旭川",
"812248", "大河原",
"819556", "唐津",
"818543", "安来",
"817452", "大和高田",
"8128798", "大田原",
"817495", "長浜",
"8112398", "栗山",
"819955", "加治木",
"812897", "鹿沼",
"812797", "渋川",
"819804", "名護",
"812679", "佐久",
"81583", "岐阜",
"81725", "和泉",
"812582", "長岡",
"811982", "花巻",
"81225", "石巻",
"81270", "伊勢崎",
"81176", "十和田",
"8112399", "栗山",
"81280", "古河",
"819973", "種子島",
"8198291", "延岡",
"81886", "徳島",
"81828", "広島",
"812697", "飯山",
"81929", "福岡",
"817362", "和歌山橋本",
"818552", "浜田",
"811526", "網走",
"81563", "西尾",
"818595", "米子",
"812879", "烏山",
"812995", "石岡",
"8198294", "延岡",
"8112397", "栗山",
"817995", "洲本",
"817952", "西脇",
"811552", "帯広",
"8182920", "廿日市",
"819232", "前原",
"811977", "北上",
"815367", "設楽",
"818675", "久世",
"81465", "小田原",
"812577", "六日町",
"811642", "石狩深川",
"818977", "伯方",
"815957", "上野",
"818388", "田万川",
"81937", "北九州",
"817676", "七尾",
"819746", "竹田",
"812934", "高萩",
"811534", "中標津",
"812676", "佐久",
"811753", "むつ",
"817683", "輪島",
"811853", "男鹿",
"81420", "所沢",
"817468", "上北山",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;