#include "BaseTest.h"
#include <time.h>
BaseTest::BaseTest()
{
	currentTestName=NULL;
	currentStatus=0;
	startTime=0;
}

BaseTest::~BaseTest()
{
}


	/** A test method needs to inform that his test is beggining. This is because we not using any reflection here */
void BaseTest::startTest(char * testName)
{
	currentTestName = testName;
	currentStatus=0;
	startTime = time(&startTime);
	printf ("Test \"%s\" is starting\n",currentTestName);
}

	/** A test method needs to inform that his test finished  */
void BaseTest::stopTest()
{
	time_t finishTime;
	finishTime = time(&finishTime);
	time_t difference = finishTime - startTime;
	if (currentStatus)
	{
		printf ("Test \"%s\" failed with status %d, executed in %ld seconds\n",currentTestName,currentStatus, difference);
	} else
	{
		printf ("Test \"%s\" finished without any errors, executed in %ld seconds\n",currentTestName, difference);
	}
	
}

short BaseTest::assert(short clause, char * message)
{
	if (clause)
	{
		printf ("Test %s failure = %s\n",currentTestName,message);
	}
	currentStatus=clause;
	return currentStatus;
}

void BaseTest::fail(char * failMessage)
{
	printf ("%s failed because of %s\n",currentTestName,failMessage);
}
