/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _GUESTFS_PROTOCOL_H_RPCGEN
#define _GUESTFS_PROTOCOL_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#include <config.h>

typedef char *guestfs_str;

struct guestfs_int_int_bool {
	int i;
	int b;
};
typedef struct guestfs_int_int_bool guestfs_int_int_bool;

typedef struct {
	u_int guestfs_int_int_bool_list_len;
	guestfs_int_int_bool *guestfs_int_int_bool_list_val;
} guestfs_int_int_bool_list;

struct guestfs_int_lvm_pv {
	char *pv_name;
	char pv_uuid[32];
	char *pv_fmt;
	int64_t pv_size;
	int64_t dev_size;
	int64_t pv_free;
	int64_t pv_used;
	char *pv_attr;
	int64_t pv_pe_count;
	int64_t pv_pe_alloc_count;
	char *pv_tags;
	int64_t pe_start;
	int64_t pv_mda_count;
	int64_t pv_mda_free;
};
typedef struct guestfs_int_lvm_pv guestfs_int_lvm_pv;

typedef struct {
	u_int guestfs_int_lvm_pv_list_len;
	guestfs_int_lvm_pv *guestfs_int_lvm_pv_list_val;
} guestfs_int_lvm_pv_list;

struct guestfs_int_lvm_vg {
	char *vg_name;
	char vg_uuid[32];
	char *vg_fmt;
	char *vg_attr;
	int64_t vg_size;
	int64_t vg_free;
	char *vg_sysid;
	int64_t vg_extent_size;
	int64_t vg_extent_count;
	int64_t vg_free_count;
	int64_t max_lv;
	int64_t max_pv;
	int64_t pv_count;
	int64_t lv_count;
	int64_t snap_count;
	int64_t vg_seqno;
	char *vg_tags;
	int64_t vg_mda_count;
	int64_t vg_mda_free;
};
typedef struct guestfs_int_lvm_vg guestfs_int_lvm_vg;

typedef struct {
	u_int guestfs_int_lvm_vg_list_len;
	guestfs_int_lvm_vg *guestfs_int_lvm_vg_list_val;
} guestfs_int_lvm_vg_list;

struct guestfs_int_lvm_lv {
	char *lv_name;
	char lv_uuid[32];
	char *lv_attr;
	int64_t lv_major;
	int64_t lv_minor;
	int64_t lv_kernel_major;
	int64_t lv_kernel_minor;
	int64_t lv_size;
	int64_t seg_count;
	char *origin;
	float snap_percent;
	float copy_percent;
	char *move_pv;
	char *lv_tags;
	char *mirror_log;
	char *modules;
};
typedef struct guestfs_int_lvm_lv guestfs_int_lvm_lv;

typedef struct {
	u_int guestfs_int_lvm_lv_list_len;
	guestfs_int_lvm_lv *guestfs_int_lvm_lv_list_val;
} guestfs_int_lvm_lv_list;

struct guestfs_int_stat {
	int64_t dev;
	int64_t ino;
	int64_t mode;
	int64_t nlink;
	int64_t uid;
	int64_t gid;
	int64_t rdev;
	int64_t size;
	int64_t blksize;
	int64_t blocks;
	int64_t atime;
	int64_t mtime;
	int64_t ctime;
};
typedef struct guestfs_int_stat guestfs_int_stat;

typedef struct {
	u_int guestfs_int_stat_list_len;
	guestfs_int_stat *guestfs_int_stat_list_val;
} guestfs_int_stat_list;

struct guestfs_int_statns {
	int64_t st_dev;
	int64_t st_ino;
	int64_t st_mode;
	int64_t st_nlink;
	int64_t st_uid;
	int64_t st_gid;
	int64_t st_rdev;
	int64_t st_size;
	int64_t st_blksize;
	int64_t st_blocks;
	int64_t st_atime_sec;
	int64_t st_atime_nsec;
	int64_t st_mtime_sec;
	int64_t st_mtime_nsec;
	int64_t st_ctime_sec;
	int64_t st_ctime_nsec;
	int64_t st_spare1;
	int64_t st_spare2;
	int64_t st_spare3;
	int64_t st_spare4;
	int64_t st_spare5;
	int64_t st_spare6;
};
typedef struct guestfs_int_statns guestfs_int_statns;

typedef struct {
	u_int guestfs_int_statns_list_len;
	guestfs_int_statns *guestfs_int_statns_list_val;
} guestfs_int_statns_list;

struct guestfs_int_statvfs {
	int64_t bsize;
	int64_t frsize;
	int64_t blocks;
	int64_t bfree;
	int64_t bavail;
	int64_t files;
	int64_t ffree;
	int64_t favail;
	int64_t fsid;
	int64_t flag;
	int64_t namemax;
};
typedef struct guestfs_int_statvfs guestfs_int_statvfs;

typedef struct {
	u_int guestfs_int_statvfs_list_len;
	guestfs_int_statvfs *guestfs_int_statvfs_list_val;
} guestfs_int_statvfs_list;

struct guestfs_int_dirent {
	int64_t ino;
	char ftyp;
	char *name;
};
typedef struct guestfs_int_dirent guestfs_int_dirent;

typedef struct {
	u_int guestfs_int_dirent_list_len;
	guestfs_int_dirent *guestfs_int_dirent_list_val;
} guestfs_int_dirent_list;

struct guestfs_int_version {
	int64_t major;
	int64_t minor;
	int64_t release;
	char *extra;
};
typedef struct guestfs_int_version guestfs_int_version;

typedef struct {
	u_int guestfs_int_version_list_len;
	guestfs_int_version *guestfs_int_version_list_val;
} guestfs_int_version_list;

struct guestfs_int_xattr {
	char *attrname;
	struct {
		u_int attrval_len;
		char *attrval_val;
	} attrval;
};
typedef struct guestfs_int_xattr guestfs_int_xattr;

typedef struct {
	u_int guestfs_int_xattr_list_len;
	guestfs_int_xattr *guestfs_int_xattr_list_val;
} guestfs_int_xattr_list;

struct guestfs_int_inotify_event {
	int64_t in_wd;
	u_int in_mask;
	u_int in_cookie;
	char *in_name;
};
typedef struct guestfs_int_inotify_event guestfs_int_inotify_event;

typedef struct {
	u_int guestfs_int_inotify_event_list_len;
	guestfs_int_inotify_event *guestfs_int_inotify_event_list_val;
} guestfs_int_inotify_event_list;

struct guestfs_int_partition {
	int part_num;
	int64_t part_start;
	int64_t part_end;
	int64_t part_size;
};
typedef struct guestfs_int_partition guestfs_int_partition;

typedef struct {
	u_int guestfs_int_partition_list_len;
	guestfs_int_partition *guestfs_int_partition_list_val;
} guestfs_int_partition_list;

struct guestfs_int_application {
	char *app_name;
	char *app_display_name;
	int app_epoch;
	char *app_version;
	char *app_release;
	char *app_install_path;
	char *app_trans_path;
	char *app_publisher;
	char *app_url;
	char *app_source_package;
	char *app_summary;
	char *app_description;
};
typedef struct guestfs_int_application guestfs_int_application;

typedef struct {
	u_int guestfs_int_application_list_len;
	guestfs_int_application *guestfs_int_application_list_val;
} guestfs_int_application_list;

struct guestfs_int_application2 {
	char *app2_name;
	char *app2_display_name;
	int app2_epoch;
	char *app2_version;
	char *app2_release;
	char *app2_arch;
	char *app2_install_path;
	char *app2_trans_path;
	char *app2_publisher;
	char *app2_url;
	char *app2_source_package;
	char *app2_summary;
	char *app2_description;
	char *app2_spare1;
	char *app2_spare2;
	char *app2_spare3;
	char *app2_spare4;
};
typedef struct guestfs_int_application2 guestfs_int_application2;

typedef struct {
	u_int guestfs_int_application2_list_len;
	guestfs_int_application2 *guestfs_int_application2_list_val;
} guestfs_int_application2_list;

struct guestfs_int_isoinfo {
	char *iso_system_id;
	char *iso_volume_id;
	u_int iso_volume_space_size;
	u_int iso_volume_set_size;
	u_int iso_volume_sequence_number;
	u_int iso_logical_block_size;
	char *iso_volume_set_id;
	char *iso_publisher_id;
	char *iso_data_preparer_id;
	char *iso_application_id;
	char *iso_copyright_file_id;
	char *iso_abstract_file_id;
	char *iso_bibliographic_file_id;
	int64_t iso_volume_creation_t;
	int64_t iso_volume_modification_t;
	int64_t iso_volume_expiration_t;
	int64_t iso_volume_effective_t;
};
typedef struct guestfs_int_isoinfo guestfs_int_isoinfo;

typedef struct {
	u_int guestfs_int_isoinfo_list_len;
	guestfs_int_isoinfo *guestfs_int_isoinfo_list_val;
} guestfs_int_isoinfo_list;

struct guestfs_int_mdstat {
	char *mdstat_device;
	int mdstat_index;
	char *mdstat_flags;
};
typedef struct guestfs_int_mdstat guestfs_int_mdstat;

typedef struct {
	u_int guestfs_int_mdstat_list_len;
	guestfs_int_mdstat *guestfs_int_mdstat_list_val;
} guestfs_int_mdstat_list;

struct guestfs_int_btrfssubvolume {
	uint64_t btrfssubvolume_id;
	uint64_t btrfssubvolume_top_level_id;
	char *btrfssubvolume_path;
};
typedef struct guestfs_int_btrfssubvolume guestfs_int_btrfssubvolume;

typedef struct {
	u_int guestfs_int_btrfssubvolume_list_len;
	guestfs_int_btrfssubvolume *guestfs_int_btrfssubvolume_list_val;
} guestfs_int_btrfssubvolume_list;

struct guestfs_int_btrfsqgroup {
	char *btrfsqgroup_id;
	uint64_t btrfsqgroup_rfer;
	uint64_t btrfsqgroup_excl;
};
typedef struct guestfs_int_btrfsqgroup guestfs_int_btrfsqgroup;

typedef struct {
	u_int guestfs_int_btrfsqgroup_list_len;
	guestfs_int_btrfsqgroup *guestfs_int_btrfsqgroup_list_val;
} guestfs_int_btrfsqgroup_list;

struct guestfs_int_btrfsbalance {
	char *btrfsbalance_status;
	uint64_t btrfsbalance_total;
	uint64_t btrfsbalance_balanced;
	uint64_t btrfsbalance_considered;
	uint64_t btrfsbalance_left;
};
typedef struct guestfs_int_btrfsbalance guestfs_int_btrfsbalance;

typedef struct {
	u_int guestfs_int_btrfsbalance_list_len;
	guestfs_int_btrfsbalance *guestfs_int_btrfsbalance_list_val;
} guestfs_int_btrfsbalance_list;

struct guestfs_int_btrfsscrub {
	uint64_t btrfsscrub_data_extents_scrubbed;
	uint64_t btrfsscrub_tree_extents_scrubbed;
	uint64_t btrfsscrub_data_bytes_scrubbed;
	uint64_t btrfsscrub_tree_bytes_scrubbed;
	uint64_t btrfsscrub_read_errors;
	uint64_t btrfsscrub_csum_errors;
	uint64_t btrfsscrub_verify_errors;
	uint64_t btrfsscrub_no_csum;
	uint64_t btrfsscrub_csum_discards;
	uint64_t btrfsscrub_super_errors;
	uint64_t btrfsscrub_malloc_errors;
	uint64_t btrfsscrub_uncorrectable_errors;
	uint64_t btrfsscrub_unverified_errors;
	uint64_t btrfsscrub_corrected_errors;
	uint64_t btrfsscrub_last_physical;
};
typedef struct guestfs_int_btrfsscrub guestfs_int_btrfsscrub;

typedef struct {
	u_int guestfs_int_btrfsscrub_list_len;
	guestfs_int_btrfsscrub *guestfs_int_btrfsscrub_list_val;
} guestfs_int_btrfsscrub_list;

struct guestfs_int_xfsinfo {
	char *xfs_mntpoint;
	u_int xfs_inodesize;
	u_int xfs_agcount;
	u_int xfs_agsize;
	u_int xfs_sectsize;
	u_int xfs_attr;
	u_int xfs_blocksize;
	uint64_t xfs_datablocks;
	u_int xfs_imaxpct;
	u_int xfs_sunit;
	u_int xfs_swidth;
	u_int xfs_dirversion;
	u_int xfs_dirblocksize;
	u_int xfs_cimode;
	char *xfs_logname;
	u_int xfs_logblocksize;
	u_int xfs_logblocks;
	u_int xfs_logversion;
	u_int xfs_logsectsize;
	u_int xfs_logsunit;
	u_int xfs_lazycount;
	char *xfs_rtname;
	u_int xfs_rtextsize;
	uint64_t xfs_rtblocks;
	uint64_t xfs_rtextents;
};
typedef struct guestfs_int_xfsinfo guestfs_int_xfsinfo;

typedef struct {
	u_int guestfs_int_xfsinfo_list_len;
	guestfs_int_xfsinfo *guestfs_int_xfsinfo_list_val;
} guestfs_int_xfsinfo_list;

struct guestfs_int_utsname {
	char *uts_sysname;
	char *uts_release;
	char *uts_version;
	char *uts_machine;
};
typedef struct guestfs_int_utsname guestfs_int_utsname;

typedef struct {
	u_int guestfs_int_utsname_list_len;
	guestfs_int_utsname *guestfs_int_utsname_list_val;
} guestfs_int_utsname_list;

struct guestfs_int_hivex_node {
	int64_t hivex_node_h;
};
typedef struct guestfs_int_hivex_node guestfs_int_hivex_node;

typedef struct {
	u_int guestfs_int_hivex_node_list_len;
	guestfs_int_hivex_node *guestfs_int_hivex_node_list_val;
} guestfs_int_hivex_node_list;

struct guestfs_int_hivex_value {
	int64_t hivex_value_h;
};
typedef struct guestfs_int_hivex_value guestfs_int_hivex_value;

typedef struct {
	u_int guestfs_int_hivex_value_list_len;
	guestfs_int_hivex_value *guestfs_int_hivex_value_list_val;
} guestfs_int_hivex_value_list;

struct guestfs_int_internal_mountable {
	int im_type;
	char *im_device;
	char *im_volume;
};
typedef struct guestfs_int_internal_mountable guestfs_int_internal_mountable;

typedef struct {
	u_int guestfs_int_internal_mountable_list_len;
	guestfs_int_internal_mountable *guestfs_int_internal_mountable_list_val;
} guestfs_int_internal_mountable_list;

struct guestfs_int_tsk_dirent {
	uint64_t tsk_inode;
	char tsk_type;
	int64_t tsk_size;
	char *tsk_name;
	u_int tsk_flags;
	int64_t tsk_atime_sec;
	int64_t tsk_atime_nsec;
	int64_t tsk_mtime_sec;
	int64_t tsk_mtime_nsec;
	int64_t tsk_ctime_sec;
	int64_t tsk_ctime_nsec;
	int64_t tsk_crtime_sec;
	int64_t tsk_crtime_nsec;
	int64_t tsk_nlink;
	char *tsk_link;
	int64_t tsk_spare1;
};
typedef struct guestfs_int_tsk_dirent guestfs_int_tsk_dirent;

typedef struct {
	u_int guestfs_int_tsk_dirent_list_len;
	guestfs_int_tsk_dirent *guestfs_int_tsk_dirent_list_val;
} guestfs_int_tsk_dirent_list;

struct guestfs_int_yara_detection {
	char *yara_name;
	char *yara_rule;
};
typedef struct guestfs_int_yara_detection guestfs_int_yara_detection;

typedef struct {
	u_int guestfs_int_yara_detection_list_len;
	guestfs_int_yara_detection *guestfs_int_yara_detection_list_val;
} guestfs_int_yara_detection_list;

struct guestfs_acl_delete_def_file_args {
	char *dir;
};
typedef struct guestfs_acl_delete_def_file_args guestfs_acl_delete_def_file_args;

struct guestfs_acl_get_file_args {
	char *path;
	char *acltype;
};
typedef struct guestfs_acl_get_file_args guestfs_acl_get_file_args;

struct guestfs_acl_get_file_ret {
	char *acl;
};
typedef struct guestfs_acl_get_file_ret guestfs_acl_get_file_ret;

struct guestfs_acl_set_file_args {
	char *path;
	char *acltype;
	char *acl;
};
typedef struct guestfs_acl_set_file_args guestfs_acl_set_file_args;

struct guestfs_aug_clear_args {
	char *augpath;
};
typedef struct guestfs_aug_clear_args guestfs_aug_clear_args;

struct guestfs_aug_defnode_args {
	char *name;
	char *expr;
	char *val;
};
typedef struct guestfs_aug_defnode_args guestfs_aug_defnode_args;

struct guestfs_aug_defnode_ret {
	guestfs_int_int_bool nrnodescreated;
};
typedef struct guestfs_aug_defnode_ret guestfs_aug_defnode_ret;

struct guestfs_aug_defvar_args {
	char *name;
	guestfs_str *expr;
};
typedef struct guestfs_aug_defvar_args guestfs_aug_defvar_args;

struct guestfs_aug_defvar_ret {
	int nrnodes;
};
typedef struct guestfs_aug_defvar_ret guestfs_aug_defvar_ret;

struct guestfs_aug_get_args {
	char *augpath;
};
typedef struct guestfs_aug_get_args guestfs_aug_get_args;

struct guestfs_aug_get_ret {
	char *val;
};
typedef struct guestfs_aug_get_ret guestfs_aug_get_ret;

struct guestfs_aug_init_args {
	char *root;
	int flags;
};
typedef struct guestfs_aug_init_args guestfs_aug_init_args;

struct guestfs_aug_insert_args {
	char *augpath;
	char *label;
	bool_t before;
};
typedef struct guestfs_aug_insert_args guestfs_aug_insert_args;

struct guestfs_aug_label_args {
	char *augpath;
};
typedef struct guestfs_aug_label_args guestfs_aug_label_args;

struct guestfs_aug_label_ret {
	char *label;
};
typedef struct guestfs_aug_label_ret guestfs_aug_label_ret;

struct guestfs_aug_ls_args {
	char *augpath;
};
typedef struct guestfs_aug_ls_args guestfs_aug_ls_args;

struct guestfs_aug_ls_ret {
	struct {
		u_int matches_len;
		guestfs_str *matches_val;
	} matches;
};
typedef struct guestfs_aug_ls_ret guestfs_aug_ls_ret;

struct guestfs_aug_match_args {
	char *augpath;
};
typedef struct guestfs_aug_match_args guestfs_aug_match_args;

struct guestfs_aug_match_ret {
	struct {
		u_int matches_len;
		guestfs_str *matches_val;
	} matches;
};
typedef struct guestfs_aug_match_ret guestfs_aug_match_ret;

struct guestfs_aug_mv_args {
	char *src;
	char *dest;
};
typedef struct guestfs_aug_mv_args guestfs_aug_mv_args;

struct guestfs_aug_rm_args {
	char *augpath;
};
typedef struct guestfs_aug_rm_args guestfs_aug_rm_args;

struct guestfs_aug_rm_ret {
	int nrnodes;
};
typedef struct guestfs_aug_rm_ret guestfs_aug_rm_ret;

struct guestfs_aug_set_args {
	char *augpath;
	char *val;
};
typedef struct guestfs_aug_set_args guestfs_aug_set_args;

struct guestfs_aug_setm_args {
	char *base;
	guestfs_str *sub;
	char *val;
};
typedef struct guestfs_aug_setm_args guestfs_aug_setm_args;

struct guestfs_aug_setm_ret {
	int nodes;
};
typedef struct guestfs_aug_setm_ret guestfs_aug_setm_ret;

struct guestfs_aug_transform_args {
	char *lens;
	char *file;
	bool_t remove;
};
typedef struct guestfs_aug_transform_args guestfs_aug_transform_args;

struct guestfs_available_all_groups_ret {
	struct {
		u_int groups_len;
		guestfs_str *groups_val;
	} groups;
};
typedef struct guestfs_available_all_groups_ret guestfs_available_all_groups_ret;

struct guestfs_base64_in_args {
	char *filename;
};
typedef struct guestfs_base64_in_args guestfs_base64_in_args;

struct guestfs_base64_out_args {
	char *filename;
};
typedef struct guestfs_base64_out_args guestfs_base64_out_args;

struct guestfs_blkdiscard_args {
	char *device;
};
typedef struct guestfs_blkdiscard_args guestfs_blkdiscard_args;

struct guestfs_blkdiscardzeroes_args {
	char *device;
};
typedef struct guestfs_blkdiscardzeroes_args guestfs_blkdiscardzeroes_args;

struct guestfs_blkdiscardzeroes_ret {
	bool_t zeroes;
};
typedef struct guestfs_blkdiscardzeroes_ret guestfs_blkdiscardzeroes_ret;

struct guestfs_blkid_args {
	char *device;
};
typedef struct guestfs_blkid_args guestfs_blkid_args;

struct guestfs_blkid_ret {
	struct {
		u_int info_len;
		guestfs_str *info_val;
	} info;
};
typedef struct guestfs_blkid_ret guestfs_blkid_ret;

struct guestfs_blockdev_flushbufs_args {
	char *device;
};
typedef struct guestfs_blockdev_flushbufs_args guestfs_blockdev_flushbufs_args;

struct guestfs_blockdev_getbsz_args {
	char *device;
};
typedef struct guestfs_blockdev_getbsz_args guestfs_blockdev_getbsz_args;

struct guestfs_blockdev_getbsz_ret {
	int blocksize;
};
typedef struct guestfs_blockdev_getbsz_ret guestfs_blockdev_getbsz_ret;

struct guestfs_blockdev_getro_args {
	char *device;
};
typedef struct guestfs_blockdev_getro_args guestfs_blockdev_getro_args;

struct guestfs_blockdev_getro_ret {
	bool_t ro;
};
typedef struct guestfs_blockdev_getro_ret guestfs_blockdev_getro_ret;

struct guestfs_blockdev_getsize64_args {
	char *device;
};
typedef struct guestfs_blockdev_getsize64_args guestfs_blockdev_getsize64_args;

struct guestfs_blockdev_getsize64_ret {
	int64_t sizeinbytes;
};
typedef struct guestfs_blockdev_getsize64_ret guestfs_blockdev_getsize64_ret;

struct guestfs_blockdev_getss_args {
	char *device;
};
typedef struct guestfs_blockdev_getss_args guestfs_blockdev_getss_args;

struct guestfs_blockdev_getss_ret {
	int sectorsize;
};
typedef struct guestfs_blockdev_getss_ret guestfs_blockdev_getss_ret;

struct guestfs_blockdev_getsz_args {
	char *device;
};
typedef struct guestfs_blockdev_getsz_args guestfs_blockdev_getsz_args;

struct guestfs_blockdev_getsz_ret {
	int64_t sizeinsectors;
};
typedef struct guestfs_blockdev_getsz_ret guestfs_blockdev_getsz_ret;

struct guestfs_blockdev_rereadpt_args {
	char *device;
};
typedef struct guestfs_blockdev_rereadpt_args guestfs_blockdev_rereadpt_args;

struct guestfs_blockdev_setbsz_args {
	char *device;
	int blocksize;
};
typedef struct guestfs_blockdev_setbsz_args guestfs_blockdev_setbsz_args;

struct guestfs_blockdev_setra_args {
	char *device;
	int sectors;
};
typedef struct guestfs_blockdev_setra_args guestfs_blockdev_setra_args;

struct guestfs_blockdev_setro_args {
	char *device;
};
typedef struct guestfs_blockdev_setro_args guestfs_blockdev_setro_args;

struct guestfs_blockdev_setrw_args {
	char *device;
};
typedef struct guestfs_blockdev_setrw_args guestfs_blockdev_setrw_args;

struct guestfs_btrfs_balance_cancel_args {
	char *path;
};
typedef struct guestfs_btrfs_balance_cancel_args guestfs_btrfs_balance_cancel_args;

struct guestfs_btrfs_balance_pause_args {
	char *path;
};
typedef struct guestfs_btrfs_balance_pause_args guestfs_btrfs_balance_pause_args;

struct guestfs_btrfs_balance_resume_args {
	char *path;
};
typedef struct guestfs_btrfs_balance_resume_args guestfs_btrfs_balance_resume_args;

struct guestfs_btrfs_balance_status_args {
	char *path;
};
typedef struct guestfs_btrfs_balance_status_args guestfs_btrfs_balance_status_args;

struct guestfs_btrfs_balance_status_ret {
	guestfs_int_btrfsbalance status;
};
typedef struct guestfs_btrfs_balance_status_ret guestfs_btrfs_balance_status_ret;

struct guestfs_btrfs_device_add_args {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
	char *fs;
};
typedef struct guestfs_btrfs_device_add_args guestfs_btrfs_device_add_args;

struct guestfs_btrfs_device_delete_args {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
	char *fs;
};
typedef struct guestfs_btrfs_device_delete_args guestfs_btrfs_device_delete_args;

struct guestfs_btrfs_filesystem_balance_args {
	char *fs;
};
typedef struct guestfs_btrfs_filesystem_balance_args guestfs_btrfs_filesystem_balance_args;

struct guestfs_btrfs_filesystem_defragment_args {
	char *path;
	bool_t flush;
	char *compress;
};
typedef struct guestfs_btrfs_filesystem_defragment_args guestfs_btrfs_filesystem_defragment_args;

struct guestfs_btrfs_filesystem_resize_args {
	char *mountpoint;
	int64_t size;
};
typedef struct guestfs_btrfs_filesystem_resize_args guestfs_btrfs_filesystem_resize_args;

struct guestfs_btrfs_filesystem_show_args {
	char *device;
};
typedef struct guestfs_btrfs_filesystem_show_args guestfs_btrfs_filesystem_show_args;

struct guestfs_btrfs_filesystem_show_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_btrfs_filesystem_show_ret guestfs_btrfs_filesystem_show_ret;

struct guestfs_btrfs_filesystem_sync_args {
	char *fs;
};
typedef struct guestfs_btrfs_filesystem_sync_args guestfs_btrfs_filesystem_sync_args;

struct guestfs_btrfs_fsck_args {
	char *device;
	int64_t superblock;
	bool_t repair;
};
typedef struct guestfs_btrfs_fsck_args guestfs_btrfs_fsck_args;

struct guestfs_btrfs_image_args {
	struct {
		u_int source_len;
		guestfs_str *source_val;
	} source;
	char *image;
	int compresslevel;
};
typedef struct guestfs_btrfs_image_args guestfs_btrfs_image_args;

struct guestfs_btrfs_qgroup_assign_args {
	char *src;
	char *dst;
	char *path;
};
typedef struct guestfs_btrfs_qgroup_assign_args guestfs_btrfs_qgroup_assign_args;

struct guestfs_btrfs_qgroup_create_args {
	char *qgroupid;
	char *subvolume;
};
typedef struct guestfs_btrfs_qgroup_create_args guestfs_btrfs_qgroup_create_args;

struct guestfs_btrfs_qgroup_destroy_args {
	char *qgroupid;
	char *subvolume;
};
typedef struct guestfs_btrfs_qgroup_destroy_args guestfs_btrfs_qgroup_destroy_args;

struct guestfs_btrfs_qgroup_limit_args {
	char *subvolume;
	int64_t size;
};
typedef struct guestfs_btrfs_qgroup_limit_args guestfs_btrfs_qgroup_limit_args;

struct guestfs_btrfs_qgroup_remove_args {
	char *src;
	char *dst;
	char *path;
};
typedef struct guestfs_btrfs_qgroup_remove_args guestfs_btrfs_qgroup_remove_args;

struct guestfs_btrfs_qgroup_show_args {
	char *path;
};
typedef struct guestfs_btrfs_qgroup_show_args guestfs_btrfs_qgroup_show_args;

struct guestfs_btrfs_qgroup_show_ret {
	guestfs_int_btrfsqgroup_list qgroups;
};
typedef struct guestfs_btrfs_qgroup_show_ret guestfs_btrfs_qgroup_show_ret;

struct guestfs_btrfs_quota_enable_args {
	char *fs;
	bool_t enable;
};
typedef struct guestfs_btrfs_quota_enable_args guestfs_btrfs_quota_enable_args;

struct guestfs_btrfs_quota_rescan_args {
	char *fs;
};
typedef struct guestfs_btrfs_quota_rescan_args guestfs_btrfs_quota_rescan_args;

struct guestfs_btrfs_replace_args {
	char *srcdev;
	char *targetdev;
	char *mntpoint;
};
typedef struct guestfs_btrfs_replace_args guestfs_btrfs_replace_args;

struct guestfs_btrfs_rescue_chunk_recover_args {
	char *device;
};
typedef struct guestfs_btrfs_rescue_chunk_recover_args guestfs_btrfs_rescue_chunk_recover_args;

struct guestfs_btrfs_rescue_super_recover_args {
	char *device;
};
typedef struct guestfs_btrfs_rescue_super_recover_args guestfs_btrfs_rescue_super_recover_args;

struct guestfs_btrfs_scrub_cancel_args {
	char *path;
};
typedef struct guestfs_btrfs_scrub_cancel_args guestfs_btrfs_scrub_cancel_args;

struct guestfs_btrfs_scrub_resume_args {
	char *path;
};
typedef struct guestfs_btrfs_scrub_resume_args guestfs_btrfs_scrub_resume_args;

struct guestfs_btrfs_scrub_start_args {
	char *path;
};
typedef struct guestfs_btrfs_scrub_start_args guestfs_btrfs_scrub_start_args;

struct guestfs_btrfs_scrub_status_args {
	char *path;
};
typedef struct guestfs_btrfs_scrub_status_args guestfs_btrfs_scrub_status_args;

struct guestfs_btrfs_scrub_status_ret {
	guestfs_int_btrfsscrub status;
};
typedef struct guestfs_btrfs_scrub_status_ret guestfs_btrfs_scrub_status_ret;

struct guestfs_btrfs_set_seeding_args {
	char *device;
	bool_t seeding;
};
typedef struct guestfs_btrfs_set_seeding_args guestfs_btrfs_set_seeding_args;

struct guestfs_btrfs_subvolume_create_args {
	char *dest;
	char *qgroupid;
};
typedef struct guestfs_btrfs_subvolume_create_args guestfs_btrfs_subvolume_create_args;

struct guestfs_btrfs_subvolume_delete_args {
	char *subvolume;
};
typedef struct guestfs_btrfs_subvolume_delete_args guestfs_btrfs_subvolume_delete_args;

struct guestfs_btrfs_subvolume_get_default_args {
	char *fs;
};
typedef struct guestfs_btrfs_subvolume_get_default_args guestfs_btrfs_subvolume_get_default_args;

struct guestfs_btrfs_subvolume_get_default_ret {
	int64_t id;
};
typedef struct guestfs_btrfs_subvolume_get_default_ret guestfs_btrfs_subvolume_get_default_ret;

struct guestfs_btrfs_subvolume_list_args {
	char *fs;
};
typedef struct guestfs_btrfs_subvolume_list_args guestfs_btrfs_subvolume_list_args;

struct guestfs_btrfs_subvolume_list_ret {
	guestfs_int_btrfssubvolume_list subvolumes;
};
typedef struct guestfs_btrfs_subvolume_list_ret guestfs_btrfs_subvolume_list_ret;

struct guestfs_btrfs_subvolume_set_default_args {
	int64_t id;
	char *fs;
};
typedef struct guestfs_btrfs_subvolume_set_default_args guestfs_btrfs_subvolume_set_default_args;

struct guestfs_btrfs_subvolume_show_args {
	char *subvolume;
};
typedef struct guestfs_btrfs_subvolume_show_args guestfs_btrfs_subvolume_show_args;

struct guestfs_btrfs_subvolume_show_ret {
	struct {
		u_int btrfssubvolumeinfo_len;
		guestfs_str *btrfssubvolumeinfo_val;
	} btrfssubvolumeinfo;
};
typedef struct guestfs_btrfs_subvolume_show_ret guestfs_btrfs_subvolume_show_ret;

struct guestfs_btrfs_subvolume_snapshot_args {
	char *source;
	char *dest;
	bool_t ro;
	char *qgroupid;
};
typedef struct guestfs_btrfs_subvolume_snapshot_args guestfs_btrfs_subvolume_snapshot_args;

struct guestfs_btrfstune_enable_extended_inode_refs_args {
	char *device;
};
typedef struct guestfs_btrfstune_enable_extended_inode_refs_args guestfs_btrfstune_enable_extended_inode_refs_args;

struct guestfs_btrfstune_enable_skinny_metadata_extent_refs_args {
	char *device;
};
typedef struct guestfs_btrfstune_enable_skinny_metadata_extent_refs_args guestfs_btrfstune_enable_skinny_metadata_extent_refs_args;

struct guestfs_btrfstune_seeding_args {
	char *device;
	bool_t seeding;
};
typedef struct guestfs_btrfstune_seeding_args guestfs_btrfstune_seeding_args;

struct guestfs_cap_get_file_args {
	char *path;
};
typedef struct guestfs_cap_get_file_args guestfs_cap_get_file_args;

struct guestfs_cap_get_file_ret {
	char *cap;
};
typedef struct guestfs_cap_get_file_ret guestfs_cap_get_file_ret;

struct guestfs_cap_set_file_args {
	char *path;
	char *cap;
};
typedef struct guestfs_cap_set_file_args guestfs_cap_set_file_args;

struct guestfs_case_sensitive_path_args {
	char *path;
};
typedef struct guestfs_case_sensitive_path_args guestfs_case_sensitive_path_args;

struct guestfs_case_sensitive_path_ret {
	char *rpath;
};
typedef struct guestfs_case_sensitive_path_ret guestfs_case_sensitive_path_ret;

struct guestfs_checksum_args {
	char *csumtype;
	char *path;
};
typedef struct guestfs_checksum_args guestfs_checksum_args;

struct guestfs_checksum_ret {
	char *checksum;
};
typedef struct guestfs_checksum_ret guestfs_checksum_ret;

struct guestfs_checksum_device_args {
	char *csumtype;
	char *device;
};
typedef struct guestfs_checksum_device_args guestfs_checksum_device_args;

struct guestfs_checksum_device_ret {
	char *checksum;
};
typedef struct guestfs_checksum_device_ret guestfs_checksum_device_ret;

struct guestfs_checksums_out_args {
	char *csumtype;
	char *directory;
};
typedef struct guestfs_checksums_out_args guestfs_checksums_out_args;

struct guestfs_chmod_args {
	int mode;
	char *path;
};
typedef struct guestfs_chmod_args guestfs_chmod_args;

struct guestfs_chown_args {
	int owner;
	int group;
	char *path;
};
typedef struct guestfs_chown_args guestfs_chown_args;

struct guestfs_command_args {
	struct {
		u_int arguments_len;
		guestfs_str *arguments_val;
	} arguments;
};
typedef struct guestfs_command_args guestfs_command_args;

struct guestfs_command_ret {
	char *output;
};
typedef struct guestfs_command_ret guestfs_command_ret;

struct guestfs_command_lines_args {
	struct {
		u_int arguments_len;
		guestfs_str *arguments_val;
	} arguments;
};
typedef struct guestfs_command_lines_args guestfs_command_lines_args;

struct guestfs_command_lines_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_command_lines_ret guestfs_command_lines_ret;

struct guestfs_compress_device_out_args {
	char *ctype;
	char *device;
	int level;
};
typedef struct guestfs_compress_device_out_args guestfs_compress_device_out_args;

struct guestfs_compress_out_args {
	char *ctype;
	char *file;
	int level;
};
typedef struct guestfs_compress_out_args guestfs_compress_out_args;

struct guestfs_copy_attributes_args {
	char *src;
	char *dest;
	bool_t all;
	bool_t mode;
	bool_t xattributes;
	bool_t ownership;
};
typedef struct guestfs_copy_attributes_args guestfs_copy_attributes_args;

struct guestfs_copy_device_to_device_args {
	char *src;
	char *dest;
	int64_t srcoffset;
	int64_t destoffset;
	int64_t size;
	bool_t sparse;
	bool_t append;
};
typedef struct guestfs_copy_device_to_device_args guestfs_copy_device_to_device_args;

struct guestfs_copy_device_to_file_args {
	char *src;
	char *dest;
	int64_t srcoffset;
	int64_t destoffset;
	int64_t size;
	bool_t sparse;
	bool_t append;
};
typedef struct guestfs_copy_device_to_file_args guestfs_copy_device_to_file_args;

struct guestfs_copy_file_to_device_args {
	char *src;
	char *dest;
	int64_t srcoffset;
	int64_t destoffset;
	int64_t size;
	bool_t sparse;
	bool_t append;
};
typedef struct guestfs_copy_file_to_device_args guestfs_copy_file_to_device_args;

struct guestfs_copy_file_to_file_args {
	char *src;
	char *dest;
	int64_t srcoffset;
	int64_t destoffset;
	int64_t size;
	bool_t sparse;
	bool_t append;
};
typedef struct guestfs_copy_file_to_file_args guestfs_copy_file_to_file_args;

struct guestfs_copy_size_args {
	char *src;
	char *dest;
	int64_t size;
};
typedef struct guestfs_copy_size_args guestfs_copy_size_args;

struct guestfs_cp_args {
	char *src;
	char *dest;
};
typedef struct guestfs_cp_args guestfs_cp_args;

struct guestfs_cp_a_args {
	char *src;
	char *dest;
};
typedef struct guestfs_cp_a_args guestfs_cp_a_args;

struct guestfs_cp_r_args {
	char *src;
	char *dest;
};
typedef struct guestfs_cp_r_args guestfs_cp_r_args;

struct guestfs_cpio_out_args {
	char *directory;
	char *format;
};
typedef struct guestfs_cpio_out_args guestfs_cpio_out_args;

struct guestfs_cryptsetup_close_args {
	char *device;
};
typedef struct guestfs_cryptsetup_close_args guestfs_cryptsetup_close_args;

struct guestfs_cryptsetup_open_args {
	char *device;
	char *key;
	char *mapname;
	bool_t readonly;
	char *crypttype;
};
typedef struct guestfs_cryptsetup_open_args guestfs_cryptsetup_open_args;

struct guestfs_dd_args {
	char *src;
	char *dest;
};
typedef struct guestfs_dd_args guestfs_dd_args;

struct guestfs_debug_args {
	char *subcmd;
	struct {
		u_int extraargs_len;
		guestfs_str *extraargs_val;
	} extraargs;
};
typedef struct guestfs_debug_args guestfs_debug_args;

struct guestfs_debug_ret {
	char *result;
};
typedef struct guestfs_debug_ret guestfs_debug_ret;

struct guestfs_debug_upload_args {
	char *tmpname;
	int mode;
};
typedef struct guestfs_debug_upload_args guestfs_debug_upload_args;

struct guestfs_df_ret {
	char *output;
};
typedef struct guestfs_df_ret guestfs_df_ret;

struct guestfs_df_h_ret {
	char *output;
};
typedef struct guestfs_df_h_ret guestfs_df_h_ret;

struct guestfs_dmesg_ret {
	char *kmsgs;
};
typedef struct guestfs_dmesg_ret guestfs_dmesg_ret;

struct guestfs_download_args {
	char *remotefilename;
};
typedef struct guestfs_download_args guestfs_download_args;

struct guestfs_download_blocks_args {
	char *device;
	int64_t start;
	int64_t stop;
	bool_t unallocated;
};
typedef struct guestfs_download_blocks_args guestfs_download_blocks_args;

struct guestfs_download_inode_args {
	char *device;
	int64_t inode;
};
typedef struct guestfs_download_inode_args guestfs_download_inode_args;

struct guestfs_download_offset_args {
	char *remotefilename;
	int64_t offset;
	int64_t size;
};
typedef struct guestfs_download_offset_args guestfs_download_offset_args;

struct guestfs_drop_caches_args {
	int whattodrop;
};
typedef struct guestfs_drop_caches_args guestfs_drop_caches_args;

struct guestfs_du_args {
	char *path;
};
typedef struct guestfs_du_args guestfs_du_args;

struct guestfs_du_ret {
	int64_t sizekb;
};
typedef struct guestfs_du_ret guestfs_du_ret;

struct guestfs_e2fsck_args {
	char *device;
	bool_t correct;
	bool_t forceall;
};
typedef struct guestfs_e2fsck_args guestfs_e2fsck_args;

struct guestfs_e2fsck_f_args {
	char *device;
};
typedef struct guestfs_e2fsck_f_args guestfs_e2fsck_f_args;

struct guestfs_echo_daemon_args {
	struct {
		u_int words_len;
		guestfs_str *words_val;
	} words;
};
typedef struct guestfs_echo_daemon_args guestfs_echo_daemon_args;

struct guestfs_echo_daemon_ret {
	char *output;
};
typedef struct guestfs_echo_daemon_ret guestfs_echo_daemon_ret;

struct guestfs_egrep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_egrep_args guestfs_egrep_args;

struct guestfs_egrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_egrep_ret guestfs_egrep_ret;

struct guestfs_egrepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_egrepi_args guestfs_egrepi_args;

struct guestfs_egrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_egrepi_ret guestfs_egrepi_ret;

struct guestfs_equal_args {
	char *file1;
	char *file2;
};
typedef struct guestfs_equal_args guestfs_equal_args;

struct guestfs_equal_ret {
	bool_t equality;
};
typedef struct guestfs_equal_ret guestfs_equal_ret;

struct guestfs_exists_args {
	char *path;
};
typedef struct guestfs_exists_args guestfs_exists_args;

struct guestfs_exists_ret {
	bool_t existsflag;
};
typedef struct guestfs_exists_ret guestfs_exists_ret;

struct guestfs_extlinux_args {
	char *directory;
};
typedef struct guestfs_extlinux_args guestfs_extlinux_args;

struct guestfs_f2fs_expand_args {
	char *device;
};
typedef struct guestfs_f2fs_expand_args guestfs_f2fs_expand_args;

struct guestfs_fallocate_args {
	char *path;
	int len;
};
typedef struct guestfs_fallocate_args guestfs_fallocate_args;

struct guestfs_fallocate64_args {
	char *path;
	int64_t len;
};
typedef struct guestfs_fallocate64_args guestfs_fallocate64_args;

struct guestfs_fgrep_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_fgrep_args guestfs_fgrep_args;

struct guestfs_fgrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_fgrep_ret guestfs_fgrep_ret;

struct guestfs_fgrepi_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_fgrepi_args guestfs_fgrepi_args;

struct guestfs_fgrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_fgrepi_ret guestfs_fgrepi_ret;

struct guestfs_file_args {
	char *path;
};
typedef struct guestfs_file_args guestfs_file_args;

struct guestfs_file_ret {
	char *description;
};
typedef struct guestfs_file_ret guestfs_file_ret;

struct guestfs_file_architecture_args {
	char *filename;
};
typedef struct guestfs_file_architecture_args guestfs_file_architecture_args;

struct guestfs_file_architecture_ret {
	char *arch;
};
typedef struct guestfs_file_architecture_ret guestfs_file_architecture_ret;

struct guestfs_filesize_args {
	char *file;
};
typedef struct guestfs_filesize_args guestfs_filesize_args;

struct guestfs_filesize_ret {
	int64_t size;
};
typedef struct guestfs_filesize_ret guestfs_filesize_ret;

struct guestfs_filesystem_available_args {
	char *filesystem;
};
typedef struct guestfs_filesystem_available_args guestfs_filesystem_available_args;

struct guestfs_filesystem_available_ret {
	bool_t fsavail;
};
typedef struct guestfs_filesystem_available_ret guestfs_filesystem_available_ret;

struct guestfs_fill_args {
	int c;
	int len;
	char *path;
};
typedef struct guestfs_fill_args guestfs_fill_args;

struct guestfs_fill_dir_args {
	char *dir;
	int nr;
};
typedef struct guestfs_fill_dir_args guestfs_fill_dir_args;

struct guestfs_fill_pattern_args {
	char *pattern;
	int len;
	char *path;
};
typedef struct guestfs_fill_pattern_args guestfs_fill_pattern_args;

struct guestfs_find0_args {
	char *directory;
};
typedef struct guestfs_find0_args guestfs_find0_args;

struct guestfs_findfs_label_args {
	char *label;
};
typedef struct guestfs_findfs_label_args guestfs_findfs_label_args;

struct guestfs_findfs_label_ret {
	char *device;
};
typedef struct guestfs_findfs_label_ret guestfs_findfs_label_ret;

struct guestfs_findfs_uuid_args {
	char *uuid;
};
typedef struct guestfs_findfs_uuid_args guestfs_findfs_uuid_args;

struct guestfs_findfs_uuid_ret {
	char *device;
};
typedef struct guestfs_findfs_uuid_ret guestfs_findfs_uuid_ret;

struct guestfs_fsck_args {
	char *fstype;
	char *device;
};
typedef struct guestfs_fsck_args guestfs_fsck_args;

struct guestfs_fsck_ret {
	int status;
};
typedef struct guestfs_fsck_ret guestfs_fsck_ret;

struct guestfs_fstrim_args {
	char *mountpoint;
	int64_t offset;
	int64_t length;
	int64_t minimumfreeextent;
};
typedef struct guestfs_fstrim_args guestfs_fstrim_args;

struct guestfs_get_e2attrs_args {
	char *file;
};
typedef struct guestfs_get_e2attrs_args guestfs_get_e2attrs_args;

struct guestfs_get_e2attrs_ret {
	char *attrs;
};
typedef struct guestfs_get_e2attrs_ret guestfs_get_e2attrs_ret;

struct guestfs_get_e2generation_args {
	char *file;
};
typedef struct guestfs_get_e2generation_args guestfs_get_e2generation_args;

struct guestfs_get_e2generation_ret {
	int64_t generation;
};
typedef struct guestfs_get_e2generation_ret guestfs_get_e2generation_ret;

struct guestfs_get_e2label_args {
	char *device;
};
typedef struct guestfs_get_e2label_args guestfs_get_e2label_args;

struct guestfs_get_e2label_ret {
	char *label;
};
typedef struct guestfs_get_e2label_ret guestfs_get_e2label_ret;

struct guestfs_get_e2uuid_args {
	char *device;
};
typedef struct guestfs_get_e2uuid_args guestfs_get_e2uuid_args;

struct guestfs_get_e2uuid_ret {
	char *uuid;
};
typedef struct guestfs_get_e2uuid_ret guestfs_get_e2uuid_ret;

struct guestfs_get_umask_ret {
	int mask;
};
typedef struct guestfs_get_umask_ret guestfs_get_umask_ret;

struct guestfs_getcon_ret {
	char *context;
};
typedef struct guestfs_getcon_ret guestfs_getcon_ret;

struct guestfs_getxattr_args {
	char *path;
	char *name;
};
typedef struct guestfs_getxattr_args guestfs_getxattr_args;

struct guestfs_getxattr_ret {
	struct {
		u_int xattr_len;
		char *xattr_val;
	} xattr;
};
typedef struct guestfs_getxattr_ret guestfs_getxattr_ret;

struct guestfs_getxattrs_args {
	char *path;
};
typedef struct guestfs_getxattrs_args guestfs_getxattrs_args;

struct guestfs_getxattrs_ret {
	guestfs_int_xattr_list xattrs;
};
typedef struct guestfs_getxattrs_ret guestfs_getxattrs_ret;

struct guestfs_glob_expand_args {
	char *pattern;
	bool_t directoryslash;
};
typedef struct guestfs_glob_expand_args guestfs_glob_expand_args;

struct guestfs_glob_expand_ret {
	struct {
		u_int paths_len;
		guestfs_str *paths_val;
	} paths;
};
typedef struct guestfs_glob_expand_ret guestfs_glob_expand_ret;

struct guestfs_grep_args {
	char *regex;
	char *path;
	bool_t extended;
	bool_t fixed;
	bool_t insensitive;
	bool_t compressed;
};
typedef struct guestfs_grep_args guestfs_grep_args;

struct guestfs_grep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_grep_ret guestfs_grep_ret;

struct guestfs_grepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_grepi_args guestfs_grepi_args;

struct guestfs_grepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_grepi_ret guestfs_grepi_ret;

struct guestfs_grub_install_args {
	char *root;
	char *device;
};
typedef struct guestfs_grub_install_args guestfs_grub_install_args;

struct guestfs_head_args {
	char *path;
};
typedef struct guestfs_head_args guestfs_head_args;

struct guestfs_head_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_head_ret guestfs_head_ret;

struct guestfs_head_n_args {
	int nrlines;
	char *path;
};
typedef struct guestfs_head_n_args guestfs_head_n_args;

struct guestfs_head_n_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_head_n_ret guestfs_head_n_ret;

struct guestfs_hexdump_args {
	char *path;
};
typedef struct guestfs_hexdump_args guestfs_hexdump_args;

struct guestfs_hexdump_ret {
	char *dump;
};
typedef struct guestfs_hexdump_ret guestfs_hexdump_ret;

struct guestfs_hivex_commit_args {
	guestfs_str *filename;
};
typedef struct guestfs_hivex_commit_args guestfs_hivex_commit_args;

struct guestfs_hivex_node_add_child_args {
	int64_t parent;
	char *name;
};
typedef struct guestfs_hivex_node_add_child_args guestfs_hivex_node_add_child_args;

struct guestfs_hivex_node_add_child_ret {
	int64_t nodeh;
};
typedef struct guestfs_hivex_node_add_child_ret guestfs_hivex_node_add_child_ret;

struct guestfs_hivex_node_children_args {
	int64_t nodeh;
};
typedef struct guestfs_hivex_node_children_args guestfs_hivex_node_children_args;

struct guestfs_hivex_node_children_ret {
	guestfs_int_hivex_node_list nodehs;
};
typedef struct guestfs_hivex_node_children_ret guestfs_hivex_node_children_ret;

struct guestfs_hivex_node_delete_child_args {
	int64_t nodeh;
};
typedef struct guestfs_hivex_node_delete_child_args guestfs_hivex_node_delete_child_args;

struct guestfs_hivex_node_get_child_args {
	int64_t nodeh;
	char *name;
};
typedef struct guestfs_hivex_node_get_child_args guestfs_hivex_node_get_child_args;

struct guestfs_hivex_node_get_child_ret {
	int64_t child;
};
typedef struct guestfs_hivex_node_get_child_ret guestfs_hivex_node_get_child_ret;

struct guestfs_hivex_node_get_value_args {
	int64_t nodeh;
	char *key;
};
typedef struct guestfs_hivex_node_get_value_args guestfs_hivex_node_get_value_args;

struct guestfs_hivex_node_get_value_ret {
	int64_t valueh;
};
typedef struct guestfs_hivex_node_get_value_ret guestfs_hivex_node_get_value_ret;

struct guestfs_hivex_node_name_args {
	int64_t nodeh;
};
typedef struct guestfs_hivex_node_name_args guestfs_hivex_node_name_args;

struct guestfs_hivex_node_name_ret {
	char *name;
};
typedef struct guestfs_hivex_node_name_ret guestfs_hivex_node_name_ret;

struct guestfs_hivex_node_parent_args {
	int64_t nodeh;
};
typedef struct guestfs_hivex_node_parent_args guestfs_hivex_node_parent_args;

struct guestfs_hivex_node_parent_ret {
	int64_t parent;
};
typedef struct guestfs_hivex_node_parent_ret guestfs_hivex_node_parent_ret;

struct guestfs_hivex_node_set_value_args {
	int64_t nodeh;
	char *key;
	int64_t t;
	struct {
		u_int val_len;
		char *val_val;
	} val;
};
typedef struct guestfs_hivex_node_set_value_args guestfs_hivex_node_set_value_args;

struct guestfs_hivex_node_values_args {
	int64_t nodeh;
};
typedef struct guestfs_hivex_node_values_args guestfs_hivex_node_values_args;

struct guestfs_hivex_node_values_ret {
	guestfs_int_hivex_value_list valuehs;
};
typedef struct guestfs_hivex_node_values_ret guestfs_hivex_node_values_ret;

struct guestfs_hivex_open_args {
	char *filename;
	bool_t verbose;
	bool_t debug;
	bool_t write;
	bool_t unsafe;
};
typedef struct guestfs_hivex_open_args guestfs_hivex_open_args;

struct guestfs_hivex_root_ret {
	int64_t nodeh;
};
typedef struct guestfs_hivex_root_ret guestfs_hivex_root_ret;

struct guestfs_hivex_value_key_args {
	int64_t valueh;
};
typedef struct guestfs_hivex_value_key_args guestfs_hivex_value_key_args;

struct guestfs_hivex_value_key_ret {
	char *key;
};
typedef struct guestfs_hivex_value_key_ret guestfs_hivex_value_key_ret;

struct guestfs_hivex_value_string_args {
	int64_t valueh;
};
typedef struct guestfs_hivex_value_string_args guestfs_hivex_value_string_args;

struct guestfs_hivex_value_string_ret {
	char *databuf;
};
typedef struct guestfs_hivex_value_string_ret guestfs_hivex_value_string_ret;

struct guestfs_hivex_value_type_args {
	int64_t valueh;
};
typedef struct guestfs_hivex_value_type_args guestfs_hivex_value_type_args;

struct guestfs_hivex_value_type_ret {
	int64_t datatype;
};
typedef struct guestfs_hivex_value_type_ret guestfs_hivex_value_type_ret;

struct guestfs_hivex_value_utf8_args {
	int64_t valueh;
};
typedef struct guestfs_hivex_value_utf8_args guestfs_hivex_value_utf8_args;

struct guestfs_hivex_value_utf8_ret {
	char *databuf;
};
typedef struct guestfs_hivex_value_utf8_ret guestfs_hivex_value_utf8_ret;

struct guestfs_hivex_value_value_args {
	int64_t valueh;
};
typedef struct guestfs_hivex_value_value_args guestfs_hivex_value_value_args;

struct guestfs_hivex_value_value_ret {
	struct {
		u_int databuf_len;
		char *databuf_val;
	} databuf;
};
typedef struct guestfs_hivex_value_value_ret guestfs_hivex_value_value_ret;

struct guestfs_initrd_cat_args {
	char *initrdpath;
	char *filename;
};
typedef struct guestfs_initrd_cat_args guestfs_initrd_cat_args;

struct guestfs_initrd_cat_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_initrd_cat_ret guestfs_initrd_cat_ret;

struct guestfs_initrd_list_args {
	char *path;
};
typedef struct guestfs_initrd_list_args guestfs_initrd_list_args;

struct guestfs_initrd_list_ret {
	struct {
		u_int filenames_len;
		guestfs_str *filenames_val;
	} filenames;
};
typedef struct guestfs_initrd_list_ret guestfs_initrd_list_ret;

struct guestfs_inotify_add_watch_args {
	char *path;
	int mask;
};
typedef struct guestfs_inotify_add_watch_args guestfs_inotify_add_watch_args;

struct guestfs_inotify_add_watch_ret {
	int64_t wd;
};
typedef struct guestfs_inotify_add_watch_ret guestfs_inotify_add_watch_ret;

struct guestfs_inotify_files_ret {
	struct {
		u_int paths_len;
		guestfs_str *paths_val;
	} paths;
};
typedef struct guestfs_inotify_files_ret guestfs_inotify_files_ret;

struct guestfs_inotify_init_args {
	int maxevents;
};
typedef struct guestfs_inotify_init_args guestfs_inotify_init_args;

struct guestfs_inotify_read_ret {
	guestfs_int_inotify_event_list events;
};
typedef struct guestfs_inotify_read_ret guestfs_inotify_read_ret;

struct guestfs_inotify_rm_watch_args {
	int wd;
};
typedef struct guestfs_inotify_rm_watch_args guestfs_inotify_rm_watch_args;

struct guestfs_inspect_get_arch_args {
	char *root;
};
typedef struct guestfs_inspect_get_arch_args guestfs_inspect_get_arch_args;

struct guestfs_inspect_get_arch_ret {
	char *arch;
};
typedef struct guestfs_inspect_get_arch_ret guestfs_inspect_get_arch_ret;

struct guestfs_inspect_get_distro_args {
	char *root;
};
typedef struct guestfs_inspect_get_distro_args guestfs_inspect_get_distro_args;

struct guestfs_inspect_get_distro_ret {
	char *distro;
};
typedef struct guestfs_inspect_get_distro_ret guestfs_inspect_get_distro_ret;

struct guestfs_inspect_get_drive_mappings_args {
	char *root;
};
typedef struct guestfs_inspect_get_drive_mappings_args guestfs_inspect_get_drive_mappings_args;

struct guestfs_inspect_get_drive_mappings_ret {
	struct {
		u_int drives_len;
		guestfs_str *drives_val;
	} drives;
};
typedef struct guestfs_inspect_get_drive_mappings_ret guestfs_inspect_get_drive_mappings_ret;

struct guestfs_inspect_get_filesystems_args {
	char *root;
};
typedef struct guestfs_inspect_get_filesystems_args guestfs_inspect_get_filesystems_args;

struct guestfs_inspect_get_filesystems_ret {
	struct {
		u_int filesystems_len;
		guestfs_str *filesystems_val;
	} filesystems;
};
typedef struct guestfs_inspect_get_filesystems_ret guestfs_inspect_get_filesystems_ret;

struct guestfs_inspect_get_format_args {
	char *root;
};
typedef struct guestfs_inspect_get_format_args guestfs_inspect_get_format_args;

struct guestfs_inspect_get_format_ret {
	char *format;
};
typedef struct guestfs_inspect_get_format_ret guestfs_inspect_get_format_ret;

struct guestfs_inspect_get_hostname_args {
	char *root;
};
typedef struct guestfs_inspect_get_hostname_args guestfs_inspect_get_hostname_args;

struct guestfs_inspect_get_hostname_ret {
	char *hostname;
};
typedef struct guestfs_inspect_get_hostname_ret guestfs_inspect_get_hostname_ret;

struct guestfs_inspect_get_major_version_args {
	char *root;
};
typedef struct guestfs_inspect_get_major_version_args guestfs_inspect_get_major_version_args;

struct guestfs_inspect_get_major_version_ret {
	int major;
};
typedef struct guestfs_inspect_get_major_version_ret guestfs_inspect_get_major_version_ret;

struct guestfs_inspect_get_minor_version_args {
	char *root;
};
typedef struct guestfs_inspect_get_minor_version_args guestfs_inspect_get_minor_version_args;

struct guestfs_inspect_get_minor_version_ret {
	int minor;
};
typedef struct guestfs_inspect_get_minor_version_ret guestfs_inspect_get_minor_version_ret;

struct guestfs_inspect_get_mountpoints_args {
	char *root;
};
typedef struct guestfs_inspect_get_mountpoints_args guestfs_inspect_get_mountpoints_args;

struct guestfs_inspect_get_mountpoints_ret {
	struct {
		u_int mountpoints_len;
		guestfs_str *mountpoints_val;
	} mountpoints;
};
typedef struct guestfs_inspect_get_mountpoints_ret guestfs_inspect_get_mountpoints_ret;

struct guestfs_inspect_get_package_format_args {
	char *root;
};
typedef struct guestfs_inspect_get_package_format_args guestfs_inspect_get_package_format_args;

struct guestfs_inspect_get_package_format_ret {
	char *packageformat;
};
typedef struct guestfs_inspect_get_package_format_ret guestfs_inspect_get_package_format_ret;

struct guestfs_inspect_get_package_management_args {
	char *root;
};
typedef struct guestfs_inspect_get_package_management_args guestfs_inspect_get_package_management_args;

struct guestfs_inspect_get_package_management_ret {
	char *packagemanagement;
};
typedef struct guestfs_inspect_get_package_management_ret guestfs_inspect_get_package_management_ret;

struct guestfs_inspect_get_product_name_args {
	char *root;
};
typedef struct guestfs_inspect_get_product_name_args guestfs_inspect_get_product_name_args;

struct guestfs_inspect_get_product_name_ret {
	char *product;
};
typedef struct guestfs_inspect_get_product_name_ret guestfs_inspect_get_product_name_ret;

struct guestfs_inspect_get_product_variant_args {
	char *root;
};
typedef struct guestfs_inspect_get_product_variant_args guestfs_inspect_get_product_variant_args;

struct guestfs_inspect_get_product_variant_ret {
	char *variant;
};
typedef struct guestfs_inspect_get_product_variant_ret guestfs_inspect_get_product_variant_ret;

struct guestfs_inspect_get_roots_ret {
	struct {
		u_int roots_len;
		guestfs_str *roots_val;
	} roots;
};
typedef struct guestfs_inspect_get_roots_ret guestfs_inspect_get_roots_ret;

struct guestfs_inspect_get_type_args {
	char *root;
};
typedef struct guestfs_inspect_get_type_args guestfs_inspect_get_type_args;

struct guestfs_inspect_get_type_ret {
	char *name;
};
typedef struct guestfs_inspect_get_type_ret guestfs_inspect_get_type_ret;

struct guestfs_inspect_get_windows_current_control_set_args {
	char *root;
};
typedef struct guestfs_inspect_get_windows_current_control_set_args guestfs_inspect_get_windows_current_control_set_args;

struct guestfs_inspect_get_windows_current_control_set_ret {
	char *controlset;
};
typedef struct guestfs_inspect_get_windows_current_control_set_ret guestfs_inspect_get_windows_current_control_set_ret;

struct guestfs_inspect_get_windows_software_hive_args {
	char *root;
};
typedef struct guestfs_inspect_get_windows_software_hive_args guestfs_inspect_get_windows_software_hive_args;

struct guestfs_inspect_get_windows_software_hive_ret {
	char *path;
};
typedef struct guestfs_inspect_get_windows_software_hive_ret guestfs_inspect_get_windows_software_hive_ret;

struct guestfs_inspect_get_windows_system_hive_args {
	char *root;
};
typedef struct guestfs_inspect_get_windows_system_hive_args guestfs_inspect_get_windows_system_hive_args;

struct guestfs_inspect_get_windows_system_hive_ret {
	char *path;
};
typedef struct guestfs_inspect_get_windows_system_hive_ret guestfs_inspect_get_windows_system_hive_ret;

struct guestfs_inspect_get_windows_systemroot_args {
	char *root;
};
typedef struct guestfs_inspect_get_windows_systemroot_args guestfs_inspect_get_windows_systemroot_args;

struct guestfs_inspect_get_windows_systemroot_ret {
	char *systemroot;
};
typedef struct guestfs_inspect_get_windows_systemroot_ret guestfs_inspect_get_windows_systemroot_ret;

struct guestfs_inspect_is_live_args {
	char *root;
};
typedef struct guestfs_inspect_is_live_args guestfs_inspect_is_live_args;

struct guestfs_inspect_is_live_ret {
	bool_t live;
};
typedef struct guestfs_inspect_is_live_ret guestfs_inspect_is_live_ret;

struct guestfs_inspect_is_multipart_args {
	char *root;
};
typedef struct guestfs_inspect_is_multipart_args guestfs_inspect_is_multipart_args;

struct guestfs_inspect_is_multipart_ret {
	bool_t multipart;
};
typedef struct guestfs_inspect_is_multipart_ret guestfs_inspect_is_multipart_ret;

struct guestfs_inspect_is_netinst_args {
	char *root;
};
typedef struct guestfs_inspect_is_netinst_args guestfs_inspect_is_netinst_args;

struct guestfs_inspect_is_netinst_ret {
	bool_t netinst;
};
typedef struct guestfs_inspect_is_netinst_ret guestfs_inspect_is_netinst_ret;

struct guestfs_inspect_os_ret {
	struct {
		u_int roots_len;
		guestfs_str *roots_val;
	} roots;
};
typedef struct guestfs_inspect_os_ret guestfs_inspect_os_ret;

struct guestfs_internal_feature_available_args {
	char *group;
};
typedef struct guestfs_internal_feature_available_args guestfs_internal_feature_available_args;

struct guestfs_internal_feature_available_ret {
	int result;
};
typedef struct guestfs_internal_feature_available_ret guestfs_internal_feature_available_ret;

struct guestfs_internal_filesystem_walk_args {
	char *device;
};
typedef struct guestfs_internal_filesystem_walk_args guestfs_internal_filesystem_walk_args;

struct guestfs_internal_find_inode_args {
	char *device;
	int64_t inode;
};
typedef struct guestfs_internal_find_inode_args guestfs_internal_find_inode_args;

struct guestfs_internal_hot_add_drive_args {
	char *label;
};
typedef struct guestfs_internal_hot_add_drive_args guestfs_internal_hot_add_drive_args;

struct guestfs_internal_hot_remove_drive_args {
	char *label;
};
typedef struct guestfs_internal_hot_remove_drive_args guestfs_internal_hot_remove_drive_args;

struct guestfs_internal_hot_remove_drive_precheck_args {
	char *label;
};
typedef struct guestfs_internal_hot_remove_drive_precheck_args guestfs_internal_hot_remove_drive_precheck_args;

struct guestfs_internal_list_rpm_applications_ret {
	guestfs_int_application2_list applications2;
};
typedef struct guestfs_internal_list_rpm_applications_ret guestfs_internal_list_rpm_applications_ret;

struct guestfs_internal_lstatnslist_args {
	char *path;
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_internal_lstatnslist_args guestfs_internal_lstatnslist_args;

struct guestfs_internal_lstatnslist_ret {
	guestfs_int_statns_list statbufs;
};
typedef struct guestfs_internal_lstatnslist_ret guestfs_internal_lstatnslist_ret;

struct guestfs_internal_lxattrlist_args {
	char *path;
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_internal_lxattrlist_args guestfs_internal_lxattrlist_args;

struct guestfs_internal_lxattrlist_ret {
	guestfs_int_xattr_list xattrs;
};
typedef struct guestfs_internal_lxattrlist_ret guestfs_internal_lxattrlist_ret;

struct guestfs_internal_parse_mountable_args {
	char *mountable;
};
typedef struct guestfs_internal_parse_mountable_args guestfs_internal_parse_mountable_args;

struct guestfs_internal_parse_mountable_ret {
	guestfs_int_internal_mountable mountable;
};
typedef struct guestfs_internal_parse_mountable_ret guestfs_internal_parse_mountable_ret;

struct guestfs_internal_readlinklist_args {
	char *path;
	struct {
		u_int names_len;
		guestfs_str *names_val;
	} names;
};
typedef struct guestfs_internal_readlinklist_args guestfs_internal_readlinklist_args;

struct guestfs_internal_readlinklist_ret {
	struct {
		u_int links_len;
		guestfs_str *links_val;
	} links;
};
typedef struct guestfs_internal_readlinklist_ret guestfs_internal_readlinklist_ret;

struct guestfs_internal_rhbz914931_args {
	int count;
};
typedef struct guestfs_internal_rhbz914931_args guestfs_internal_rhbz914931_args;

struct guestfs_internal_upload_args {
	char *tmpname;
	int mode;
};
typedef struct guestfs_internal_upload_args guestfs_internal_upload_args;

struct guestfs_internal_write_args {
	char *path;
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_internal_write_args guestfs_internal_write_args;

struct guestfs_internal_write_append_args {
	char *path;
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_internal_write_append_args guestfs_internal_write_append_args;

struct guestfs_internal_yara_scan_args {
	char *path;
};
typedef struct guestfs_internal_yara_scan_args guestfs_internal_yara_scan_args;

struct guestfs_is_blockdev_args {
	char *path;
	bool_t followsymlinks;
};
typedef struct guestfs_is_blockdev_args guestfs_is_blockdev_args;

struct guestfs_is_blockdev_ret {
	bool_t flag;
};
typedef struct guestfs_is_blockdev_ret guestfs_is_blockdev_ret;

struct guestfs_is_chardev_args {
	char *path;
	bool_t followsymlinks;
};
typedef struct guestfs_is_chardev_args guestfs_is_chardev_args;

struct guestfs_is_chardev_ret {
	bool_t flag;
};
typedef struct guestfs_is_chardev_ret guestfs_is_chardev_ret;

struct guestfs_is_dir_args {
	char *path;
	bool_t followsymlinks;
};
typedef struct guestfs_is_dir_args guestfs_is_dir_args;

struct guestfs_is_dir_ret {
	bool_t dirflag;
};
typedef struct guestfs_is_dir_ret guestfs_is_dir_ret;

struct guestfs_is_fifo_args {
	char *path;
	bool_t followsymlinks;
};
typedef struct guestfs_is_fifo_args guestfs_is_fifo_args;

struct guestfs_is_fifo_ret {
	bool_t flag;
};
typedef struct guestfs_is_fifo_ret guestfs_is_fifo_ret;

struct guestfs_is_file_args {
	char *path;
	bool_t followsymlinks;
};
typedef struct guestfs_is_file_args guestfs_is_file_args;

struct guestfs_is_file_ret {
	bool_t fileflag;
};
typedef struct guestfs_is_file_ret guestfs_is_file_ret;

struct guestfs_is_lv_args {
	char *mountable;
};
typedef struct guestfs_is_lv_args guestfs_is_lv_args;

struct guestfs_is_lv_ret {
	bool_t lvflag;
};
typedef struct guestfs_is_lv_ret guestfs_is_lv_ret;

struct guestfs_is_socket_args {
	char *path;
	bool_t followsymlinks;
};
typedef struct guestfs_is_socket_args guestfs_is_socket_args;

struct guestfs_is_socket_ret {
	bool_t flag;
};
typedef struct guestfs_is_socket_ret guestfs_is_socket_ret;

struct guestfs_is_symlink_args {
	char *path;
};
typedef struct guestfs_is_symlink_args guestfs_is_symlink_args;

struct guestfs_is_symlink_ret {
	bool_t flag;
};
typedef struct guestfs_is_symlink_ret guestfs_is_symlink_ret;

struct guestfs_is_whole_device_args {
	char *device;
};
typedef struct guestfs_is_whole_device_args guestfs_is_whole_device_args;

struct guestfs_is_whole_device_ret {
	bool_t flag;
};
typedef struct guestfs_is_whole_device_ret guestfs_is_whole_device_ret;

struct guestfs_is_zero_args {
	char *path;
};
typedef struct guestfs_is_zero_args guestfs_is_zero_args;

struct guestfs_is_zero_ret {
	bool_t zeroflag;
};
typedef struct guestfs_is_zero_ret guestfs_is_zero_ret;

struct guestfs_is_zero_device_args {
	char *device;
};
typedef struct guestfs_is_zero_device_args guestfs_is_zero_device_args;

struct guestfs_is_zero_device_ret {
	bool_t zeroflag;
};
typedef struct guestfs_is_zero_device_ret guestfs_is_zero_device_ret;

struct guestfs_isoinfo_args {
	char *isofile;
};
typedef struct guestfs_isoinfo_args guestfs_isoinfo_args;

struct guestfs_isoinfo_ret {
	guestfs_int_isoinfo isodata;
};
typedef struct guestfs_isoinfo_ret guestfs_isoinfo_ret;

struct guestfs_isoinfo_device_args {
	char *device;
};
typedef struct guestfs_isoinfo_device_args guestfs_isoinfo_device_args;

struct guestfs_isoinfo_device_ret {
	guestfs_int_isoinfo isodata;
};
typedef struct guestfs_isoinfo_device_ret guestfs_isoinfo_device_ret;

struct guestfs_journal_get_data_threshold_ret {
	int64_t threshold;
};
typedef struct guestfs_journal_get_data_threshold_ret guestfs_journal_get_data_threshold_ret;

struct guestfs_journal_get_realtime_usec_ret {
	int64_t usec;
};
typedef struct guestfs_journal_get_realtime_usec_ret guestfs_journal_get_realtime_usec_ret;

struct guestfs_journal_next_ret {
	bool_t more;
};
typedef struct guestfs_journal_next_ret guestfs_journal_next_ret;

struct guestfs_journal_open_args {
	char *directory;
};
typedef struct guestfs_journal_open_args guestfs_journal_open_args;

struct guestfs_journal_set_data_threshold_args {
	int64_t threshold;
};
typedef struct guestfs_journal_set_data_threshold_args guestfs_journal_set_data_threshold_args;

struct guestfs_journal_skip_args {
	int64_t skip;
};
typedef struct guestfs_journal_skip_args guestfs_journal_skip_args;

struct guestfs_journal_skip_ret {
	int64_t rskip;
};
typedef struct guestfs_journal_skip_ret guestfs_journal_skip_ret;

struct guestfs_lchown_args {
	int owner;
	int group;
	char *path;
};
typedef struct guestfs_lchown_args guestfs_lchown_args;

struct guestfs_ldmtool_diskgroup_disks_args {
	char *diskgroup;
};
typedef struct guestfs_ldmtool_diskgroup_disks_args guestfs_ldmtool_diskgroup_disks_args;

struct guestfs_ldmtool_diskgroup_disks_ret {
	struct {
		u_int disks_len;
		guestfs_str *disks_val;
	} disks;
};
typedef struct guestfs_ldmtool_diskgroup_disks_ret guestfs_ldmtool_diskgroup_disks_ret;

struct guestfs_ldmtool_diskgroup_name_args {
	char *diskgroup;
};
typedef struct guestfs_ldmtool_diskgroup_name_args guestfs_ldmtool_diskgroup_name_args;

struct guestfs_ldmtool_diskgroup_name_ret {
	char *name;
};
typedef struct guestfs_ldmtool_diskgroup_name_ret guestfs_ldmtool_diskgroup_name_ret;

struct guestfs_ldmtool_diskgroup_volumes_args {
	char *diskgroup;
};
typedef struct guestfs_ldmtool_diskgroup_volumes_args guestfs_ldmtool_diskgroup_volumes_args;

struct guestfs_ldmtool_diskgroup_volumes_ret {
	struct {
		u_int volumes_len;
		guestfs_str *volumes_val;
	} volumes;
};
typedef struct guestfs_ldmtool_diskgroup_volumes_ret guestfs_ldmtool_diskgroup_volumes_ret;

struct guestfs_ldmtool_scan_ret {
	struct {
		u_int guids_len;
		guestfs_str *guids_val;
	} guids;
};
typedef struct guestfs_ldmtool_scan_ret guestfs_ldmtool_scan_ret;

struct guestfs_ldmtool_scan_devices_args {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_ldmtool_scan_devices_args guestfs_ldmtool_scan_devices_args;

struct guestfs_ldmtool_scan_devices_ret {
	struct {
		u_int guids_len;
		guestfs_str *guids_val;
	} guids;
};
typedef struct guestfs_ldmtool_scan_devices_ret guestfs_ldmtool_scan_devices_ret;

struct guestfs_ldmtool_volume_hint_args {
	char *diskgroup;
	char *volume;
};
typedef struct guestfs_ldmtool_volume_hint_args guestfs_ldmtool_volume_hint_args;

struct guestfs_ldmtool_volume_hint_ret {
	char *hint;
};
typedef struct guestfs_ldmtool_volume_hint_ret guestfs_ldmtool_volume_hint_ret;

struct guestfs_ldmtool_volume_partitions_args {
	char *diskgroup;
	char *volume;
};
typedef struct guestfs_ldmtool_volume_partitions_args guestfs_ldmtool_volume_partitions_args;

struct guestfs_ldmtool_volume_partitions_ret {
	struct {
		u_int partitions_len;
		guestfs_str *partitions_val;
	} partitions;
};
typedef struct guestfs_ldmtool_volume_partitions_ret guestfs_ldmtool_volume_partitions_ret;

struct guestfs_ldmtool_volume_type_args {
	char *diskgroup;
	char *volume;
};
typedef struct guestfs_ldmtool_volume_type_args guestfs_ldmtool_volume_type_args;

struct guestfs_ldmtool_volume_type_ret {
	char *voltype;
};
typedef struct guestfs_ldmtool_volume_type_ret guestfs_ldmtool_volume_type_ret;

struct guestfs_lgetxattr_args {
	char *path;
	char *name;
};
typedef struct guestfs_lgetxattr_args guestfs_lgetxattr_args;

struct guestfs_lgetxattr_ret {
	struct {
		u_int xattr_len;
		char *xattr_val;
	} xattr;
};
typedef struct guestfs_lgetxattr_ret guestfs_lgetxattr_ret;

struct guestfs_lgetxattrs_args {
	char *path;
};
typedef struct guestfs_lgetxattrs_args guestfs_lgetxattrs_args;

struct guestfs_lgetxattrs_ret {
	guestfs_int_xattr_list xattrs;
};
typedef struct guestfs_lgetxattrs_ret guestfs_lgetxattrs_ret;

struct guestfs_list_9p_ret {
	struct {
		u_int mounttags_len;
		guestfs_str *mounttags_val;
	} mounttags;
};
typedef struct guestfs_list_9p_ret guestfs_list_9p_ret;

struct guestfs_list_devices_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_devices_ret guestfs_list_devices_ret;

struct guestfs_list_disk_labels_ret {
	struct {
		u_int labels_len;
		guestfs_str *labels_val;
	} labels;
};
typedef struct guestfs_list_disk_labels_ret guestfs_list_disk_labels_ret;

struct guestfs_list_dm_devices_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_dm_devices_ret guestfs_list_dm_devices_ret;

struct guestfs_list_filesystems_ret {
	struct {
		u_int fses_len;
		guestfs_str *fses_val;
	} fses;
};
typedef struct guestfs_list_filesystems_ret guestfs_list_filesystems_ret;

struct guestfs_list_ldm_partitions_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_ldm_partitions_ret guestfs_list_ldm_partitions_ret;

struct guestfs_list_ldm_volumes_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_ldm_volumes_ret guestfs_list_ldm_volumes_ret;

struct guestfs_list_md_devices_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_list_md_devices_ret guestfs_list_md_devices_ret;

struct guestfs_list_partitions_ret {
	struct {
		u_int partitions_len;
		guestfs_str *partitions_val;
	} partitions;
};
typedef struct guestfs_list_partitions_ret guestfs_list_partitions_ret;

struct guestfs_ll_args {
	char *directory;
};
typedef struct guestfs_ll_args guestfs_ll_args;

struct guestfs_ll_ret {
	char *listing;
};
typedef struct guestfs_ll_ret guestfs_ll_ret;

struct guestfs_llz_args {
	char *directory;
};
typedef struct guestfs_llz_args guestfs_llz_args;

struct guestfs_llz_ret {
	char *listing;
};
typedef struct guestfs_llz_ret guestfs_llz_ret;

struct guestfs_ln_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_args guestfs_ln_args;

struct guestfs_ln_f_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_f_args guestfs_ln_f_args;

struct guestfs_ln_s_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_s_args guestfs_ln_s_args;

struct guestfs_ln_sf_args {
	char *target;
	char *linkname;
};
typedef struct guestfs_ln_sf_args guestfs_ln_sf_args;

struct guestfs_lremovexattr_args {
	char *xattr;
	char *path;
};
typedef struct guestfs_lremovexattr_args guestfs_lremovexattr_args;

struct guestfs_ls0_args {
	char *dir;
};
typedef struct guestfs_ls0_args guestfs_ls0_args;

struct guestfs_lsetxattr_args {
	char *xattr;
	char *val;
	int vallen;
	char *path;
};
typedef struct guestfs_lsetxattr_args guestfs_lsetxattr_args;

struct guestfs_lstatns_args {
	char *path;
};
typedef struct guestfs_lstatns_args guestfs_lstatns_args;

struct guestfs_lstatns_ret {
	guestfs_int_statns statbuf;
};
typedef struct guestfs_lstatns_ret guestfs_lstatns_ret;

struct guestfs_luks_add_key_args {
	char *device;
	char *key;
	char *newkey;
	int keyslot;
};
typedef struct guestfs_luks_add_key_args guestfs_luks_add_key_args;

struct guestfs_luks_close_args {
	char *device;
};
typedef struct guestfs_luks_close_args guestfs_luks_close_args;

struct guestfs_luks_format_args {
	char *device;
	char *key;
	int keyslot;
};
typedef struct guestfs_luks_format_args guestfs_luks_format_args;

struct guestfs_luks_format_cipher_args {
	char *device;
	char *key;
	int keyslot;
	char *cipher;
};
typedef struct guestfs_luks_format_cipher_args guestfs_luks_format_cipher_args;

struct guestfs_luks_kill_slot_args {
	char *device;
	char *key;
	int keyslot;
};
typedef struct guestfs_luks_kill_slot_args guestfs_luks_kill_slot_args;

struct guestfs_luks_open_args {
	char *device;
	char *key;
	char *mapname;
};
typedef struct guestfs_luks_open_args guestfs_luks_open_args;

struct guestfs_luks_open_ro_args {
	char *device;
	char *key;
	char *mapname;
};
typedef struct guestfs_luks_open_ro_args guestfs_luks_open_ro_args;

struct guestfs_luks_uuid_args {
	char *device;
};
typedef struct guestfs_luks_uuid_args guestfs_luks_uuid_args;

struct guestfs_luks_uuid_ret {
	char *uuid;
};
typedef struct guestfs_luks_uuid_ret guestfs_luks_uuid_ret;

struct guestfs_lvcreate_args {
	char *logvol;
	char *volgroup;
	int mbytes;
};
typedef struct guestfs_lvcreate_args guestfs_lvcreate_args;

struct guestfs_lvcreate_free_args {
	char *logvol;
	char *volgroup;
	int percent;
};
typedef struct guestfs_lvcreate_free_args guestfs_lvcreate_free_args;

struct guestfs_lvm_canonical_lv_name_args {
	char *lvname;
};
typedef struct guestfs_lvm_canonical_lv_name_args guestfs_lvm_canonical_lv_name_args;

struct guestfs_lvm_canonical_lv_name_ret {
	char *lv;
};
typedef struct guestfs_lvm_canonical_lv_name_ret guestfs_lvm_canonical_lv_name_ret;

struct guestfs_lvm_scan_args {
	bool_t activate;
};
typedef struct guestfs_lvm_scan_args guestfs_lvm_scan_args;

struct guestfs_lvm_set_filter_args {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_lvm_set_filter_args guestfs_lvm_set_filter_args;

struct guestfs_lvremove_args {
	char *device;
};
typedef struct guestfs_lvremove_args guestfs_lvremove_args;

struct guestfs_lvrename_args {
	char *logvol;
	char *newlogvol;
};
typedef struct guestfs_lvrename_args guestfs_lvrename_args;

struct guestfs_lvresize_args {
	char *device;
	int mbytes;
};
typedef struct guestfs_lvresize_args guestfs_lvresize_args;

struct guestfs_lvresize_free_args {
	char *lv;
	int percent;
};
typedef struct guestfs_lvresize_free_args guestfs_lvresize_free_args;

struct guestfs_lvs_ret {
	struct {
		u_int logvols_len;
		guestfs_str *logvols_val;
	} logvols;
};
typedef struct guestfs_lvs_ret guestfs_lvs_ret;

struct guestfs_lvs_full_ret {
	guestfs_int_lvm_lv_list logvols;
};
typedef struct guestfs_lvs_full_ret guestfs_lvs_full_ret;

struct guestfs_lvuuid_args {
	char *device;
};
typedef struct guestfs_lvuuid_args guestfs_lvuuid_args;

struct guestfs_lvuuid_ret {
	char *uuid;
};
typedef struct guestfs_lvuuid_ret guestfs_lvuuid_ret;

struct guestfs_md_create_args {
	char *name;
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
	int64_t missingbitmap;
	int nrdevices;
	int spare;
	int64_t chunk;
	char *level;
};
typedef struct guestfs_md_create_args guestfs_md_create_args;

struct guestfs_md_detail_args {
	char *md;
};
typedef struct guestfs_md_detail_args guestfs_md_detail_args;

struct guestfs_md_detail_ret {
	struct {
		u_int info_len;
		guestfs_str *info_val;
	} info;
};
typedef struct guestfs_md_detail_ret guestfs_md_detail_ret;

struct guestfs_md_stat_args {
	char *md;
};
typedef struct guestfs_md_stat_args guestfs_md_stat_args;

struct guestfs_md_stat_ret {
	guestfs_int_mdstat_list devices;
};
typedef struct guestfs_md_stat_ret guestfs_md_stat_ret;

struct guestfs_md_stop_args {
	char *md;
};
typedef struct guestfs_md_stop_args guestfs_md_stop_args;

struct guestfs_mkdir_args {
	char *path;
};
typedef struct guestfs_mkdir_args guestfs_mkdir_args;

struct guestfs_mkdir_mode_args {
	char *path;
	int mode;
};
typedef struct guestfs_mkdir_mode_args guestfs_mkdir_mode_args;

struct guestfs_mkdir_p_args {
	char *path;
};
typedef struct guestfs_mkdir_p_args guestfs_mkdir_p_args;

struct guestfs_mkdtemp_args {
	char *tmpl;
};
typedef struct guestfs_mkdtemp_args guestfs_mkdtemp_args;

struct guestfs_mkdtemp_ret {
	char *dir;
};
typedef struct guestfs_mkdtemp_ret guestfs_mkdtemp_ret;

struct guestfs_mke2fs_args {
	char *device;
	int64_t blockscount;
	int64_t blocksize;
	int64_t fragsize;
	int64_t blockspergroup;
	int64_t numberofgroups;
	int64_t bytesperinode;
	int64_t inodesize;
	int64_t journalsize;
	int64_t numberofinodes;
	int64_t stridesize;
	int64_t stripewidth;
	int64_t maxonlineresize;
	int reservedblockspercentage;
	int mmpupdateinterval;
	char *journaldevice;
	char *label;
	char *lastmounteddir;
	char *creatoros;
	char *fstype;
	char *usagetype;
	char *uuid;
	bool_t forcecreate;
	bool_t writesbandgrouponly;
	bool_t lazyitableinit;
	bool_t lazyjournalinit;
	bool_t testfs;
	bool_t discard;
	bool_t quotatype;
	bool_t extent;
	bool_t filetype;
	bool_t flexbg;
	bool_t hasjournal;
	bool_t journaldev;
	bool_t largefile;
	bool_t quota;
	bool_t resizeinode;
	bool_t sparsesuper;
	bool_t uninitbg;
};
typedef struct guestfs_mke2fs_args guestfs_mke2fs_args;

struct guestfs_mke2fs_J_args {
	char *fstype;
	int blocksize;
	char *device;
	char *journal;
};
typedef struct guestfs_mke2fs_J_args guestfs_mke2fs_J_args;

struct guestfs_mke2fs_JL_args {
	char *fstype;
	int blocksize;
	char *device;
	char *label;
};
typedef struct guestfs_mke2fs_JL_args guestfs_mke2fs_JL_args;

struct guestfs_mke2fs_JU_args {
	char *fstype;
	int blocksize;
	char *device;
	char *uuid;
};
typedef struct guestfs_mke2fs_JU_args guestfs_mke2fs_JU_args;

struct guestfs_mke2journal_args {
	int blocksize;
	char *device;
};
typedef struct guestfs_mke2journal_args guestfs_mke2journal_args;

struct guestfs_mke2journal_L_args {
	int blocksize;
	char *label;
	char *device;
};
typedef struct guestfs_mke2journal_L_args guestfs_mke2journal_L_args;

struct guestfs_mke2journal_U_args {
	int blocksize;
	char *uuid;
	char *device;
};
typedef struct guestfs_mke2journal_U_args guestfs_mke2journal_U_args;

struct guestfs_mkfifo_args {
	int mode;
	char *path;
};
typedef struct guestfs_mkfifo_args guestfs_mkfifo_args;

struct guestfs_mkfs_args {
	char *fstype;
	char *device;
	int blocksize;
	char *features;
	int inode;
	int sectorsize;
	char *label;
};
typedef struct guestfs_mkfs_args guestfs_mkfs_args;

struct guestfs_mkfs_b_args {
	char *fstype;
	int blocksize;
	char *device;
};
typedef struct guestfs_mkfs_b_args guestfs_mkfs_b_args;

struct guestfs_mkfs_btrfs_args {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
	int64_t allocstart;
	int64_t bytecount;
	char *datatype;
	int leafsize;
	char *label;
	char *metadata;
	int nodesize;
	int sectorsize;
};
typedef struct guestfs_mkfs_btrfs_args guestfs_mkfs_btrfs_args;

struct guestfs_mklost_and_found_args {
	char *mountpoint;
};
typedef struct guestfs_mklost_and_found_args guestfs_mklost_and_found_args;

struct guestfs_mkmountpoint_args {
	char *exemptpath;
};
typedef struct guestfs_mkmountpoint_args guestfs_mkmountpoint_args;

struct guestfs_mknod_args {
	int mode;
	int devmajor;
	int devminor;
	char *path;
};
typedef struct guestfs_mknod_args guestfs_mknod_args;

struct guestfs_mknod_b_args {
	int mode;
	int devmajor;
	int devminor;
	char *path;
};
typedef struct guestfs_mknod_b_args guestfs_mknod_b_args;

struct guestfs_mknod_c_args {
	int mode;
	int devmajor;
	int devminor;
	char *path;
};
typedef struct guestfs_mknod_c_args guestfs_mknod_c_args;

struct guestfs_mksquashfs_args {
	char *path;
	char *compress;
	struct {
		u_int excludes_len;
		guestfs_str *excludes_val;
	} excludes;
};
typedef struct guestfs_mksquashfs_args guestfs_mksquashfs_args;

struct guestfs_mkswap_args {
	char *device;
	char *label;
	char *uuid;
};
typedef struct guestfs_mkswap_args guestfs_mkswap_args;

struct guestfs_mkswap_L_args {
	char *label;
	char *device;
};
typedef struct guestfs_mkswap_L_args guestfs_mkswap_L_args;

struct guestfs_mkswap_U_args {
	char *uuid;
	char *device;
};
typedef struct guestfs_mkswap_U_args guestfs_mkswap_U_args;

struct guestfs_mkswap_file_args {
	char *path;
};
typedef struct guestfs_mkswap_file_args guestfs_mkswap_file_args;

struct guestfs_mktemp_args {
	char *tmpl;
	char *suffix;
};
typedef struct guestfs_mktemp_args guestfs_mktemp_args;

struct guestfs_mktemp_ret {
	char *path;
};
typedef struct guestfs_mktemp_ret guestfs_mktemp_ret;

struct guestfs_modprobe_args {
	char *modulename;
};
typedef struct guestfs_modprobe_args guestfs_modprobe_args;

struct guestfs_mount_args {
	char *mountable;
	char *mountpoint;
};
typedef struct guestfs_mount_args guestfs_mount_args;

struct guestfs_mount_9p_args {
	char *mounttag;
	char *mountpoint;
	char *options;
};
typedef struct guestfs_mount_9p_args guestfs_mount_9p_args;

struct guestfs_mount_loop_args {
	char *file;
	char *mountpoint;
};
typedef struct guestfs_mount_loop_args guestfs_mount_loop_args;

struct guestfs_mount_options_args {
	char *options;
	char *mountable;
	char *mountpoint;
};
typedef struct guestfs_mount_options_args guestfs_mount_options_args;

struct guestfs_mount_ro_args {
	char *mountable;
	char *mountpoint;
};
typedef struct guestfs_mount_ro_args guestfs_mount_ro_args;

struct guestfs_mount_vfs_args {
	char *options;
	char *vfstype;
	char *mountable;
	char *mountpoint;
};
typedef struct guestfs_mount_vfs_args guestfs_mount_vfs_args;

struct guestfs_mountpoints_ret {
	struct {
		u_int mps_len;
		guestfs_str *mps_val;
	} mps;
};
typedef struct guestfs_mountpoints_ret guestfs_mountpoints_ret;

struct guestfs_mounts_ret {
	struct {
		u_int devices_len;
		guestfs_str *devices_val;
	} devices;
};
typedef struct guestfs_mounts_ret guestfs_mounts_ret;

struct guestfs_mv_args {
	char *src;
	char *dest;
};
typedef struct guestfs_mv_args guestfs_mv_args;

struct guestfs_nr_devices_ret {
	int nrdisks;
};
typedef struct guestfs_nr_devices_ret guestfs_nr_devices_ret;

struct guestfs_ntfs_3g_probe_args {
	bool_t rw;
	char *device;
};
typedef struct guestfs_ntfs_3g_probe_args guestfs_ntfs_3g_probe_args;

struct guestfs_ntfs_3g_probe_ret {
	int status;
};
typedef struct guestfs_ntfs_3g_probe_ret guestfs_ntfs_3g_probe_ret;

struct guestfs_ntfscat_i_args {
	char *device;
	int64_t inode;
};
typedef struct guestfs_ntfscat_i_args guestfs_ntfscat_i_args;

struct guestfs_ntfsclone_in_args {
	char *device;
};
typedef struct guestfs_ntfsclone_in_args guestfs_ntfsclone_in_args;

struct guestfs_ntfsclone_out_args {
	char *device;
	bool_t metadataonly;
	bool_t rescue;
	bool_t ignorefscheck;
	bool_t preservetimestamps;
	bool_t force;
};
typedef struct guestfs_ntfsclone_out_args guestfs_ntfsclone_out_args;

struct guestfs_ntfsfix_args {
	char *device;
	bool_t clearbadsectors;
};
typedef struct guestfs_ntfsfix_args guestfs_ntfsfix_args;

struct guestfs_ntfsresize_args {
	char *device;
	int64_t size;
	bool_t force;
};
typedef struct guestfs_ntfsresize_args guestfs_ntfsresize_args;

struct guestfs_ntfsresize_size_args {
	char *device;
	int64_t size;
};
typedef struct guestfs_ntfsresize_size_args guestfs_ntfsresize_size_args;

struct guestfs_part_add_args {
	char *device;
	char *prlogex;
	int64_t startsect;
	int64_t endsect;
};
typedef struct guestfs_part_add_args guestfs_part_add_args;

struct guestfs_part_del_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_del_args guestfs_part_del_args;

struct guestfs_part_disk_args {
	char *device;
	char *parttype;
};
typedef struct guestfs_part_disk_args guestfs_part_disk_args;

struct guestfs_part_expand_gpt_args {
	char *device;
};
typedef struct guestfs_part_expand_gpt_args guestfs_part_expand_gpt_args;

struct guestfs_part_get_bootable_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_bootable_args guestfs_part_get_bootable_args;

struct guestfs_part_get_bootable_ret {
	bool_t bootable;
};
typedef struct guestfs_part_get_bootable_ret guestfs_part_get_bootable_ret;

struct guestfs_part_get_disk_guid_args {
	char *device;
};
typedef struct guestfs_part_get_disk_guid_args guestfs_part_get_disk_guid_args;

struct guestfs_part_get_disk_guid_ret {
	char *guid;
};
typedef struct guestfs_part_get_disk_guid_ret guestfs_part_get_disk_guid_ret;

struct guestfs_part_get_gpt_attributes_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_gpt_attributes_args guestfs_part_get_gpt_attributes_args;

struct guestfs_part_get_gpt_attributes_ret {
	int64_t attributes;
};
typedef struct guestfs_part_get_gpt_attributes_ret guestfs_part_get_gpt_attributes_ret;

struct guestfs_part_get_gpt_guid_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_gpt_guid_args guestfs_part_get_gpt_guid_args;

struct guestfs_part_get_gpt_guid_ret {
	char *guid;
};
typedef struct guestfs_part_get_gpt_guid_ret guestfs_part_get_gpt_guid_ret;

struct guestfs_part_get_gpt_type_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_gpt_type_args guestfs_part_get_gpt_type_args;

struct guestfs_part_get_gpt_type_ret {
	char *guid;
};
typedef struct guestfs_part_get_gpt_type_ret guestfs_part_get_gpt_type_ret;

struct guestfs_part_get_mbr_id_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_mbr_id_args guestfs_part_get_mbr_id_args;

struct guestfs_part_get_mbr_id_ret {
	int idbyte;
};
typedef struct guestfs_part_get_mbr_id_ret guestfs_part_get_mbr_id_ret;

struct guestfs_part_get_mbr_part_type_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_mbr_part_type_args guestfs_part_get_mbr_part_type_args;

struct guestfs_part_get_mbr_part_type_ret {
	char *partitiontype;
};
typedef struct guestfs_part_get_mbr_part_type_ret guestfs_part_get_mbr_part_type_ret;

struct guestfs_part_get_name_args {
	char *device;
	int partnum;
};
typedef struct guestfs_part_get_name_args guestfs_part_get_name_args;

struct guestfs_part_get_name_ret {
	char *name;
};
typedef struct guestfs_part_get_name_ret guestfs_part_get_name_ret;

struct guestfs_part_get_parttype_args {
	char *device;
};
typedef struct guestfs_part_get_parttype_args guestfs_part_get_parttype_args;

struct guestfs_part_get_parttype_ret {
	char *parttype;
};
typedef struct guestfs_part_get_parttype_ret guestfs_part_get_parttype_ret;

struct guestfs_part_init_args {
	char *device;
	char *parttype;
};
typedef struct guestfs_part_init_args guestfs_part_init_args;

struct guestfs_part_list_args {
	char *device;
};
typedef struct guestfs_part_list_args guestfs_part_list_args;

struct guestfs_part_list_ret {
	guestfs_int_partition_list partitions;
};
typedef struct guestfs_part_list_ret guestfs_part_list_ret;

struct guestfs_part_resize_args {
	char *device;
	int partnum;
	int64_t endsect;
};
typedef struct guestfs_part_resize_args guestfs_part_resize_args;

struct guestfs_part_set_bootable_args {
	char *device;
	int partnum;
	bool_t bootable;
};
typedef struct guestfs_part_set_bootable_args guestfs_part_set_bootable_args;

struct guestfs_part_set_disk_guid_args {
	char *device;
	char *guid;
};
typedef struct guestfs_part_set_disk_guid_args guestfs_part_set_disk_guid_args;

struct guestfs_part_set_disk_guid_random_args {
	char *device;
};
typedef struct guestfs_part_set_disk_guid_random_args guestfs_part_set_disk_guid_random_args;

struct guestfs_part_set_gpt_attributes_args {
	char *device;
	int partnum;
	int64_t attributes;
};
typedef struct guestfs_part_set_gpt_attributes_args guestfs_part_set_gpt_attributes_args;

struct guestfs_part_set_gpt_guid_args {
	char *device;
	int partnum;
	char *guid;
};
typedef struct guestfs_part_set_gpt_guid_args guestfs_part_set_gpt_guid_args;

struct guestfs_part_set_gpt_type_args {
	char *device;
	int partnum;
	char *guid;
};
typedef struct guestfs_part_set_gpt_type_args guestfs_part_set_gpt_type_args;

struct guestfs_part_set_mbr_id_args {
	char *device;
	int partnum;
	int idbyte;
};
typedef struct guestfs_part_set_mbr_id_args guestfs_part_set_mbr_id_args;

struct guestfs_part_set_name_args {
	char *device;
	int partnum;
	char *name;
};
typedef struct guestfs_part_set_name_args guestfs_part_set_name_args;

struct guestfs_part_to_dev_args {
	char *partition;
};
typedef struct guestfs_part_to_dev_args guestfs_part_to_dev_args;

struct guestfs_part_to_dev_ret {
	char *device;
};
typedef struct guestfs_part_to_dev_ret guestfs_part_to_dev_ret;

struct guestfs_part_to_partnum_args {
	char *partition;
};
typedef struct guestfs_part_to_partnum_args guestfs_part_to_partnum_args;

struct guestfs_part_to_partnum_ret {
	int partnum;
};
typedef struct guestfs_part_to_partnum_ret guestfs_part_to_partnum_ret;

struct guestfs_pread_args {
	char *path;
	int count;
	int64_t offset;
};
typedef struct guestfs_pread_args guestfs_pread_args;

struct guestfs_pread_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_pread_ret guestfs_pread_ret;

struct guestfs_pread_device_args {
	char *device;
	int count;
	int64_t offset;
};
typedef struct guestfs_pread_device_args guestfs_pread_device_args;

struct guestfs_pread_device_ret {
	struct {
		u_int content_len;
		char *content_val;
	} content;
};
typedef struct guestfs_pread_device_ret guestfs_pread_device_ret;

struct guestfs_pvchange_uuid_args {
	char *device;
};
typedef struct guestfs_pvchange_uuid_args guestfs_pvchange_uuid_args;

struct guestfs_pvcreate_args {
	char *device;
};
typedef struct guestfs_pvcreate_args guestfs_pvcreate_args;

struct guestfs_pvremove_args {
	char *device;
};
typedef struct guestfs_pvremove_args guestfs_pvremove_args;

struct guestfs_pvresize_args {
	char *device;
};
typedef struct guestfs_pvresize_args guestfs_pvresize_args;

struct guestfs_pvresize_size_args {
	char *device;
	int64_t size;
};
typedef struct guestfs_pvresize_size_args guestfs_pvresize_size_args;

struct guestfs_pvs_ret {
	struct {
		u_int physvols_len;
		guestfs_str *physvols_val;
	} physvols;
};
typedef struct guestfs_pvs_ret guestfs_pvs_ret;

struct guestfs_pvs_full_ret {
	guestfs_int_lvm_pv_list physvols;
};
typedef struct guestfs_pvs_full_ret guestfs_pvs_full_ret;

struct guestfs_pvuuid_args {
	char *device;
};
typedef struct guestfs_pvuuid_args guestfs_pvuuid_args;

struct guestfs_pvuuid_ret {
	char *uuid;
};
typedef struct guestfs_pvuuid_ret guestfs_pvuuid_ret;

struct guestfs_pwrite_args {
	char *path;
	struct {
		u_int content_len;
		char *content_val;
	} content;
	int64_t offset;
};
typedef struct guestfs_pwrite_args guestfs_pwrite_args;

struct guestfs_pwrite_ret {
	int nbytes;
};
typedef struct guestfs_pwrite_ret guestfs_pwrite_ret;

struct guestfs_pwrite_device_args {
	char *device;
	struct {
		u_int content_len;
		char *content_val;
	} content;
	int64_t offset;
};
typedef struct guestfs_pwrite_device_args guestfs_pwrite_device_args;

struct guestfs_pwrite_device_ret {
	int nbytes;
};
typedef struct guestfs_pwrite_device_ret guestfs_pwrite_device_ret;

struct guestfs_readdir_args {
	char *dir;
};
typedef struct guestfs_readdir_args guestfs_readdir_args;

struct guestfs_readdir_ret {
	guestfs_int_dirent_list entries;
};
typedef struct guestfs_readdir_ret guestfs_readdir_ret;

struct guestfs_readlink_args {
	char *path;
};
typedef struct guestfs_readlink_args guestfs_readlink_args;

struct guestfs_readlink_ret {
	char *link;
};
typedef struct guestfs_readlink_ret guestfs_readlink_ret;

struct guestfs_realpath_args {
	char *path;
};
typedef struct guestfs_realpath_args guestfs_realpath_args;

struct guestfs_realpath_ret {
	char *rpath;
};
typedef struct guestfs_realpath_ret guestfs_realpath_ret;

struct guestfs_remount_args {
	char *mountpoint;
	bool_t rw;
};
typedef struct guestfs_remount_args guestfs_remount_args;

struct guestfs_removexattr_args {
	char *xattr;
	char *path;
};
typedef struct guestfs_removexattr_args guestfs_removexattr_args;

struct guestfs_rename_args {
	char *oldpath;
	char *newpath;
};
typedef struct guestfs_rename_args guestfs_rename_args;

struct guestfs_resize2fs_args {
	char *device;
};
typedef struct guestfs_resize2fs_args guestfs_resize2fs_args;

struct guestfs_resize2fs_M_args {
	char *device;
};
typedef struct guestfs_resize2fs_M_args guestfs_resize2fs_M_args;

struct guestfs_resize2fs_size_args {
	char *device;
	int64_t size;
};
typedef struct guestfs_resize2fs_size_args guestfs_resize2fs_size_args;

struct guestfs_rm_args {
	char *path;
};
typedef struct guestfs_rm_args guestfs_rm_args;

struct guestfs_rm_f_args {
	char *path;
};
typedef struct guestfs_rm_f_args guestfs_rm_f_args;

struct guestfs_rm_rf_args {
	char *path;
};
typedef struct guestfs_rm_rf_args guestfs_rm_rf_args;

struct guestfs_rmdir_args {
	char *path;
};
typedef struct guestfs_rmdir_args guestfs_rmdir_args;

struct guestfs_rmmountpoint_args {
	char *exemptpath;
};
typedef struct guestfs_rmmountpoint_args guestfs_rmmountpoint_args;

struct guestfs_rsync_args {
	char *src;
	char *dest;
	bool_t archive;
	bool_t deletedest;
};
typedef struct guestfs_rsync_args guestfs_rsync_args;

struct guestfs_rsync_in_args {
	char *remote;
	char *dest;
	bool_t archive;
	bool_t deletedest;
};
typedef struct guestfs_rsync_in_args guestfs_rsync_in_args;

struct guestfs_rsync_out_args {
	char *src;
	char *remote;
	bool_t archive;
	bool_t deletedest;
};
typedef struct guestfs_rsync_out_args guestfs_rsync_out_args;

struct guestfs_scrub_device_args {
	char *device;
};
typedef struct guestfs_scrub_device_args guestfs_scrub_device_args;

struct guestfs_scrub_file_args {
	char *file;
};
typedef struct guestfs_scrub_file_args guestfs_scrub_file_args;

struct guestfs_scrub_freespace_args {
	char *dir;
};
typedef struct guestfs_scrub_freespace_args guestfs_scrub_freespace_args;

struct guestfs_selinux_relabel_args {
	char *specfile;
	char *path;
	bool_t force;
};
typedef struct guestfs_selinux_relabel_args guestfs_selinux_relabel_args;

struct guestfs_set_e2attrs_args {
	char *file;
	char *attrs;
	bool_t clear;
};
typedef struct guestfs_set_e2attrs_args guestfs_set_e2attrs_args;

struct guestfs_set_e2generation_args {
	char *file;
	int64_t generation;
};
typedef struct guestfs_set_e2generation_args guestfs_set_e2generation_args;

struct guestfs_set_e2label_args {
	char *device;
	char *label;
};
typedef struct guestfs_set_e2label_args guestfs_set_e2label_args;

struct guestfs_set_e2uuid_args {
	char *device;
	char *uuid;
};
typedef struct guestfs_set_e2uuid_args guestfs_set_e2uuid_args;

struct guestfs_set_label_args {
	char *mountable;
	char *label;
};
typedef struct guestfs_set_label_args guestfs_set_label_args;

struct guestfs_set_uuid_args {
	char *device;
	char *uuid;
};
typedef struct guestfs_set_uuid_args guestfs_set_uuid_args;

struct guestfs_set_uuid_random_args {
	char *device;
};
typedef struct guestfs_set_uuid_random_args guestfs_set_uuid_random_args;

struct guestfs_setcon_args {
	char *context;
};
typedef struct guestfs_setcon_args guestfs_setcon_args;

struct guestfs_setxattr_args {
	char *xattr;
	char *val;
	int vallen;
	char *path;
};
typedef struct guestfs_setxattr_args guestfs_setxattr_args;

struct guestfs_sfdisk_args {
	char *device;
	int cyls;
	int heads;
	int sectors;
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_sfdisk_args guestfs_sfdisk_args;

struct guestfs_sfdiskM_args {
	char *device;
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_sfdiskM_args guestfs_sfdiskM_args;

struct guestfs_sfdisk_N_args {
	char *device;
	int partnum;
	int cyls;
	int heads;
	int sectors;
	char *line;
};
typedef struct guestfs_sfdisk_N_args guestfs_sfdisk_N_args;

struct guestfs_sfdisk_disk_geometry_args {
	char *device;
};
typedef struct guestfs_sfdisk_disk_geometry_args guestfs_sfdisk_disk_geometry_args;

struct guestfs_sfdisk_disk_geometry_ret {
	char *partitions;
};
typedef struct guestfs_sfdisk_disk_geometry_ret guestfs_sfdisk_disk_geometry_ret;

struct guestfs_sfdisk_kernel_geometry_args {
	char *device;
};
typedef struct guestfs_sfdisk_kernel_geometry_args guestfs_sfdisk_kernel_geometry_args;

struct guestfs_sfdisk_kernel_geometry_ret {
	char *partitions;
};
typedef struct guestfs_sfdisk_kernel_geometry_ret guestfs_sfdisk_kernel_geometry_ret;

struct guestfs_sfdisk_l_args {
	char *device;
};
typedef struct guestfs_sfdisk_l_args guestfs_sfdisk_l_args;

struct guestfs_sfdisk_l_ret {
	char *partitions;
};
typedef struct guestfs_sfdisk_l_ret guestfs_sfdisk_l_ret;

struct guestfs_sh_args {
	char *command;
};
typedef struct guestfs_sh_args guestfs_sh_args;

struct guestfs_sh_ret {
	char *output;
};
typedef struct guestfs_sh_ret guestfs_sh_ret;

struct guestfs_sh_lines_args {
	char *command;
};
typedef struct guestfs_sh_lines_args guestfs_sh_lines_args;

struct guestfs_sh_lines_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_sh_lines_ret guestfs_sh_lines_ret;

struct guestfs_sleep_args {
	int secs;
};
typedef struct guestfs_sleep_args guestfs_sleep_args;

struct guestfs_statns_args {
	char *path;
};
typedef struct guestfs_statns_args guestfs_statns_args;

struct guestfs_statns_ret {
	guestfs_int_statns statbuf;
};
typedef struct guestfs_statns_ret guestfs_statns_ret;

struct guestfs_statvfs_args {
	char *path;
};
typedef struct guestfs_statvfs_args guestfs_statvfs_args;

struct guestfs_statvfs_ret {
	guestfs_int_statvfs statbuf;
};
typedef struct guestfs_statvfs_ret guestfs_statvfs_ret;

struct guestfs_strings_args {
	char *path;
};
typedef struct guestfs_strings_args guestfs_strings_args;

struct guestfs_strings_ret {
	struct {
		u_int stringsout_len;
		guestfs_str *stringsout_val;
	} stringsout;
};
typedef struct guestfs_strings_ret guestfs_strings_ret;

struct guestfs_strings_e_args {
	char *encoding;
	char *path;
};
typedef struct guestfs_strings_e_args guestfs_strings_e_args;

struct guestfs_strings_e_ret {
	struct {
		u_int stringsout_len;
		guestfs_str *stringsout_val;
	} stringsout;
};
typedef struct guestfs_strings_e_ret guestfs_strings_e_ret;

struct guestfs_swapoff_device_args {
	char *device;
};
typedef struct guestfs_swapoff_device_args guestfs_swapoff_device_args;

struct guestfs_swapoff_file_args {
	char *file;
};
typedef struct guestfs_swapoff_file_args guestfs_swapoff_file_args;

struct guestfs_swapoff_label_args {
	char *label;
};
typedef struct guestfs_swapoff_label_args guestfs_swapoff_label_args;

struct guestfs_swapoff_uuid_args {
	char *uuid;
};
typedef struct guestfs_swapoff_uuid_args guestfs_swapoff_uuid_args;

struct guestfs_swapon_device_args {
	char *device;
};
typedef struct guestfs_swapon_device_args guestfs_swapon_device_args;

struct guestfs_swapon_file_args {
	char *file;
};
typedef struct guestfs_swapon_file_args guestfs_swapon_file_args;

struct guestfs_swapon_label_args {
	char *label;
};
typedef struct guestfs_swapon_label_args guestfs_swapon_label_args;

struct guestfs_swapon_uuid_args {
	char *uuid;
};
typedef struct guestfs_swapon_uuid_args guestfs_swapon_uuid_args;

struct guestfs_syslinux_args {
	char *device;
	char *directory;
};
typedef struct guestfs_syslinux_args guestfs_syslinux_args;

struct guestfs_tail_args {
	char *path;
};
typedef struct guestfs_tail_args guestfs_tail_args;

struct guestfs_tail_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_tail_ret guestfs_tail_ret;

struct guestfs_tail_n_args {
	int nrlines;
	char *path;
};
typedef struct guestfs_tail_n_args guestfs_tail_n_args;

struct guestfs_tail_n_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_tail_n_ret guestfs_tail_n_ret;

struct guestfs_tar_in_args {
	char *directory;
	char *compress;
	bool_t xattrs;
	bool_t selinux;
	bool_t acls;
};
typedef struct guestfs_tar_in_args guestfs_tar_in_args;

struct guestfs_tar_out_args {
	char *directory;
	char *compress;
	bool_t numericowner;
	struct {
		u_int excludes_len;
		guestfs_str *excludes_val;
	} excludes;
	bool_t xattrs;
	bool_t selinux;
	bool_t acls;
};
typedef struct guestfs_tar_out_args guestfs_tar_out_args;

struct guestfs_tgz_in_args {
	char *directory;
};
typedef struct guestfs_tgz_in_args guestfs_tgz_in_args;

struct guestfs_tgz_out_args {
	char *directory;
};
typedef struct guestfs_tgz_out_args guestfs_tgz_out_args;

struct guestfs_touch_args {
	char *path;
};
typedef struct guestfs_touch_args guestfs_touch_args;

struct guestfs_truncate_args {
	char *path;
};
typedef struct guestfs_truncate_args guestfs_truncate_args;

struct guestfs_truncate_size_args {
	char *path;
	int64_t size;
};
typedef struct guestfs_truncate_size_args guestfs_truncate_size_args;

struct guestfs_tune2fs_args {
	char *device;
	bool_t force;
	int maxmountcount;
	int mountcount;
	char *errorbehavior;
	int64_t group;
	int intervalbetweenchecks;
	int reservedblockspercentage;
	char *lastmounteddirectory;
	int64_t reservedblockscount;
	int64_t user;
};
typedef struct guestfs_tune2fs_args guestfs_tune2fs_args;

struct guestfs_tune2fs_l_args {
	char *device;
};
typedef struct guestfs_tune2fs_l_args guestfs_tune2fs_l_args;

struct guestfs_tune2fs_l_ret {
	struct {
		u_int superblock_len;
		guestfs_str *superblock_val;
	} superblock;
};
typedef struct guestfs_tune2fs_l_ret guestfs_tune2fs_l_ret;

struct guestfs_txz_in_args {
	char *directory;
};
typedef struct guestfs_txz_in_args guestfs_txz_in_args;

struct guestfs_txz_out_args {
	char *directory;
};
typedef struct guestfs_txz_out_args guestfs_txz_out_args;

struct guestfs_umask_args {
	int mask;
};
typedef struct guestfs_umask_args guestfs_umask_args;

struct guestfs_umask_ret {
	int oldmask;
};
typedef struct guestfs_umask_ret guestfs_umask_ret;

struct guestfs_umount_args {
	char *pathordevice;
	bool_t force;
	bool_t lazyunmount;
};
typedef struct guestfs_umount_args guestfs_umount_args;

struct guestfs_upload_args {
	char *remotefilename;
};
typedef struct guestfs_upload_args guestfs_upload_args;

struct guestfs_upload_offset_args {
	char *remotefilename;
	int64_t offset;
};
typedef struct guestfs_upload_offset_args guestfs_upload_offset_args;

struct guestfs_utimens_args {
	char *path;
	int64_t atsecs;
	int64_t atnsecs;
	int64_t mtsecs;
	int64_t mtnsecs;
};
typedef struct guestfs_utimens_args guestfs_utimens_args;

struct guestfs_utsname_ret {
	guestfs_int_utsname uts;
};
typedef struct guestfs_utsname_ret guestfs_utsname_ret;

struct guestfs_vfs_label_args {
	char *mountable;
};
typedef struct guestfs_vfs_label_args guestfs_vfs_label_args;

struct guestfs_vfs_label_ret {
	char *label;
};
typedef struct guestfs_vfs_label_ret guestfs_vfs_label_ret;

struct guestfs_vfs_minimum_size_args {
	char *mountable;
};
typedef struct guestfs_vfs_minimum_size_args guestfs_vfs_minimum_size_args;

struct guestfs_vfs_minimum_size_ret {
	int64_t sizeinbytes;
};
typedef struct guestfs_vfs_minimum_size_ret guestfs_vfs_minimum_size_ret;

struct guestfs_vfs_type_args {
	char *mountable;
};
typedef struct guestfs_vfs_type_args guestfs_vfs_type_args;

struct guestfs_vfs_type_ret {
	char *fstype;
};
typedef struct guestfs_vfs_type_ret guestfs_vfs_type_ret;

struct guestfs_vfs_uuid_args {
	char *mountable;
};
typedef struct guestfs_vfs_uuid_args guestfs_vfs_uuid_args;

struct guestfs_vfs_uuid_ret {
	char *uuid;
};
typedef struct guestfs_vfs_uuid_ret guestfs_vfs_uuid_ret;

struct guestfs_vg_activate_args {
	bool_t activate;
	struct {
		u_int volgroups_len;
		guestfs_str *volgroups_val;
	} volgroups;
};
typedef struct guestfs_vg_activate_args guestfs_vg_activate_args;

struct guestfs_vg_activate_all_args {
	bool_t activate;
};
typedef struct guestfs_vg_activate_all_args guestfs_vg_activate_all_args;

struct guestfs_vgchange_uuid_args {
	char *vg;
};
typedef struct guestfs_vgchange_uuid_args guestfs_vgchange_uuid_args;

struct guestfs_vgcreate_args {
	char *volgroup;
	struct {
		u_int physvols_len;
		guestfs_str *physvols_val;
	} physvols;
};
typedef struct guestfs_vgcreate_args guestfs_vgcreate_args;

struct guestfs_vglvuuids_args {
	char *vgname;
};
typedef struct guestfs_vglvuuids_args guestfs_vglvuuids_args;

struct guestfs_vglvuuids_ret {
	struct {
		u_int uuids_len;
		guestfs_str *uuids_val;
	} uuids;
};
typedef struct guestfs_vglvuuids_ret guestfs_vglvuuids_ret;

struct guestfs_vgmeta_args {
	char *vgname;
};
typedef struct guestfs_vgmeta_args guestfs_vgmeta_args;

struct guestfs_vgmeta_ret {
	struct {
		u_int metadata_len;
		char *metadata_val;
	} metadata;
};
typedef struct guestfs_vgmeta_ret guestfs_vgmeta_ret;

struct guestfs_vgpvuuids_args {
	char *vgname;
};
typedef struct guestfs_vgpvuuids_args guestfs_vgpvuuids_args;

struct guestfs_vgpvuuids_ret {
	struct {
		u_int uuids_len;
		guestfs_str *uuids_val;
	} uuids;
};
typedef struct guestfs_vgpvuuids_ret guestfs_vgpvuuids_ret;

struct guestfs_vgremove_args {
	char *vgname;
};
typedef struct guestfs_vgremove_args guestfs_vgremove_args;

struct guestfs_vgrename_args {
	char *volgroup;
	char *newvolgroup;
};
typedef struct guestfs_vgrename_args guestfs_vgrename_args;

struct guestfs_vgs_ret {
	struct {
		u_int volgroups_len;
		guestfs_str *volgroups_val;
	} volgroups;
};
typedef struct guestfs_vgs_ret guestfs_vgs_ret;

struct guestfs_vgs_full_ret {
	guestfs_int_lvm_vg_list volgroups;
};
typedef struct guestfs_vgs_full_ret guestfs_vgs_full_ret;

struct guestfs_vguuid_args {
	char *vgname;
};
typedef struct guestfs_vguuid_args guestfs_vguuid_args;

struct guestfs_vguuid_ret {
	char *uuid;
};
typedef struct guestfs_vguuid_ret guestfs_vguuid_ret;

struct guestfs_wc_c_args {
	char *path;
};
typedef struct guestfs_wc_c_args guestfs_wc_c_args;

struct guestfs_wc_c_ret {
	int chars;
};
typedef struct guestfs_wc_c_ret guestfs_wc_c_ret;

struct guestfs_wc_l_args {
	char *path;
};
typedef struct guestfs_wc_l_args guestfs_wc_l_args;

struct guestfs_wc_l_ret {
	int lines;
};
typedef struct guestfs_wc_l_ret guestfs_wc_l_ret;

struct guestfs_wc_w_args {
	char *path;
};
typedef struct guestfs_wc_w_args guestfs_wc_w_args;

struct guestfs_wc_w_ret {
	int words;
};
typedef struct guestfs_wc_w_ret guestfs_wc_w_ret;

struct guestfs_wipefs_args {
	char *device;
};
typedef struct guestfs_wipefs_args guestfs_wipefs_args;

struct guestfs_write_file_args {
	char *path;
	char *content;
	int size;
};
typedef struct guestfs_write_file_args guestfs_write_file_args;

struct guestfs_xfs_admin_args {
	char *device;
	bool_t extunwritten;
	bool_t imgfile;
	bool_t v2log;
	bool_t projid32bit;
	bool_t lazycounter;
	char *label;
	char *uuid;
};
typedef struct guestfs_xfs_admin_args guestfs_xfs_admin_args;

struct guestfs_xfs_growfs_args {
	char *path;
	bool_t datasec;
	bool_t logsec;
	bool_t rtsec;
	int64_t datasize;
	int64_t logsize;
	int64_t rtsize;
	int64_t rtextsize;
	int maxpct;
};
typedef struct guestfs_xfs_growfs_args guestfs_xfs_growfs_args;

struct guestfs_xfs_info_args {
	char *pathordevice;
};
typedef struct guestfs_xfs_info_args guestfs_xfs_info_args;

struct guestfs_xfs_info_ret {
	guestfs_int_xfsinfo info;
};
typedef struct guestfs_xfs_info_ret guestfs_xfs_info_ret;

struct guestfs_xfs_repair_args {
	char *device;
	bool_t forcelogzero;
	bool_t nomodify;
	bool_t noprefetch;
	bool_t forcegeometry;
	int64_t maxmem;
	int64_t ihashsize;
	int64_t bhashsize;
	int64_t agstride;
	char *logdev;
	char *rtdev;
};
typedef struct guestfs_xfs_repair_args guestfs_xfs_repair_args;

struct guestfs_xfs_repair_ret {
	int status;
};
typedef struct guestfs_xfs_repair_ret guestfs_xfs_repair_ret;

struct guestfs_zegrep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zegrep_args guestfs_zegrep_args;

struct guestfs_zegrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zegrep_ret guestfs_zegrep_ret;

struct guestfs_zegrepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zegrepi_args guestfs_zegrepi_args;

struct guestfs_zegrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zegrepi_ret guestfs_zegrepi_ret;

struct guestfs_zero_args {
	char *device;
};
typedef struct guestfs_zero_args guestfs_zero_args;

struct guestfs_zero_device_args {
	char *device;
};
typedef struct guestfs_zero_device_args guestfs_zero_device_args;

struct guestfs_zero_free_space_args {
	char *directory;
};
typedef struct guestfs_zero_free_space_args guestfs_zero_free_space_args;

struct guestfs_zerofree_args {
	char *device;
};
typedef struct guestfs_zerofree_args guestfs_zerofree_args;

struct guestfs_zfgrep_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_zfgrep_args guestfs_zfgrep_args;

struct guestfs_zfgrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zfgrep_ret guestfs_zfgrep_ret;

struct guestfs_zfgrepi_args {
	char *pattern;
	char *path;
};
typedef struct guestfs_zfgrepi_args guestfs_zfgrepi_args;

struct guestfs_zfgrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zfgrepi_ret guestfs_zfgrepi_ret;

struct guestfs_zfile_args {
	char *meth;
	char *path;
};
typedef struct guestfs_zfile_args guestfs_zfile_args;

struct guestfs_zfile_ret {
	char *description;
};
typedef struct guestfs_zfile_ret guestfs_zfile_ret;

struct guestfs_zgrep_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zgrep_args guestfs_zgrep_args;

struct guestfs_zgrep_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zgrep_ret guestfs_zgrep_ret;

struct guestfs_zgrepi_args {
	char *regex;
	char *path;
};
typedef struct guestfs_zgrepi_args guestfs_zgrepi_args;

struct guestfs_zgrepi_ret {
	struct {
		u_int lines_len;
		guestfs_str *lines_val;
	} lines;
};
typedef struct guestfs_zgrepi_ret guestfs_zgrepi_ret;

enum guestfs_procedure {
	GUESTFS_PROC_ACL_DELETE_DEF_FILE = 377,
	GUESTFS_PROC_ACL_GET_FILE = 375,
	GUESTFS_PROC_ACL_SET_FILE = 376,
	GUESTFS_PROC_AUG_CLEAR = 239,
	GUESTFS_PROC_AUG_CLOSE = 26,
	GUESTFS_PROC_AUG_DEFNODE = 18,
	GUESTFS_PROC_AUG_DEFVAR = 17,
	GUESTFS_PROC_AUG_GET = 19,
	GUESTFS_PROC_AUG_INIT = 16,
	GUESTFS_PROC_AUG_INSERT = 21,
	GUESTFS_PROC_AUG_LABEL = 412,
	GUESTFS_PROC_AUG_LOAD = 27,
	GUESTFS_PROC_AUG_LS = 28,
	GUESTFS_PROC_AUG_MATCH = 24,
	GUESTFS_PROC_AUG_MV = 23,
	GUESTFS_PROC_AUG_RM = 22,
	GUESTFS_PROC_AUG_SAVE = 25,
	GUESTFS_PROC_AUG_SET = 20,
	GUESTFS_PROC_AUG_SETM = 411,
	GUESTFS_PROC_AUG_TRANSFORM = 469,
	GUESTFS_PROC_AVAILABLE_ALL_GROUPS = 251,
	GUESTFS_PROC_BASE64_IN = 242,
	GUESTFS_PROC_BASE64_OUT = 243,
	GUESTFS_PROC_BLKDISCARD = 417,
	GUESTFS_PROC_BLKDISCARDZEROES = 418,
	GUESTFS_PROC_BLKID = 303,
	GUESTFS_PROC_BLOCKDEV_FLUSHBUFS = 64,
	GUESTFS_PROC_BLOCKDEV_GETBSZ = 60,
	GUESTFS_PROC_BLOCKDEV_GETRO = 58,
	GUESTFS_PROC_BLOCKDEV_GETSIZE64 = 63,
	GUESTFS_PROC_BLOCKDEV_GETSS = 59,
	GUESTFS_PROC_BLOCKDEV_GETSZ = 62,
	GUESTFS_PROC_BLOCKDEV_REREADPT = 65,
	GUESTFS_PROC_BLOCKDEV_SETBSZ = 61,
	GUESTFS_PROC_BLOCKDEV_SETRA = 424,
	GUESTFS_PROC_BLOCKDEV_SETRO = 56,
	GUESTFS_PROC_BLOCKDEV_SETRW = 57,
	GUESTFS_PROC_BTRFS_BALANCE_CANCEL = 439,
	GUESTFS_PROC_BTRFS_BALANCE_PAUSE = 438,
	GUESTFS_PROC_BTRFS_BALANCE_RESUME = 440,
	GUESTFS_PROC_BTRFS_BALANCE_STATUS = 448,
	GUESTFS_PROC_BTRFS_DEVICE_ADD = 329,
	GUESTFS_PROC_BTRFS_DEVICE_DELETE = 330,
	GUESTFS_PROC_BTRFS_FILESYSTEM_BALANCE = 328,
	GUESTFS_PROC_BTRFS_FILESYSTEM_DEFRAGMENT = 443,
	GUESTFS_PROC_BTRFS_FILESYSTEM_RESIZE = 289,
	GUESTFS_PROC_BTRFS_FILESYSTEM_SHOW = 465,
	GUESTFS_PROC_BTRFS_FILESYSTEM_SYNC = 327,
	GUESTFS_PROC_BTRFS_FSCK = 332,
	GUESTFS_PROC_BTRFS_IMAGE = 453,
	GUESTFS_PROC_BTRFS_QGROUP_ASSIGN = 433,
	GUESTFS_PROC_BTRFS_QGROUP_CREATE = 430,
	GUESTFS_PROC_BTRFS_QGROUP_DESTROY = 431,
	GUESTFS_PROC_BTRFS_QGROUP_LIMIT = 429,
	GUESTFS_PROC_BTRFS_QGROUP_REMOVE = 434,
	GUESTFS_PROC_BTRFS_QGROUP_SHOW = 432,
	GUESTFS_PROC_BTRFS_QUOTA_ENABLE = 427,
	GUESTFS_PROC_BTRFS_QUOTA_RESCAN = 428,
	GUESTFS_PROC_BTRFS_REPLACE = 455,
	GUESTFS_PROC_BTRFS_RESCUE_CHUNK_RECOVER = 444,
	GUESTFS_PROC_BTRFS_RESCUE_SUPER_RECOVER = 445,
	GUESTFS_PROC_BTRFS_SCRUB_CANCEL = 436,
	GUESTFS_PROC_BTRFS_SCRUB_RESUME = 437,
	GUESTFS_PROC_BTRFS_SCRUB_START = 435,
	GUESTFS_PROC_BTRFS_SCRUB_STATUS = 449,
	GUESTFS_PROC_BTRFS_SET_SEEDING = 331,
	GUESTFS_PROC_BTRFS_SUBVOLUME_CREATE = 324,
	GUESTFS_PROC_BTRFS_SUBVOLUME_DELETE = 323,
	GUESTFS_PROC_BTRFS_SUBVOLUME_GET_DEFAULT = 425,
	GUESTFS_PROC_BTRFS_SUBVOLUME_LIST = 325,
	GUESTFS_PROC_BTRFS_SUBVOLUME_SET_DEFAULT = 326,
	GUESTFS_PROC_BTRFS_SUBVOLUME_SHOW = 426,
	GUESTFS_PROC_BTRFS_SUBVOLUME_SNAPSHOT = 322,
	GUESTFS_PROC_BTRFSTUNE_ENABLE_EXTENDED_INODE_REFS = 451,
	GUESTFS_PROC_BTRFSTUNE_ENABLE_SKINNY_METADATA_EXTENT_REFS = 452,
	GUESTFS_PROC_BTRFSTUNE_SEEDING = 450,
	GUESTFS_PROC_CAP_GET_FILE = 378,
	GUESTFS_PROC_CAP_SET_FILE = 379,
	GUESTFS_PROC_CASE_SENSITIVE_PATH = 197,
	GUESTFS_PROC_CHECKSUM = 68,
	GUESTFS_PROC_CHECKSUM_DEVICE = 237,
	GUESTFS_PROC_CHECKSUMS_OUT = 244,
	GUESTFS_PROC_CHMOD = 34,
	GUESTFS_PROC_CHOWN = 35,
	GUESTFS_PROC_COMMAND = 50,
	GUESTFS_PROC_COMMAND_LINES = 51,
	GUESTFS_PROC_COMPRESS_DEVICE_OUT = 292,
	GUESTFS_PROC_COMPRESS_OUT = 291,
	GUESTFS_PROC_COPY_ATTRIBUTES = 415,
	GUESTFS_PROC_COPY_DEVICE_TO_DEVICE = 294,
	GUESTFS_PROC_COPY_DEVICE_TO_FILE = 295,
	GUESTFS_PROC_COPY_FILE_TO_DEVICE = 296,
	GUESTFS_PROC_COPY_FILE_TO_FILE = 297,
	GUESTFS_PROC_COPY_SIZE = 227,
	GUESTFS_PROC_CP = 87,
	GUESTFS_PROC_CP_A = 88,
	GUESTFS_PROC_CP_R = 401,
	GUESTFS_PROC_CPIO_OUT = 419,
	GUESTFS_PROC_CRYPTSETUP_CLOSE = 509,
	GUESTFS_PROC_CRYPTSETUP_OPEN = 508,
	GUESTFS_PROC_DD = 217,
	GUESTFS_PROC_DEBUG = 76,
	GUESTFS_PROC_DEBUG_UPLOAD = 241,
	GUESTFS_PROC_DF = 125,
	GUESTFS_PROC_DF_H = 126,
	GUESTFS_PROC_DMESG = 91,
	GUESTFS_PROC_DOWNLOAD = 67,
	GUESTFS_PROC_DOWNLOAD_BLOCKS = 468,
	GUESTFS_PROC_DOWNLOAD_INODE = 464,
	GUESTFS_PROC_DOWNLOAD_OFFSET = 274,
	GUESTFS_PROC_DROP_CACHES = 90,
	GUESTFS_PROC_DU = 127,
	GUESTFS_PROC_E2FSCK = 304,
	GUESTFS_PROC_E2FSCK_F = 108,
	GUESTFS_PROC_ECHO_DAEMON = 195,
	GUESTFS_PROC_EGREP = 152,
	GUESTFS_PROC_EGREPI = 155,
	GUESTFS_PROC_EQUAL = 93,
	GUESTFS_PROC_EXISTS = 36,
	GUESTFS_PROC_EXTLINUX = 400,
	GUESTFS_PROC_F2FS_EXPAND = 505,
	GUESTFS_PROC_FALLOCATE = 169,
	GUESTFS_PROC_FALLOCATE64 = 252,
	GUESTFS_PROC_FGREP = 153,
	GUESTFS_PROC_FGREPI = 156,
	GUESTFS_PROC_FILE = 49,
	GUESTFS_PROC_FILE_ARCHITECTURE = 475,
	GUESTFS_PROC_FILESIZE = 218,
	GUESTFS_PROC_FILESYSTEM_AVAILABLE = 333,
	GUESTFS_PROC_FILL = 215,
	GUESTFS_PROC_FILL_DIR = 348,
	GUESTFS_PROC_FILL_PATTERN = 245,
	GUESTFS_PROC_FIND0 = 196,
	GUESTFS_PROC_FINDFS_LABEL = 266,
	GUESTFS_PROC_FINDFS_UUID = 265,
	GUESTFS_PROC_FSCK = 84,
	GUESTFS_PROC_FSTRIM = 334,
	GUESTFS_PROC_GET_E2ATTRS = 318,
	GUESTFS_PROC_GET_E2GENERATION = 320,
	GUESTFS_PROC_GET_E2LABEL = 81,
	GUESTFS_PROC_GET_E2UUID = 83,
	GUESTFS_PROC_GET_UMASK = 240,
	GUESTFS_PROC_GETCON = 186,
	GUESTFS_PROC_GETXATTR = 279,
	GUESTFS_PROC_GETXATTRS = 141,
	GUESTFS_PROC_GLOB_EXPAND = 113,
	GUESTFS_PROC_GREP = 151,
	GUESTFS_PROC_GREPI = 154,
	GUESTFS_PROC_GRUB_INSTALL = 86,
	GUESTFS_PROC_HEAD = 121,
	GUESTFS_PROC_HEAD_N = 122,
	GUESTFS_PROC_HEXDUMP = 96,
	GUESTFS_PROC_HIVEX_CLOSE = 351,
	GUESTFS_PROC_HIVEX_COMMIT = 362,
	GUESTFS_PROC_HIVEX_NODE_ADD_CHILD = 363,
	GUESTFS_PROC_HIVEX_NODE_CHILDREN = 354,
	GUESTFS_PROC_HIVEX_NODE_DELETE_CHILD = 364,
	GUESTFS_PROC_HIVEX_NODE_GET_CHILD = 355,
	GUESTFS_PROC_HIVEX_NODE_GET_VALUE = 358,
	GUESTFS_PROC_HIVEX_NODE_NAME = 353,
	GUESTFS_PROC_HIVEX_NODE_PARENT = 356,
	GUESTFS_PROC_HIVEX_NODE_SET_VALUE = 365,
	GUESTFS_PROC_HIVEX_NODE_VALUES = 357,
	GUESTFS_PROC_HIVEX_OPEN = 350,
	GUESTFS_PROC_HIVEX_ROOT = 352,
	GUESTFS_PROC_HIVEX_VALUE_KEY = 359,
	GUESTFS_PROC_HIVEX_VALUE_STRING = 479,
	GUESTFS_PROC_HIVEX_VALUE_TYPE = 360,
	GUESTFS_PROC_HIVEX_VALUE_UTF8 = 478,
	GUESTFS_PROC_HIVEX_VALUE_VALUE = 361,
	GUESTFS_PROC_INITRD_CAT = 221,
	GUESTFS_PROC_INITRD_LIST = 128,
	GUESTFS_PROC_INOTIFY_ADD_WATCH = 180,
	GUESTFS_PROC_INOTIFY_CLOSE = 184,
	GUESTFS_PROC_INOTIFY_FILES = 183,
	GUESTFS_PROC_INOTIFY_INIT = 179,
	GUESTFS_PROC_INOTIFY_READ = 182,
	GUESTFS_PROC_INOTIFY_RM_WATCH = 181,
	GUESTFS_PROC_INSPECT_GET_ARCH = 491,
	GUESTFS_PROC_INSPECT_GET_DISTRO = 484,
	GUESTFS_PROC_INSPECT_GET_DRIVE_MAPPINGS = 502,
	GUESTFS_PROC_INSPECT_GET_FILESYSTEMS = 501,
	GUESTFS_PROC_INSPECT_GET_FORMAT = 482,
	GUESTFS_PROC_INSPECT_GET_HOSTNAME = 492,
	GUESTFS_PROC_INSPECT_GET_MAJOR_VERSION = 489,
	GUESTFS_PROC_INSPECT_GET_MINOR_VERSION = 490,
	GUESTFS_PROC_INSPECT_GET_MOUNTPOINTS = 500,
	GUESTFS_PROC_INSPECT_GET_PACKAGE_FORMAT = 485,
	GUESTFS_PROC_INSPECT_GET_PACKAGE_MANAGEMENT = 486,
	GUESTFS_PROC_INSPECT_GET_PRODUCT_NAME = 487,
	GUESTFS_PROC_INSPECT_GET_PRODUCT_VARIANT = 488,
	GUESTFS_PROC_INSPECT_GET_ROOTS = 481,
	GUESTFS_PROC_INSPECT_GET_TYPE = 483,
	GUESTFS_PROC_INSPECT_GET_WINDOWS_CURRENT_CONTROL_SET = 496,
	GUESTFS_PROC_INSPECT_GET_WINDOWS_SOFTWARE_HIVE = 494,
	GUESTFS_PROC_INSPECT_GET_WINDOWS_SYSTEM_HIVE = 495,
	GUESTFS_PROC_INSPECT_GET_WINDOWS_SYSTEMROOT = 493,
	GUESTFS_PROC_INSPECT_IS_LIVE = 497,
	GUESTFS_PROC_INSPECT_IS_MULTIPART = 499,
	GUESTFS_PROC_INSPECT_IS_NETINST = 498,
	GUESTFS_PROC_INSPECT_OS = 480,
	GUESTFS_PROC_INTERNAL_AUTOSYNC = 282,
	GUESTFS_PROC_INTERNAL_EXIT = 414,
	GUESTFS_PROC_INTERNAL_FEATURE_AVAILABLE = 458,
	GUESTFS_PROC_INTERNAL_FILESYSTEM_WALK = 466,
	GUESTFS_PROC_INTERNAL_FIND_INODE = 470,
	GUESTFS_PROC_INTERNAL_HOT_ADD_DRIVE = 370,
	GUESTFS_PROC_INTERNAL_HOT_REMOVE_DRIVE = 372,
	GUESTFS_PROC_INTERNAL_HOT_REMOVE_DRIVE_PRECHECK = 371,
	GUESTFS_PROC_INTERNAL_JOURNAL_GET = 408,
	GUESTFS_PROC_INTERNAL_LIST_RPM_APPLICATIONS = 510,
	GUESTFS_PROC_INTERNAL_LSTATNSLIST = 423,
	GUESTFS_PROC_INTERNAL_LXATTRLIST = 205,
	GUESTFS_PROC_INTERNAL_PARSE_MOUNTABLE = 396,
	GUESTFS_PROC_INTERNAL_READLINKLIST = 206,
	GUESTFS_PROC_INTERNAL_RHBZ914931 = 397,
	GUESTFS_PROC_INTERNAL_UPLOAD = 413,
	GUESTFS_PROC_INTERNAL_WRITE = 246,
	GUESTFS_PROC_INTERNAL_WRITE_APPEND = 290,
	GUESTFS_PROC_INTERNAL_YARA_SCAN = 474,
	GUESTFS_PROC_IS_BLOCKDEV = 268,
	GUESTFS_PROC_IS_CHARDEV = 267,
	GUESTFS_PROC_IS_DIR = 38,
	GUESTFS_PROC_IS_FIFO = 269,
	GUESTFS_PROC_IS_FILE = 37,
	GUESTFS_PROC_IS_LV = 264,
	GUESTFS_PROC_IS_SOCKET = 271,
	GUESTFS_PROC_IS_SYMLINK = 270,
	GUESTFS_PROC_IS_WHOLE_DEVICE = 395,
	GUESTFS_PROC_IS_ZERO = 283,
	GUESTFS_PROC_IS_ZERO_DEVICE = 284,
	GUESTFS_PROC_ISOINFO = 314,
	GUESTFS_PROC_ISOINFO_DEVICE = 313,
	GUESTFS_PROC_JOURNAL_CLOSE = 405,
	GUESTFS_PROC_JOURNAL_GET_DATA_THRESHOLD = 409,
	GUESTFS_PROC_JOURNAL_GET_REALTIME_USEC = 420,
	GUESTFS_PROC_JOURNAL_NEXT = 406,
	GUESTFS_PROC_JOURNAL_OPEN = 404,
	GUESTFS_PROC_JOURNAL_SET_DATA_THRESHOLD = 410,
	GUESTFS_PROC_JOURNAL_SKIP = 407,
	GUESTFS_PROC_LCHOWN = 203,
	GUESTFS_PROC_LDMTOOL_CREATE_ALL = 382,
	GUESTFS_PROC_LDMTOOL_DISKGROUP_DISKS = 388,
	GUESTFS_PROC_LDMTOOL_DISKGROUP_NAME = 386,
	GUESTFS_PROC_LDMTOOL_DISKGROUP_VOLUMES = 387,
	GUESTFS_PROC_LDMTOOL_REMOVE_ALL = 383,
	GUESTFS_PROC_LDMTOOL_SCAN = 384,
	GUESTFS_PROC_LDMTOOL_SCAN_DEVICES = 385,
	GUESTFS_PROC_LDMTOOL_VOLUME_HINT = 390,
	GUESTFS_PROC_LDMTOOL_VOLUME_PARTITIONS = 391,
	GUESTFS_PROC_LDMTOOL_VOLUME_TYPE = 389,
	GUESTFS_PROC_LGETXATTR = 280,
	GUESTFS_PROC_LGETXATTRS = 142,
	GUESTFS_PROC_LIST_9P = 285,
	GUESTFS_PROC_LIST_DEVICES = 7,
	GUESTFS_PROC_LIST_DISK_LABELS = 369,
	GUESTFS_PROC_LIST_DM_DEVICES = 287,
	GUESTFS_PROC_LIST_FILESYSTEMS = 476,
	GUESTFS_PROC_LIST_LDM_PARTITIONS = 381,
	GUESTFS_PROC_LIST_LDM_VOLUMES = 380,
	GUESTFS_PROC_LIST_MD_DEVICES = 300,
	GUESTFS_PROC_LIST_PARTITIONS = 8,
	GUESTFS_PROC_LL = 5,
	GUESTFS_PROC_LLZ = 305,
	GUESTFS_PROC_LN = 164,
	GUESTFS_PROC_LN_F = 165,
	GUESTFS_PROC_LN_S = 166,
	GUESTFS_PROC_LN_SF = 167,
	GUESTFS_PROC_LREMOVEXATTR = 146,
	GUESTFS_PROC_LS0 = 347,
	GUESTFS_PROC_LSETXATTR = 144,
	GUESTFS_PROC_LSTATNS = 422,
	GUESTFS_PROC_LUKS_ADD_KEY = 262,
	GUESTFS_PROC_LUKS_CLOSE = 259,
	GUESTFS_PROC_LUKS_FORMAT = 260,
	GUESTFS_PROC_LUKS_FORMAT_CIPHER = 261,
	GUESTFS_PROC_LUKS_KILL_SLOT = 263,
	GUESTFS_PROC_LUKS_OPEN = 257,
	GUESTFS_PROC_LUKS_OPEN_RO = 258,
	GUESTFS_PROC_LUKS_UUID = 507,
	GUESTFS_PROC_LVCREATE = 41,
	GUESTFS_PROC_LVCREATE_FREE = 312,
	GUESTFS_PROC_LVM_CANONICAL_LV_NAME = 277,
	GUESTFS_PROC_LVM_CLEAR_FILTER = 256,
	GUESTFS_PROC_LVM_REMOVE_ALL = 48,
	GUESTFS_PROC_LVM_SCAN = 506,
	GUESTFS_PROC_LVM_SET_FILTER = 255,
	GUESTFS_PROC_LVREMOVE = 77,
	GUESTFS_PROC_LVRENAME = 219,
	GUESTFS_PROC_LVRESIZE = 105,
	GUESTFS_PROC_LVRESIZE_FREE = 238,
	GUESTFS_PROC_LVS = 11,
	GUESTFS_PROC_LVS_FULL = 14,
	GUESTFS_PROC_LVUUID = 224,
	GUESTFS_PROC_MD_CREATE = 299,
	GUESTFS_PROC_MD_DETAIL = 301,
	GUESTFS_PROC_MD_STAT = 316,
	GUESTFS_PROC_MD_STOP = 302,
	GUESTFS_PROC_MKDIR = 32,
	GUESTFS_PROC_MKDIR_MODE = 202,
	GUESTFS_PROC_MKDIR_P = 33,
	GUESTFS_PROC_MKDTEMP = 117,
	GUESTFS_PROC_MKE2FS = 368,
	GUESTFS_PROC_MKE2FS_J = 191,
	GUESTFS_PROC_MKE2FS_JL = 192,
	GUESTFS_PROC_MKE2FS_JU = 193,
	GUESTFS_PROC_MKE2JOURNAL = 188,
	GUESTFS_PROC_MKE2JOURNAL_L = 189,
	GUESTFS_PROC_MKE2JOURNAL_U = 190,
	GUESTFS_PROC_MKFIFO = 134,
	GUESTFS_PROC_MKFS = 278,
	GUESTFS_PROC_MKFS_B = 187,
	GUESTFS_PROC_MKFS_BTRFS = 317,
	GUESTFS_PROC_MKLOST_AND_FOUND = 374,
	GUESTFS_PROC_MKMOUNTPOINT = 148,
	GUESTFS_PROC_MKNOD = 133,
	GUESTFS_PROC_MKNOD_B = 135,
	GUESTFS_PROC_MKNOD_C = 136,
	GUESTFS_PROC_MKSQUASHFS = 471,
	GUESTFS_PROC_MKSWAP = 130,
	GUESTFS_PROC_MKSWAP_L = 131,
	GUESTFS_PROC_MKSWAP_U = 132,
	GUESTFS_PROC_MKSWAP_FILE = 178,
	GUESTFS_PROC_MKTEMP = 373,
	GUESTFS_PROC_MODPROBE = 194,
	GUESTFS_PROC_MOUNT = 1,
	GUESTFS_PROC_MOUNT_9P = 286,
	GUESTFS_PROC_MOUNT_LOOP = 129,
	GUESTFS_PROC_MOUNT_OPTIONS = 74,
	GUESTFS_PROC_MOUNT_RO = 73,
	GUESTFS_PROC_MOUNT_VFS = 75,
	GUESTFS_PROC_MOUNTPOINTS = 147,
	GUESTFS_PROC_MOUNTS = 46,
	GUESTFS_PROC_MV = 89,
	GUESTFS_PROC_NR_DEVICES = 336,
	GUESTFS_PROC_NTFS_3G_PROBE = 110,
	GUESTFS_PROC_NTFSCAT_I = 463,
	GUESTFS_PROC_NTFSCLONE_IN = 309,
	GUESTFS_PROC_NTFSCLONE_OUT = 308,
	GUESTFS_PROC_NTFSFIX = 307,
	GUESTFS_PROC_NTFSRESIZE = 288,
	GUESTFS_PROC_NTFSRESIZE_SIZE = 250,
	GUESTFS_PROC_PART_ADD = 209,
	GUESTFS_PROC_PART_DEL = 233,
	GUESTFS_PROC_PART_DISK = 210,
	GUESTFS_PROC_PART_EXPAND_GPT = 462,
	GUESTFS_PROC_PART_GET_BOOTABLE = 234,
	GUESTFS_PROC_PART_GET_DISK_GUID = 460,
	GUESTFS_PROC_PART_GET_GPT_ATTRIBUTES = 504,
	GUESTFS_PROC_PART_GET_GPT_GUID = 447,
	GUESTFS_PROC_PART_GET_GPT_TYPE = 393,
	GUESTFS_PROC_PART_GET_MBR_ID = 235,
	GUESTFS_PROC_PART_GET_MBR_PART_TYPE = 454,
	GUESTFS_PROC_PART_GET_NAME = 416,
	GUESTFS_PROC_PART_GET_PARTTYPE = 214,
	GUESTFS_PROC_PART_INIT = 208,
	GUESTFS_PROC_PART_LIST = 213,
	GUESTFS_PROC_PART_RESIZE = 477,
	GUESTFS_PROC_PART_SET_BOOTABLE = 211,
	GUESTFS_PROC_PART_SET_DISK_GUID = 459,
	GUESTFS_PROC_PART_SET_DISK_GUID_RANDOM = 461,
	GUESTFS_PROC_PART_SET_GPT_ATTRIBUTES = 503,
	GUESTFS_PROC_PART_SET_GPT_GUID = 446,
	GUESTFS_PROC_PART_SET_GPT_TYPE = 392,
	GUESTFS_PROC_PART_SET_MBR_ID = 236,
	GUESTFS_PROC_PART_SET_NAME = 212,
	GUESTFS_PROC_PART_TO_DEV = 272,
	GUESTFS_PROC_PART_TO_PARTNUM = 293,
	GUESTFS_PROC_PING_DAEMON = 92,
	GUESTFS_PROC_PREAD = 207,
	GUESTFS_PROC_PREAD_DEVICE = 276,
	GUESTFS_PROC_PVCHANGE_UUID = 338,
	GUESTFS_PROC_PVCHANGE_UUID_ALL = 339,
	GUESTFS_PROC_PVCREATE = 39,
	GUESTFS_PROC_PVREMOVE = 79,
	GUESTFS_PROC_PVRESIZE = 98,
	GUESTFS_PROC_PVRESIZE_SIZE = 249,
	GUESTFS_PROC_PVS = 9,
	GUESTFS_PROC_PVS_FULL = 12,
	GUESTFS_PROC_PVUUID = 222,
	GUESTFS_PROC_PWRITE = 247,
	GUESTFS_PROC_PWRITE_DEVICE = 275,
	GUESTFS_PROC_READDIR = 138,
	GUESTFS_PROC_READLINK = 168,
	GUESTFS_PROC_REALPATH = 163,
	GUESTFS_PROC_REMOUNT = 402,
	GUESTFS_PROC_REMOVEXATTR = 145,
	GUESTFS_PROC_RENAME = 394,
	GUESTFS_PROC_RESIZE2FS = 106,
	GUESTFS_PROC_RESIZE2FS_M = 281,
	GUESTFS_PROC_RESIZE2FS_SIZE = 248,
	GUESTFS_PROC_RM = 29,
	GUESTFS_PROC_RM_F = 367,
	GUESTFS_PROC_RM_RF = 31,
	GUESTFS_PROC_RMDIR = 30,
	GUESTFS_PROC_RMMOUNTPOINT = 149,
	GUESTFS_PROC_RSYNC = 344,
	GUESTFS_PROC_RSYNC_IN = 345,
	GUESTFS_PROC_RSYNC_OUT = 346,
	GUESTFS_PROC_SCRUB_DEVICE = 114,
	GUESTFS_PROC_SCRUB_FILE = 115,
	GUESTFS_PROC_SCRUB_FREESPACE = 116,
	GUESTFS_PROC_SELINUX_RELABEL = 467,
	GUESTFS_PROC_SET_E2ATTRS = 319,
	GUESTFS_PROC_SET_E2GENERATION = 321,
	GUESTFS_PROC_SET_E2LABEL = 80,
	GUESTFS_PROC_SET_E2UUID = 82,
	GUESTFS_PROC_SET_LABEL = 310,
	GUESTFS_PROC_SET_UUID = 403,
	GUESTFS_PROC_SET_UUID_RANDOM = 456,
	GUESTFS_PROC_SETCON = 185,
	GUESTFS_PROC_SETXATTR = 143,
	GUESTFS_PROC_SFDISK = 43,
	GUESTFS_PROC_SFDISKM = 139,
	GUESTFS_PROC_SFDISK_N = 99,
	GUESTFS_PROC_SFDISK_DISK_GEOMETRY = 102,
	GUESTFS_PROC_SFDISK_KERNEL_GEOMETRY = 101,
	GUESTFS_PROC_SFDISK_L = 100,
	GUESTFS_PROC_SH = 111,
	GUESTFS_PROC_SH_LINES = 112,
	GUESTFS_PROC_SLEEP = 109,
	GUESTFS_PROC_STATNS = 421,
	GUESTFS_PROC_STATVFS = 54,
	GUESTFS_PROC_STRINGS = 94,
	GUESTFS_PROC_STRINGS_E = 95,
	GUESTFS_PROC_SWAPOFF_DEVICE = 171,
	GUESTFS_PROC_SWAPOFF_FILE = 173,
	GUESTFS_PROC_SWAPOFF_LABEL = 175,
	GUESTFS_PROC_SWAPOFF_UUID = 177,
	GUESTFS_PROC_SWAPON_DEVICE = 170,
	GUESTFS_PROC_SWAPON_FILE = 172,
	GUESTFS_PROC_SWAPON_LABEL = 174,
	GUESTFS_PROC_SWAPON_UUID = 176,
	GUESTFS_PROC_SYNC = 2,
	GUESTFS_PROC_SYSLINUX = 399,
	GUESTFS_PROC_TAIL = 123,
	GUESTFS_PROC_TAIL_N = 124,
	GUESTFS_PROC_TAR_IN = 69,
	GUESTFS_PROC_TAR_OUT = 70,
	GUESTFS_PROC_TGZ_IN = 71,
	GUESTFS_PROC_TGZ_OUT = 72,
	GUESTFS_PROC_TOUCH = 3,
	GUESTFS_PROC_TRUNCATE = 199,
	GUESTFS_PROC_TRUNCATE_SIZE = 200,
	GUESTFS_PROC_TUNE2FS = 298,
	GUESTFS_PROC_TUNE2FS_L = 55,
	GUESTFS_PROC_TXZ_IN = 229,
	GUESTFS_PROC_TXZ_OUT = 230,
	GUESTFS_PROC_UMASK = 137,
	GUESTFS_PROC_UMOUNT = 45,
	GUESTFS_PROC_UMOUNT_ALL = 47,
	GUESTFS_PROC_UPLOAD = 66,
	GUESTFS_PROC_UPLOAD_OFFSET = 273,
	GUESTFS_PROC_UTIMENS = 201,
	GUESTFS_PROC_UTSNAME = 342,
	GUESTFS_PROC_VFS_LABEL = 253,
	GUESTFS_PROC_VFS_MINIMUM_SIZE = 457,
	GUESTFS_PROC_VFS_TYPE = 198,
	GUESTFS_PROC_VFS_UUID = 254,
	GUESTFS_PROC_VG_ACTIVATE = 104,
	GUESTFS_PROC_VG_ACTIVATE_ALL = 103,
	GUESTFS_PROC_VGCHANGE_UUID = 340,
	GUESTFS_PROC_VGCHANGE_UUID_ALL = 341,
	GUESTFS_PROC_VGCREATE = 40,
	GUESTFS_PROC_VGLVUUIDS = 226,
	GUESTFS_PROC_VGMETA = 315,
	GUESTFS_PROC_VGPVUUIDS = 225,
	GUESTFS_PROC_VGREMOVE = 78,
	GUESTFS_PROC_VGRENAME = 220,
	GUESTFS_PROC_VGS = 10,
	GUESTFS_PROC_VGS_FULL = 13,
	GUESTFS_PROC_VGSCAN = 232,
	GUESTFS_PROC_VGUUID = 223,
	GUESTFS_PROC_WC_C = 120,
	GUESTFS_PROC_WC_L = 118,
	GUESTFS_PROC_WC_W = 119,
	GUESTFS_PROC_WIPEFS = 306,
	GUESTFS_PROC_WRITE_FILE = 44,
	GUESTFS_PROC_XFS_ADMIN = 349,
	GUESTFS_PROC_XFS_GROWFS = 343,
	GUESTFS_PROC_XFS_INFO = 337,
	GUESTFS_PROC_XFS_REPAIR = 366,
	GUESTFS_PROC_YARA_DESTROY = 473,
	GUESTFS_PROC_YARA_LOAD = 472,
	GUESTFS_PROC_ZEGREP = 158,
	GUESTFS_PROC_ZEGREPI = 161,
	GUESTFS_PROC_ZERO = 85,
	GUESTFS_PROC_ZERO_DEVICE = 228,
	GUESTFS_PROC_ZERO_FREE_SPACE = 311,
	GUESTFS_PROC_ZEROFREE = 97,
	GUESTFS_PROC_ZFGREP = 159,
	GUESTFS_PROC_ZFGREPI = 162,
	GUESTFS_PROC_ZFILE = 140,
	GUESTFS_PROC_ZGREP = 157,
	GUESTFS_PROC_ZGREPI = 160,
};
typedef enum guestfs_procedure guestfs_procedure;
#define GUESTFS_MAX_PROC_NR 510
#define GUESTFS_MESSAGE_MAX 4194304
#define GUESTFS_PROGRAM 0x2000F5F5
#define GUESTFS_PROTOCOL_VERSION 4
#define GUESTFS_LAUNCH_FLAG 0xf5f55ff5
#define GUESTFS_CANCEL_FLAG 0xffffeeee
#define GUESTFS_PROGRESS_FLAG 0xffff5555

enum guestfs_message_direction {
	GUESTFS_DIRECTION_CALL = 0,
	GUESTFS_DIRECTION_REPLY = 1,
};
typedef enum guestfs_message_direction guestfs_message_direction;

enum guestfs_message_status {
	GUESTFS_STATUS_OK = 0,
	GUESTFS_STATUS_ERROR = 1,
};
typedef enum guestfs_message_status guestfs_message_status;
#define GUESTFS_ERROR_LEN 65536

struct guestfs_message_error {
	char *errno_string;
	char *error_message;
};
typedef struct guestfs_message_error guestfs_message_error;

struct guestfs_message_header {
	u_int prog;
	u_int vers;
	guestfs_procedure proc;
	guestfs_message_direction direction;
	u_int serial;
	uint64_t progress_hint;
	uint64_t optargs_bitmask;
	guestfs_message_status status;
};
typedef struct guestfs_message_header guestfs_message_header;
#define GUESTFS_MAX_CHUNK_SIZE 8192

struct guestfs_chunk {
	int cancel;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct guestfs_chunk guestfs_chunk;

struct guestfs_progress {
	guestfs_procedure proc;
	u_int serial;
	uint64_t position;
	uint64_t total;
};
typedef struct guestfs_progress guestfs_progress;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_guestfs_str (XDR *, guestfs_str*);
extern  bool_t xdr_guestfs_int_int_bool (XDR *, guestfs_int_int_bool*);
extern  bool_t xdr_guestfs_int_int_bool_list (XDR *, guestfs_int_int_bool_list*);
extern  bool_t xdr_guestfs_int_lvm_pv (XDR *, guestfs_int_lvm_pv*);
extern  bool_t xdr_guestfs_int_lvm_pv_list (XDR *, guestfs_int_lvm_pv_list*);
extern  bool_t xdr_guestfs_int_lvm_vg (XDR *, guestfs_int_lvm_vg*);
extern  bool_t xdr_guestfs_int_lvm_vg_list (XDR *, guestfs_int_lvm_vg_list*);
extern  bool_t xdr_guestfs_int_lvm_lv (XDR *, guestfs_int_lvm_lv*);
extern  bool_t xdr_guestfs_int_lvm_lv_list (XDR *, guestfs_int_lvm_lv_list*);
extern  bool_t xdr_guestfs_int_stat (XDR *, guestfs_int_stat*);
extern  bool_t xdr_guestfs_int_stat_list (XDR *, guestfs_int_stat_list*);
extern  bool_t xdr_guestfs_int_statns (XDR *, guestfs_int_statns*);
extern  bool_t xdr_guestfs_int_statns_list (XDR *, guestfs_int_statns_list*);
extern  bool_t xdr_guestfs_int_statvfs (XDR *, guestfs_int_statvfs*);
extern  bool_t xdr_guestfs_int_statvfs_list (XDR *, guestfs_int_statvfs_list*);
extern  bool_t xdr_guestfs_int_dirent (XDR *, guestfs_int_dirent*);
extern  bool_t xdr_guestfs_int_dirent_list (XDR *, guestfs_int_dirent_list*);
extern  bool_t xdr_guestfs_int_version (XDR *, guestfs_int_version*);
extern  bool_t xdr_guestfs_int_version_list (XDR *, guestfs_int_version_list*);
extern  bool_t xdr_guestfs_int_xattr (XDR *, guestfs_int_xattr*);
extern  bool_t xdr_guestfs_int_xattr_list (XDR *, guestfs_int_xattr_list*);
extern  bool_t xdr_guestfs_int_inotify_event (XDR *, guestfs_int_inotify_event*);
extern  bool_t xdr_guestfs_int_inotify_event_list (XDR *, guestfs_int_inotify_event_list*);
extern  bool_t xdr_guestfs_int_partition (XDR *, guestfs_int_partition*);
extern  bool_t xdr_guestfs_int_partition_list (XDR *, guestfs_int_partition_list*);
extern  bool_t xdr_guestfs_int_application (XDR *, guestfs_int_application*);
extern  bool_t xdr_guestfs_int_application_list (XDR *, guestfs_int_application_list*);
extern  bool_t xdr_guestfs_int_application2 (XDR *, guestfs_int_application2*);
extern  bool_t xdr_guestfs_int_application2_list (XDR *, guestfs_int_application2_list*);
extern  bool_t xdr_guestfs_int_isoinfo (XDR *, guestfs_int_isoinfo*);
extern  bool_t xdr_guestfs_int_isoinfo_list (XDR *, guestfs_int_isoinfo_list*);
extern  bool_t xdr_guestfs_int_mdstat (XDR *, guestfs_int_mdstat*);
extern  bool_t xdr_guestfs_int_mdstat_list (XDR *, guestfs_int_mdstat_list*);
extern  bool_t xdr_guestfs_int_btrfssubvolume (XDR *, guestfs_int_btrfssubvolume*);
extern  bool_t xdr_guestfs_int_btrfssubvolume_list (XDR *, guestfs_int_btrfssubvolume_list*);
extern  bool_t xdr_guestfs_int_btrfsqgroup (XDR *, guestfs_int_btrfsqgroup*);
extern  bool_t xdr_guestfs_int_btrfsqgroup_list (XDR *, guestfs_int_btrfsqgroup_list*);
extern  bool_t xdr_guestfs_int_btrfsbalance (XDR *, guestfs_int_btrfsbalance*);
extern  bool_t xdr_guestfs_int_btrfsbalance_list (XDR *, guestfs_int_btrfsbalance_list*);
extern  bool_t xdr_guestfs_int_btrfsscrub (XDR *, guestfs_int_btrfsscrub*);
extern  bool_t xdr_guestfs_int_btrfsscrub_list (XDR *, guestfs_int_btrfsscrub_list*);
extern  bool_t xdr_guestfs_int_xfsinfo (XDR *, guestfs_int_xfsinfo*);
extern  bool_t xdr_guestfs_int_xfsinfo_list (XDR *, guestfs_int_xfsinfo_list*);
extern  bool_t xdr_guestfs_int_utsname (XDR *, guestfs_int_utsname*);
extern  bool_t xdr_guestfs_int_utsname_list (XDR *, guestfs_int_utsname_list*);
extern  bool_t xdr_guestfs_int_hivex_node (XDR *, guestfs_int_hivex_node*);
extern  bool_t xdr_guestfs_int_hivex_node_list (XDR *, guestfs_int_hivex_node_list*);
extern  bool_t xdr_guestfs_int_hivex_value (XDR *, guestfs_int_hivex_value*);
extern  bool_t xdr_guestfs_int_hivex_value_list (XDR *, guestfs_int_hivex_value_list*);
extern  bool_t xdr_guestfs_int_internal_mountable (XDR *, guestfs_int_internal_mountable*);
extern  bool_t xdr_guestfs_int_internal_mountable_list (XDR *, guestfs_int_internal_mountable_list*);
extern  bool_t xdr_guestfs_int_tsk_dirent (XDR *, guestfs_int_tsk_dirent*);
extern  bool_t xdr_guestfs_int_tsk_dirent_list (XDR *, guestfs_int_tsk_dirent_list*);
extern  bool_t xdr_guestfs_int_yara_detection (XDR *, guestfs_int_yara_detection*);
extern  bool_t xdr_guestfs_int_yara_detection_list (XDR *, guestfs_int_yara_detection_list*);
extern  bool_t xdr_guestfs_acl_delete_def_file_args (XDR *, guestfs_acl_delete_def_file_args*);
extern  bool_t xdr_guestfs_acl_get_file_args (XDR *, guestfs_acl_get_file_args*);
extern  bool_t xdr_guestfs_acl_get_file_ret (XDR *, guestfs_acl_get_file_ret*);
extern  bool_t xdr_guestfs_acl_set_file_args (XDR *, guestfs_acl_set_file_args*);
extern  bool_t xdr_guestfs_aug_clear_args (XDR *, guestfs_aug_clear_args*);
extern  bool_t xdr_guestfs_aug_defnode_args (XDR *, guestfs_aug_defnode_args*);
extern  bool_t xdr_guestfs_aug_defnode_ret (XDR *, guestfs_aug_defnode_ret*);
extern  bool_t xdr_guestfs_aug_defvar_args (XDR *, guestfs_aug_defvar_args*);
extern  bool_t xdr_guestfs_aug_defvar_ret (XDR *, guestfs_aug_defvar_ret*);
extern  bool_t xdr_guestfs_aug_get_args (XDR *, guestfs_aug_get_args*);
extern  bool_t xdr_guestfs_aug_get_ret (XDR *, guestfs_aug_get_ret*);
extern  bool_t xdr_guestfs_aug_init_args (XDR *, guestfs_aug_init_args*);
extern  bool_t xdr_guestfs_aug_insert_args (XDR *, guestfs_aug_insert_args*);
extern  bool_t xdr_guestfs_aug_label_args (XDR *, guestfs_aug_label_args*);
extern  bool_t xdr_guestfs_aug_label_ret (XDR *, guestfs_aug_label_ret*);
extern  bool_t xdr_guestfs_aug_ls_args (XDR *, guestfs_aug_ls_args*);
extern  bool_t xdr_guestfs_aug_ls_ret (XDR *, guestfs_aug_ls_ret*);
extern  bool_t xdr_guestfs_aug_match_args (XDR *, guestfs_aug_match_args*);
extern  bool_t xdr_guestfs_aug_match_ret (XDR *, guestfs_aug_match_ret*);
extern  bool_t xdr_guestfs_aug_mv_args (XDR *, guestfs_aug_mv_args*);
extern  bool_t xdr_guestfs_aug_rm_args (XDR *, guestfs_aug_rm_args*);
extern  bool_t xdr_guestfs_aug_rm_ret (XDR *, guestfs_aug_rm_ret*);
extern  bool_t xdr_guestfs_aug_set_args (XDR *, guestfs_aug_set_args*);
extern  bool_t xdr_guestfs_aug_setm_args (XDR *, guestfs_aug_setm_args*);
extern  bool_t xdr_guestfs_aug_setm_ret (XDR *, guestfs_aug_setm_ret*);
extern  bool_t xdr_guestfs_aug_transform_args (XDR *, guestfs_aug_transform_args*);
extern  bool_t xdr_guestfs_available_all_groups_ret (XDR *, guestfs_available_all_groups_ret*);
extern  bool_t xdr_guestfs_base64_in_args (XDR *, guestfs_base64_in_args*);
extern  bool_t xdr_guestfs_base64_out_args (XDR *, guestfs_base64_out_args*);
extern  bool_t xdr_guestfs_blkdiscard_args (XDR *, guestfs_blkdiscard_args*);
extern  bool_t xdr_guestfs_blkdiscardzeroes_args (XDR *, guestfs_blkdiscardzeroes_args*);
extern  bool_t xdr_guestfs_blkdiscardzeroes_ret (XDR *, guestfs_blkdiscardzeroes_ret*);
extern  bool_t xdr_guestfs_blkid_args (XDR *, guestfs_blkid_args*);
extern  bool_t xdr_guestfs_blkid_ret (XDR *, guestfs_blkid_ret*);
extern  bool_t xdr_guestfs_blockdev_flushbufs_args (XDR *, guestfs_blockdev_flushbufs_args*);
extern  bool_t xdr_guestfs_blockdev_getbsz_args (XDR *, guestfs_blockdev_getbsz_args*);
extern  bool_t xdr_guestfs_blockdev_getbsz_ret (XDR *, guestfs_blockdev_getbsz_ret*);
extern  bool_t xdr_guestfs_blockdev_getro_args (XDR *, guestfs_blockdev_getro_args*);
extern  bool_t xdr_guestfs_blockdev_getro_ret (XDR *, guestfs_blockdev_getro_ret*);
extern  bool_t xdr_guestfs_blockdev_getsize64_args (XDR *, guestfs_blockdev_getsize64_args*);
extern  bool_t xdr_guestfs_blockdev_getsize64_ret (XDR *, guestfs_blockdev_getsize64_ret*);
extern  bool_t xdr_guestfs_blockdev_getss_args (XDR *, guestfs_blockdev_getss_args*);
extern  bool_t xdr_guestfs_blockdev_getss_ret (XDR *, guestfs_blockdev_getss_ret*);
extern  bool_t xdr_guestfs_blockdev_getsz_args (XDR *, guestfs_blockdev_getsz_args*);
extern  bool_t xdr_guestfs_blockdev_getsz_ret (XDR *, guestfs_blockdev_getsz_ret*);
extern  bool_t xdr_guestfs_blockdev_rereadpt_args (XDR *, guestfs_blockdev_rereadpt_args*);
extern  bool_t xdr_guestfs_blockdev_setbsz_args (XDR *, guestfs_blockdev_setbsz_args*);
extern  bool_t xdr_guestfs_blockdev_setra_args (XDR *, guestfs_blockdev_setra_args*);
extern  bool_t xdr_guestfs_blockdev_setro_args (XDR *, guestfs_blockdev_setro_args*);
extern  bool_t xdr_guestfs_blockdev_setrw_args (XDR *, guestfs_blockdev_setrw_args*);
extern  bool_t xdr_guestfs_btrfs_balance_cancel_args (XDR *, guestfs_btrfs_balance_cancel_args*);
extern  bool_t xdr_guestfs_btrfs_balance_pause_args (XDR *, guestfs_btrfs_balance_pause_args*);
extern  bool_t xdr_guestfs_btrfs_balance_resume_args (XDR *, guestfs_btrfs_balance_resume_args*);
extern  bool_t xdr_guestfs_btrfs_balance_status_args (XDR *, guestfs_btrfs_balance_status_args*);
extern  bool_t xdr_guestfs_btrfs_balance_status_ret (XDR *, guestfs_btrfs_balance_status_ret*);
extern  bool_t xdr_guestfs_btrfs_device_add_args (XDR *, guestfs_btrfs_device_add_args*);
extern  bool_t xdr_guestfs_btrfs_device_delete_args (XDR *, guestfs_btrfs_device_delete_args*);
extern  bool_t xdr_guestfs_btrfs_filesystem_balance_args (XDR *, guestfs_btrfs_filesystem_balance_args*);
extern  bool_t xdr_guestfs_btrfs_filesystem_defragment_args (XDR *, guestfs_btrfs_filesystem_defragment_args*);
extern  bool_t xdr_guestfs_btrfs_filesystem_resize_args (XDR *, guestfs_btrfs_filesystem_resize_args*);
extern  bool_t xdr_guestfs_btrfs_filesystem_show_args (XDR *, guestfs_btrfs_filesystem_show_args*);
extern  bool_t xdr_guestfs_btrfs_filesystem_show_ret (XDR *, guestfs_btrfs_filesystem_show_ret*);
extern  bool_t xdr_guestfs_btrfs_filesystem_sync_args (XDR *, guestfs_btrfs_filesystem_sync_args*);
extern  bool_t xdr_guestfs_btrfs_fsck_args (XDR *, guestfs_btrfs_fsck_args*);
extern  bool_t xdr_guestfs_btrfs_image_args (XDR *, guestfs_btrfs_image_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_assign_args (XDR *, guestfs_btrfs_qgroup_assign_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_create_args (XDR *, guestfs_btrfs_qgroup_create_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_destroy_args (XDR *, guestfs_btrfs_qgroup_destroy_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_limit_args (XDR *, guestfs_btrfs_qgroup_limit_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_remove_args (XDR *, guestfs_btrfs_qgroup_remove_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_show_args (XDR *, guestfs_btrfs_qgroup_show_args*);
extern  bool_t xdr_guestfs_btrfs_qgroup_show_ret (XDR *, guestfs_btrfs_qgroup_show_ret*);
extern  bool_t xdr_guestfs_btrfs_quota_enable_args (XDR *, guestfs_btrfs_quota_enable_args*);
extern  bool_t xdr_guestfs_btrfs_quota_rescan_args (XDR *, guestfs_btrfs_quota_rescan_args*);
extern  bool_t xdr_guestfs_btrfs_replace_args (XDR *, guestfs_btrfs_replace_args*);
extern  bool_t xdr_guestfs_btrfs_rescue_chunk_recover_args (XDR *, guestfs_btrfs_rescue_chunk_recover_args*);
extern  bool_t xdr_guestfs_btrfs_rescue_super_recover_args (XDR *, guestfs_btrfs_rescue_super_recover_args*);
extern  bool_t xdr_guestfs_btrfs_scrub_cancel_args (XDR *, guestfs_btrfs_scrub_cancel_args*);
extern  bool_t xdr_guestfs_btrfs_scrub_resume_args (XDR *, guestfs_btrfs_scrub_resume_args*);
extern  bool_t xdr_guestfs_btrfs_scrub_start_args (XDR *, guestfs_btrfs_scrub_start_args*);
extern  bool_t xdr_guestfs_btrfs_scrub_status_args (XDR *, guestfs_btrfs_scrub_status_args*);
extern  bool_t xdr_guestfs_btrfs_scrub_status_ret (XDR *, guestfs_btrfs_scrub_status_ret*);
extern  bool_t xdr_guestfs_btrfs_set_seeding_args (XDR *, guestfs_btrfs_set_seeding_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_create_args (XDR *, guestfs_btrfs_subvolume_create_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_delete_args (XDR *, guestfs_btrfs_subvolume_delete_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_get_default_args (XDR *, guestfs_btrfs_subvolume_get_default_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_get_default_ret (XDR *, guestfs_btrfs_subvolume_get_default_ret*);
extern  bool_t xdr_guestfs_btrfs_subvolume_list_args (XDR *, guestfs_btrfs_subvolume_list_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_list_ret (XDR *, guestfs_btrfs_subvolume_list_ret*);
extern  bool_t xdr_guestfs_btrfs_subvolume_set_default_args (XDR *, guestfs_btrfs_subvolume_set_default_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_show_args (XDR *, guestfs_btrfs_subvolume_show_args*);
extern  bool_t xdr_guestfs_btrfs_subvolume_show_ret (XDR *, guestfs_btrfs_subvolume_show_ret*);
extern  bool_t xdr_guestfs_btrfs_subvolume_snapshot_args (XDR *, guestfs_btrfs_subvolume_snapshot_args*);
extern  bool_t xdr_guestfs_btrfstune_enable_extended_inode_refs_args (XDR *, guestfs_btrfstune_enable_extended_inode_refs_args*);
extern  bool_t xdr_guestfs_btrfstune_enable_skinny_metadata_extent_refs_args (XDR *, guestfs_btrfstune_enable_skinny_metadata_extent_refs_args*);
extern  bool_t xdr_guestfs_btrfstune_seeding_args (XDR *, guestfs_btrfstune_seeding_args*);
extern  bool_t xdr_guestfs_cap_get_file_args (XDR *, guestfs_cap_get_file_args*);
extern  bool_t xdr_guestfs_cap_get_file_ret (XDR *, guestfs_cap_get_file_ret*);
extern  bool_t xdr_guestfs_cap_set_file_args (XDR *, guestfs_cap_set_file_args*);
extern  bool_t xdr_guestfs_case_sensitive_path_args (XDR *, guestfs_case_sensitive_path_args*);
extern  bool_t xdr_guestfs_case_sensitive_path_ret (XDR *, guestfs_case_sensitive_path_ret*);
extern  bool_t xdr_guestfs_checksum_args (XDR *, guestfs_checksum_args*);
extern  bool_t xdr_guestfs_checksum_ret (XDR *, guestfs_checksum_ret*);
extern  bool_t xdr_guestfs_checksum_device_args (XDR *, guestfs_checksum_device_args*);
extern  bool_t xdr_guestfs_checksum_device_ret (XDR *, guestfs_checksum_device_ret*);
extern  bool_t xdr_guestfs_checksums_out_args (XDR *, guestfs_checksums_out_args*);
extern  bool_t xdr_guestfs_chmod_args (XDR *, guestfs_chmod_args*);
extern  bool_t xdr_guestfs_chown_args (XDR *, guestfs_chown_args*);
extern  bool_t xdr_guestfs_command_args (XDR *, guestfs_command_args*);
extern  bool_t xdr_guestfs_command_ret (XDR *, guestfs_command_ret*);
extern  bool_t xdr_guestfs_command_lines_args (XDR *, guestfs_command_lines_args*);
extern  bool_t xdr_guestfs_command_lines_ret (XDR *, guestfs_command_lines_ret*);
extern  bool_t xdr_guestfs_compress_device_out_args (XDR *, guestfs_compress_device_out_args*);
extern  bool_t xdr_guestfs_compress_out_args (XDR *, guestfs_compress_out_args*);
extern  bool_t xdr_guestfs_copy_attributes_args (XDR *, guestfs_copy_attributes_args*);
extern  bool_t xdr_guestfs_copy_device_to_device_args (XDR *, guestfs_copy_device_to_device_args*);
extern  bool_t xdr_guestfs_copy_device_to_file_args (XDR *, guestfs_copy_device_to_file_args*);
extern  bool_t xdr_guestfs_copy_file_to_device_args (XDR *, guestfs_copy_file_to_device_args*);
extern  bool_t xdr_guestfs_copy_file_to_file_args (XDR *, guestfs_copy_file_to_file_args*);
extern  bool_t xdr_guestfs_copy_size_args (XDR *, guestfs_copy_size_args*);
extern  bool_t xdr_guestfs_cp_args (XDR *, guestfs_cp_args*);
extern  bool_t xdr_guestfs_cp_a_args (XDR *, guestfs_cp_a_args*);
extern  bool_t xdr_guestfs_cp_r_args (XDR *, guestfs_cp_r_args*);
extern  bool_t xdr_guestfs_cpio_out_args (XDR *, guestfs_cpio_out_args*);
extern  bool_t xdr_guestfs_cryptsetup_close_args (XDR *, guestfs_cryptsetup_close_args*);
extern  bool_t xdr_guestfs_cryptsetup_open_args (XDR *, guestfs_cryptsetup_open_args*);
extern  bool_t xdr_guestfs_dd_args (XDR *, guestfs_dd_args*);
extern  bool_t xdr_guestfs_debug_args (XDR *, guestfs_debug_args*);
extern  bool_t xdr_guestfs_debug_ret (XDR *, guestfs_debug_ret*);
extern  bool_t xdr_guestfs_debug_upload_args (XDR *, guestfs_debug_upload_args*);
extern  bool_t xdr_guestfs_df_ret (XDR *, guestfs_df_ret*);
extern  bool_t xdr_guestfs_df_h_ret (XDR *, guestfs_df_h_ret*);
extern  bool_t xdr_guestfs_dmesg_ret (XDR *, guestfs_dmesg_ret*);
extern  bool_t xdr_guestfs_download_args (XDR *, guestfs_download_args*);
extern  bool_t xdr_guestfs_download_blocks_args (XDR *, guestfs_download_blocks_args*);
extern  bool_t xdr_guestfs_download_inode_args (XDR *, guestfs_download_inode_args*);
extern  bool_t xdr_guestfs_download_offset_args (XDR *, guestfs_download_offset_args*);
extern  bool_t xdr_guestfs_drop_caches_args (XDR *, guestfs_drop_caches_args*);
extern  bool_t xdr_guestfs_du_args (XDR *, guestfs_du_args*);
extern  bool_t xdr_guestfs_du_ret (XDR *, guestfs_du_ret*);
extern  bool_t xdr_guestfs_e2fsck_args (XDR *, guestfs_e2fsck_args*);
extern  bool_t xdr_guestfs_e2fsck_f_args (XDR *, guestfs_e2fsck_f_args*);
extern  bool_t xdr_guestfs_echo_daemon_args (XDR *, guestfs_echo_daemon_args*);
extern  bool_t xdr_guestfs_echo_daemon_ret (XDR *, guestfs_echo_daemon_ret*);
extern  bool_t xdr_guestfs_egrep_args (XDR *, guestfs_egrep_args*);
extern  bool_t xdr_guestfs_egrep_ret (XDR *, guestfs_egrep_ret*);
extern  bool_t xdr_guestfs_egrepi_args (XDR *, guestfs_egrepi_args*);
extern  bool_t xdr_guestfs_egrepi_ret (XDR *, guestfs_egrepi_ret*);
extern  bool_t xdr_guestfs_equal_args (XDR *, guestfs_equal_args*);
extern  bool_t xdr_guestfs_equal_ret (XDR *, guestfs_equal_ret*);
extern  bool_t xdr_guestfs_exists_args (XDR *, guestfs_exists_args*);
extern  bool_t xdr_guestfs_exists_ret (XDR *, guestfs_exists_ret*);
extern  bool_t xdr_guestfs_extlinux_args (XDR *, guestfs_extlinux_args*);
extern  bool_t xdr_guestfs_f2fs_expand_args (XDR *, guestfs_f2fs_expand_args*);
extern  bool_t xdr_guestfs_fallocate_args (XDR *, guestfs_fallocate_args*);
extern  bool_t xdr_guestfs_fallocate64_args (XDR *, guestfs_fallocate64_args*);
extern  bool_t xdr_guestfs_fgrep_args (XDR *, guestfs_fgrep_args*);
extern  bool_t xdr_guestfs_fgrep_ret (XDR *, guestfs_fgrep_ret*);
extern  bool_t xdr_guestfs_fgrepi_args (XDR *, guestfs_fgrepi_args*);
extern  bool_t xdr_guestfs_fgrepi_ret (XDR *, guestfs_fgrepi_ret*);
extern  bool_t xdr_guestfs_file_args (XDR *, guestfs_file_args*);
extern  bool_t xdr_guestfs_file_ret (XDR *, guestfs_file_ret*);
extern  bool_t xdr_guestfs_file_architecture_args (XDR *, guestfs_file_architecture_args*);
extern  bool_t xdr_guestfs_file_architecture_ret (XDR *, guestfs_file_architecture_ret*);
extern  bool_t xdr_guestfs_filesize_args (XDR *, guestfs_filesize_args*);
extern  bool_t xdr_guestfs_filesize_ret (XDR *, guestfs_filesize_ret*);
extern  bool_t xdr_guestfs_filesystem_available_args (XDR *, guestfs_filesystem_available_args*);
extern  bool_t xdr_guestfs_filesystem_available_ret (XDR *, guestfs_filesystem_available_ret*);
extern  bool_t xdr_guestfs_fill_args (XDR *, guestfs_fill_args*);
extern  bool_t xdr_guestfs_fill_dir_args (XDR *, guestfs_fill_dir_args*);
extern  bool_t xdr_guestfs_fill_pattern_args (XDR *, guestfs_fill_pattern_args*);
extern  bool_t xdr_guestfs_find0_args (XDR *, guestfs_find0_args*);
extern  bool_t xdr_guestfs_findfs_label_args (XDR *, guestfs_findfs_label_args*);
extern  bool_t xdr_guestfs_findfs_label_ret (XDR *, guestfs_findfs_label_ret*);
extern  bool_t xdr_guestfs_findfs_uuid_args (XDR *, guestfs_findfs_uuid_args*);
extern  bool_t xdr_guestfs_findfs_uuid_ret (XDR *, guestfs_findfs_uuid_ret*);
extern  bool_t xdr_guestfs_fsck_args (XDR *, guestfs_fsck_args*);
extern  bool_t xdr_guestfs_fsck_ret (XDR *, guestfs_fsck_ret*);
extern  bool_t xdr_guestfs_fstrim_args (XDR *, guestfs_fstrim_args*);
extern  bool_t xdr_guestfs_get_e2attrs_args (XDR *, guestfs_get_e2attrs_args*);
extern  bool_t xdr_guestfs_get_e2attrs_ret (XDR *, guestfs_get_e2attrs_ret*);
extern  bool_t xdr_guestfs_get_e2generation_args (XDR *, guestfs_get_e2generation_args*);
extern  bool_t xdr_guestfs_get_e2generation_ret (XDR *, guestfs_get_e2generation_ret*);
extern  bool_t xdr_guestfs_get_e2label_args (XDR *, guestfs_get_e2label_args*);
extern  bool_t xdr_guestfs_get_e2label_ret (XDR *, guestfs_get_e2label_ret*);
extern  bool_t xdr_guestfs_get_e2uuid_args (XDR *, guestfs_get_e2uuid_args*);
extern  bool_t xdr_guestfs_get_e2uuid_ret (XDR *, guestfs_get_e2uuid_ret*);
extern  bool_t xdr_guestfs_get_umask_ret (XDR *, guestfs_get_umask_ret*);
extern  bool_t xdr_guestfs_getcon_ret (XDR *, guestfs_getcon_ret*);
extern  bool_t xdr_guestfs_getxattr_args (XDR *, guestfs_getxattr_args*);
extern  bool_t xdr_guestfs_getxattr_ret (XDR *, guestfs_getxattr_ret*);
extern  bool_t xdr_guestfs_getxattrs_args (XDR *, guestfs_getxattrs_args*);
extern  bool_t xdr_guestfs_getxattrs_ret (XDR *, guestfs_getxattrs_ret*);
extern  bool_t xdr_guestfs_glob_expand_args (XDR *, guestfs_glob_expand_args*);
extern  bool_t xdr_guestfs_glob_expand_ret (XDR *, guestfs_glob_expand_ret*);
extern  bool_t xdr_guestfs_grep_args (XDR *, guestfs_grep_args*);
extern  bool_t xdr_guestfs_grep_ret (XDR *, guestfs_grep_ret*);
extern  bool_t xdr_guestfs_grepi_args (XDR *, guestfs_grepi_args*);
extern  bool_t xdr_guestfs_grepi_ret (XDR *, guestfs_grepi_ret*);
extern  bool_t xdr_guestfs_grub_install_args (XDR *, guestfs_grub_install_args*);
extern  bool_t xdr_guestfs_head_args (XDR *, guestfs_head_args*);
extern  bool_t xdr_guestfs_head_ret (XDR *, guestfs_head_ret*);
extern  bool_t xdr_guestfs_head_n_args (XDR *, guestfs_head_n_args*);
extern  bool_t xdr_guestfs_head_n_ret (XDR *, guestfs_head_n_ret*);
extern  bool_t xdr_guestfs_hexdump_args (XDR *, guestfs_hexdump_args*);
extern  bool_t xdr_guestfs_hexdump_ret (XDR *, guestfs_hexdump_ret*);
extern  bool_t xdr_guestfs_hivex_commit_args (XDR *, guestfs_hivex_commit_args*);
extern  bool_t xdr_guestfs_hivex_node_add_child_args (XDR *, guestfs_hivex_node_add_child_args*);
extern  bool_t xdr_guestfs_hivex_node_add_child_ret (XDR *, guestfs_hivex_node_add_child_ret*);
extern  bool_t xdr_guestfs_hivex_node_children_args (XDR *, guestfs_hivex_node_children_args*);
extern  bool_t xdr_guestfs_hivex_node_children_ret (XDR *, guestfs_hivex_node_children_ret*);
extern  bool_t xdr_guestfs_hivex_node_delete_child_args (XDR *, guestfs_hivex_node_delete_child_args*);
extern  bool_t xdr_guestfs_hivex_node_get_child_args (XDR *, guestfs_hivex_node_get_child_args*);
extern  bool_t xdr_guestfs_hivex_node_get_child_ret (XDR *, guestfs_hivex_node_get_child_ret*);
extern  bool_t xdr_guestfs_hivex_node_get_value_args (XDR *, guestfs_hivex_node_get_value_args*);
extern  bool_t xdr_guestfs_hivex_node_get_value_ret (XDR *, guestfs_hivex_node_get_value_ret*);
extern  bool_t xdr_guestfs_hivex_node_name_args (XDR *, guestfs_hivex_node_name_args*);
extern  bool_t xdr_guestfs_hivex_node_name_ret (XDR *, guestfs_hivex_node_name_ret*);
extern  bool_t xdr_guestfs_hivex_node_parent_args (XDR *, guestfs_hivex_node_parent_args*);
extern  bool_t xdr_guestfs_hivex_node_parent_ret (XDR *, guestfs_hivex_node_parent_ret*);
extern  bool_t xdr_guestfs_hivex_node_set_value_args (XDR *, guestfs_hivex_node_set_value_args*);
extern  bool_t xdr_guestfs_hivex_node_values_args (XDR *, guestfs_hivex_node_values_args*);
extern  bool_t xdr_guestfs_hivex_node_values_ret (XDR *, guestfs_hivex_node_values_ret*);
extern  bool_t xdr_guestfs_hivex_open_args (XDR *, guestfs_hivex_open_args*);
extern  bool_t xdr_guestfs_hivex_root_ret (XDR *, guestfs_hivex_root_ret*);
extern  bool_t xdr_guestfs_hivex_value_key_args (XDR *, guestfs_hivex_value_key_args*);
extern  bool_t xdr_guestfs_hivex_value_key_ret (XDR *, guestfs_hivex_value_key_ret*);
extern  bool_t xdr_guestfs_hivex_value_string_args (XDR *, guestfs_hivex_value_string_args*);
extern  bool_t xdr_guestfs_hivex_value_string_ret (XDR *, guestfs_hivex_value_string_ret*);
extern  bool_t xdr_guestfs_hivex_value_type_args (XDR *, guestfs_hivex_value_type_args*);
extern  bool_t xdr_guestfs_hivex_value_type_ret (XDR *, guestfs_hivex_value_type_ret*);
extern  bool_t xdr_guestfs_hivex_value_utf8_args (XDR *, guestfs_hivex_value_utf8_args*);
extern  bool_t xdr_guestfs_hivex_value_utf8_ret (XDR *, guestfs_hivex_value_utf8_ret*);
extern  bool_t xdr_guestfs_hivex_value_value_args (XDR *, guestfs_hivex_value_value_args*);
extern  bool_t xdr_guestfs_hivex_value_value_ret (XDR *, guestfs_hivex_value_value_ret*);
extern  bool_t xdr_guestfs_initrd_cat_args (XDR *, guestfs_initrd_cat_args*);
extern  bool_t xdr_guestfs_initrd_cat_ret (XDR *, guestfs_initrd_cat_ret*);
extern  bool_t xdr_guestfs_initrd_list_args (XDR *, guestfs_initrd_list_args*);
extern  bool_t xdr_guestfs_initrd_list_ret (XDR *, guestfs_initrd_list_ret*);
extern  bool_t xdr_guestfs_inotify_add_watch_args (XDR *, guestfs_inotify_add_watch_args*);
extern  bool_t xdr_guestfs_inotify_add_watch_ret (XDR *, guestfs_inotify_add_watch_ret*);
extern  bool_t xdr_guestfs_inotify_files_ret (XDR *, guestfs_inotify_files_ret*);
extern  bool_t xdr_guestfs_inotify_init_args (XDR *, guestfs_inotify_init_args*);
extern  bool_t xdr_guestfs_inotify_read_ret (XDR *, guestfs_inotify_read_ret*);
extern  bool_t xdr_guestfs_inotify_rm_watch_args (XDR *, guestfs_inotify_rm_watch_args*);
extern  bool_t xdr_guestfs_inspect_get_arch_args (XDR *, guestfs_inspect_get_arch_args*);
extern  bool_t xdr_guestfs_inspect_get_arch_ret (XDR *, guestfs_inspect_get_arch_ret*);
extern  bool_t xdr_guestfs_inspect_get_distro_args (XDR *, guestfs_inspect_get_distro_args*);
extern  bool_t xdr_guestfs_inspect_get_distro_ret (XDR *, guestfs_inspect_get_distro_ret*);
extern  bool_t xdr_guestfs_inspect_get_drive_mappings_args (XDR *, guestfs_inspect_get_drive_mappings_args*);
extern  bool_t xdr_guestfs_inspect_get_drive_mappings_ret (XDR *, guestfs_inspect_get_drive_mappings_ret*);
extern  bool_t xdr_guestfs_inspect_get_filesystems_args (XDR *, guestfs_inspect_get_filesystems_args*);
extern  bool_t xdr_guestfs_inspect_get_filesystems_ret (XDR *, guestfs_inspect_get_filesystems_ret*);
extern  bool_t xdr_guestfs_inspect_get_format_args (XDR *, guestfs_inspect_get_format_args*);
extern  bool_t xdr_guestfs_inspect_get_format_ret (XDR *, guestfs_inspect_get_format_ret*);
extern  bool_t xdr_guestfs_inspect_get_hostname_args (XDR *, guestfs_inspect_get_hostname_args*);
extern  bool_t xdr_guestfs_inspect_get_hostname_ret (XDR *, guestfs_inspect_get_hostname_ret*);
extern  bool_t xdr_guestfs_inspect_get_major_version_args (XDR *, guestfs_inspect_get_major_version_args*);
extern  bool_t xdr_guestfs_inspect_get_major_version_ret (XDR *, guestfs_inspect_get_major_version_ret*);
extern  bool_t xdr_guestfs_inspect_get_minor_version_args (XDR *, guestfs_inspect_get_minor_version_args*);
extern  bool_t xdr_guestfs_inspect_get_minor_version_ret (XDR *, guestfs_inspect_get_minor_version_ret*);
extern  bool_t xdr_guestfs_inspect_get_mountpoints_args (XDR *, guestfs_inspect_get_mountpoints_args*);
extern  bool_t xdr_guestfs_inspect_get_mountpoints_ret (XDR *, guestfs_inspect_get_mountpoints_ret*);
extern  bool_t xdr_guestfs_inspect_get_package_format_args (XDR *, guestfs_inspect_get_package_format_args*);
extern  bool_t xdr_guestfs_inspect_get_package_format_ret (XDR *, guestfs_inspect_get_package_format_ret*);
extern  bool_t xdr_guestfs_inspect_get_package_management_args (XDR *, guestfs_inspect_get_package_management_args*);
extern  bool_t xdr_guestfs_inspect_get_package_management_ret (XDR *, guestfs_inspect_get_package_management_ret*);
extern  bool_t xdr_guestfs_inspect_get_product_name_args (XDR *, guestfs_inspect_get_product_name_args*);
extern  bool_t xdr_guestfs_inspect_get_product_name_ret (XDR *, guestfs_inspect_get_product_name_ret*);
extern  bool_t xdr_guestfs_inspect_get_product_variant_args (XDR *, guestfs_inspect_get_product_variant_args*);
extern  bool_t xdr_guestfs_inspect_get_product_variant_ret (XDR *, guestfs_inspect_get_product_variant_ret*);
extern  bool_t xdr_guestfs_inspect_get_roots_ret (XDR *, guestfs_inspect_get_roots_ret*);
extern  bool_t xdr_guestfs_inspect_get_type_args (XDR *, guestfs_inspect_get_type_args*);
extern  bool_t xdr_guestfs_inspect_get_type_ret (XDR *, guestfs_inspect_get_type_ret*);
extern  bool_t xdr_guestfs_inspect_get_windows_current_control_set_args (XDR *, guestfs_inspect_get_windows_current_control_set_args*);
extern  bool_t xdr_guestfs_inspect_get_windows_current_control_set_ret (XDR *, guestfs_inspect_get_windows_current_control_set_ret*);
extern  bool_t xdr_guestfs_inspect_get_windows_software_hive_args (XDR *, guestfs_inspect_get_windows_software_hive_args*);
extern  bool_t xdr_guestfs_inspect_get_windows_software_hive_ret (XDR *, guestfs_inspect_get_windows_software_hive_ret*);
extern  bool_t xdr_guestfs_inspect_get_windows_system_hive_args (XDR *, guestfs_inspect_get_windows_system_hive_args*);
extern  bool_t xdr_guestfs_inspect_get_windows_system_hive_ret (XDR *, guestfs_inspect_get_windows_system_hive_ret*);
extern  bool_t xdr_guestfs_inspect_get_windows_systemroot_args (XDR *, guestfs_inspect_get_windows_systemroot_args*);
extern  bool_t xdr_guestfs_inspect_get_windows_systemroot_ret (XDR *, guestfs_inspect_get_windows_systemroot_ret*);
extern  bool_t xdr_guestfs_inspect_is_live_args (XDR *, guestfs_inspect_is_live_args*);
extern  bool_t xdr_guestfs_inspect_is_live_ret (XDR *, guestfs_inspect_is_live_ret*);
extern  bool_t xdr_guestfs_inspect_is_multipart_args (XDR *, guestfs_inspect_is_multipart_args*);
extern  bool_t xdr_guestfs_inspect_is_multipart_ret (XDR *, guestfs_inspect_is_multipart_ret*);
extern  bool_t xdr_guestfs_inspect_is_netinst_args (XDR *, guestfs_inspect_is_netinst_args*);
extern  bool_t xdr_guestfs_inspect_is_netinst_ret (XDR *, guestfs_inspect_is_netinst_ret*);
extern  bool_t xdr_guestfs_inspect_os_ret (XDR *, guestfs_inspect_os_ret*);
extern  bool_t xdr_guestfs_internal_feature_available_args (XDR *, guestfs_internal_feature_available_args*);
extern  bool_t xdr_guestfs_internal_feature_available_ret (XDR *, guestfs_internal_feature_available_ret*);
extern  bool_t xdr_guestfs_internal_filesystem_walk_args (XDR *, guestfs_internal_filesystem_walk_args*);
extern  bool_t xdr_guestfs_internal_find_inode_args (XDR *, guestfs_internal_find_inode_args*);
extern  bool_t xdr_guestfs_internal_hot_add_drive_args (XDR *, guestfs_internal_hot_add_drive_args*);
extern  bool_t xdr_guestfs_internal_hot_remove_drive_args (XDR *, guestfs_internal_hot_remove_drive_args*);
extern  bool_t xdr_guestfs_internal_hot_remove_drive_precheck_args (XDR *, guestfs_internal_hot_remove_drive_precheck_args*);
extern  bool_t xdr_guestfs_internal_list_rpm_applications_ret (XDR *, guestfs_internal_list_rpm_applications_ret*);
extern  bool_t xdr_guestfs_internal_lstatnslist_args (XDR *, guestfs_internal_lstatnslist_args*);
extern  bool_t xdr_guestfs_internal_lstatnslist_ret (XDR *, guestfs_internal_lstatnslist_ret*);
extern  bool_t xdr_guestfs_internal_lxattrlist_args (XDR *, guestfs_internal_lxattrlist_args*);
extern  bool_t xdr_guestfs_internal_lxattrlist_ret (XDR *, guestfs_internal_lxattrlist_ret*);
extern  bool_t xdr_guestfs_internal_parse_mountable_args (XDR *, guestfs_internal_parse_mountable_args*);
extern  bool_t xdr_guestfs_internal_parse_mountable_ret (XDR *, guestfs_internal_parse_mountable_ret*);
extern  bool_t xdr_guestfs_internal_readlinklist_args (XDR *, guestfs_internal_readlinklist_args*);
extern  bool_t xdr_guestfs_internal_readlinklist_ret (XDR *, guestfs_internal_readlinklist_ret*);
extern  bool_t xdr_guestfs_internal_rhbz914931_args (XDR *, guestfs_internal_rhbz914931_args*);
extern  bool_t xdr_guestfs_internal_upload_args (XDR *, guestfs_internal_upload_args*);
extern  bool_t xdr_guestfs_internal_write_args (XDR *, guestfs_internal_write_args*);
extern  bool_t xdr_guestfs_internal_write_append_args (XDR *, guestfs_internal_write_append_args*);
extern  bool_t xdr_guestfs_internal_yara_scan_args (XDR *, guestfs_internal_yara_scan_args*);
extern  bool_t xdr_guestfs_is_blockdev_args (XDR *, guestfs_is_blockdev_args*);
extern  bool_t xdr_guestfs_is_blockdev_ret (XDR *, guestfs_is_blockdev_ret*);
extern  bool_t xdr_guestfs_is_chardev_args (XDR *, guestfs_is_chardev_args*);
extern  bool_t xdr_guestfs_is_chardev_ret (XDR *, guestfs_is_chardev_ret*);
extern  bool_t xdr_guestfs_is_dir_args (XDR *, guestfs_is_dir_args*);
extern  bool_t xdr_guestfs_is_dir_ret (XDR *, guestfs_is_dir_ret*);
extern  bool_t xdr_guestfs_is_fifo_args (XDR *, guestfs_is_fifo_args*);
extern  bool_t xdr_guestfs_is_fifo_ret (XDR *, guestfs_is_fifo_ret*);
extern  bool_t xdr_guestfs_is_file_args (XDR *, guestfs_is_file_args*);
extern  bool_t xdr_guestfs_is_file_ret (XDR *, guestfs_is_file_ret*);
extern  bool_t xdr_guestfs_is_lv_args (XDR *, guestfs_is_lv_args*);
extern  bool_t xdr_guestfs_is_lv_ret (XDR *, guestfs_is_lv_ret*);
extern  bool_t xdr_guestfs_is_socket_args (XDR *, guestfs_is_socket_args*);
extern  bool_t xdr_guestfs_is_socket_ret (XDR *, guestfs_is_socket_ret*);
extern  bool_t xdr_guestfs_is_symlink_args (XDR *, guestfs_is_symlink_args*);
extern  bool_t xdr_guestfs_is_symlink_ret (XDR *, guestfs_is_symlink_ret*);
extern  bool_t xdr_guestfs_is_whole_device_args (XDR *, guestfs_is_whole_device_args*);
extern  bool_t xdr_guestfs_is_whole_device_ret (XDR *, guestfs_is_whole_device_ret*);
extern  bool_t xdr_guestfs_is_zero_args (XDR *, guestfs_is_zero_args*);
extern  bool_t xdr_guestfs_is_zero_ret (XDR *, guestfs_is_zero_ret*);
extern  bool_t xdr_guestfs_is_zero_device_args (XDR *, guestfs_is_zero_device_args*);
extern  bool_t xdr_guestfs_is_zero_device_ret (XDR *, guestfs_is_zero_device_ret*);
extern  bool_t xdr_guestfs_isoinfo_args (XDR *, guestfs_isoinfo_args*);
extern  bool_t xdr_guestfs_isoinfo_ret (XDR *, guestfs_isoinfo_ret*);
extern  bool_t xdr_guestfs_isoinfo_device_args (XDR *, guestfs_isoinfo_device_args*);
extern  bool_t xdr_guestfs_isoinfo_device_ret (XDR *, guestfs_isoinfo_device_ret*);
extern  bool_t xdr_guestfs_journal_get_data_threshold_ret (XDR *, guestfs_journal_get_data_threshold_ret*);
extern  bool_t xdr_guestfs_journal_get_realtime_usec_ret (XDR *, guestfs_journal_get_realtime_usec_ret*);
extern  bool_t xdr_guestfs_journal_next_ret (XDR *, guestfs_journal_next_ret*);
extern  bool_t xdr_guestfs_journal_open_args (XDR *, guestfs_journal_open_args*);
extern  bool_t xdr_guestfs_journal_set_data_threshold_args (XDR *, guestfs_journal_set_data_threshold_args*);
extern  bool_t xdr_guestfs_journal_skip_args (XDR *, guestfs_journal_skip_args*);
extern  bool_t xdr_guestfs_journal_skip_ret (XDR *, guestfs_journal_skip_ret*);
extern  bool_t xdr_guestfs_lchown_args (XDR *, guestfs_lchown_args*);
extern  bool_t xdr_guestfs_ldmtool_diskgroup_disks_args (XDR *, guestfs_ldmtool_diskgroup_disks_args*);
extern  bool_t xdr_guestfs_ldmtool_diskgroup_disks_ret (XDR *, guestfs_ldmtool_diskgroup_disks_ret*);
extern  bool_t xdr_guestfs_ldmtool_diskgroup_name_args (XDR *, guestfs_ldmtool_diskgroup_name_args*);
extern  bool_t xdr_guestfs_ldmtool_diskgroup_name_ret (XDR *, guestfs_ldmtool_diskgroup_name_ret*);
extern  bool_t xdr_guestfs_ldmtool_diskgroup_volumes_args (XDR *, guestfs_ldmtool_diskgroup_volumes_args*);
extern  bool_t xdr_guestfs_ldmtool_diskgroup_volumes_ret (XDR *, guestfs_ldmtool_diskgroup_volumes_ret*);
extern  bool_t xdr_guestfs_ldmtool_scan_ret (XDR *, guestfs_ldmtool_scan_ret*);
extern  bool_t xdr_guestfs_ldmtool_scan_devices_args (XDR *, guestfs_ldmtool_scan_devices_args*);
extern  bool_t xdr_guestfs_ldmtool_scan_devices_ret (XDR *, guestfs_ldmtool_scan_devices_ret*);
extern  bool_t xdr_guestfs_ldmtool_volume_hint_args (XDR *, guestfs_ldmtool_volume_hint_args*);
extern  bool_t xdr_guestfs_ldmtool_volume_hint_ret (XDR *, guestfs_ldmtool_volume_hint_ret*);
extern  bool_t xdr_guestfs_ldmtool_volume_partitions_args (XDR *, guestfs_ldmtool_volume_partitions_args*);
extern  bool_t xdr_guestfs_ldmtool_volume_partitions_ret (XDR *, guestfs_ldmtool_volume_partitions_ret*);
extern  bool_t xdr_guestfs_ldmtool_volume_type_args (XDR *, guestfs_ldmtool_volume_type_args*);
extern  bool_t xdr_guestfs_ldmtool_volume_type_ret (XDR *, guestfs_ldmtool_volume_type_ret*);
extern  bool_t xdr_guestfs_lgetxattr_args (XDR *, guestfs_lgetxattr_args*);
extern  bool_t xdr_guestfs_lgetxattr_ret (XDR *, guestfs_lgetxattr_ret*);
extern  bool_t xdr_guestfs_lgetxattrs_args (XDR *, guestfs_lgetxattrs_args*);
extern  bool_t xdr_guestfs_lgetxattrs_ret (XDR *, guestfs_lgetxattrs_ret*);
extern  bool_t xdr_guestfs_list_9p_ret (XDR *, guestfs_list_9p_ret*);
extern  bool_t xdr_guestfs_list_devices_ret (XDR *, guestfs_list_devices_ret*);
extern  bool_t xdr_guestfs_list_disk_labels_ret (XDR *, guestfs_list_disk_labels_ret*);
extern  bool_t xdr_guestfs_list_dm_devices_ret (XDR *, guestfs_list_dm_devices_ret*);
extern  bool_t xdr_guestfs_list_filesystems_ret (XDR *, guestfs_list_filesystems_ret*);
extern  bool_t xdr_guestfs_list_ldm_partitions_ret (XDR *, guestfs_list_ldm_partitions_ret*);
extern  bool_t xdr_guestfs_list_ldm_volumes_ret (XDR *, guestfs_list_ldm_volumes_ret*);
extern  bool_t xdr_guestfs_list_md_devices_ret (XDR *, guestfs_list_md_devices_ret*);
extern  bool_t xdr_guestfs_list_partitions_ret (XDR *, guestfs_list_partitions_ret*);
extern  bool_t xdr_guestfs_ll_args (XDR *, guestfs_ll_args*);
extern  bool_t xdr_guestfs_ll_ret (XDR *, guestfs_ll_ret*);
extern  bool_t xdr_guestfs_llz_args (XDR *, guestfs_llz_args*);
extern  bool_t xdr_guestfs_llz_ret (XDR *, guestfs_llz_ret*);
extern  bool_t xdr_guestfs_ln_args (XDR *, guestfs_ln_args*);
extern  bool_t xdr_guestfs_ln_f_args (XDR *, guestfs_ln_f_args*);
extern  bool_t xdr_guestfs_ln_s_args (XDR *, guestfs_ln_s_args*);
extern  bool_t xdr_guestfs_ln_sf_args (XDR *, guestfs_ln_sf_args*);
extern  bool_t xdr_guestfs_lremovexattr_args (XDR *, guestfs_lremovexattr_args*);
extern  bool_t xdr_guestfs_ls0_args (XDR *, guestfs_ls0_args*);
extern  bool_t xdr_guestfs_lsetxattr_args (XDR *, guestfs_lsetxattr_args*);
extern  bool_t xdr_guestfs_lstatns_args (XDR *, guestfs_lstatns_args*);
extern  bool_t xdr_guestfs_lstatns_ret (XDR *, guestfs_lstatns_ret*);
extern  bool_t xdr_guestfs_luks_add_key_args (XDR *, guestfs_luks_add_key_args*);
extern  bool_t xdr_guestfs_luks_close_args (XDR *, guestfs_luks_close_args*);
extern  bool_t xdr_guestfs_luks_format_args (XDR *, guestfs_luks_format_args*);
extern  bool_t xdr_guestfs_luks_format_cipher_args (XDR *, guestfs_luks_format_cipher_args*);
extern  bool_t xdr_guestfs_luks_kill_slot_args (XDR *, guestfs_luks_kill_slot_args*);
extern  bool_t xdr_guestfs_luks_open_args (XDR *, guestfs_luks_open_args*);
extern  bool_t xdr_guestfs_luks_open_ro_args (XDR *, guestfs_luks_open_ro_args*);
extern  bool_t xdr_guestfs_luks_uuid_args (XDR *, guestfs_luks_uuid_args*);
extern  bool_t xdr_guestfs_luks_uuid_ret (XDR *, guestfs_luks_uuid_ret*);
extern  bool_t xdr_guestfs_lvcreate_args (XDR *, guestfs_lvcreate_args*);
extern  bool_t xdr_guestfs_lvcreate_free_args (XDR *, guestfs_lvcreate_free_args*);
extern  bool_t xdr_guestfs_lvm_canonical_lv_name_args (XDR *, guestfs_lvm_canonical_lv_name_args*);
extern  bool_t xdr_guestfs_lvm_canonical_lv_name_ret (XDR *, guestfs_lvm_canonical_lv_name_ret*);
extern  bool_t xdr_guestfs_lvm_scan_args (XDR *, guestfs_lvm_scan_args*);
extern  bool_t xdr_guestfs_lvm_set_filter_args (XDR *, guestfs_lvm_set_filter_args*);
extern  bool_t xdr_guestfs_lvremove_args (XDR *, guestfs_lvremove_args*);
extern  bool_t xdr_guestfs_lvrename_args (XDR *, guestfs_lvrename_args*);
extern  bool_t xdr_guestfs_lvresize_args (XDR *, guestfs_lvresize_args*);
extern  bool_t xdr_guestfs_lvresize_free_args (XDR *, guestfs_lvresize_free_args*);
extern  bool_t xdr_guestfs_lvs_ret (XDR *, guestfs_lvs_ret*);
extern  bool_t xdr_guestfs_lvs_full_ret (XDR *, guestfs_lvs_full_ret*);
extern  bool_t xdr_guestfs_lvuuid_args (XDR *, guestfs_lvuuid_args*);
extern  bool_t xdr_guestfs_lvuuid_ret (XDR *, guestfs_lvuuid_ret*);
extern  bool_t xdr_guestfs_md_create_args (XDR *, guestfs_md_create_args*);
extern  bool_t xdr_guestfs_md_detail_args (XDR *, guestfs_md_detail_args*);
extern  bool_t xdr_guestfs_md_detail_ret (XDR *, guestfs_md_detail_ret*);
extern  bool_t xdr_guestfs_md_stat_args (XDR *, guestfs_md_stat_args*);
extern  bool_t xdr_guestfs_md_stat_ret (XDR *, guestfs_md_stat_ret*);
extern  bool_t xdr_guestfs_md_stop_args (XDR *, guestfs_md_stop_args*);
extern  bool_t xdr_guestfs_mkdir_args (XDR *, guestfs_mkdir_args*);
extern  bool_t xdr_guestfs_mkdir_mode_args (XDR *, guestfs_mkdir_mode_args*);
extern  bool_t xdr_guestfs_mkdir_p_args (XDR *, guestfs_mkdir_p_args*);
extern  bool_t xdr_guestfs_mkdtemp_args (XDR *, guestfs_mkdtemp_args*);
extern  bool_t xdr_guestfs_mkdtemp_ret (XDR *, guestfs_mkdtemp_ret*);
extern  bool_t xdr_guestfs_mke2fs_args (XDR *, guestfs_mke2fs_args*);
extern  bool_t xdr_guestfs_mke2fs_J_args (XDR *, guestfs_mke2fs_J_args*);
extern  bool_t xdr_guestfs_mke2fs_JL_args (XDR *, guestfs_mke2fs_JL_args*);
extern  bool_t xdr_guestfs_mke2fs_JU_args (XDR *, guestfs_mke2fs_JU_args*);
extern  bool_t xdr_guestfs_mke2journal_args (XDR *, guestfs_mke2journal_args*);
extern  bool_t xdr_guestfs_mke2journal_L_args (XDR *, guestfs_mke2journal_L_args*);
extern  bool_t xdr_guestfs_mke2journal_U_args (XDR *, guestfs_mke2journal_U_args*);
extern  bool_t xdr_guestfs_mkfifo_args (XDR *, guestfs_mkfifo_args*);
extern  bool_t xdr_guestfs_mkfs_args (XDR *, guestfs_mkfs_args*);
extern  bool_t xdr_guestfs_mkfs_b_args (XDR *, guestfs_mkfs_b_args*);
extern  bool_t xdr_guestfs_mkfs_btrfs_args (XDR *, guestfs_mkfs_btrfs_args*);
extern  bool_t xdr_guestfs_mklost_and_found_args (XDR *, guestfs_mklost_and_found_args*);
extern  bool_t xdr_guestfs_mkmountpoint_args (XDR *, guestfs_mkmountpoint_args*);
extern  bool_t xdr_guestfs_mknod_args (XDR *, guestfs_mknod_args*);
extern  bool_t xdr_guestfs_mknod_b_args (XDR *, guestfs_mknod_b_args*);
extern  bool_t xdr_guestfs_mknod_c_args (XDR *, guestfs_mknod_c_args*);
extern  bool_t xdr_guestfs_mksquashfs_args (XDR *, guestfs_mksquashfs_args*);
extern  bool_t xdr_guestfs_mkswap_args (XDR *, guestfs_mkswap_args*);
extern  bool_t xdr_guestfs_mkswap_L_args (XDR *, guestfs_mkswap_L_args*);
extern  bool_t xdr_guestfs_mkswap_U_args (XDR *, guestfs_mkswap_U_args*);
extern  bool_t xdr_guestfs_mkswap_file_args (XDR *, guestfs_mkswap_file_args*);
extern  bool_t xdr_guestfs_mktemp_args (XDR *, guestfs_mktemp_args*);
extern  bool_t xdr_guestfs_mktemp_ret (XDR *, guestfs_mktemp_ret*);
extern  bool_t xdr_guestfs_modprobe_args (XDR *, guestfs_modprobe_args*);
extern  bool_t xdr_guestfs_mount_args (XDR *, guestfs_mount_args*);
extern  bool_t xdr_guestfs_mount_9p_args (XDR *, guestfs_mount_9p_args*);
extern  bool_t xdr_guestfs_mount_loop_args (XDR *, guestfs_mount_loop_args*);
extern  bool_t xdr_guestfs_mount_options_args (XDR *, guestfs_mount_options_args*);
extern  bool_t xdr_guestfs_mount_ro_args (XDR *, guestfs_mount_ro_args*);
extern  bool_t xdr_guestfs_mount_vfs_args (XDR *, guestfs_mount_vfs_args*);
extern  bool_t xdr_guestfs_mountpoints_ret (XDR *, guestfs_mountpoints_ret*);
extern  bool_t xdr_guestfs_mounts_ret (XDR *, guestfs_mounts_ret*);
extern  bool_t xdr_guestfs_mv_args (XDR *, guestfs_mv_args*);
extern  bool_t xdr_guestfs_nr_devices_ret (XDR *, guestfs_nr_devices_ret*);
extern  bool_t xdr_guestfs_ntfs_3g_probe_args (XDR *, guestfs_ntfs_3g_probe_args*);
extern  bool_t xdr_guestfs_ntfs_3g_probe_ret (XDR *, guestfs_ntfs_3g_probe_ret*);
extern  bool_t xdr_guestfs_ntfscat_i_args (XDR *, guestfs_ntfscat_i_args*);
extern  bool_t xdr_guestfs_ntfsclone_in_args (XDR *, guestfs_ntfsclone_in_args*);
extern  bool_t xdr_guestfs_ntfsclone_out_args (XDR *, guestfs_ntfsclone_out_args*);
extern  bool_t xdr_guestfs_ntfsfix_args (XDR *, guestfs_ntfsfix_args*);
extern  bool_t xdr_guestfs_ntfsresize_args (XDR *, guestfs_ntfsresize_args*);
extern  bool_t xdr_guestfs_ntfsresize_size_args (XDR *, guestfs_ntfsresize_size_args*);
extern  bool_t xdr_guestfs_part_add_args (XDR *, guestfs_part_add_args*);
extern  bool_t xdr_guestfs_part_del_args (XDR *, guestfs_part_del_args*);
extern  bool_t xdr_guestfs_part_disk_args (XDR *, guestfs_part_disk_args*);
extern  bool_t xdr_guestfs_part_expand_gpt_args (XDR *, guestfs_part_expand_gpt_args*);
extern  bool_t xdr_guestfs_part_get_bootable_args (XDR *, guestfs_part_get_bootable_args*);
extern  bool_t xdr_guestfs_part_get_bootable_ret (XDR *, guestfs_part_get_bootable_ret*);
extern  bool_t xdr_guestfs_part_get_disk_guid_args (XDR *, guestfs_part_get_disk_guid_args*);
extern  bool_t xdr_guestfs_part_get_disk_guid_ret (XDR *, guestfs_part_get_disk_guid_ret*);
extern  bool_t xdr_guestfs_part_get_gpt_attributes_args (XDR *, guestfs_part_get_gpt_attributes_args*);
extern  bool_t xdr_guestfs_part_get_gpt_attributes_ret (XDR *, guestfs_part_get_gpt_attributes_ret*);
extern  bool_t xdr_guestfs_part_get_gpt_guid_args (XDR *, guestfs_part_get_gpt_guid_args*);
extern  bool_t xdr_guestfs_part_get_gpt_guid_ret (XDR *, guestfs_part_get_gpt_guid_ret*);
extern  bool_t xdr_guestfs_part_get_gpt_type_args (XDR *, guestfs_part_get_gpt_type_args*);
extern  bool_t xdr_guestfs_part_get_gpt_type_ret (XDR *, guestfs_part_get_gpt_type_ret*);
extern  bool_t xdr_guestfs_part_get_mbr_id_args (XDR *, guestfs_part_get_mbr_id_args*);
extern  bool_t xdr_guestfs_part_get_mbr_id_ret (XDR *, guestfs_part_get_mbr_id_ret*);
extern  bool_t xdr_guestfs_part_get_mbr_part_type_args (XDR *, guestfs_part_get_mbr_part_type_args*);
extern  bool_t xdr_guestfs_part_get_mbr_part_type_ret (XDR *, guestfs_part_get_mbr_part_type_ret*);
extern  bool_t xdr_guestfs_part_get_name_args (XDR *, guestfs_part_get_name_args*);
extern  bool_t xdr_guestfs_part_get_name_ret (XDR *, guestfs_part_get_name_ret*);
extern  bool_t xdr_guestfs_part_get_parttype_args (XDR *, guestfs_part_get_parttype_args*);
extern  bool_t xdr_guestfs_part_get_parttype_ret (XDR *, guestfs_part_get_parttype_ret*);
extern  bool_t xdr_guestfs_part_init_args (XDR *, guestfs_part_init_args*);
extern  bool_t xdr_guestfs_part_list_args (XDR *, guestfs_part_list_args*);
extern  bool_t xdr_guestfs_part_list_ret (XDR *, guestfs_part_list_ret*);
extern  bool_t xdr_guestfs_part_resize_args (XDR *, guestfs_part_resize_args*);
extern  bool_t xdr_guestfs_part_set_bootable_args (XDR *, guestfs_part_set_bootable_args*);
extern  bool_t xdr_guestfs_part_set_disk_guid_args (XDR *, guestfs_part_set_disk_guid_args*);
extern  bool_t xdr_guestfs_part_set_disk_guid_random_args (XDR *, guestfs_part_set_disk_guid_random_args*);
extern  bool_t xdr_guestfs_part_set_gpt_attributes_args (XDR *, guestfs_part_set_gpt_attributes_args*);
extern  bool_t xdr_guestfs_part_set_gpt_guid_args (XDR *, guestfs_part_set_gpt_guid_args*);
extern  bool_t xdr_guestfs_part_set_gpt_type_args (XDR *, guestfs_part_set_gpt_type_args*);
extern  bool_t xdr_guestfs_part_set_mbr_id_args (XDR *, guestfs_part_set_mbr_id_args*);
extern  bool_t xdr_guestfs_part_set_name_args (XDR *, guestfs_part_set_name_args*);
extern  bool_t xdr_guestfs_part_to_dev_args (XDR *, guestfs_part_to_dev_args*);
extern  bool_t xdr_guestfs_part_to_dev_ret (XDR *, guestfs_part_to_dev_ret*);
extern  bool_t xdr_guestfs_part_to_partnum_args (XDR *, guestfs_part_to_partnum_args*);
extern  bool_t xdr_guestfs_part_to_partnum_ret (XDR *, guestfs_part_to_partnum_ret*);
extern  bool_t xdr_guestfs_pread_args (XDR *, guestfs_pread_args*);
extern  bool_t xdr_guestfs_pread_ret (XDR *, guestfs_pread_ret*);
extern  bool_t xdr_guestfs_pread_device_args (XDR *, guestfs_pread_device_args*);
extern  bool_t xdr_guestfs_pread_device_ret (XDR *, guestfs_pread_device_ret*);
extern  bool_t xdr_guestfs_pvchange_uuid_args (XDR *, guestfs_pvchange_uuid_args*);
extern  bool_t xdr_guestfs_pvcreate_args (XDR *, guestfs_pvcreate_args*);
extern  bool_t xdr_guestfs_pvremove_args (XDR *, guestfs_pvremove_args*);
extern  bool_t xdr_guestfs_pvresize_args (XDR *, guestfs_pvresize_args*);
extern  bool_t xdr_guestfs_pvresize_size_args (XDR *, guestfs_pvresize_size_args*);
extern  bool_t xdr_guestfs_pvs_ret (XDR *, guestfs_pvs_ret*);
extern  bool_t xdr_guestfs_pvs_full_ret (XDR *, guestfs_pvs_full_ret*);
extern  bool_t xdr_guestfs_pvuuid_args (XDR *, guestfs_pvuuid_args*);
extern  bool_t xdr_guestfs_pvuuid_ret (XDR *, guestfs_pvuuid_ret*);
extern  bool_t xdr_guestfs_pwrite_args (XDR *, guestfs_pwrite_args*);
extern  bool_t xdr_guestfs_pwrite_ret (XDR *, guestfs_pwrite_ret*);
extern  bool_t xdr_guestfs_pwrite_device_args (XDR *, guestfs_pwrite_device_args*);
extern  bool_t xdr_guestfs_pwrite_device_ret (XDR *, guestfs_pwrite_device_ret*);
extern  bool_t xdr_guestfs_readdir_args (XDR *, guestfs_readdir_args*);
extern  bool_t xdr_guestfs_readdir_ret (XDR *, guestfs_readdir_ret*);
extern  bool_t xdr_guestfs_readlink_args (XDR *, guestfs_readlink_args*);
extern  bool_t xdr_guestfs_readlink_ret (XDR *, guestfs_readlink_ret*);
extern  bool_t xdr_guestfs_realpath_args (XDR *, guestfs_realpath_args*);
extern  bool_t xdr_guestfs_realpath_ret (XDR *, guestfs_realpath_ret*);
extern  bool_t xdr_guestfs_remount_args (XDR *, guestfs_remount_args*);
extern  bool_t xdr_guestfs_removexattr_args (XDR *, guestfs_removexattr_args*);
extern  bool_t xdr_guestfs_rename_args (XDR *, guestfs_rename_args*);
extern  bool_t xdr_guestfs_resize2fs_args (XDR *, guestfs_resize2fs_args*);
extern  bool_t xdr_guestfs_resize2fs_M_args (XDR *, guestfs_resize2fs_M_args*);
extern  bool_t xdr_guestfs_resize2fs_size_args (XDR *, guestfs_resize2fs_size_args*);
extern  bool_t xdr_guestfs_rm_args (XDR *, guestfs_rm_args*);
extern  bool_t xdr_guestfs_rm_f_args (XDR *, guestfs_rm_f_args*);
extern  bool_t xdr_guestfs_rm_rf_args (XDR *, guestfs_rm_rf_args*);
extern  bool_t xdr_guestfs_rmdir_args (XDR *, guestfs_rmdir_args*);
extern  bool_t xdr_guestfs_rmmountpoint_args (XDR *, guestfs_rmmountpoint_args*);
extern  bool_t xdr_guestfs_rsync_args (XDR *, guestfs_rsync_args*);
extern  bool_t xdr_guestfs_rsync_in_args (XDR *, guestfs_rsync_in_args*);
extern  bool_t xdr_guestfs_rsync_out_args (XDR *, guestfs_rsync_out_args*);
extern  bool_t xdr_guestfs_scrub_device_args (XDR *, guestfs_scrub_device_args*);
extern  bool_t xdr_guestfs_scrub_file_args (XDR *, guestfs_scrub_file_args*);
extern  bool_t xdr_guestfs_scrub_freespace_args (XDR *, guestfs_scrub_freespace_args*);
extern  bool_t xdr_guestfs_selinux_relabel_args (XDR *, guestfs_selinux_relabel_args*);
extern  bool_t xdr_guestfs_set_e2attrs_args (XDR *, guestfs_set_e2attrs_args*);
extern  bool_t xdr_guestfs_set_e2generation_args (XDR *, guestfs_set_e2generation_args*);
extern  bool_t xdr_guestfs_set_e2label_args (XDR *, guestfs_set_e2label_args*);
extern  bool_t xdr_guestfs_set_e2uuid_args (XDR *, guestfs_set_e2uuid_args*);
extern  bool_t xdr_guestfs_set_label_args (XDR *, guestfs_set_label_args*);
extern  bool_t xdr_guestfs_set_uuid_args (XDR *, guestfs_set_uuid_args*);
extern  bool_t xdr_guestfs_set_uuid_random_args (XDR *, guestfs_set_uuid_random_args*);
extern  bool_t xdr_guestfs_setcon_args (XDR *, guestfs_setcon_args*);
extern  bool_t xdr_guestfs_setxattr_args (XDR *, guestfs_setxattr_args*);
extern  bool_t xdr_guestfs_sfdisk_args (XDR *, guestfs_sfdisk_args*);
extern  bool_t xdr_guestfs_sfdiskM_args (XDR *, guestfs_sfdiskM_args*);
extern  bool_t xdr_guestfs_sfdisk_N_args (XDR *, guestfs_sfdisk_N_args*);
extern  bool_t xdr_guestfs_sfdisk_disk_geometry_args (XDR *, guestfs_sfdisk_disk_geometry_args*);
extern  bool_t xdr_guestfs_sfdisk_disk_geometry_ret (XDR *, guestfs_sfdisk_disk_geometry_ret*);
extern  bool_t xdr_guestfs_sfdisk_kernel_geometry_args (XDR *, guestfs_sfdisk_kernel_geometry_args*);
extern  bool_t xdr_guestfs_sfdisk_kernel_geometry_ret (XDR *, guestfs_sfdisk_kernel_geometry_ret*);
extern  bool_t xdr_guestfs_sfdisk_l_args (XDR *, guestfs_sfdisk_l_args*);
extern  bool_t xdr_guestfs_sfdisk_l_ret (XDR *, guestfs_sfdisk_l_ret*);
extern  bool_t xdr_guestfs_sh_args (XDR *, guestfs_sh_args*);
extern  bool_t xdr_guestfs_sh_ret (XDR *, guestfs_sh_ret*);
extern  bool_t xdr_guestfs_sh_lines_args (XDR *, guestfs_sh_lines_args*);
extern  bool_t xdr_guestfs_sh_lines_ret (XDR *, guestfs_sh_lines_ret*);
extern  bool_t xdr_guestfs_sleep_args (XDR *, guestfs_sleep_args*);
extern  bool_t xdr_guestfs_statns_args (XDR *, guestfs_statns_args*);
extern  bool_t xdr_guestfs_statns_ret (XDR *, guestfs_statns_ret*);
extern  bool_t xdr_guestfs_statvfs_args (XDR *, guestfs_statvfs_args*);
extern  bool_t xdr_guestfs_statvfs_ret (XDR *, guestfs_statvfs_ret*);
extern  bool_t xdr_guestfs_strings_args (XDR *, guestfs_strings_args*);
extern  bool_t xdr_guestfs_strings_ret (XDR *, guestfs_strings_ret*);
extern  bool_t xdr_guestfs_strings_e_args (XDR *, guestfs_strings_e_args*);
extern  bool_t xdr_guestfs_strings_e_ret (XDR *, guestfs_strings_e_ret*);
extern  bool_t xdr_guestfs_swapoff_device_args (XDR *, guestfs_swapoff_device_args*);
extern  bool_t xdr_guestfs_swapoff_file_args (XDR *, guestfs_swapoff_file_args*);
extern  bool_t xdr_guestfs_swapoff_label_args (XDR *, guestfs_swapoff_label_args*);
extern  bool_t xdr_guestfs_swapoff_uuid_args (XDR *, guestfs_swapoff_uuid_args*);
extern  bool_t xdr_guestfs_swapon_device_args (XDR *, guestfs_swapon_device_args*);
extern  bool_t xdr_guestfs_swapon_file_args (XDR *, guestfs_swapon_file_args*);
extern  bool_t xdr_guestfs_swapon_label_args (XDR *, guestfs_swapon_label_args*);
extern  bool_t xdr_guestfs_swapon_uuid_args (XDR *, guestfs_swapon_uuid_args*);
extern  bool_t xdr_guestfs_syslinux_args (XDR *, guestfs_syslinux_args*);
extern  bool_t xdr_guestfs_tail_args (XDR *, guestfs_tail_args*);
extern  bool_t xdr_guestfs_tail_ret (XDR *, guestfs_tail_ret*);
extern  bool_t xdr_guestfs_tail_n_args (XDR *, guestfs_tail_n_args*);
extern  bool_t xdr_guestfs_tail_n_ret (XDR *, guestfs_tail_n_ret*);
extern  bool_t xdr_guestfs_tar_in_args (XDR *, guestfs_tar_in_args*);
extern  bool_t xdr_guestfs_tar_out_args (XDR *, guestfs_tar_out_args*);
extern  bool_t xdr_guestfs_tgz_in_args (XDR *, guestfs_tgz_in_args*);
extern  bool_t xdr_guestfs_tgz_out_args (XDR *, guestfs_tgz_out_args*);
extern  bool_t xdr_guestfs_touch_args (XDR *, guestfs_touch_args*);
extern  bool_t xdr_guestfs_truncate_args (XDR *, guestfs_truncate_args*);
extern  bool_t xdr_guestfs_truncate_size_args (XDR *, guestfs_truncate_size_args*);
extern  bool_t xdr_guestfs_tune2fs_args (XDR *, guestfs_tune2fs_args*);
extern  bool_t xdr_guestfs_tune2fs_l_args (XDR *, guestfs_tune2fs_l_args*);
extern  bool_t xdr_guestfs_tune2fs_l_ret (XDR *, guestfs_tune2fs_l_ret*);
extern  bool_t xdr_guestfs_txz_in_args (XDR *, guestfs_txz_in_args*);
extern  bool_t xdr_guestfs_txz_out_args (XDR *, guestfs_txz_out_args*);
extern  bool_t xdr_guestfs_umask_args (XDR *, guestfs_umask_args*);
extern  bool_t xdr_guestfs_umask_ret (XDR *, guestfs_umask_ret*);
extern  bool_t xdr_guestfs_umount_args (XDR *, guestfs_umount_args*);
extern  bool_t xdr_guestfs_upload_args (XDR *, guestfs_upload_args*);
extern  bool_t xdr_guestfs_upload_offset_args (XDR *, guestfs_upload_offset_args*);
extern  bool_t xdr_guestfs_utimens_args (XDR *, guestfs_utimens_args*);
extern  bool_t xdr_guestfs_utsname_ret (XDR *, guestfs_utsname_ret*);
extern  bool_t xdr_guestfs_vfs_label_args (XDR *, guestfs_vfs_label_args*);
extern  bool_t xdr_guestfs_vfs_label_ret (XDR *, guestfs_vfs_label_ret*);
extern  bool_t xdr_guestfs_vfs_minimum_size_args (XDR *, guestfs_vfs_minimum_size_args*);
extern  bool_t xdr_guestfs_vfs_minimum_size_ret (XDR *, guestfs_vfs_minimum_size_ret*);
extern  bool_t xdr_guestfs_vfs_type_args (XDR *, guestfs_vfs_type_args*);
extern  bool_t xdr_guestfs_vfs_type_ret (XDR *, guestfs_vfs_type_ret*);
extern  bool_t xdr_guestfs_vfs_uuid_args (XDR *, guestfs_vfs_uuid_args*);
extern  bool_t xdr_guestfs_vfs_uuid_ret (XDR *, guestfs_vfs_uuid_ret*);
extern  bool_t xdr_guestfs_vg_activate_args (XDR *, guestfs_vg_activate_args*);
extern  bool_t xdr_guestfs_vg_activate_all_args (XDR *, guestfs_vg_activate_all_args*);
extern  bool_t xdr_guestfs_vgchange_uuid_args (XDR *, guestfs_vgchange_uuid_args*);
extern  bool_t xdr_guestfs_vgcreate_args (XDR *, guestfs_vgcreate_args*);
extern  bool_t xdr_guestfs_vglvuuids_args (XDR *, guestfs_vglvuuids_args*);
extern  bool_t xdr_guestfs_vglvuuids_ret (XDR *, guestfs_vglvuuids_ret*);
extern  bool_t xdr_guestfs_vgmeta_args (XDR *, guestfs_vgmeta_args*);
extern  bool_t xdr_guestfs_vgmeta_ret (XDR *, guestfs_vgmeta_ret*);
extern  bool_t xdr_guestfs_vgpvuuids_args (XDR *, guestfs_vgpvuuids_args*);
extern  bool_t xdr_guestfs_vgpvuuids_ret (XDR *, guestfs_vgpvuuids_ret*);
extern  bool_t xdr_guestfs_vgremove_args (XDR *, guestfs_vgremove_args*);
extern  bool_t xdr_guestfs_vgrename_args (XDR *, guestfs_vgrename_args*);
extern  bool_t xdr_guestfs_vgs_ret (XDR *, guestfs_vgs_ret*);
extern  bool_t xdr_guestfs_vgs_full_ret (XDR *, guestfs_vgs_full_ret*);
extern  bool_t xdr_guestfs_vguuid_args (XDR *, guestfs_vguuid_args*);
extern  bool_t xdr_guestfs_vguuid_ret (XDR *, guestfs_vguuid_ret*);
extern  bool_t xdr_guestfs_wc_c_args (XDR *, guestfs_wc_c_args*);
extern  bool_t xdr_guestfs_wc_c_ret (XDR *, guestfs_wc_c_ret*);
extern  bool_t xdr_guestfs_wc_l_args (XDR *, guestfs_wc_l_args*);
extern  bool_t xdr_guestfs_wc_l_ret (XDR *, guestfs_wc_l_ret*);
extern  bool_t xdr_guestfs_wc_w_args (XDR *, guestfs_wc_w_args*);
extern  bool_t xdr_guestfs_wc_w_ret (XDR *, guestfs_wc_w_ret*);
extern  bool_t xdr_guestfs_wipefs_args (XDR *, guestfs_wipefs_args*);
extern  bool_t xdr_guestfs_write_file_args (XDR *, guestfs_write_file_args*);
extern  bool_t xdr_guestfs_xfs_admin_args (XDR *, guestfs_xfs_admin_args*);
extern  bool_t xdr_guestfs_xfs_growfs_args (XDR *, guestfs_xfs_growfs_args*);
extern  bool_t xdr_guestfs_xfs_info_args (XDR *, guestfs_xfs_info_args*);
extern  bool_t xdr_guestfs_xfs_info_ret (XDR *, guestfs_xfs_info_ret*);
extern  bool_t xdr_guestfs_xfs_repair_args (XDR *, guestfs_xfs_repair_args*);
extern  bool_t xdr_guestfs_xfs_repair_ret (XDR *, guestfs_xfs_repair_ret*);
extern  bool_t xdr_guestfs_zegrep_args (XDR *, guestfs_zegrep_args*);
extern  bool_t xdr_guestfs_zegrep_ret (XDR *, guestfs_zegrep_ret*);
extern  bool_t xdr_guestfs_zegrepi_args (XDR *, guestfs_zegrepi_args*);
extern  bool_t xdr_guestfs_zegrepi_ret (XDR *, guestfs_zegrepi_ret*);
extern  bool_t xdr_guestfs_zero_args (XDR *, guestfs_zero_args*);
extern  bool_t xdr_guestfs_zero_device_args (XDR *, guestfs_zero_device_args*);
extern  bool_t xdr_guestfs_zero_free_space_args (XDR *, guestfs_zero_free_space_args*);
extern  bool_t xdr_guestfs_zerofree_args (XDR *, guestfs_zerofree_args*);
extern  bool_t xdr_guestfs_zfgrep_args (XDR *, guestfs_zfgrep_args*);
extern  bool_t xdr_guestfs_zfgrep_ret (XDR *, guestfs_zfgrep_ret*);
extern  bool_t xdr_guestfs_zfgrepi_args (XDR *, guestfs_zfgrepi_args*);
extern  bool_t xdr_guestfs_zfgrepi_ret (XDR *, guestfs_zfgrepi_ret*);
extern  bool_t xdr_guestfs_zfile_args (XDR *, guestfs_zfile_args*);
extern  bool_t xdr_guestfs_zfile_ret (XDR *, guestfs_zfile_ret*);
extern  bool_t xdr_guestfs_zgrep_args (XDR *, guestfs_zgrep_args*);
extern  bool_t xdr_guestfs_zgrep_ret (XDR *, guestfs_zgrep_ret*);
extern  bool_t xdr_guestfs_zgrepi_args (XDR *, guestfs_zgrepi_args*);
extern  bool_t xdr_guestfs_zgrepi_ret (XDR *, guestfs_zgrepi_ret*);
extern  bool_t xdr_guestfs_procedure (XDR *, guestfs_procedure*);
extern  bool_t xdr_guestfs_message_direction (XDR *, guestfs_message_direction*);
extern  bool_t xdr_guestfs_message_status (XDR *, guestfs_message_status*);
extern  bool_t xdr_guestfs_message_error (XDR *, guestfs_message_error*);
extern  bool_t xdr_guestfs_message_header (XDR *, guestfs_message_header*);
extern  bool_t xdr_guestfs_chunk (XDR *, guestfs_chunk*);
extern  bool_t xdr_guestfs_progress (XDR *, guestfs_progress*);

#else /* K&R C */
extern bool_t xdr_guestfs_str ();
extern bool_t xdr_guestfs_int_int_bool ();
extern bool_t xdr_guestfs_int_int_bool_list ();
extern bool_t xdr_guestfs_int_lvm_pv ();
extern bool_t xdr_guestfs_int_lvm_pv_list ();
extern bool_t xdr_guestfs_int_lvm_vg ();
extern bool_t xdr_guestfs_int_lvm_vg_list ();
extern bool_t xdr_guestfs_int_lvm_lv ();
extern bool_t xdr_guestfs_int_lvm_lv_list ();
extern bool_t xdr_guestfs_int_stat ();
extern bool_t xdr_guestfs_int_stat_list ();
extern bool_t xdr_guestfs_int_statns ();
extern bool_t xdr_guestfs_int_statns_list ();
extern bool_t xdr_guestfs_int_statvfs ();
extern bool_t xdr_guestfs_int_statvfs_list ();
extern bool_t xdr_guestfs_int_dirent ();
extern bool_t xdr_guestfs_int_dirent_list ();
extern bool_t xdr_guestfs_int_version ();
extern bool_t xdr_guestfs_int_version_list ();
extern bool_t xdr_guestfs_int_xattr ();
extern bool_t xdr_guestfs_int_xattr_list ();
extern bool_t xdr_guestfs_int_inotify_event ();
extern bool_t xdr_guestfs_int_inotify_event_list ();
extern bool_t xdr_guestfs_int_partition ();
extern bool_t xdr_guestfs_int_partition_list ();
extern bool_t xdr_guestfs_int_application ();
extern bool_t xdr_guestfs_int_application_list ();
extern bool_t xdr_guestfs_int_application2 ();
extern bool_t xdr_guestfs_int_application2_list ();
extern bool_t xdr_guestfs_int_isoinfo ();
extern bool_t xdr_guestfs_int_isoinfo_list ();
extern bool_t xdr_guestfs_int_mdstat ();
extern bool_t xdr_guestfs_int_mdstat_list ();
extern bool_t xdr_guestfs_int_btrfssubvolume ();
extern bool_t xdr_guestfs_int_btrfssubvolume_list ();
extern bool_t xdr_guestfs_int_btrfsqgroup ();
extern bool_t xdr_guestfs_int_btrfsqgroup_list ();
extern bool_t xdr_guestfs_int_btrfsbalance ();
extern bool_t xdr_guestfs_int_btrfsbalance_list ();
extern bool_t xdr_guestfs_int_btrfsscrub ();
extern bool_t xdr_guestfs_int_btrfsscrub_list ();
extern bool_t xdr_guestfs_int_xfsinfo ();
extern bool_t xdr_guestfs_int_xfsinfo_list ();
extern bool_t xdr_guestfs_int_utsname ();
extern bool_t xdr_guestfs_int_utsname_list ();
extern bool_t xdr_guestfs_int_hivex_node ();
extern bool_t xdr_guestfs_int_hivex_node_list ();
extern bool_t xdr_guestfs_int_hivex_value ();
extern bool_t xdr_guestfs_int_hivex_value_list ();
extern bool_t xdr_guestfs_int_internal_mountable ();
extern bool_t xdr_guestfs_int_internal_mountable_list ();
extern bool_t xdr_guestfs_int_tsk_dirent ();
extern bool_t xdr_guestfs_int_tsk_dirent_list ();
extern bool_t xdr_guestfs_int_yara_detection ();
extern bool_t xdr_guestfs_int_yara_detection_list ();
extern bool_t xdr_guestfs_acl_delete_def_file_args ();
extern bool_t xdr_guestfs_acl_get_file_args ();
extern bool_t xdr_guestfs_acl_get_file_ret ();
extern bool_t xdr_guestfs_acl_set_file_args ();
extern bool_t xdr_guestfs_aug_clear_args ();
extern bool_t xdr_guestfs_aug_defnode_args ();
extern bool_t xdr_guestfs_aug_defnode_ret ();
extern bool_t xdr_guestfs_aug_defvar_args ();
extern bool_t xdr_guestfs_aug_defvar_ret ();
extern bool_t xdr_guestfs_aug_get_args ();
extern bool_t xdr_guestfs_aug_get_ret ();
extern bool_t xdr_guestfs_aug_init_args ();
extern bool_t xdr_guestfs_aug_insert_args ();
extern bool_t xdr_guestfs_aug_label_args ();
extern bool_t xdr_guestfs_aug_label_ret ();
extern bool_t xdr_guestfs_aug_ls_args ();
extern bool_t xdr_guestfs_aug_ls_ret ();
extern bool_t xdr_guestfs_aug_match_args ();
extern bool_t xdr_guestfs_aug_match_ret ();
extern bool_t xdr_guestfs_aug_mv_args ();
extern bool_t xdr_guestfs_aug_rm_args ();
extern bool_t xdr_guestfs_aug_rm_ret ();
extern bool_t xdr_guestfs_aug_set_args ();
extern bool_t xdr_guestfs_aug_setm_args ();
extern bool_t xdr_guestfs_aug_setm_ret ();
extern bool_t xdr_guestfs_aug_transform_args ();
extern bool_t xdr_guestfs_available_all_groups_ret ();
extern bool_t xdr_guestfs_base64_in_args ();
extern bool_t xdr_guestfs_base64_out_args ();
extern bool_t xdr_guestfs_blkdiscard_args ();
extern bool_t xdr_guestfs_blkdiscardzeroes_args ();
extern bool_t xdr_guestfs_blkdiscardzeroes_ret ();
extern bool_t xdr_guestfs_blkid_args ();
extern bool_t xdr_guestfs_blkid_ret ();
extern bool_t xdr_guestfs_blockdev_flushbufs_args ();
extern bool_t xdr_guestfs_blockdev_getbsz_args ();
extern bool_t xdr_guestfs_blockdev_getbsz_ret ();
extern bool_t xdr_guestfs_blockdev_getro_args ();
extern bool_t xdr_guestfs_blockdev_getro_ret ();
extern bool_t xdr_guestfs_blockdev_getsize64_args ();
extern bool_t xdr_guestfs_blockdev_getsize64_ret ();
extern bool_t xdr_guestfs_blockdev_getss_args ();
extern bool_t xdr_guestfs_blockdev_getss_ret ();
extern bool_t xdr_guestfs_blockdev_getsz_args ();
extern bool_t xdr_guestfs_blockdev_getsz_ret ();
extern bool_t xdr_guestfs_blockdev_rereadpt_args ();
extern bool_t xdr_guestfs_blockdev_setbsz_args ();
extern bool_t xdr_guestfs_blockdev_setra_args ();
extern bool_t xdr_guestfs_blockdev_setro_args ();
extern bool_t xdr_guestfs_blockdev_setrw_args ();
extern bool_t xdr_guestfs_btrfs_balance_cancel_args ();
extern bool_t xdr_guestfs_btrfs_balance_pause_args ();
extern bool_t xdr_guestfs_btrfs_balance_resume_args ();
extern bool_t xdr_guestfs_btrfs_balance_status_args ();
extern bool_t xdr_guestfs_btrfs_balance_status_ret ();
extern bool_t xdr_guestfs_btrfs_device_add_args ();
extern bool_t xdr_guestfs_btrfs_device_delete_args ();
extern bool_t xdr_guestfs_btrfs_filesystem_balance_args ();
extern bool_t xdr_guestfs_btrfs_filesystem_defragment_args ();
extern bool_t xdr_guestfs_btrfs_filesystem_resize_args ();
extern bool_t xdr_guestfs_btrfs_filesystem_show_args ();
extern bool_t xdr_guestfs_btrfs_filesystem_show_ret ();
extern bool_t xdr_guestfs_btrfs_filesystem_sync_args ();
extern bool_t xdr_guestfs_btrfs_fsck_args ();
extern bool_t xdr_guestfs_btrfs_image_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_assign_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_create_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_destroy_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_limit_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_remove_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_show_args ();
extern bool_t xdr_guestfs_btrfs_qgroup_show_ret ();
extern bool_t xdr_guestfs_btrfs_quota_enable_args ();
extern bool_t xdr_guestfs_btrfs_quota_rescan_args ();
extern bool_t xdr_guestfs_btrfs_replace_args ();
extern bool_t xdr_guestfs_btrfs_rescue_chunk_recover_args ();
extern bool_t xdr_guestfs_btrfs_rescue_super_recover_args ();
extern bool_t xdr_guestfs_btrfs_scrub_cancel_args ();
extern bool_t xdr_guestfs_btrfs_scrub_resume_args ();
extern bool_t xdr_guestfs_btrfs_scrub_start_args ();
extern bool_t xdr_guestfs_btrfs_scrub_status_args ();
extern bool_t xdr_guestfs_btrfs_scrub_status_ret ();
extern bool_t xdr_guestfs_btrfs_set_seeding_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_create_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_delete_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_get_default_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_get_default_ret ();
extern bool_t xdr_guestfs_btrfs_subvolume_list_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_list_ret ();
extern bool_t xdr_guestfs_btrfs_subvolume_set_default_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_show_args ();
extern bool_t xdr_guestfs_btrfs_subvolume_show_ret ();
extern bool_t xdr_guestfs_btrfs_subvolume_snapshot_args ();
extern bool_t xdr_guestfs_btrfstune_enable_extended_inode_refs_args ();
extern bool_t xdr_guestfs_btrfstune_enable_skinny_metadata_extent_refs_args ();
extern bool_t xdr_guestfs_btrfstune_seeding_args ();
extern bool_t xdr_guestfs_cap_get_file_args ();
extern bool_t xdr_guestfs_cap_get_file_ret ();
extern bool_t xdr_guestfs_cap_set_file_args ();
extern bool_t xdr_guestfs_case_sensitive_path_args ();
extern bool_t xdr_guestfs_case_sensitive_path_ret ();
extern bool_t xdr_guestfs_checksum_args ();
extern bool_t xdr_guestfs_checksum_ret ();
extern bool_t xdr_guestfs_checksum_device_args ();
extern bool_t xdr_guestfs_checksum_device_ret ();
extern bool_t xdr_guestfs_checksums_out_args ();
extern bool_t xdr_guestfs_chmod_args ();
extern bool_t xdr_guestfs_chown_args ();
extern bool_t xdr_guestfs_command_args ();
extern bool_t xdr_guestfs_command_ret ();
extern bool_t xdr_guestfs_command_lines_args ();
extern bool_t xdr_guestfs_command_lines_ret ();
extern bool_t xdr_guestfs_compress_device_out_args ();
extern bool_t xdr_guestfs_compress_out_args ();
extern bool_t xdr_guestfs_copy_attributes_args ();
extern bool_t xdr_guestfs_copy_device_to_device_args ();
extern bool_t xdr_guestfs_copy_device_to_file_args ();
extern bool_t xdr_guestfs_copy_file_to_device_args ();
extern bool_t xdr_guestfs_copy_file_to_file_args ();
extern bool_t xdr_guestfs_copy_size_args ();
extern bool_t xdr_guestfs_cp_args ();
extern bool_t xdr_guestfs_cp_a_args ();
extern bool_t xdr_guestfs_cp_r_args ();
extern bool_t xdr_guestfs_cpio_out_args ();
extern bool_t xdr_guestfs_cryptsetup_close_args ();
extern bool_t xdr_guestfs_cryptsetup_open_args ();
extern bool_t xdr_guestfs_dd_args ();
extern bool_t xdr_guestfs_debug_args ();
extern bool_t xdr_guestfs_debug_ret ();
extern bool_t xdr_guestfs_debug_upload_args ();
extern bool_t xdr_guestfs_df_ret ();
extern bool_t xdr_guestfs_df_h_ret ();
extern bool_t xdr_guestfs_dmesg_ret ();
extern bool_t xdr_guestfs_download_args ();
extern bool_t xdr_guestfs_download_blocks_args ();
extern bool_t xdr_guestfs_download_inode_args ();
extern bool_t xdr_guestfs_download_offset_args ();
extern bool_t xdr_guestfs_drop_caches_args ();
extern bool_t xdr_guestfs_du_args ();
extern bool_t xdr_guestfs_du_ret ();
extern bool_t xdr_guestfs_e2fsck_args ();
extern bool_t xdr_guestfs_e2fsck_f_args ();
extern bool_t xdr_guestfs_echo_daemon_args ();
extern bool_t xdr_guestfs_echo_daemon_ret ();
extern bool_t xdr_guestfs_egrep_args ();
extern bool_t xdr_guestfs_egrep_ret ();
extern bool_t xdr_guestfs_egrepi_args ();
extern bool_t xdr_guestfs_egrepi_ret ();
extern bool_t xdr_guestfs_equal_args ();
extern bool_t xdr_guestfs_equal_ret ();
extern bool_t xdr_guestfs_exists_args ();
extern bool_t xdr_guestfs_exists_ret ();
extern bool_t xdr_guestfs_extlinux_args ();
extern bool_t xdr_guestfs_f2fs_expand_args ();
extern bool_t xdr_guestfs_fallocate_args ();
extern bool_t xdr_guestfs_fallocate64_args ();
extern bool_t xdr_guestfs_fgrep_args ();
extern bool_t xdr_guestfs_fgrep_ret ();
extern bool_t xdr_guestfs_fgrepi_args ();
extern bool_t xdr_guestfs_fgrepi_ret ();
extern bool_t xdr_guestfs_file_args ();
extern bool_t xdr_guestfs_file_ret ();
extern bool_t xdr_guestfs_file_architecture_args ();
extern bool_t xdr_guestfs_file_architecture_ret ();
extern bool_t xdr_guestfs_filesize_args ();
extern bool_t xdr_guestfs_filesize_ret ();
extern bool_t xdr_guestfs_filesystem_available_args ();
extern bool_t xdr_guestfs_filesystem_available_ret ();
extern bool_t xdr_guestfs_fill_args ();
extern bool_t xdr_guestfs_fill_dir_args ();
extern bool_t xdr_guestfs_fill_pattern_args ();
extern bool_t xdr_guestfs_find0_args ();
extern bool_t xdr_guestfs_findfs_label_args ();
extern bool_t xdr_guestfs_findfs_label_ret ();
extern bool_t xdr_guestfs_findfs_uuid_args ();
extern bool_t xdr_guestfs_findfs_uuid_ret ();
extern bool_t xdr_guestfs_fsck_args ();
extern bool_t xdr_guestfs_fsck_ret ();
extern bool_t xdr_guestfs_fstrim_args ();
extern bool_t xdr_guestfs_get_e2attrs_args ();
extern bool_t xdr_guestfs_get_e2attrs_ret ();
extern bool_t xdr_guestfs_get_e2generation_args ();
extern bool_t xdr_guestfs_get_e2generation_ret ();
extern bool_t xdr_guestfs_get_e2label_args ();
extern bool_t xdr_guestfs_get_e2label_ret ();
extern bool_t xdr_guestfs_get_e2uuid_args ();
extern bool_t xdr_guestfs_get_e2uuid_ret ();
extern bool_t xdr_guestfs_get_umask_ret ();
extern bool_t xdr_guestfs_getcon_ret ();
extern bool_t xdr_guestfs_getxattr_args ();
extern bool_t xdr_guestfs_getxattr_ret ();
extern bool_t xdr_guestfs_getxattrs_args ();
extern bool_t xdr_guestfs_getxattrs_ret ();
extern bool_t xdr_guestfs_glob_expand_args ();
extern bool_t xdr_guestfs_glob_expand_ret ();
extern bool_t xdr_guestfs_grep_args ();
extern bool_t xdr_guestfs_grep_ret ();
extern bool_t xdr_guestfs_grepi_args ();
extern bool_t xdr_guestfs_grepi_ret ();
extern bool_t xdr_guestfs_grub_install_args ();
extern bool_t xdr_guestfs_head_args ();
extern bool_t xdr_guestfs_head_ret ();
extern bool_t xdr_guestfs_head_n_args ();
extern bool_t xdr_guestfs_head_n_ret ();
extern bool_t xdr_guestfs_hexdump_args ();
extern bool_t xdr_guestfs_hexdump_ret ();
extern bool_t xdr_guestfs_hivex_commit_args ();
extern bool_t xdr_guestfs_hivex_node_add_child_args ();
extern bool_t xdr_guestfs_hivex_node_add_child_ret ();
extern bool_t xdr_guestfs_hivex_node_children_args ();
extern bool_t xdr_guestfs_hivex_node_children_ret ();
extern bool_t xdr_guestfs_hivex_node_delete_child_args ();
extern bool_t xdr_guestfs_hivex_node_get_child_args ();
extern bool_t xdr_guestfs_hivex_node_get_child_ret ();
extern bool_t xdr_guestfs_hivex_node_get_value_args ();
extern bool_t xdr_guestfs_hivex_node_get_value_ret ();
extern bool_t xdr_guestfs_hivex_node_name_args ();
extern bool_t xdr_guestfs_hivex_node_name_ret ();
extern bool_t xdr_guestfs_hivex_node_parent_args ();
extern bool_t xdr_guestfs_hivex_node_parent_ret ();
extern bool_t xdr_guestfs_hivex_node_set_value_args ();
extern bool_t xdr_guestfs_hivex_node_values_args ();
extern bool_t xdr_guestfs_hivex_node_values_ret ();
extern bool_t xdr_guestfs_hivex_open_args ();
extern bool_t xdr_guestfs_hivex_root_ret ();
extern bool_t xdr_guestfs_hivex_value_key_args ();
extern bool_t xdr_guestfs_hivex_value_key_ret ();
extern bool_t xdr_guestfs_hivex_value_string_args ();
extern bool_t xdr_guestfs_hivex_value_string_ret ();
extern bool_t xdr_guestfs_hivex_value_type_args ();
extern bool_t xdr_guestfs_hivex_value_type_ret ();
extern bool_t xdr_guestfs_hivex_value_utf8_args ();
extern bool_t xdr_guestfs_hivex_value_utf8_ret ();
extern bool_t xdr_guestfs_hivex_value_value_args ();
extern bool_t xdr_guestfs_hivex_value_value_ret ();
extern bool_t xdr_guestfs_initrd_cat_args ();
extern bool_t xdr_guestfs_initrd_cat_ret ();
extern bool_t xdr_guestfs_initrd_list_args ();
extern bool_t xdr_guestfs_initrd_list_ret ();
extern bool_t xdr_guestfs_inotify_add_watch_args ();
extern bool_t xdr_guestfs_inotify_add_watch_ret ();
extern bool_t xdr_guestfs_inotify_files_ret ();
extern bool_t xdr_guestfs_inotify_init_args ();
extern bool_t xdr_guestfs_inotify_read_ret ();
extern bool_t xdr_guestfs_inotify_rm_watch_args ();
extern bool_t xdr_guestfs_inspect_get_arch_args ();
extern bool_t xdr_guestfs_inspect_get_arch_ret ();
extern bool_t xdr_guestfs_inspect_get_distro_args ();
extern bool_t xdr_guestfs_inspect_get_distro_ret ();
extern bool_t xdr_guestfs_inspect_get_drive_mappings_args ();
extern bool_t xdr_guestfs_inspect_get_drive_mappings_ret ();
extern bool_t xdr_guestfs_inspect_get_filesystems_args ();
extern bool_t xdr_guestfs_inspect_get_filesystems_ret ();
extern bool_t xdr_guestfs_inspect_get_format_args ();
extern bool_t xdr_guestfs_inspect_get_format_ret ();
extern bool_t xdr_guestfs_inspect_get_hostname_args ();
extern bool_t xdr_guestfs_inspect_get_hostname_ret ();
extern bool_t xdr_guestfs_inspect_get_major_version_args ();
extern bool_t xdr_guestfs_inspect_get_major_version_ret ();
extern bool_t xdr_guestfs_inspect_get_minor_version_args ();
extern bool_t xdr_guestfs_inspect_get_minor_version_ret ();
extern bool_t xdr_guestfs_inspect_get_mountpoints_args ();
extern bool_t xdr_guestfs_inspect_get_mountpoints_ret ();
extern bool_t xdr_guestfs_inspect_get_package_format_args ();
extern bool_t xdr_guestfs_inspect_get_package_format_ret ();
extern bool_t xdr_guestfs_inspect_get_package_management_args ();
extern bool_t xdr_guestfs_inspect_get_package_management_ret ();
extern bool_t xdr_guestfs_inspect_get_product_name_args ();
extern bool_t xdr_guestfs_inspect_get_product_name_ret ();
extern bool_t xdr_guestfs_inspect_get_product_variant_args ();
extern bool_t xdr_guestfs_inspect_get_product_variant_ret ();
extern bool_t xdr_guestfs_inspect_get_roots_ret ();
extern bool_t xdr_guestfs_inspect_get_type_args ();
extern bool_t xdr_guestfs_inspect_get_type_ret ();
extern bool_t xdr_guestfs_inspect_get_windows_current_control_set_args ();
extern bool_t xdr_guestfs_inspect_get_windows_current_control_set_ret ();
extern bool_t xdr_guestfs_inspect_get_windows_software_hive_args ();
extern bool_t xdr_guestfs_inspect_get_windows_software_hive_ret ();
extern bool_t xdr_guestfs_inspect_get_windows_system_hive_args ();
extern bool_t xdr_guestfs_inspect_get_windows_system_hive_ret ();
extern bool_t xdr_guestfs_inspect_get_windows_systemroot_args ();
extern bool_t xdr_guestfs_inspect_get_windows_systemroot_ret ();
extern bool_t xdr_guestfs_inspect_is_live_args ();
extern bool_t xdr_guestfs_inspect_is_live_ret ();
extern bool_t xdr_guestfs_inspect_is_multipart_args ();
extern bool_t xdr_guestfs_inspect_is_multipart_ret ();
extern bool_t xdr_guestfs_inspect_is_netinst_args ();
extern bool_t xdr_guestfs_inspect_is_netinst_ret ();
extern bool_t xdr_guestfs_inspect_os_ret ();
extern bool_t xdr_guestfs_internal_feature_available_args ();
extern bool_t xdr_guestfs_internal_feature_available_ret ();
extern bool_t xdr_guestfs_internal_filesystem_walk_args ();
extern bool_t xdr_guestfs_internal_find_inode_args ();
extern bool_t xdr_guestfs_internal_hot_add_drive_args ();
extern bool_t xdr_guestfs_internal_hot_remove_drive_args ();
extern bool_t xdr_guestfs_internal_hot_remove_drive_precheck_args ();
extern bool_t xdr_guestfs_internal_list_rpm_applications_ret ();
extern bool_t xdr_guestfs_internal_lstatnslist_args ();
extern bool_t xdr_guestfs_internal_lstatnslist_ret ();
extern bool_t xdr_guestfs_internal_lxattrlist_args ();
extern bool_t xdr_guestfs_internal_lxattrlist_ret ();
extern bool_t xdr_guestfs_internal_parse_mountable_args ();
extern bool_t xdr_guestfs_internal_parse_mountable_ret ();
extern bool_t xdr_guestfs_internal_readlinklist_args ();
extern bool_t xdr_guestfs_internal_readlinklist_ret ();
extern bool_t xdr_guestfs_internal_rhbz914931_args ();
extern bool_t xdr_guestfs_internal_upload_args ();
extern bool_t xdr_guestfs_internal_write_args ();
extern bool_t xdr_guestfs_internal_write_append_args ();
extern bool_t xdr_guestfs_internal_yara_scan_args ();
extern bool_t xdr_guestfs_is_blockdev_args ();
extern bool_t xdr_guestfs_is_blockdev_ret ();
extern bool_t xdr_guestfs_is_chardev_args ();
extern bool_t xdr_guestfs_is_chardev_ret ();
extern bool_t xdr_guestfs_is_dir_args ();
extern bool_t xdr_guestfs_is_dir_ret ();
extern bool_t xdr_guestfs_is_fifo_args ();
extern bool_t xdr_guestfs_is_fifo_ret ();
extern bool_t xdr_guestfs_is_file_args ();
extern bool_t xdr_guestfs_is_file_ret ();
extern bool_t xdr_guestfs_is_lv_args ();
extern bool_t xdr_guestfs_is_lv_ret ();
extern bool_t xdr_guestfs_is_socket_args ();
extern bool_t xdr_guestfs_is_socket_ret ();
extern bool_t xdr_guestfs_is_symlink_args ();
extern bool_t xdr_guestfs_is_symlink_ret ();
extern bool_t xdr_guestfs_is_whole_device_args ();
extern bool_t xdr_guestfs_is_whole_device_ret ();
extern bool_t xdr_guestfs_is_zero_args ();
extern bool_t xdr_guestfs_is_zero_ret ();
extern bool_t xdr_guestfs_is_zero_device_args ();
extern bool_t xdr_guestfs_is_zero_device_ret ();
extern bool_t xdr_guestfs_isoinfo_args ();
extern bool_t xdr_guestfs_isoinfo_ret ();
extern bool_t xdr_guestfs_isoinfo_device_args ();
extern bool_t xdr_guestfs_isoinfo_device_ret ();
extern bool_t xdr_guestfs_journal_get_data_threshold_ret ();
extern bool_t xdr_guestfs_journal_get_realtime_usec_ret ();
extern bool_t xdr_guestfs_journal_next_ret ();
extern bool_t xdr_guestfs_journal_open_args ();
extern bool_t xdr_guestfs_journal_set_data_threshold_args ();
extern bool_t xdr_guestfs_journal_skip_args ();
extern bool_t xdr_guestfs_journal_skip_ret ();
extern bool_t xdr_guestfs_lchown_args ();
extern bool_t xdr_guestfs_ldmtool_diskgroup_disks_args ();
extern bool_t xdr_guestfs_ldmtool_diskgroup_disks_ret ();
extern bool_t xdr_guestfs_ldmtool_diskgroup_name_args ();
extern bool_t xdr_guestfs_ldmtool_diskgroup_name_ret ();
extern bool_t xdr_guestfs_ldmtool_diskgroup_volumes_args ();
extern bool_t xdr_guestfs_ldmtool_diskgroup_volumes_ret ();
extern bool_t xdr_guestfs_ldmtool_scan_ret ();
extern bool_t xdr_guestfs_ldmtool_scan_devices_args ();
extern bool_t xdr_guestfs_ldmtool_scan_devices_ret ();
extern bool_t xdr_guestfs_ldmtool_volume_hint_args ();
extern bool_t xdr_guestfs_ldmtool_volume_hint_ret ();
extern bool_t xdr_guestfs_ldmtool_volume_partitions_args ();
extern bool_t xdr_guestfs_ldmtool_volume_partitions_ret ();
extern bool_t xdr_guestfs_ldmtool_volume_type_args ();
extern bool_t xdr_guestfs_ldmtool_volume_type_ret ();
extern bool_t xdr_guestfs_lgetxattr_args ();
extern bool_t xdr_guestfs_lgetxattr_ret ();
extern bool_t xdr_guestfs_lgetxattrs_args ();
extern bool_t xdr_guestfs_lgetxattrs_ret ();
extern bool_t xdr_guestfs_list_9p_ret ();
extern bool_t xdr_guestfs_list_devices_ret ();
extern bool_t xdr_guestfs_list_disk_labels_ret ();
extern bool_t xdr_guestfs_list_dm_devices_ret ();
extern bool_t xdr_guestfs_list_filesystems_ret ();
extern bool_t xdr_guestfs_list_ldm_partitions_ret ();
extern bool_t xdr_guestfs_list_ldm_volumes_ret ();
extern bool_t xdr_guestfs_list_md_devices_ret ();
extern bool_t xdr_guestfs_list_partitions_ret ();
extern bool_t xdr_guestfs_ll_args ();
extern bool_t xdr_guestfs_ll_ret ();
extern bool_t xdr_guestfs_llz_args ();
extern bool_t xdr_guestfs_llz_ret ();
extern bool_t xdr_guestfs_ln_args ();
extern bool_t xdr_guestfs_ln_f_args ();
extern bool_t xdr_guestfs_ln_s_args ();
extern bool_t xdr_guestfs_ln_sf_args ();
extern bool_t xdr_guestfs_lremovexattr_args ();
extern bool_t xdr_guestfs_ls0_args ();
extern bool_t xdr_guestfs_lsetxattr_args ();
extern bool_t xdr_guestfs_lstatns_args ();
extern bool_t xdr_guestfs_lstatns_ret ();
extern bool_t xdr_guestfs_luks_add_key_args ();
extern bool_t xdr_guestfs_luks_close_args ();
extern bool_t xdr_guestfs_luks_format_args ();
extern bool_t xdr_guestfs_luks_format_cipher_args ();
extern bool_t xdr_guestfs_luks_kill_slot_args ();
extern bool_t xdr_guestfs_luks_open_args ();
extern bool_t xdr_guestfs_luks_open_ro_args ();
extern bool_t xdr_guestfs_luks_uuid_args ();
extern bool_t xdr_guestfs_luks_uuid_ret ();
extern bool_t xdr_guestfs_lvcreate_args ();
extern bool_t xdr_guestfs_lvcreate_free_args ();
extern bool_t xdr_guestfs_lvm_canonical_lv_name_args ();
extern bool_t xdr_guestfs_lvm_canonical_lv_name_ret ();
extern bool_t xdr_guestfs_lvm_scan_args ();
extern bool_t xdr_guestfs_lvm_set_filter_args ();
extern bool_t xdr_guestfs_lvremove_args ();
extern bool_t xdr_guestfs_lvrename_args ();
extern bool_t xdr_guestfs_lvresize_args ();
extern bool_t xdr_guestfs_lvresize_free_args ();
extern bool_t xdr_guestfs_lvs_ret ();
extern bool_t xdr_guestfs_lvs_full_ret ();
extern bool_t xdr_guestfs_lvuuid_args ();
extern bool_t xdr_guestfs_lvuuid_ret ();
extern bool_t xdr_guestfs_md_create_args ();
extern bool_t xdr_guestfs_md_detail_args ();
extern bool_t xdr_guestfs_md_detail_ret ();
extern bool_t xdr_guestfs_md_stat_args ();
extern bool_t xdr_guestfs_md_stat_ret ();
extern bool_t xdr_guestfs_md_stop_args ();
extern bool_t xdr_guestfs_mkdir_args ();
extern bool_t xdr_guestfs_mkdir_mode_args ();
extern bool_t xdr_guestfs_mkdir_p_args ();
extern bool_t xdr_guestfs_mkdtemp_args ();
extern bool_t xdr_guestfs_mkdtemp_ret ();
extern bool_t xdr_guestfs_mke2fs_args ();
extern bool_t xdr_guestfs_mke2fs_J_args ();
extern bool_t xdr_guestfs_mke2fs_JL_args ();
extern bool_t xdr_guestfs_mke2fs_JU_args ();
extern bool_t xdr_guestfs_mke2journal_args ();
extern bool_t xdr_guestfs_mke2journal_L_args ();
extern bool_t xdr_guestfs_mke2journal_U_args ();
extern bool_t xdr_guestfs_mkfifo_args ();
extern bool_t xdr_guestfs_mkfs_args ();
extern bool_t xdr_guestfs_mkfs_b_args ();
extern bool_t xdr_guestfs_mkfs_btrfs_args ();
extern bool_t xdr_guestfs_mklost_and_found_args ();
extern bool_t xdr_guestfs_mkmountpoint_args ();
extern bool_t xdr_guestfs_mknod_args ();
extern bool_t xdr_guestfs_mknod_b_args ();
extern bool_t xdr_guestfs_mknod_c_args ();
extern bool_t xdr_guestfs_mksquashfs_args ();
extern bool_t xdr_guestfs_mkswap_args ();
extern bool_t xdr_guestfs_mkswap_L_args ();
extern bool_t xdr_guestfs_mkswap_U_args ();
extern bool_t xdr_guestfs_mkswap_file_args ();
extern bool_t xdr_guestfs_mktemp_args ();
extern bool_t xdr_guestfs_mktemp_ret ();
extern bool_t xdr_guestfs_modprobe_args ();
extern bool_t xdr_guestfs_mount_args ();
extern bool_t xdr_guestfs_mount_9p_args ();
extern bool_t xdr_guestfs_mount_loop_args ();
extern bool_t xdr_guestfs_mount_options_args ();
extern bool_t xdr_guestfs_mount_ro_args ();
extern bool_t xdr_guestfs_mount_vfs_args ();
extern bool_t xdr_guestfs_mountpoints_ret ();
extern bool_t xdr_guestfs_mounts_ret ();
extern bool_t xdr_guestfs_mv_args ();
extern bool_t xdr_guestfs_nr_devices_ret ();
extern bool_t xdr_guestfs_ntfs_3g_probe_args ();
extern bool_t xdr_guestfs_ntfs_3g_probe_ret ();
extern bool_t xdr_guestfs_ntfscat_i_args ();
extern bool_t xdr_guestfs_ntfsclone_in_args ();
extern bool_t xdr_guestfs_ntfsclone_out_args ();
extern bool_t xdr_guestfs_ntfsfix_args ();
extern bool_t xdr_guestfs_ntfsresize_args ();
extern bool_t xdr_guestfs_ntfsresize_size_args ();
extern bool_t xdr_guestfs_part_add_args ();
extern bool_t xdr_guestfs_part_del_args ();
extern bool_t xdr_guestfs_part_disk_args ();
extern bool_t xdr_guestfs_part_expand_gpt_args ();
extern bool_t xdr_guestfs_part_get_bootable_args ();
extern bool_t xdr_guestfs_part_get_bootable_ret ();
extern bool_t xdr_guestfs_part_get_disk_guid_args ();
extern bool_t xdr_guestfs_part_get_disk_guid_ret ();
extern bool_t xdr_guestfs_part_get_gpt_attributes_args ();
extern bool_t xdr_guestfs_part_get_gpt_attributes_ret ();
extern bool_t xdr_guestfs_part_get_gpt_guid_args ();
extern bool_t xdr_guestfs_part_get_gpt_guid_ret ();
extern bool_t xdr_guestfs_part_get_gpt_type_args ();
extern bool_t xdr_guestfs_part_get_gpt_type_ret ();
extern bool_t xdr_guestfs_part_get_mbr_id_args ();
extern bool_t xdr_guestfs_part_get_mbr_id_ret ();
extern bool_t xdr_guestfs_part_get_mbr_part_type_args ();
extern bool_t xdr_guestfs_part_get_mbr_part_type_ret ();
extern bool_t xdr_guestfs_part_get_name_args ();
extern bool_t xdr_guestfs_part_get_name_ret ();
extern bool_t xdr_guestfs_part_get_parttype_args ();
extern bool_t xdr_guestfs_part_get_parttype_ret ();
extern bool_t xdr_guestfs_part_init_args ();
extern bool_t xdr_guestfs_part_list_args ();
extern bool_t xdr_guestfs_part_list_ret ();
extern bool_t xdr_guestfs_part_resize_args ();
extern bool_t xdr_guestfs_part_set_bootable_args ();
extern bool_t xdr_guestfs_part_set_disk_guid_args ();
extern bool_t xdr_guestfs_part_set_disk_guid_random_args ();
extern bool_t xdr_guestfs_part_set_gpt_attributes_args ();
extern bool_t xdr_guestfs_part_set_gpt_guid_args ();
extern bool_t xdr_guestfs_part_set_gpt_type_args ();
extern bool_t xdr_guestfs_part_set_mbr_id_args ();
extern bool_t xdr_guestfs_part_set_name_args ();
extern bool_t xdr_guestfs_part_to_dev_args ();
extern bool_t xdr_guestfs_part_to_dev_ret ();
extern bool_t xdr_guestfs_part_to_partnum_args ();
extern bool_t xdr_guestfs_part_to_partnum_ret ();
extern bool_t xdr_guestfs_pread_args ();
extern bool_t xdr_guestfs_pread_ret ();
extern bool_t xdr_guestfs_pread_device_args ();
extern bool_t xdr_guestfs_pread_device_ret ();
extern bool_t xdr_guestfs_pvchange_uuid_args ();
extern bool_t xdr_guestfs_pvcreate_args ();
extern bool_t xdr_guestfs_pvremove_args ();
extern bool_t xdr_guestfs_pvresize_args ();
extern bool_t xdr_guestfs_pvresize_size_args ();
extern bool_t xdr_guestfs_pvs_ret ();
extern bool_t xdr_guestfs_pvs_full_ret ();
extern bool_t xdr_guestfs_pvuuid_args ();
extern bool_t xdr_guestfs_pvuuid_ret ();
extern bool_t xdr_guestfs_pwrite_args ();
extern bool_t xdr_guestfs_pwrite_ret ();
extern bool_t xdr_guestfs_pwrite_device_args ();
extern bool_t xdr_guestfs_pwrite_device_ret ();
extern bool_t xdr_guestfs_readdir_args ();
extern bool_t xdr_guestfs_readdir_ret ();
extern bool_t xdr_guestfs_readlink_args ();
extern bool_t xdr_guestfs_readlink_ret ();
extern bool_t xdr_guestfs_realpath_args ();
extern bool_t xdr_guestfs_realpath_ret ();
extern bool_t xdr_guestfs_remount_args ();
extern bool_t xdr_guestfs_removexattr_args ();
extern bool_t xdr_guestfs_rename_args ();
extern bool_t xdr_guestfs_resize2fs_args ();
extern bool_t xdr_guestfs_resize2fs_M_args ();
extern bool_t xdr_guestfs_resize2fs_size_args ();
extern bool_t xdr_guestfs_rm_args ();
extern bool_t xdr_guestfs_rm_f_args ();
extern bool_t xdr_guestfs_rm_rf_args ();
extern bool_t xdr_guestfs_rmdir_args ();
extern bool_t xdr_guestfs_rmmountpoint_args ();
extern bool_t xdr_guestfs_rsync_args ();
extern bool_t xdr_guestfs_rsync_in_args ();
extern bool_t xdr_guestfs_rsync_out_args ();
extern bool_t xdr_guestfs_scrub_device_args ();
extern bool_t xdr_guestfs_scrub_file_args ();
extern bool_t xdr_guestfs_scrub_freespace_args ();
extern bool_t xdr_guestfs_selinux_relabel_args ();
extern bool_t xdr_guestfs_set_e2attrs_args ();
extern bool_t xdr_guestfs_set_e2generation_args ();
extern bool_t xdr_guestfs_set_e2label_args ();
extern bool_t xdr_guestfs_set_e2uuid_args ();
extern bool_t xdr_guestfs_set_label_args ();
extern bool_t xdr_guestfs_set_uuid_args ();
extern bool_t xdr_guestfs_set_uuid_random_args ();
extern bool_t xdr_guestfs_setcon_args ();
extern bool_t xdr_guestfs_setxattr_args ();
extern bool_t xdr_guestfs_sfdisk_args ();
extern bool_t xdr_guestfs_sfdiskM_args ();
extern bool_t xdr_guestfs_sfdisk_N_args ();
extern bool_t xdr_guestfs_sfdisk_disk_geometry_args ();
extern bool_t xdr_guestfs_sfdisk_disk_geometry_ret ();
extern bool_t xdr_guestfs_sfdisk_kernel_geometry_args ();
extern bool_t xdr_guestfs_sfdisk_kernel_geometry_ret ();
extern bool_t xdr_guestfs_sfdisk_l_args ();
extern bool_t xdr_guestfs_sfdisk_l_ret ();
extern bool_t xdr_guestfs_sh_args ();
extern bool_t xdr_guestfs_sh_ret ();
extern bool_t xdr_guestfs_sh_lines_args ();
extern bool_t xdr_guestfs_sh_lines_ret ();
extern bool_t xdr_guestfs_sleep_args ();
extern bool_t xdr_guestfs_statns_args ();
extern bool_t xdr_guestfs_statns_ret ();
extern bool_t xdr_guestfs_statvfs_args ();
extern bool_t xdr_guestfs_statvfs_ret ();
extern bool_t xdr_guestfs_strings_args ();
extern bool_t xdr_guestfs_strings_ret ();
extern bool_t xdr_guestfs_strings_e_args ();
extern bool_t xdr_guestfs_strings_e_ret ();
extern bool_t xdr_guestfs_swapoff_device_args ();
extern bool_t xdr_guestfs_swapoff_file_args ();
extern bool_t xdr_guestfs_swapoff_label_args ();
extern bool_t xdr_guestfs_swapoff_uuid_args ();
extern bool_t xdr_guestfs_swapon_device_args ();
extern bool_t xdr_guestfs_swapon_file_args ();
extern bool_t xdr_guestfs_swapon_label_args ();
extern bool_t xdr_guestfs_swapon_uuid_args ();
extern bool_t xdr_guestfs_syslinux_args ();
extern bool_t xdr_guestfs_tail_args ();
extern bool_t xdr_guestfs_tail_ret ();
extern bool_t xdr_guestfs_tail_n_args ();
extern bool_t xdr_guestfs_tail_n_ret ();
extern bool_t xdr_guestfs_tar_in_args ();
extern bool_t xdr_guestfs_tar_out_args ();
extern bool_t xdr_guestfs_tgz_in_args ();
extern bool_t xdr_guestfs_tgz_out_args ();
extern bool_t xdr_guestfs_touch_args ();
extern bool_t xdr_guestfs_truncate_args ();
extern bool_t xdr_guestfs_truncate_size_args ();
extern bool_t xdr_guestfs_tune2fs_args ();
extern bool_t xdr_guestfs_tune2fs_l_args ();
extern bool_t xdr_guestfs_tune2fs_l_ret ();
extern bool_t xdr_guestfs_txz_in_args ();
extern bool_t xdr_guestfs_txz_out_args ();
extern bool_t xdr_guestfs_umask_args ();
extern bool_t xdr_guestfs_umask_ret ();
extern bool_t xdr_guestfs_umount_args ();
extern bool_t xdr_guestfs_upload_args ();
extern bool_t xdr_guestfs_upload_offset_args ();
extern bool_t xdr_guestfs_utimens_args ();
extern bool_t xdr_guestfs_utsname_ret ();
extern bool_t xdr_guestfs_vfs_label_args ();
extern bool_t xdr_guestfs_vfs_label_ret ();
extern bool_t xdr_guestfs_vfs_minimum_size_args ();
extern bool_t xdr_guestfs_vfs_minimum_size_ret ();
extern bool_t xdr_guestfs_vfs_type_args ();
extern bool_t xdr_guestfs_vfs_type_ret ();
extern bool_t xdr_guestfs_vfs_uuid_args ();
extern bool_t xdr_guestfs_vfs_uuid_ret ();
extern bool_t xdr_guestfs_vg_activate_args ();
extern bool_t xdr_guestfs_vg_activate_all_args ();
extern bool_t xdr_guestfs_vgchange_uuid_args ();
extern bool_t xdr_guestfs_vgcreate_args ();
extern bool_t xdr_guestfs_vglvuuids_args ();
extern bool_t xdr_guestfs_vglvuuids_ret ();
extern bool_t xdr_guestfs_vgmeta_args ();
extern bool_t xdr_guestfs_vgmeta_ret ();
extern bool_t xdr_guestfs_vgpvuuids_args ();
extern bool_t xdr_guestfs_vgpvuuids_ret ();
extern bool_t xdr_guestfs_vgremove_args ();
extern bool_t xdr_guestfs_vgrename_args ();
extern bool_t xdr_guestfs_vgs_ret ();
extern bool_t xdr_guestfs_vgs_full_ret ();
extern bool_t xdr_guestfs_vguuid_args ();
extern bool_t xdr_guestfs_vguuid_ret ();
extern bool_t xdr_guestfs_wc_c_args ();
extern bool_t xdr_guestfs_wc_c_ret ();
extern bool_t xdr_guestfs_wc_l_args ();
extern bool_t xdr_guestfs_wc_l_ret ();
extern bool_t xdr_guestfs_wc_w_args ();
extern bool_t xdr_guestfs_wc_w_ret ();
extern bool_t xdr_guestfs_wipefs_args ();
extern bool_t xdr_guestfs_write_file_args ();
extern bool_t xdr_guestfs_xfs_admin_args ();
extern bool_t xdr_guestfs_xfs_growfs_args ();
extern bool_t xdr_guestfs_xfs_info_args ();
extern bool_t xdr_guestfs_xfs_info_ret ();
extern bool_t xdr_guestfs_xfs_repair_args ();
extern bool_t xdr_guestfs_xfs_repair_ret ();
extern bool_t xdr_guestfs_zegrep_args ();
extern bool_t xdr_guestfs_zegrep_ret ();
extern bool_t xdr_guestfs_zegrepi_args ();
extern bool_t xdr_guestfs_zegrepi_ret ();
extern bool_t xdr_guestfs_zero_args ();
extern bool_t xdr_guestfs_zero_device_args ();
extern bool_t xdr_guestfs_zero_free_space_args ();
extern bool_t xdr_guestfs_zerofree_args ();
extern bool_t xdr_guestfs_zfgrep_args ();
extern bool_t xdr_guestfs_zfgrep_ret ();
extern bool_t xdr_guestfs_zfgrepi_args ();
extern bool_t xdr_guestfs_zfgrepi_ret ();
extern bool_t xdr_guestfs_zfile_args ();
extern bool_t xdr_guestfs_zfile_ret ();
extern bool_t xdr_guestfs_zgrep_args ();
extern bool_t xdr_guestfs_zgrep_ret ();
extern bool_t xdr_guestfs_zgrepi_args ();
extern bool_t xdr_guestfs_zgrepi_ret ();
extern bool_t xdr_guestfs_procedure ();
extern bool_t xdr_guestfs_message_direction ();
extern bool_t xdr_guestfs_message_status ();
extern bool_t xdr_guestfs_message_error ();
extern bool_t xdr_guestfs_message_header ();
extern bool_t xdr_guestfs_chunk ();
extern bool_t xdr_guestfs_progress ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_GUESTFS_PROTOCOL_H_RPCGEN */
