.\" @(#)$RCSfile: Cns_listclass.man,v $ $Revision: 1.1.1.1 $ $Date: 2004/10/06 08:10:34 $ CERN IT-PDP/DM Jean-Philippe Baud
.\" Copyright (C) 2000-2004 by CERN/IT/PDP/DM
.\" All rights reserved
.\"
.TH CNS_LISTCLASS 3 "$Date: 2004/10/06 08:10:34 $" CASTOR "Cns Library Functions"
.SH NAME
Cns_listclass \- list fileclass entries in the name server
.SH SYNOPSIS
.B #include <sys/types.h>
.br
\fB#include "Cns_api.h"\fR
.sp
.BI "struct Cns_fileclass *Cns_listclass (char *" server ,
.BI "int " flags ,
.BI "Cns_list *" listp )
.SH DESCRIPTION
.B Cns_listclass
lists fileclass entries in the name server.
.TP
.I server
specifies the CASTOR Name Server to be contacted to get the fileclass
definitions.
.TP
.I flags
may be one of the following constant:
.RS
.TP
.B CNS_LIST_BEGIN
the first call must have this flag set to allocate buffers and
initialize pointers.
.TP
.B CNS_LIST_CONTINUE
all the following calls must have this flag set.
.TP
.B CNS_LIST_END
final call to terminate the list and free resources.
.RE
.SH RETURN VALUE
This routine returns a pointer to a structure containing the current class entry
if the operation was successful or NULL if all entries have been returned
or if the operation failed. In the latter case,
.B serrno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOMEM
Memory could not be allocated for the output buffer.
.TP
.B EFAULT
.I listp
is a NULL pointer.
.TP
.B SENOSHOST
Host unknown.
.TP
.B SENOSSERV
Service unknown.
.TP
.B SECOMERR
Communication error.
.TP
.B ENSNACT
Name server is not running or is being shutdown.
.SH SEE ALSO
.BR Castor_limits(4) ,
.BR Cns_enterclass(3)
.SH AUTHOR
\fBCASTOR\fP Team <castor.support@cern.ch>
