package latexDraw.ui.dialog;

import java.awt.*;
import java.awt.event.ActionEvent;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.Axe;
import latexDraw.figures.Figure;
import latexDraw.figures.GridShape;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.psTricks.PSTricksConstants;
import latexDraw.ui.DrawPanel;


/** 
 * This class defines the frame allowing to modify axes.<br>
 *<br>
 * This file is part of LaTeXDraw.<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 08/17/06<br>
 * @author Arnaud BLOUIN<br>
 * @since 1.8<br>
 * @version 2.0.0<br>
 */
public class ParametersAxeFrame extends AbstractGridShapeFrame
{
	private static final long serialVersionUID = 1L;

	protected JCheckBox drawXLabel;
	
	protected JCheckBox drawYLabel;

	protected JCheckBox drawXTicks;
	
	protected JCheckBox drawYTicks;
	
	protected JCheckBox defineLabelDistCB;
	
	protected JComboBox axeShapeChoice;

	protected JComboBox ticksShapeChoice;
	
	protected JSpinner ticksSizeField;
	
	protected JSpinner labelXDistField;
	
	protected JSpinner labelYDistField;
	
	/** Allows to change the increment of the X labels. */
	protected JSpinner labelXIncrement;
	
	/** Allows to change the increment of the Y labels. */
	protected JSpinner labelYIncrement;
	
	/** Allows to change the origin of the X labels. */
	protected JSpinner labelXOrigin;
	
	/** Allows to change the origin of the Y labels. */
	protected JSpinner labelYOrigin;
	
	protected JCheckBox showOriginCB;
	
	public static final String LABEL_DRAW_X_LABELS = "dispXLab";//$NON-NLS-1$
	
	public static final String LABEL_DEF_LABELS_DIST = "defDist";//$NON-NLS-1$

	public static final String LABEL_DRAW_Y_LABELS = "dispYLab";//$NON-NLS-1$

	public static final String LABEL_DRAW_X_TICKS = "dispXTicks";//$NON-NLS-1$
	
	public static final String LABEL_DRAW_Y_TICKS = "dispYTicks";//$NON-NLS-1$
	
	public static final String LABEL_Y_LABEL_DIST = "xLabSep";//$NON-NLS-1$
	
	public static final String LABEL_X_LABEL_DIST = "yLabSep";//$NON-NLS-1$
	
	public static final String LABEL_TICKS_SIZE_FIELD = "ticksSizeField";//$NON-NLS-1$
	
	public static final String LABEL_LABEL_X_INCR = "labXInc";//$NON-NLS-1$

	public static final String LABEL_LABEL_Y_INCR = "labYInc";//$NON-NLS-1$

	public static final String LABEL_LABEL_X_ORIG = "labXOrig";//$NON-NLS-1$
	
	public static final String LABEL_LABEL_Y_ORIG = "labYOrig";//$NON-NLS-1$
	
	public static final String LABEL_SHOW_ORIGIN = "showOrig";//$NON-NLS-1$
	
	
	
	
	public ParametersAxeFrame(Frame parent, DrawPanel d, boolean attachToMainFrame)
	{
		super(parent, d, attachToMainFrame);

		try
		{
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		JTabbedPane tabbedPane = new JTabbedPane();
	  		JPanel pButton  = createButtonsPanel(this);
	  		JPanel pGeneral = new JPanel();
	  		JPanel pAxes	= new JPanel();
	     	JPanel pOther = new JPanel(new FlowLayout(FlowLayout.LEFT));
	     	pAxes.setLayout(new BoxLayout(pAxes, BoxLayout.Y_AXIS));
	     	JPanel positionP = createPositionPanel(false);
	     	
	  		pGeneral.setLayout(new BoxLayout(pGeneral, BoxLayout.Y_AXIS));
	     	pGeneral.add(positionP);
	     	pGeneral.add(createBordersPanel(false));
	     	pGeneral.add(pOther);

	     	pOther.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.0"))); //$NON-NLS-1$
	     	
	     	axeShapeChoice = Axe.createAxeStyleChoice();
	     	axeShapeChoice.addActionListener(this);
	     	pOther.add(axeShapeChoice);
	     	
	     	showOriginCB = new JCheckBox(LaTeXDrawLang.getString1_8("ParametersAxeFrame.1"), true); //$NON-NLS-1$
	     	showOriginCB.setActionCommand(LABEL_SHOW_ORIGIN);
	     	showOriginCB.setName(LABEL_SHOW_ORIGIN);
	     	showOriginCB.addActionListener(this);
	     	pOther.add(showOriginCB);
	     	
	     	String axesS = LaTeXDrawLang.getString1_8("ParametersAxeFrame.2"); //$NON-NLS-1$
	     	pOther.setBorder(new CompoundBorder(new TitledBorder(null, axesS,
					  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	
	     	pAxes.add(createLabelsPanel());
	     	pAxes.add(createTicksPanel());
	     	
	     	tabbedPane.addTab(TITLE_TABBED_PANE_GENERAL, pGeneral);
	     	tabbedPane.addTab(axesS, pAxes);
	     	tabbedPane.addTab(NAME_TABBEDPANE_ARROW, createArrowPanel(true, false));
	     	BoxLayout bl = new BoxLayout(getContentPane(), BoxLayout.Y_AXIS);
	     	getContentPane().setLayout(bl);
	     	getContentPane().add(glimpsePanelZoom);
	     	getContentPane().add(tabbedPane);
			getContentPane().add(pButton);
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);

		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}

	
	
	
	protected JPanel createLabelsPanel()
	{
		JPanel pLabels = new JPanel(new GridBagLayout());
		GridBagConstraints constraint = new GridBagConstraints();
		
    	constraint.gridx = 0;
     	constraint.gridy = 0;
     	constraint.gridwidth = 1;
     	constraint.gridheight = 1;
     	constraint.weightx = 0.1;
     	constraint.weighty = 0.1;
     	constraint.fill = GridBagConstraints.NONE;
     	constraint.anchor = GridBagConstraints.WEST;
     	
     	drawXLabel = new JCheckBox(LaTeXDrawLang.getString1_8("ParametersAxeFrame.3"), true); //$NON-NLS-1$
     	drawXLabel.setActionCommand(LABEL_DRAW_X_LABELS);
     	drawXLabel.setName(LABEL_DRAW_X_LABELS);
     	drawXLabel.addActionListener(this);
     	constraint.gridx=0;
     	pLabels.add(drawXLabel, constraint);

     	drawYLabel = new JCheckBox(LaTeXDrawLang.getString1_8("ParametersAxeFrame.4"), true); //$NON-NLS-1$
     	drawYLabel.setActionCommand(LABEL_DRAW_Y_LABELS);
     	drawYLabel.setName(LABEL_DRAW_Y_LABELS);
     	drawYLabel.addActionListener(this);
     	constraint.gridx+=2;
     	pLabels.add(drawYLabel, constraint);
     	
     	constraint.gridx = 0;	constraint.gridy++;
     	constraint.gridwidth=2;
     	invertXLabelsCB = new JCheckBox(LABEL_ISXLABEL);
     	invertXLabelsCB.setText(LABEL_ISXLABEL);
     	invertXLabelsCB.setSelected(GridShape.DEFAULT_ISYLABELWEST);
     	invertXLabelsCB.setActionCommand(LABEL_ISXLABEL);
     	invertXLabelsCB.addActionListener(this);
     	pLabels.add(invertXLabelsCB, constraint);
     	
     	constraint.gridx+=2;
     	invertYLabelsCB = new JCheckBox(LABEL_ISYLABEL);
     	invertYLabelsCB.setText(LABEL_ISYLABEL);
     	invertYLabelsCB.setSelected(GridShape.DEFAULT_ISXLABELSOUTH);
     	invertYLabelsCB.addActionListener(this);
     	invertYLabelsCB.setActionCommand(LABEL_ISYLABEL);
     	pLabels.add(invertYLabelsCB, constraint);
     	
     	constraint.gridx=0;
     	constraint.gridy++;
     	defineLabelDistCB = new JCheckBox(LABEL_DEF_LABELS_DIST);
     	defineLabelDistCB.setText(LaTeXDrawLang.getString1_8("ParametersAxeFrame.5")); //$NON-NLS-1$
     	defineLabelDistCB.setSelected(false);
     	defineLabelDistCB.addActionListener(this);
     	defineLabelDistCB.setActionCommand(LABEL_DEF_LABELS_DIST);
     	pLabels.add(defineLabelDistCB, constraint);

     	constraint.gridwidth=1;
     	constraint.gridx=0;
     	constraint.gridy++;
     	pLabels.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.6")), constraint); //$NON-NLS-1$
     	
     	SpinnerModel model = new SpinnerNumberModel(0.01,0.01,1000,0.05);
     	labelXDistField = new JSpinner(model);
     	labelXDistField.setEditor(new JSpinner.NumberEditor(labelXDistField, "0.00"));//$NON-NLS-1$
     	labelXDistField.addChangeListener(this);
     	labelXDistField.setName(LABEL_X_LABEL_DIST);
     	labelXDistField.setEnabled(false);
     	constraint.gridx++;
     	pLabels.add(labelXDistField, constraint);

     	constraint.gridx++;
     	pLabels.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.7")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(0.01,0.01,1000,0.05);
     	labelYDistField = new JSpinner(model);
     	labelYDistField.setEditor(new JSpinner.NumberEditor(labelYDistField, "0.00"));//$NON-NLS-1$
     	labelYDistField.addChangeListener(this);
     	labelYDistField.setEnabled(false);
     	labelYDistField.setName(LABEL_Y_LABEL_DIST);
     	constraint.gridx++;
     	pLabels.add(labelYDistField, constraint);
     	
     	constraint.gridx=0;
     	constraint.gridy++;
     	pLabels.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.8")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(0.0001,0.0001,1000,1);
     	labelXIncrement = new JSpinner(model);
     	labelXIncrement.setEditor(new JSpinner.NumberEditor(labelXIncrement, "0.000"));//$NON-NLS-1$
     	labelXIncrement.addChangeListener(this);
     	labelXIncrement.setName(LABEL_LABEL_X_INCR);
     	constraint.gridx++;
     	pLabels.add(labelXIncrement, constraint);
     	
     	constraint.gridx++;
     	pLabels.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.9")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(0.0001,0.0001,1000,1);
     	labelYIncrement = new JSpinner(model);
     	labelYIncrement.setEditor(new JSpinner.NumberEditor(labelYIncrement, "0.000"));//$NON-NLS-1$
     	labelYIncrement.addChangeListener(this);
     	labelYIncrement.setName(LABEL_LABEL_Y_INCR);
     	constraint.gridx++;
     	pLabels.add(labelYIncrement, constraint);
     	
     	constraint.gridx=0;
     	constraint.gridy++;
     	pLabels.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.10")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(1,-1000,1000,1);
     	labelXOrigin = new JSpinner(model);
     	labelXOrigin.setEditor(new JSpinner.NumberEditor(labelXOrigin, "0"));//$NON-NLS-1$
     	labelXOrigin.addChangeListener(this);
     	labelXOrigin.setName(LABEL_LABEL_X_ORIG);
     	constraint.gridx++;
     	pLabels.add(labelXOrigin, constraint);
     	
     	constraint.gridx++;
     	pLabels.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.11")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(1,-1000,1000,1);
     	labelYOrigin = new JSpinner(model);
     	labelYOrigin.setEditor(new JSpinner.NumberEditor(labelYOrigin, "0"));//$NON-NLS-1$
     	labelYOrigin.addChangeListener(this);
     	labelYOrigin.setName(LABEL_LABEL_Y_ORIG);
     	constraint.gridx++;
     	pLabels.add(labelYOrigin, constraint);
     	
     	pLabels.setBorder(new CompoundBorder(new TitledBorder(null, LaTeXDrawLang.getString1_8("ParametersAxeFrame.12"), //$NON-NLS-1$
				  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
     	
     	return pLabels;
	}
	
	
	
	protected JPanel createTicksPanel()
	{
		JPanel pTicks = new JPanel(new GridBagLayout());
		GridBagConstraints constraint = new GridBagConstraints();
		
    	constraint.gridx = 0;
     	constraint.gridy = 0;
     	constraint.gridwidth = 1;
     	constraint.gridheight = 1;
     	constraint.weightx = 0.1;
     	constraint.weighty = 0.1;
     	constraint.fill = GridBagConstraints.NONE;
     	constraint.anchor = GridBagConstraints.WEST;

     	pTicks.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.13")), constraint); //$NON-NLS-1$
     	
     	SpinnerModel model = new SpinnerNumberModel(1,1,1000,0.5);
     	ticksSizeField = new JSpinner(model);
     	ticksSizeField.setEditor(new JSpinner.NumberEditor(ticksSizeField, "0.00"));//$NON-NLS-1$
     	ticksSizeField.addChangeListener(this);
     	ticksSizeField.setName(LABEL_TICKS_SIZE_FIELD);
     	constraint.gridx++;
     	pTicks.add(ticksSizeField, constraint);
     	
     	constraint.gridx++;
    	pTicks.add(new JLabel(LaTeXDrawLang.getString1_8("ParametersAxeFrame.14")), constraint); //$NON-NLS-1$
     	
     	ticksShapeChoice = Axe.createTicksStyleChoice();
     	ticksShapeChoice.addActionListener(this);
      	constraint.gridx++;
     	pTicks.add(ticksShapeChoice, constraint);
     	
     	drawXTicks = new JCheckBox(LaTeXDrawLang.getString1_8("ParametersAxeFrame.15"), true); //$NON-NLS-1$
     	drawXTicks.setActionCommand(LABEL_DRAW_X_TICKS);
     	drawXTicks.setName(LABEL_DRAW_X_TICKS);
     	drawXTicks.addActionListener(this);
     	constraint.gridx=0;	constraint.gridy++;
     	pTicks.add(drawXTicks, constraint);

     	drawYTicks = new JCheckBox(LaTeXDrawLang.getString1_8("ParametersAxeFrame.16"), true); //$NON-NLS-1$
     	drawYTicks.setActionCommand(LABEL_DRAW_Y_TICKS);
     	drawYTicks.setName(LABEL_DRAW_Y_TICKS);
     	drawYTicks.addActionListener(this);
     	constraint.gridx+=1;
     	pTicks.add(drawYTicks, constraint);

		
		pTicks.setBorder(new CompoundBorder(new TitledBorder(null, LaTeXDrawLang.getString1_8("ParametersAxeFrame.17"), //$NON-NLS-1$
				  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
		
		return pTicks;
	}
	
	
	
	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof Axe))
				throw new ClassCastException();

			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}

	

	
	@Override
	public void setFigureFrameField()
	{
		super.setFigureFrameField();
		
		Axe a = (Axe)figure;
		int labelsDisplayed = a.getLabelsDisplayed();
		int ticksDisplayed	= a.getTicksDisplayed();
		
		if(labelsDisplayed==Axe.LABELS_DISPLAYED_ALL_VALUE || labelsDisplayed==Axe.LABELS_DISPLAYED_X_VALUE)
			drawXLabel.setSelected(true);
		
		if(labelsDisplayed==Axe.LABELS_DISPLAYED_ALL_VALUE || labelsDisplayed==Axe.LABELS_DISPLAYED_Y_VALUE)
			drawYLabel.setSelected(true);

		if(ticksDisplayed==Axe.LABELS_DISPLAYED_ALL_VALUE || ticksDisplayed==Axe.LABELS_DISPLAYED_X_VALUE)
			drawXTicks.setSelected(true);
		
		if(ticksDisplayed==Axe.LABELS_DISPLAYED_ALL_VALUE || ticksDisplayed==Axe.LABELS_DISPLAYED_Y_VALUE)
			drawYTicks.setSelected(true);
		
		String style = a.getAxesStyleToken();
		
		if(style.equals(PSTricksConstants.TOKEN_AXES_STYLE_AXES))
			axeShapeChoice.setSelectedItem(Axe.LABEL_STYLE_AXE);
		else
			if(style.equals(PSTricksConstants.TOKEN_AXES_STYLE_FRAME))
				axeShapeChoice.setSelectedItem(Axe.LABEL_STYLE_FRAME);
			else 
				if(style.equals(PSTricksConstants.TOKEN_AXES_STYLE_NONE))
					axeShapeChoice.setSelectedItem(Axe.LABEL_STYLE_NONE);
	
		style = a.getTicksStyleToken();
		
		if(style.equals(PSTricksConstants.TOKEN_TICKS_STYLE_FULL))
			ticksShapeChoice.setSelectedItem(Axe.LABEL_STYLE_TICKS_FULL);
		else
			if(style.equals(PSTricksConstants.TOKEN_TICKS_STYLE_BOTTOM))
				ticksShapeChoice.setSelectedItem(Axe.LABEL_STYLE_TICKS_BOTTOM);
			else 
				if(style.equals(PSTricksConstants.TOKEN_TICKS_STYLE_TOP))
					ticksShapeChoice.setSelectedItem(Axe.LABEL_STYLE_TICKS_TOP);
		
		ticksSizeField.setValue(a.getTicksSize());
		boolean ok = a.getDistLabelsX()!=0 || a.getDistLabelsY()!=0;
		
		defineLabelDistCB.setSelected(ok);
		labelXDistField.setEnabled(ok);
		labelYDistField.setEnabled(ok);
		labelXDistField.removeChangeListener(this);
		labelYDistField.removeChangeListener(this);
		labelXDistField.setValue(a.getDistLabelsX()==0 ? a.getIncrement().x : a.getDistLabelsX());
		labelYDistField.setValue(a.getDistLabelsY()==0 ? a.getIncrement().y : a.getDistLabelsY());
		labelXDistField.addChangeListener(this);
		labelYDistField.addChangeListener(this);
		labelXIncrement.setValue(a.getIncrement().x);
		labelYIncrement.setValue(a.getIncrement().y);
		labelXOrigin.setValue((int)a.getOrigin().x);
		labelYOrigin.setValue((int)a.getOrigin().y);
		showOriginCB.setSelected(a.isShowOrigin());
		
		glimpsePanel.repaint();
	}
	

	
	
	@Override
	public void setDefaultsValues()
	{
		super.setDefaultsValues();
		
		drawXLabel.setSelected(true);
		drawYLabel.setSelected(true);
		drawXTicks.setSelected(true);
		drawYTicks.setSelected(true);
		Axe axe = (Axe)glimpsePanel.glimpseFigure;
		
		axe.setLabelsDisplayed(Axe.LABELS_DISPLAYED_ALL_VALUE);
		axeShapeChoice.setSelectedIndex(0);
		ticksShapeChoice.setSelectedIndex(0);
		ticksSizeField.setValue(PSTricksConstants.DEFAULT_TICKS_SIZE);
		defineLabelDistCB.setSelected(false);
		labelXDistField.setEnabled(false);
		labelYDistField.setEnabled(false);
		axe.setDistLabelsX(0);
		axe.setDistLabelsY(0);
		axe.setIncrementX(PSTricksConstants.DEFAULT_DX);
		axe.setIncrementY(PSTricksConstants.DEFAULT_DY);
		axe.setOriginX(PSTricksConstants.DEFAULT_OX);
		axe.setOriginY(PSTricksConstants.DEFAULT_OY);
		axe.setShowOrigin(PSTricksConstants.DEFAULT_SHOW_ORIGIN);
		axe.updateBorders();
		
		glimpsePanel.repaint();
	}
	
	
	
	
	@Override
	public void saveParameters()
	{
		super.saveParameters();
		
		Axe a = (Axe)figure;
		double xVal = Float.valueOf(labelXDistField.getValue().toString()).doubleValue();
		double yVal = Float.valueOf(labelYDistField.getValue().toString()).doubleValue();

		if(drawXLabel.isSelected())
			if(drawYLabel.isSelected())
				a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_ALL_VALUE);
			else a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_X_VALUE);
		else 
			if(drawYLabel.isSelected())
				a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_Y_VALUE);
			else a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_NON_VALUE);

		if(drawXTicks.isSelected())
			if(drawYTicks.isSelected())
				a.setTicksDisplayed(Axe.LABELS_DISPLAYED_ALL_VALUE);
			else a.setTicksDisplayed(Axe.LABELS_DISPLAYED_X_VALUE);
		else 
			if(drawYTicks.isSelected())
				a.setTicksDisplayed(Axe.LABELS_DISPLAYED_Y_VALUE);
			else a.setTicksDisplayed(Axe.LABELS_DISPLAYED_NON_VALUE);
		
		String selected = axeShapeChoice.getSelectedItem().toString();
		
		if(selected.equals(Axe.LABEL_STYLE_AXE))
			a.setAxesStyle(Axe.AXES_STYLE_AXES_VALUE);
		else
			if(selected.equals(Axe.LABEL_STYLE_FRAME))
				a.setAxesStyle(Axe.AXES_STYLE_FRAME_VALUE);
			else 
				if(selected.equals(Axe.LABEL_STYLE_NONE))
					a.setAxesStyle(Axe.AXES_STYLE_NONE_VALUE);
		
		selected = ticksShapeChoice.getSelectedItem().toString();
		
		if(selected.equals(Axe.LABEL_STYLE_TICKS_FULL))
			a.setTicksStyle(Axe.TICKS_STYLE_FULL_VALUE);
		else
			if(selected.equals(Axe.LABEL_STYLE_TICKS_TOP))
				a.setTicksStyle(Axe.TICKS_STYLE_TOP_VALUE);
			else 
				if(selected.equals(Axe.LABEL_STYLE_TICKS_BOTTOM))
					a.setTicksStyle(Axe.TICKS_STYLE_BOTTOM_VALUE);
		
		a.setTicksSize(Float.valueOf(ticksSizeField.getValue().toString()).doubleValue());
		a.setDistLabelsX(defineLabelDistCB.isSelected() ? xVal : 0);
		a.setDistLabelsY(defineLabelDistCB.isSelected() ? yVal : 0);
		a.setIncrementX(Float.valueOf(labelXIncrement.getValue().toString()).doubleValue());
		a.setIncrementY(Float.valueOf(labelYIncrement.getValue().toString()).doubleValue());
		a.setOriginX(Float.valueOf(labelXOrigin.getValue().toString()).intValue());
		a.setOriginY(Float.valueOf(labelYOrigin.getValue().toString()).intValue());
		a.setShowOrigin(showOriginCB.isSelected());
		a.updateBorders();
		
		drawPanel.getFrameParent().setExportAsMenu(true);
		drawPanel.getDraw().updateBorders();
		drawPanel.updateDraw(true);
	}
	
	
	
	
	@Override
	public void actionPerformed(ActionEvent e) 
	{
		try
		{
			Object o = e.getSource();
			Axe a = (Axe)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JCheckBox)
			{
				String label = ((JCheckBox)o).getActionCommand();
				
				if(label.equals(LABEL_SHOW_ORIGIN))
				{
					setModified(true);
					a.setShowOrigin(showOriginCB.isSelected());
					glimpsePanel.repaint();
					
					return ;
				}
				
				if(label.equals(LABEL_DEF_LABELS_DIST))
				{
					double xVal = Float.valueOf(labelXDistField.getValue().toString()).doubleValue();
					double yVal = Float.valueOf(labelYDistField.getValue().toString()).doubleValue();
					boolean isSelected = defineLabelDistCB.isSelected();
					
					setModified(true);
					labelXDistField.setEnabled(isSelected);
					labelYDistField.setEnabled(isSelected);
					a.setDistLabelsX(isSelected ? xVal : 0);
					a.setDistLabelsY(isSelected ? yVal : 0);
					a.updateBorders();
					glimpsePanel.repaint();
					
					return ;
				}
				
				if(label.equals(LABEL_DRAW_X_LABELS) || label.equals(LABEL_DRAW_Y_LABELS))
				{
					if(drawXLabel.isSelected())
						if(drawYLabel.isSelected())
							a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_ALL_VALUE);
						else a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_X_VALUE);
					else 
						if(drawYLabel.isSelected())
							a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_Y_VALUE);
						else a.setLabelsDisplayed(Axe.LABELS_DISPLAYED_NON_VALUE);
					
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				if(label.equals(LABEL_DRAW_X_TICKS) || label.equals(LABEL_DRAW_Y_TICKS))
				{
					if(drawXTicks.isSelected())
						if(drawYTicks.isSelected())
							a.setTicksDisplayed(Axe.LABELS_DISPLAYED_ALL_VALUE);
						else a.setTicksDisplayed(Axe.LABELS_DISPLAYED_X_VALUE);
					else 
						if(drawYTicks.isSelected())
							a.setTicksDisplayed(Axe.LABELS_DISPLAYED_Y_VALUE);
						else a.setTicksDisplayed(Axe.LABELS_DISPLAYED_NON_VALUE);
					
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
			}
			
			if(o instanceof JComboBox)
			{
				String label = ((JComboBox)o).getActionCommand();
				
				if(label.equals(Axe.ACTION_CMD_AXE_STYLE_CHOICE))
				{
					String selected = axeShapeChoice.getSelectedItem().toString();
					
					if(selected.equals(Axe.LABEL_STYLE_AXE))
						a.setAxesStyle(Axe.AXES_STYLE_AXES_VALUE);
					else
						if(selected.equals(Axe.LABEL_STYLE_FRAME))
							a.setAxesStyle(Axe.AXES_STYLE_FRAME_VALUE);
						else 
							if(selected.equals(Axe.LABEL_STYLE_NONE))
								a.setAxesStyle(Axe.AXES_STYLE_NONE_VALUE);
					
					setModified(true);
					boolean ok = selected.equals(Axe.LABEL_STYLE_AXE);
					arrow1Choice.setEnabled(ok);
					arrow2Choice.setEnabled(ok);
					glimpsePanel.repaint();
					return ;
				}
				
				if(label.equals(Axe.ACTION_CMD_TICKS_STYLE_CHOICE))
				{
					String selected = ticksShapeChoice.getSelectedItem().toString();
			
					if(selected.equals(Axe.LABEL_STYLE_TICKS_FULL))
						a.setTicksStyle(Axe.TICKS_STYLE_FULL_VALUE);
					else
						if(selected.equals(Axe.LABEL_STYLE_TICKS_TOP))
							a.setTicksStyle(Axe.TICKS_STYLE_TOP_VALUE);
						else 
							if(selected.equals(Axe.LABEL_STYLE_TICKS_BOTTOM))
								a.setTicksStyle(Axe.TICKS_STYLE_BOTTOM_VALUE);
					
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				return ;
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.actionPerformed(e);
	}

	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			Axe a = (Axe)glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				
				if(name.equals(LABEL_TICKS_SIZE_FIELD))
				{
					setModified(true);
					a.setTicksSize(Float.valueOf(ticksSizeField.getValue().toString()).doubleValue());
					a.updateBorders();
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_LABEL_X_INCR))
				{
					setModified(true);
					a.setIncrementX(Float.valueOf(labelXIncrement.getValue().toString()).doubleValue());
					glimpsePanel.repaint();
					return ;
				}

				if(name.equals(LABEL_LABEL_Y_INCR))
				{
					setModified(true);
					a.setIncrementY(Float.valueOf(labelYIncrement.getValue().toString()).doubleValue());
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_LABEL_X_ORIG))
				{
					setModified(true);
					a.setOriginX(Float.valueOf(labelXOrigin.getValue().toString()).intValue());
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_LABEL_Y_ORIG))
				{
					setModified(true);
					a.setOriginY(Float.valueOf(labelYOrigin.getValue().toString()).intValue());
					glimpsePanel.repaint();
					return ;
				}

				if(name.equals(LABEL_X_LABEL_DIST))
				{
					setModified(true);
					a.setDistLabelsX(Float.valueOf(labelXDistField.getValue().toString()).doubleValue());
					a.updateBorders();
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_Y_LABEL_DIST))
				{
					setModified(true);
					a.setDistLabelsY(Float.valueOf(labelYDistField.getValue().toString()).doubleValue());
					a.updateBorders();
					glimpsePanel.repaint();
					return ;
				}
			}
		}
		catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
		
		super.stateChanged(e);
	}
}
