/*
    SPDX-FileCopyrightText: 2018-2020 Red Hat Inc
    SPDX-FileCopyrightText: 2020 Aleix Pol Gonzalez <aleixpol@kde.org>
    SPDX-FileContributor: Jan Grulich <jgrulich@redhat.com>

    SPDX-License-Identifier: LGPL-2.0-or-later
*/

#pragma once

#include "plugin.h"

#include <KWaylandServer/screencast_v1_interface.h>

namespace KWin
{
class AbstractWaylandOutput;
class ScreenCastStream;

class ScreencastManager : public Plugin
{
    Q_OBJECT

public:
    explicit ScreencastManager(QObject *parent = nullptr);

private:
    void streamWindow(KWaylandServer::ScreencastStreamV1Interface *stream, const QString &winid);
    void streamWaylandOutput(KWaylandServer::ScreencastStreamV1Interface *stream,
                             KWaylandServer::OutputInterface *output,
                             KWaylandServer::ScreencastV1Interface::CursorMode mode);
    void
    streamOutput(KWaylandServer::ScreencastStreamV1Interface *stream, AbstractWaylandOutput *output, KWaylandServer::ScreencastV1Interface::CursorMode mode);
    void streamVirtualOutput(KWaylandServer::ScreencastStreamV1Interface *stream,
                             const QString &name,
                             const QSize &size,
                             double scale,
                             KWaylandServer::ScreencastV1Interface::CursorMode mode);

    void integrateStreams(KWaylandServer::ScreencastStreamV1Interface *waylandStream, ScreenCastStream *stream);

    KWaylandServer::ScreencastV1Interface *m_screencast;
};

} // namespace KWin
