/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as               *
*   published by the Free Software Foundation; either version 2.0 of      *
*   the License, or (at your option) any later version.                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
*   General Public License for more details.                              *
*                                                                         *
*   You should have received a copy of the GNU General Public             *
*   License along with this program; if not, write to                     *
*   the Free Software Foundation, Inc.,                                   *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA          *
**************************************************************************/

#include "xml_creator_server.h"

XmlCreatorServer::XmlCreatorServer(QObject *parent)
    : QObject(parent)
{
    xmlDoctype = QString(XML_DOCTYPE);
    xmlOpening = QString(XML_OPENING);
    xmlClosing = QString(XML_CLOSING);
    xmlEnding = QString(XML_ENDING);
    xmlParametersDocument = QString(xmlDoctype + XML_PARAMETERS + xmlEnding);
    xmlKontrolPackElement = QString(KONTROLPACK);
    xmlHostnameElement = QString(HOSTNAME);
    xmlSystemElement = QString(SYSTEM);
    xmlPathElement = QString(PATH);
    xmlFolderListElement = QString(FOLDER_LIST);
    xmlFileListElement = QString(FILE_LIST);
    xmlFolderElement = QString(FOLDER);
    xmlFileElement = QString(FILE_XML);
    xmlIpListElement = QString(IP_LIST);
    xmlIpElement = QString(IP);
}

QString XmlCreatorServer::createXmlParameters(QString path, QStringList *ipList)
{
    QString xmlDocument = QString("");
    xmlDocument.append(xmlParametersDocument);
    xmlDocument.append(xmlOpening + xmlKontrolPackElement + xmlEnding);

    xmlDocument.append(xmlOpening + xmlHostnameElement + xmlEnding);
    QString temp(QHostInfo::localHostName());
    xmlDocument.append(temp);
    xmlDocument.append(xmlClosing + xmlHostnameElement + xmlEnding);

    xmlDocument.append(xmlOpening + xmlSystemElement + xmlEnding);
#ifdef WIN32
    xmlDocument.append(WINDOWS);
#elif defined (linux)
    xmlDocument.append(LINUX);
#elif defined __APPLE__
    xmlDocument.append(MACOSX);
#else
    xmlDocument.append(LINUX);
#endif
    xmlDocument.append(xmlClosing + xmlSystemElement + xmlEnding);

    xmlDocument.append(xmlOpening + xmlPathElement + xmlEnding);
    xmlDocument.append(path);
    xmlDocument.append(xmlClosing + xmlPathElement + xmlEnding);

    appendFolderAndFileInfo(xmlDocument, path);

    xmlDocument.append(xmlOpening + xmlIpListElement + xmlEnding);
    for (int j = 0; j < ipList->size(); ++j) {
        xmlDocument.append(xmlOpening + xmlIpElement + xmlEnding);
        xmlDocument.append(ipList->at(j));
        xmlDocument.append(xmlClosing + xmlIpElement + xmlEnding);
    }
    xmlDocument.append(xmlClosing + xmlIpListElement + xmlEnding);

    xmlDocument.append(xmlClosing + xmlKontrolPackElement + xmlEnding);

    return xmlDocument;
}

void XmlCreatorServer::appendFolderAndFileInfo(QString &xmlDocument, QString path )
{
    QDir currentDir = QDir(path);

    QStringList documentList = currentDir.entryList(QDir::AllEntries, QDir::Name);

    xmlDocument.append( xmlOpening + xmlFolderListElement + xmlEnding );
    int cptBack = 0;
#ifdef WIN32
    QFileInfoList drivesInfo = QDir::drives();
    if (QString::compare(path, QString(CONTENT_DRIVE), Qt::CaseInsensitive) == 0) {
        for( int k = 0; k < drivesInfo.size(); k++ ) {
            QFileInfo driveName = drivesInfo.at(k);
            if (!driveName.filePath().contains("..")) {
                xmlDocument.append( xmlOpening + xmlFolderElement + xmlEnding );
                xmlDocument.append(driveName.filePath().replace("/","\\", Qt::CaseInsensitive));
                xmlDocument.append( xmlClosing + xmlFolderElement + xmlEnding );
            }
        }
    }
    if (path.size() <= 3 && path.contains(":")) {
        xmlDocument.append(xmlOpening + xmlFolderElement + xmlEnding );
        xmlDocument.append("..");
        xmlDocument.append(xmlClosing + xmlFolderElement + xmlEnding );
        cptBack = 1;
    }
#endif
    for( int j = 0; j < documentList.size(); j++ ) {
#ifdef WIN32
        QFileInfo documentInfo(QDir::toNativeSeparators(currentDir.absolutePath() + "\\" + documentList.at(j)));
#else
        QFileInfo documentInfo(QDir::toNativeSeparators(currentDir.absolutePath() + "/" + documentList.at(j)));
#endif
        QString folderName = documentList.at(j);
        if (QString::compare(folderName, QString("."), Qt::CaseInsensitive) != 0) {
            if (QString::compare(folderName, QString(".."), Qt::CaseInsensitive) == 0) {
                if (QString::compare(path, QString("/"), Qt::CaseInsensitive) != 0) {
                    if (cptBack == 0) {
                        if (!documentInfo.isBundle() && documentInfo.isDir()) {
                            xmlDocument.append(xmlOpening + xmlFolderElement + xmlEnding );
                            xmlDocument.append(folderName);
                            xmlDocument.append(xmlClosing + xmlFolderElement + xmlEnding );
                        }
                    }
                }
            } else {
                if (!documentInfo.isBundle() && documentInfo.isDir()) {
                    xmlDocument.append(xmlOpening + xmlFolderElement + xmlEnding );
                    xmlDocument.append(folderName);
                    xmlDocument.append(xmlClosing + xmlFolderElement + xmlEnding );
                }
            }
        }

    }
    xmlDocument.append( xmlClosing + xmlFolderListElement + xmlEnding );

    xmlDocument.append( xmlOpening + xmlFileListElement + xmlEnding );
    for( int j = 0; j < documentList.size(); j++ ) {
#ifdef WIN32
        QFileInfo documentInfo(QDir::toNativeSeparators(currentDir.absolutePath() + "\\" + documentList.at(j)));
#else
        QFileInfo documentInfo(QDir::toNativeSeparators(currentDir.absolutePath() + "/" + documentList.at(j)));
#endif
        if (documentInfo.isBundle() || documentInfo.isFile()) {
            xmlDocument.append( xmlOpening + xmlFileElement + xmlEnding );
            QString fileName = documentList.at(j);
            xmlDocument.append( fileName );
            xmlDocument.append( xmlClosing + xmlFileElement + xmlEnding );
        }
    }
    xmlDocument.append( xmlClosing + xmlFileListElement + xmlEnding );
}

QString XmlCreatorServer::getFoldersParameters(QString path)
{
    QString xmlDoctype = QString(XML_DOCTYPE);
    QString xmlOpening = QString(XML_OPENING);
    QString xmlClosing = QString(XML_CLOSING);
    QString xmlEnding = QString(XML_ENDING);
    QString xmlPathElement = QString(PATH);
    QString xmlParametersDocument = QString(xmlDoctype + XML_FOLDERS + xmlEnding);
    QString xmlKontrolPackElement = QString(KONTROLPACK);
    QString xmlHostnameElement = QString(HOSTNAME);
    QString xmlSystemElement = QString(SYSTEM);
    QString drive = QString(DRIVE);
    QString drives = QString(DRIVES);

    QFileInfoList drivesInfo = QDir::drives();

    QString xmlDocument = QString("");

    xmlDocument.append(xmlParametersDocument);
    xmlDocument.append(xmlOpening + xmlKontrolPackElement + xmlEnding);
    xmlDocument.append(xmlOpening + xmlHostnameElement + xmlEnding);
    xmlDocument.append(QHostInfo::localHostName());
    xmlDocument.append(xmlClosing + xmlHostnameElement + xmlEnding);

    xmlDocument.append(xmlOpening + xmlSystemElement + xmlEnding);
#ifdef WIN32
    xmlDocument.append(WINDOWS);
#elif defined (linux)
    xmlDocument.append(LINUX);
#elif defined __APPLE__
    xmlDocument.append(MACOSX);
#elif defined (__FreeBSD__)
    xmlDocument.append(FREEBSD);
#else
    xmlDocument.append(LINUX);
#endif
    xmlDocument.append(xmlClosing + xmlSystemElement + xmlEnding);

    xmlDocument.append(xmlOpening + xmlPathElement + xmlEnding);
    xmlDocument.append(path);
    xmlDocument.append(xmlClosing + xmlPathElement + xmlEnding);

    appendFolderAndFileInfo(xmlDocument, path);

    xmlDocument.append( xmlOpening + drives + xmlEnding );
    for( int k = 0; k < drivesInfo.size(); k++ )
    {
        xmlDocument.append( xmlOpening + drive + xmlEnding );
        QFileInfo driveName = drivesInfo.at(k);
        xmlDocument.append(driveName.filePath());
        xmlDocument.append( xmlClosing + drive + xmlEnding );
    }
    xmlDocument.append( xmlClosing + drives + xmlEnding );


    xmlDocument.append(xmlClosing + xmlKontrolPackElement + xmlEnding);

    return xmlDocument;
}


QString XmlCreatorServer::getFileInfo(QString filePath, QString path, QString header)
{
    QString xmlDoctype = QString(XML_DOCTYPE);
    QString xmlOpening = QString(XML_OPENING);
    QString xmlClosing = QString(XML_CLOSING);
    QString xmlEnding = QString(XML_ENDING);

    QString fileNameElement = QString(FILE_NAME);
    QString fileSizeElement = QString(FILE_SIZE);

    QString fileExecutableElement = QString(FILE_EXECECUTABLE);
    QString fileReadableElement = QString(FILE_READABLE);
    QString fileOwnerElement = QString(FILE_OWNER);
    QString fileExtensionElement = QString(FILE_EXTENSION);
    QString fileDirectoryDateElement = QString(FILE_DIRECTORY);
    QString fileCreationDateElement = QString(FILE_CREATION_DATE);
    QString fileModifiedDateElement = QString(FILE_MODIFIED_DATE);

    QString xmlParametersDocument = QString(xmlDoctype + header + xmlEnding);
    QString xmlKontrolPackElement = QString(KONTROLPACK);

    QFileInfo fileInfo(filePath);
    QDateTime created = fileInfo.created();
    QDateTime lastModified = fileInfo.lastModified();
    bool exec = fileInfo.isExecutable();
    bool read = fileInfo.isReadable();
    QString executable = (exec) ? "true" : "false";
    QString readable = (read) ? "true" : "false";
    QString size = QString::number(fileInfo.size()); // bytes
    QString fileName = fileInfo.fileName();
    QString owner = fileInfo.owner();
    QString extension = fileInfo.completeSuffix();
    QString directory = path;
    QString dateModified = lastModified.toString("dd.MM.yyyy");
    QString dateCreated = created.toString("dd.MM.yyyy");


    QString xmlDocument = QString("");

    xmlDocument.append(xmlParametersDocument);
    xmlDocument.append(xmlOpening + xmlKontrolPackElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileNameElement + xmlEnding);
    xmlDocument.append(fileName);
    xmlDocument.append(xmlClosing + fileNameElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileSizeElement + xmlEnding);
    xmlDocument.append(size);
    xmlDocument.append(xmlClosing + fileSizeElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileExecutableElement + xmlEnding);
    xmlDocument.append(executable);
    xmlDocument.append(xmlClosing + fileExecutableElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileReadableElement + xmlEnding);
    xmlDocument.append(readable);
    xmlDocument.append(xmlClosing + fileReadableElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileOwnerElement + xmlEnding);
    xmlDocument.append(owner);
    xmlDocument.append(xmlClosing + fileOwnerElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileExtensionElement + xmlEnding);
    xmlDocument.append(extension);
    xmlDocument.append(xmlClosing + fileExtensionElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileDirectoryDateElement + xmlEnding);
    xmlDocument.append(directory);
    xmlDocument.append(xmlClosing + fileDirectoryDateElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileCreationDateElement + xmlEnding);
    xmlDocument.append(dateCreated);
    xmlDocument.append(xmlClosing + fileCreationDateElement + xmlEnding);

    xmlDocument.append(xmlOpening + fileModifiedDateElement + xmlEnding);
    xmlDocument.append(dateModified);
    xmlDocument.append(xmlClosing + fileModifiedDateElement + xmlEnding);

    xmlDocument.append(xmlClosing + xmlKontrolPackElement + xmlEnding);

    return xmlDocument;
}


