/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef PAGE_H
#define PAGE_H

#include <QtCore/QString>

class ListingModel;
namespace Form {
  class Description;
  class PagePolicy;
  class Record;
}

class Page
{
  public:
    Page() {}
    virtual ~Page() {}

    virtual QString name() const = 0;
    virtual QString title() const = 0;
    virtual QString description() const = 0;
    virtual QString iconName() const = 0;

    virtual bool hasListingMode() const { return true; }

    virtual ListingModel* model() = 0;

    virtual Form::Description* formDescription() = 0;
    virtual Form::PagePolicy* formPolicy() = 0;
    virtual Form::Record* formRecord() = 0;
};

#endif
