/***************************************************************************
 *   Copyright (C) 2007-2012 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "kgmailnotifier.h"

#include <KAboutData>
#include <KCmdLineArgs>
#include <KLocale>
#include <KUniqueApplication>

#include <cstdlib>
using namespace std;

int main(int argc, char **argv)
{
    KLocale::setMainCatalog("kgmailnotifier");

    KAboutData aboutData("kgmailnotifier", 0, ki18n("KGmailNotifier"), "0.5.2", ki18n("A Gmail notifier applet for KDE"),
                         KAboutData::License_GPL_V3 , ki18n("(C) 2007-2012 Marcel Hasler"), ki18n(""), 0, 0);
    aboutData.addAuthor(ki18n("Marcel Hasler"), ki18n("Author and Maintainer"), "mahasler@gmail.com");

    KCmdLineArgs::init(argc, argv, &aboutData);

    if (!KUniqueApplication::start())
        exit(0);

    KGmailNotifier *kgmailnotifier = new KGmailNotifier();
    return kgmailnotifier->exec();
}

