import os, sys

import guifactory
import equation
from configuration import config
import constants
import node
from pdf import pdffactory

import logging
l = logging.getLogger(__name__)

class Control:
    def __init__(self,windowsystem):
        self.windowsystem = windowsystem
        guifact = guifactory.GuiFactory()
        self.factory = guifact.getFactory(windowsystem, self)
        if sys.platform in ["win32","nt"]:
            # oh dear its windoze
            import engines.socketengine
            self.calcengine = engines.socketengine.Engine()
        else:
            import engines.engine
            self.calcengine = engines.engine.Engine(self)
#        import engines.socketengine
#        self.calcengine = engines.socketengine.Engine()
        self.factory.initApp(self)

        self.mainwin = self.factory.makeMainWindow()

        node.fontfactory = self.factory.getFontFactory()

        self.factory.startAppLoop()

    def processInput(self, input):
        output, retcode, lineno = self.calcengine.evaluateInput(input)
        if retcode == 0:
            self.updateDisplay(input,output,lineno)

    def updateDisplay(self,input,output,lineno):
        self.setWaitCursor()
        try:
            # set some layout functions that depend on the GUI factory
            node.getScalingFunctions(self.factory)
    
            self.mainwin.insertInputListbox(input)
            self.mainwin.clearInput()
            self.mainwin.setOutput(output)
    
            equationInput = equation.Equation(input)
            equationOutput = equation.Equation(output)
            try:
                l.debug(repr(equationInput.node.getString()))
            except:
                pass
    
            id = ""
            if equationInput.textOnly == False:
                try:
                    equationInput.node.setFont(config["tablefont"], config["tablefontsize"])
                    equationInput.node.setTextSize()
                    id = equationInput.node.id
                    l.debug(" id is " + repr(id))
                    l.debug(" root input node is " + repr(equationInput.node))
                except:
                    l.exception("processing input")
                    equationOutput.textOnly = True
    
            if equationOutput.textOnly == False:
                try:
                    equationOutput.node.setFont(config["tablefont"], config["tablefontsize"])
                    equationOutput.node.setTextSize()
                except:
                    l.exception("processing input")
                    equationOutput.textOnly = True
    
            inPromptLetter,outPromptLetter = self.calcengine.getPromptLetters()
    
            if not id:
                inputId = inPromptLetter + str(lineno)
                outputId = outPromptLetter + str(lineno)
            else:
                inputId = id
                outputId = inPromptLetter + str(lineno)
                
            text1 = equation.Text("---")
            text2 = equation.Text("---")
    
            self.mainwin.addRow(equationInput.index,inputId,'i')
            self.mainwin.addRow(text1.index,"",'t')
            self.mainwin.addRow(equationOutput.index,outputId,'o')
            self.mainwin.addRow(text2.index,"",'t')
        except:
            l.exception("updating display with input/output: %s %s" % (repr(input),repr(output)))
        self.clearWaitCursor()

   
    def saveAsPDF(self, fileName):
        # set some layout functions that depend on the GUI factory
        self.setWaitCursor()
        try:
            node.getScalingFunctions(pdffactory)
            allObjects = equation.DrawObject.drawobjects
            l.debug("all object has %s nodes " % len(allObjects))
            pdfNodes = []
            for objIndex in allObjects:
                obj = allObjects[objIndex]
                l.debug("check obj " + repr(obj))
                if isinstance(obj, equation.Equation):
                    l.debug("create node for text " + repr(obj.text))
                    pdfEq = equation.Equation(obj.text, True)
                    pdfNode = pdfEq.node
                    pdfNode.setFont("Times-Roman", config["tablefontsize"])
                    pdfNode.setTextSize()
                    pdfNodes.append(pdfNode)
                    l.debug("pdf nodes has %s nodes " % len(pdfNodes))
            l.debug("pdf nodes has %s nodes " % len(pdfNodes))
            pdfFile = os.path.join(fileName)
            pdffactory.drawNodesToPdf(pdfFile,pdfNodes, config["tablefontsize"], verticalGap=20)
        except:
            l.exception("savings as PDF")
        self.clearWaitCursor()

    def plot(self):
        self.setWaitCursor()
        try:
            equationtext = self.mainwin.getCurrentEquation()
            plotEquation = equation.Equation(equationtext)
            self.mainwin.clearDlgPlot()
            allVars = plotEquation.node.getAllVariables()
            self.mainwin.showDlgPlotVars(allVars)
            self.mainwin.setDlgPlotContents(equationtext)
        except:
            l.exception("setting up plot")
        self.clearWaitCursor()
        if self.mainwin.doDlgPlot() == constants.DLG_ACCEPTED:
             self.setWaitCursor()
             try:
                # set up new tab
                plotWidget = self.mainwin.addPlotView()
    
                plotOptions = self.mainwin.getPlotOptions()
                size = plotWidget.size()
                
                plotFile = os.path.join(config["tempdir"],"gplot.ps")
                
                plotCommand = self.mainwin.getPlotCommand(equationtext, allVars, plotOptions, False, size.width(),
                                                           size.height(), plotFile)
                # add details to plots
                equation.plots[plotWidget] = (plotEquation,allVars,plotOptions)
                # run gnuplot via maxima
                l.debug( "plot command is " + plotCommand)
                self.calcengine.evaluateInput(plotCommand)
    
                myPlot, myPlotThumbnail = self.mainwin.makePixmapsOf(plotFile)
    
                self.mainwin.setPlotPixmap(plotWidget,myPlot)
    
                mygraph = equation.Graph(myPlot, myPlotThumbnail)
                graphHeight = mygraph.node.h
    
                self.mainwin.addRow(mygraph.index, 'plot','o')
             except:
                l.exception("plotting")
             self.clearWaitCursor()

    def integrate(self, equation):
        command = "integrate(" + equation + ",x)"
        self.processInput(command)

    def differentiate(self, equation):
        command = "diff(" + equation + ",x)"
        self.processInput(command)
        
    def setWaitCursor(self):
        self.factory.setWaitCursor()
        
    def clearWaitCursor(self):
        self.factory.clearWaitCursor()
