/*
* Copyright (c) 2018, Intel Corporation
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
* THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR
* OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*/
//!
//! \file     media_feature.cpp
//! \brief    Defines the common interface for media feature
//!

#include "media_feature.h"

MediaFeature::MediaFeature(void *constSettings, PMOS_INTERFACE mosInterface) : MediaFeature(mosInterface)
{
    MEDIA_FUNC_CALL();
    m_constSettings = constSettings;
};

MediaFeature::MediaFeature(PMOS_INTERFACE mosInterface)
{
    MEDIA_FUNC_CALL();

    if (mosInterface)
    {
        m_userSettingPtr = mosInterface->pfnGetUserSettingInstance(mosInterface);
    }
    if (!m_userSettingPtr)
    {
        MOS_OS_NORMALMESSAGE("Initialize m_userSettingPtr instance failed!");
    }
};

MOS_STATUS MediaFeature::Init(void *settings)
{
    MEDIA_FUNC_CALL();
    MEDIA_CHK_NULL_RETURN(settings);

    return MOS_STATUS_SUCCESS;
}

MOS_STATUS MediaFeature::Update(void *params)
{ 
    MEDIA_FUNC_CALL();
    MEDIA_CHK_NULL_RETURN(params);

    return MOS_STATUS_SUCCESS; 
}
