<a id="FileShipping"></a>Plain config file shipping
===================================================

Icinga 2 offers a very powerful configuration format. By definition, it isn't
a configuration format at all, it's a DSL, a Domain Specific Language. There is
no chance to implement all of it's feature in a config tool like Icinga Director,
that would make as much sense as trying to create a GUI for Ruby or Perl.

So, sometimes one might want to ship additional hand-crafted Icinga 2 config
files not generated by the Director. Sadly, that way you loose a lot of it's
features like tracking changes, keeping deployment history and more. That's what
this part of fileshipper has been designed for. It allows you to tell Director
to deploy additional config files without even trying to understand them.

To enable this, please create a `directories.ini` in this modules config dir,
usually `/etc/icingaweb2/modules/fileshipper`:

```ini
[custom-rules]
source = /usr/local/src/custom-rules.git
target = zones.d/director-global/custom-rules

[test]
source = /tmp/replication-test
target = zones.d/director-global/having-fun
extensions = .conf .md
```

In this example all local files from `source` will be deployed to the given target
directory. Please take care, use of this module requires advanced understanding of
Icinga2 configuration. Per default only `.conf` files are synced, you can override
this with a custom space-separated list for the `extensions` parameter.

In case you want to trigger specific actions like re-rendering or deploying the
config on changes you might want to have a look at our sample GIT hook in
[contrib/git-hooks/post-merge](../contrib/git-hooks/post-merge).

When working with Puppet or similar, please consider notifying an `exec` resource
with `refreshonly` set to `true` instead.
