'''OpenGL extension ARB.shader_draw_parameters

This module customises the behaviour of the 
OpenGL.raw.GL.ARB.shader_draw_parameters to provide a more 
Python-friendly API

Overview (from the spec)
	
	    In unextended GL, vertex shaders have inputs named gl_VertexID and
	gl_InstanceID, which contain, respectively the index of the vertex and
	instance. The value of gl_VertexID is the implicitly passed index of the
	vertex being processed, which includes the value of baseVertex, for those
	commands that accept it. Meanwhile, gl_InstanceID is the integer index
	of the current instance being processed, but, even for commands that
	accept a baseInstance parameter, it does not include the value of this
	argument. Furthermore, the equivalents to these variables in other
	graphics APIs do not necessarily follow these conventions. The reason for
	this inconsistency is that there are legitimate use cases for both
	inclusion and exclusion of the baseVertex or baseInstance parameters
	in gl_VertexID and gl_InstanceID, respectively.
	
	    Rather than change the semantics of either built-in variable, this
	extension adds two new built-in variables to the GL shading language,
	gl_BaseVertexARB and gl_BaseInstanceARB, which contain the values passed
	in the baseVertex and baseInstance parameters, respectively. Shaders
	provided by the application may use these variables to offset gl_VertexID
	or gl_InstanceID if desired, or use them for any other purpose.
	
	    Additionally, this extension adds a further built-in variable, gl_DrawID
	to the shading language. This variable contains the index of the draw
	currently being processed by a Multi* variant of a drawing command (such
	as MultiDrawElements or MultiDrawArraysIndirect).

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/ARB/shader_draw_parameters.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.ARB.shader_draw_parameters import *
from OpenGL.raw.GL.ARB.shader_draw_parameters import _EXTENSION_NAME

def glInitShaderDrawParametersARB():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION