#!/bin/sh


set -eu

SVN_BRANCH=origin/upstream-svn

HEAD=`git log --format=oneline $SVN_BRANCH -1|head -1|cut -d" " -f1`
REV=`git log --format=full $HEAD -1 | grep 'git-svn-id: ' | sed -e 's/.\+@//; s/ .\+//'`
DATE=`git show --pretty=format:%ai $HEAD | awk '{print $1; exit;}'|sed 's/-//g'`

echo upstream-svn head is $HEAD, r$REV from $DATE

if [ -n "${1:-}" ];
then
    echo Syntax: $0
    exit 1
fi

upstream_ver() {
    COMPONENT=$1
    RES=`git show $SVN_BRANCH:src/frversion.h | awk "/^#define FR_VERSION_$COMPONENT / { print \\$3 }"`
    if [ -z "$RES" ]; then
        echo "FR_VERSION_$COMPONENT not found in $SVN_BRANCH:src/frversion.h:"
        git show $SVN_BRANCH:src/frversion.h
        exit 1
    else
        echo $RES
    fi
}

VER=`upstream_ver MAJOR`.`upstream_ver MINOR`.`upstream_ver RLS`

echo "Version is $VER"

ORIG="flamerobin_$VER~svn+${REV}.orig"

git archive --format=tar --prefix=$ORIG/ $HEAD | gzip -9 -n > ../$ORIG.tar.gz

echo ../$ORIG.tar.gz ready.
